/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) loadroles.c: version 25.1 created on 12/2/91 at 17:20:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)loadroles.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <fcntl.h>
#include <sys/types.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/sakioctl.h>
#include <auth.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/synch.h>
#include <sys/security.h>
#include <sys/audit.h>
#include <param.h>
#include <stdio.h>

#define ROLE "/dev/roles"
#define UID "/dev/uids"

main( argc,argv )
int argc;
char * argv[];
{

	roldef_t *role,*getrolent();
	usrauth_t *ua,*getuaent();
	kern_role_t kr;
	kern_uidmap_t ku;
	int fd,i,number_of_roles;
	
	if( ( fd = open(ROLE,O_WRONLY) ) < 0 ) {
		fprintf(stderr, "Cannot open %s\n",ROLE);
		exit( 1 );
	}


	setrlent();

	i = 0;

	number_of_roles = 0;

	while (( role = getrolent() ) != NULL ) {

		kr.role = role->r_rolenumber;
		kr.priv = role->r_priv;
		kr.minlabel = role->r_minlabel;
		kr.maxlabel = role->r_maxlabel;
		kr.status = 0;


		if( write( fd,&kr,sizeof(kern_role_t) ) < 0 ) {

			fprintf(stderr,"Cannot write role structures\n");

			exit(1);
		}

		number_of_roles++;
	}

	endrlent();

	close(fd);



	if( ( fd = open(ROLE,O_RDONLY) ) < 0 ) {
		fprintf(stderr, "Cannot open %s\n",ROLE);
		exit( 1 );
	}

	errno = 0;

	while( read( fd,&kr,sizeof(kern_role_t) ) > 0 ) 
		 i++;

	if( errno || ( number_of_roles != i) )
		printf("read error %d roles written %d roles read %d\n",errno,number_of_roles,i);

	printf("ROLES LOADED\n");

	close ( fd );


	if( ( fd = open(UID,O_WRONLY) ) < 0 ) {
		fprintf(stderr, "Cannot open %s\n",UID);
		exit( 1 );
	}

	setuaent();

	number_of_roles = 0;
	i = 0;

	while( ( ua = getuaent() ) != NULL ) {

		ku.uid  = ua->ua_uid;
		ku.role = ua->ua_role;
		ku.status = 0;

		errno = 0;

		if( write(fd,&ku,sizeof(kern_uidmap_t) ) < 0 ) {

			fprintf(stderr,"Cannot write role structures errno %d\n",errno);

			exit(1);

		}

		number_of_roles++;

	}

	close(fd);
	enduaent();

	printf("ALL UID/ROLE PAIRS LOADED\n");


	
	if( ( fd = open(UID,O_RDONLY) ) < 0 ) {
		fprintf(stderr, "Cannot open %s\n",UID);
		exit( 1 );
	}

	errno = 0;

	while( read(fd,&ku,sizeof(kern_uidmap_t) ) > 0 ) 
		i++;


	if( errno || (number_of_roles != i))
		printf("read error %d uids written %d uids read %d\n",errno,number_of_roles,i);

	close( fd );




}
