/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) rmgrp.c: version 25.1 created on 12/2/91 at 17:20:16	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)rmgrp.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <sys/types.h>
#include <grp.h>
#ifdef TMP_FIX
#include <stat.h>
#endif
#include "auth.h"

#if !defined(TRUE)
#define	TRUE	1
#endif

#if !defined(FALSE)
#define FALSE	0
#endif

#define SECONDS_PER_DAY		(24 * 60 * 60)

/* Flags */
int ignore_retire = FALSE;	/* Ignore the retire date in the shadow file*/
int only_display = FALSE;	/* Only display the files don't update */
int remove_files = FALSE;	/* Remove any files owned by this group */
int chgrp_files = FALSE;	/* Chgrp any files owned by this group */
int shadow_is_there = FALSE;	/* The shadow file exists */
gid_t new_group_id;		/* The group id to chgrp things to */

struct group *check_group_and_options();

main(argc, argv)
int argc;
char *argv[];
{
	int c, result;
	char *group_name;
	struct group *group_entry;
	extern char *optarg;
	extern int optind;

	/* Check security */
	if (!priv(P_SEC, getuid())) {
		fprintf(stderr, "rmgrp: You do not have enough privledge to run this command\n");
		return(1);
	}

	if (access(SGRPFLE, 06) >= 0)
		shadow_is_there = TRUE;

	/* Parse our arguments */
	while ((c = getopt(argc, argv, "udrg:")) != EOF)
		switch(c) {
		case 'u':
			ignore_retire = TRUE;
			break;
		case 'd':
			only_display = TRUE;
			break;
		case 'r':
			remove_files = TRUE;
			break;
		case 'g':
			chgrp_files = TRUE;
			new_group_id = get_group_id(optarg);
			break;
		case '?':
		default:
			usage();
			/* NOT REACHED */
			break;
		}

	if (argc <= optind)
		usage();
		/* NOT REACHED */
	group_name = argv[optind];
	group_entry = check_group_and_options(group_name);

	check_retirement(group_name);

	/* Look through the file systems for files owned by this group */
	result = process_file_systems(group_entry);
	if (result == 0 && !only_display) {
		/* Delete the entry from /etc/group */
		result = delete_group_file_entry(group_name);
		if (shadow_is_there && result == 0)
			/* Delete the entry from /etc/security/group */
			result = delete_group_auth_file_entry(group_name);
	}
	return(result);
}

/* Find all the files owned by this group then, depending on the flags, remove
 * them, chgrp them or query the user about them.
 */
process_file_systems(group_entry)
struct group *group_entry;
{
	int result;
	char command[BUFSIZ];
	char file_name[BUFSIZ];
	char *p;
	FILE *pipe_end;
	extern char *strrchr();
#ifdef TMP_FIX
	struct stat statbuf;
#endif

	/* Run the find command to locate the files */
	sprintf(command, "/bin/find / -group %d -print", group_entry->gr_gid);
	fprintf(stderr, "scanning file system for files owned by %s (please wait)\n", group_entry->gr_name);
	fflush(stderr);
	if ((pipe_end = popen(command, "r")) == NULL) {
		fprintf(stderr, "rmgrp: can't run the /bin/find command\n");
		return(1);
	}

	while (fgets(file_name, BUFSIZ, pipe_end) != NULL) {
		if ((p = strrchr(file_name, '\n')) != NULL)
			*p = '\0';

		/* Remove the file */
		if (remove_files) {
			if (unlink(file_name) < 0)
				perror(file_name);
			continue;
		}

		/* chgrp the file */
		if (chgrp_files) {
#ifdef TMP_FIX
			/* Temp fix because some chowns don't like -1 */
			if (stat(file_name, &statbuf) < 0)
				perror(file_name);
			if (chown(file_name, statbuf.st_uid, new_group_id) < 0)
#else
			if (chown(file_name, -1, new_group_id) < 0)
#endif
				perror(file_name);
			continue;
		}

		/* Display the file list */
		if (only_display) {
			puts(file_name);
			continue;
		}
		else 
			query_user(file_name);
	}
	pclose(pipe_end);
	return(0);
}

query_user(file_name)
char *file_name;
{
	struct group *group_entry;
	char answer[BUFSIZ];
	int new_gid;
#ifdef TMP_FIX
	struct stat statbuf;
#endif


start_again:
	/* Ask for removal */
	printf("Would you like to remove %s (y/n): ", file_name);
	fflush(stdout);
	gets(answer);
	if (*answer == 'y' || *answer == 'Y') {
		if (unlink(file_name) < 0) {
			perror(file_name);
			goto start_again;
		}
		return;
	}
	/* Ask to chgrp */
	printf("Would you like to chgrp %s (y/n): ", file_name);
	fflush(stdout);
	gets(answer);
	if (*answer == 'y' || *answer == 'Y') {
		printf("Enter the group id or group name: ");
		fflush(stdout);
		gets(answer);
		/* If its a GID then atoi() it */
		if (isdigit(*answer)) {
			new_gid = atoi(answer);
#ifdef TMP_FIX
			if (stat(file_name, &statbuf) < 0) {
				perror(file_name);
				goto start_again;
			}
			if (chown(file_name, statbuf.st_uid, new_gid) < 0) {
#else
			if (chown(file_name, -1, new_gid) < 0) {
#endif
				perror(file_name);
				goto start_again;
			}
			return;
		}
		else {
			/* If its a group name, then getgrnam() it */
			if ((group_entry = getgrnam(answer)) == NULL) {
				fprintf(stderr, "rmgrp: can't find %s in the group file\n", answer);
				goto start_again;
			}
#ifdef TMP_FIX
			if (stat(file_name, &statbuf) < 0) {
				perror(file_name);
				goto start_again;
			}
			if (chown(file_name,
				statbuf.st_uid, group_entry->gr_gid) < 0) {
#else
			if (chown(file_name, -1, group_entry->gr_gid) < 0) {
#endif
				perror(file_name);
				goto start_again;
			}
			return;
		}
	}
	else
		printf("skipping %s\n", file_name);
}
	
delete_group_file_entry(group_name)
char *group_name;
{
	struct group *group_entry;
	FILE *temp_group_file;

	/* Open temp file */
	if ((temp_group_file = fopen(GRPTMP, "w")) == NULL) {
		fprintf(stderr, "rmgrp: can't open or access %s\n", GRPTMP);
		return(1);
	}

	/* Read the group file, writing entries to the temp file, when we
	 * get to ours, Skip it.
	 */
	setgrent();
	while ((group_entry = getgrent()) != NULL) {
		if (strcmp(group_entry->gr_name, group_name) == 0)
			continue;
		putgrent(temp_group_file, group_entry);
	}
	endgrent();

	fclose(temp_group_file);

	/* Rename the temp file to the group file (make a backup first) */
	if (rename(GRPFLE, OGRPFLE) < 0) {
		perror("rmgrp");
		unlink(GRPTMP);
		return(1);
	}
	if (rename(GRPTMP, GRPFLE) < 0) {
		perror("rmgrp");
		return(1);
	}

	return(0);
}

delete_group_auth_file_entry(group_name)
char *group_name;
{
	struct grpauth *auth_group_entry;
	FILE *temp_group_file;

	/* Open the temp file */
	if ((temp_group_file = fopen(SGRPTMP, "w")) == NULL) {
		fprintf(stderr, "rmgrp: can't open or access %s\n", SGRPTMP);
		return(1);
	}

	/* Read the group file, writing entries to the temp file, when we
	 * get to ours, Skip it.
	 */
	setgaent();
	while ((auth_group_entry = getgaent()) != NULL) {
		if (strcmp(auth_group_entry->ga_name, group_name) == 0)
			continue;
		putgaent(temp_group_file, auth_group_entry);
	}
	endgaent();

	fclose(temp_group_file);

	/* Rename the temp file to the group file (make a backup first) */
	if (rename(SGRPFLE, OSGRPFLE) < 0) {
		perror("rmgrp");
		unlink(SGRPTMP);
		return(1);
	}
	if (rename(SGRPTMP, SGRPFLE) < 0) {
		perror("rmgrp");
		return(1);
	}

	return(0);
}

/* Return the group ID associated with group_name */
get_group_id(group_name)
char *group_name;
{
	struct group *group_entry;

	if ((group_entry = getgrnam(group_name)) == NULL) {
		fprintf(stderr,"rmgrp: can't find group %s in the group file\n",								group_name);
		exit(1);
	}
	return(group_entry->gr_gid);
}

/* Check our options:
 * 	1. no -r and -g.
 *	2. valid group name.
 *	3. group does not conflict with arg of -g.
 *
 * Return the group entry.
 */
struct group *
check_group_and_options(group_name)
char *group_name;
{
	struct group *group_entry;

	if (remove_files && chgrp_files) {
		fprintf(stderr, "rmgrp: both the -r and -g flag were specified, only one is allowed\n");
		exit(1);
	}
	if ((group_entry = getgrnam(group_name)) == NULL) {
		fprintf(stderr, "rmgrp: can't find group %s in the group file\n", group_name);
		exit(1);
	}
	if (chgrp_files && (group_entry->gr_gid == new_group_id)) {
		fprintf(stderr, "rmgrp: when using the -g flag the two groups must be different\n");
		exit(1);
	}
	return(group_entry);
}

/* See that we are retired and if we are that we have 
 * been retired long enough .
 */
check_retirement(group_name)
char *group_name;
{
	struct grpauth *group_auth_entry;
	time_t clock, retired_time, default_delay_time;

	/* If no shadow, or we're ignoring the retirement return */
	if (!shadow_is_there || ignore_retire)
		return;

	/* Get the group auth entry */
	if ((group_auth_entry = getganam(group_name)) == NULL) {
		fprintf(stderr, "rmgrp: can't find group %s in the shadow group file\n", group_name);
		exit(1);
	}

	/* Make sure we're retired:  ie ga_acctstat is > 1 */
	retired_time = (time_t)group_auth_entry->ga_acctstat;
	if (retired_time < (time_t)2){
		fprintf(stderr, "rmgrp:group %s has not been retired\n",
							group_name);
		exit(1);
	}
		
	default_delay_time = get_delay_time();
	time(&clock);
	if (retired_time > (clock - default_delay_time)) {
		fprintf(stderr, "rmgrp: group %s has not been retired long enough (%d days)\n", group_name, default_delay_time/SECONDS_PER_DAY);
		exit(1);
	}
}

/* two weeks */
#define DEFAULT_DELAY_IN_SECONDS	(2 * 7 * SECONDS_PER_DAY)
#define LOGIN_PARMS			"/etc/login.parms"
#define GROUP_RETIRE			"group_retire"

time_t
get_delay_time()
{
	FILE *parms_file;
	char parm_line[BUFSIZ];
	char *p;
	extern char *strchr();

	if ((parms_file = fopen(LOGIN_PARMS, "r")) == NULL)
		return(DEFAULT_DELAY_IN_SECONDS);
	
	while (fgets(parm_line, BUFSIZ, parms_file) != NULL) {
		if (*parm_line == '#')
			continue;
		if ((p = strchr(parm_line, "=")) != NULL) {
			*p++ = '\0';
			if (strcmp(parm_line, GROUP_RETIRE) == 0)
				return(atoi(p) * SECONDS_PER_DAY);
		}
	}
	fclose(parms_file);
	return(DEFAULT_DELAY_IN_SECONDS);
}

usage()
{
	fprintf(stderr, 
		"usage: rmgrp [ -u -d ] [ -r | -g new_group ] group_name\n");
	exit(1);
}
