/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) privileges.c: version 25.1 created on 12/2/91 at 17:20:09	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)privileges.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	priviliges	ARIX version of the V/MLS privileges utilty
 *			(C) Copyright 1989 by ARIX Corp
 *	
 *	Verion 2: This utility has been reworked to handle the new
 *		  "more" POSIX compliant privilege mecahnism, and the
 *	          role mechanism
 */

#ident	"/etc/privileges: Version 2.0"

#include <sys/types.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/param.h>
#include <grp.h> 
#include <pwd.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <auth.h>
#include <string.h>

extern int optind;
extern int optarg;

#define SHORT	0x01
#define LONG	0x02
#define ROLE	0x04
#define PRIVS	0x08
#define LABELS	0x10

/* arrays for print routines */
int mode;
char grplist[512];
char rprivlist[512];
char eprivlist[512];
char mprivlist[512];
char minlabel[40];
char maxlabel[40];
char tmp[20];
char rolename[20];


main( argc, argv )
int argc;
char **argv;
{
int c, i;
struct passwd *pwd, *getpwuid(), *getpwnam();
char tmp[512];

	mode = SHORT;
	while ((c = getopt( argc, argv, "sarpl?" ))!=-1) {
		switch (c) {
			case 's':
				mode = SHORT;
				break;
			case 'a':
				mode = LONG;
				break;
			case 'l':
				mode = LABELS;
				break;
			case 'p':
				mode = PRIVS;
				break;	
			case 'r':
				mode = ROLE;
				break;
			case '?':
				usage();
				return;
			default:
				error( "bad or unkown option(s)" );
		}
	}

	i = optind;	

	/* for all the rest of the command line arguments */
	if ( argv[optind] ) {
		while ( argv[i] ) {
			if ( pwd = getpwnam( argv[i] )) {
				get_auth_privs( pwd );
				showall( argv[i++] );
			}
			else
				error( "bad or unknown user" );
		}
	}
	else {
		/* see if we can pick up his password info */
		if ( pwd = getpwuid(getuid())) {
			get_proc_privs( pwd );
			showall( pwd->pw_name );
		}
		else 
			error( "bad or unknown user" );
	}
	return(0);   /*success*/
}

/*
 *	get_auth_privs  look up the authorization privileges of a 
 *		        user in the userauth table 
 */
get_auth_privs( pwd )
struct passwd *pwd;
{
usrauth_t *ua, *getuanam();
slabel_t minl, maxl;
priv_t priv;
roldef_t *rp, *getrolent();

	/* get the user entry from the usrauth database */	
	if (!(ua = getuanam(pwd->pw_name)))
		error( "bad or unknown user" );

	if ((mode == LONG) || (mode == ROLE) || (mode == SHORT) ) {
		*rolename = 0;
		while ( rp = getrolent() ) {
			if ( rp->r_rolenumber == ua->ua_role ) {
				strcpy( rolename, rp->r_name );
				break;
			}
		}
		if ( *rolename == 0 )
			error( "bad or unknown role" );
	}

	if ( (mode == LONG) || (mode == PRIVS) )  {
		if (!cvt_priv_to_sym( rp->r_priv.real, rprivlist, 1, ' ' ))
			error( "unknown privileges" );
		if (!cvt_priv_to_sym( rp->r_priv.eff, eprivlist, 1, ' ' ))
			error( "unknown privileges" );
		if (!cvt_priv_to_sym( rp->r_priv.mask, mprivlist, 1, ' ' ))
			error( "unknown privileges" );
	}

	if ( (mode == LONG) || (mode == LABELS) ) {
		if (!cvt_slabel_sym( minlabel, &rp->r_minlabel ))
			error( "unknown labels" );
		if (!cvt_slabel_sym( maxlabel, &rp->r_maxlabel ))
			error( "unknown labels" );
	}

	if ( mode == LONG ) 
		make_grplist( pwd );
}

/*
 *	get_proc_privs  get the privileges of the current process   
 */
get_proc_privs( pwd )
struct passwd *pwd;
{
slabel_t minl, maxl;
priv_t priv;
int role;
roldef_t *rp, *getrolent();
usrauth_t *ua, *getuanam();

	if ( (mode == LONG) || (mode == ROLE) || (mode == SHORT )) {
		if ( get_role(&role) < 0 )
			error( "bad or unknown user" );
		convrole(role);
	}

	if ( (mode == LONG) || (mode == PRIVS) )  {
		if (getpriv( &priv ))
			error( "can't get privileges" );

		if (!cvt_priv_to_sym( priv.real, rprivlist, 1, ' ' ))
			error( "unknown privileges" );
		if (!cvt_priv_to_sym( priv.eff, eprivlist, 1, ' ' ))
			error( "unknown privileges" );
		if (!cvt_priv_to_sym( priv.mask, mprivlist, 1, ' ' ))
			error( "unknown privileges" );
	}

	if ( (mode == LONG) || (mode == LABELS) ) {
		if (get_slabel( &minl, &maxl ) < 0 )
			error( "can't get process labels" );
		if (!cvt_slabel_sym( minlabel, &minl ))
			error( "unknown labels" );
		if (!cvt_slabel_sym( maxlabel, &maxl ))
			error( "unknown labels" );
		
	}

	if ( mode == LONG ) 
		make_grplist( pwd );
}

/*
 *	convert role number to ascii role in rolename
 */
convrole(role)
int   role;
{
	FILE  *rol;
	char  line[256];
	char  *rolenum;
	char  *rolend;
	long  rolno;
	char  *end;

	if ( (rol = fopen("/etc/roledef","r")) == NULL ) {
		printf("can't open roledef\n");
		exit(1);
	}

	while ( fgets(line, sizeof line, rol) != NULL ) {
		if ( (rolenum = strchr(line, (int)' ')) == NULL ) {
			printf("bad roledef entry\n");
			continue;
		}

		*rolenum = '\0';
		if ( strlen(line) >= sizeof rolename )
			line[sizeof rolename - 1] = '\0';

		rolenum++;
		if ( (rolend = strchr(rolenum, (int)' ')) == NULL ) {
			printf("bad roledef entry\n");
			continue;
		}

		*rolend = '\0';
		rolno = strtol(rolenum, &end, 10);
		if ( end != rolend ) {
			printf("bad roledef entry\n");
			continue;
		}

		if ( rolno == role ) {
			strcpy(rolename, line);
			fclose(rol);
			return 0;
		}
	}
	fclose(rol);
	return 1;
}

/*
 *	showall    show the privileges to the user  
 */
showall( uname )
char *uname;
{
	if ( mode == SHORT ) {
		printf( "uname: %s\n", uname );
		printf( "rolename: %s\n", rolename );
	}

	if ( mode == ROLE ) {
		printf( "rolename: %s\n", rolename );
	}

	if ( mode == PRIVS ) {
		printf( "real privs: %s\n", rprivlist );
		printf( "eff  privs: %s\n", eprivlist );
		printf( "mask privs: %s\n", mprivlist );
	}

	if ( mode == LABELS ) {
		printf( "minimum label: %s\n", minlabel );
		printf( "maximum label: %s\n", maxlabel );
	}

	if ( mode == LONG ) {
		printf( "uname: %s\n", uname );
		printf( "rolename: %s\n", rolename );
		printf( "real privs: %s\n", rprivlist );
		printf( "eff  privs: %s\n", eprivlist );
		printf( "mask privs: %s\n", mprivlist );
		printf( "minimum label: %s\n", minlabel );
		printf( "maximum label: %s\n", maxlabel );
		printf( "groups: %s\n", grplist );
	}
}

/*
 *
 *	error    error condition so print string and get out
 *
 */

error( str )
char *str;
{
	fprintf( stderr, "%s\n", str );
	exit(errno);
}
	
/*
 *	make_grplist build the group list
 */	

make_grplist(pwd)
struct passwd *pwd;
{
char buf[40];
int role;
int i, ngroups;
gid_t	gids[NGROUPS_MAX+1];
struct group *gr, *getgrent(), *getgrgid();
struct passwd *pw, *getpwnam();
char **cp;

	if ( getuid() == pwd->pw_uid ) {
		gids[0]  = pwd->pw_gid;
		ngroups  = getgroups( NGROUPS_MAX, &gids[1] ) + 1;
		for ( i = 0; i<ngroups; i++ )  {
			if ( i && gids[i] == gids[0] )
				continue;
			if ( (short)gids[i] == (uid_t)-1 )
				break;
			if ( gr = getgrgid( gids[i] ))
				strcat( grplist, gr->gr_name );
			else {
				sprintf( buf, "%d", gids[i] );
				strcat( grplist, buf );
			}
			strcat( grplist, " " );
		}
	}
	else {
		if (! (gr = getgrgid( pwd->pw_gid ))) {
			sprintf( buf, "%d", gids[i] );
			strcat( grplist, buf );
		}
		else {
			while ( gr = getgrent( pwd->pw_gid))  {
				for ( cp = gr->gr_mem; cp && *cp; cp++ ) 
					if ( ! strcmp( *cp, pwd->pw_name ) ) {
						strcat( grplist, gr->gr_name );
						strcat( grplist, " " );
					}
			}
		}
	}
}

/*
 *	usage  uasge for privileges command
 */

usage()
{
	fprintf( stderr, "usage: privileges [<sarpl>] [users]\n" );
	fprintf( stderr, "       -s short listing\n" );
	fprintf( stderr, "       -l labels only\n" );
	fprintf( stderr, "       -p privileges only\n" );
	fprintf( stderr, "       -r roles only\n" ); 
	fprintf( stderr, "       -a long listing (all output)\n" );
}
