/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) newpriv.c: version 25.1 created on 12/2/91 at 17:19:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)newpriv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	newpriv	  change the privilege of a file
 *		  (C) Copyright 1989 by ARIX Corp.   
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <signal.h>
#include <sys/mount.h>
#include <pwd.h>
#include <time.h>
#include <ctype.h> 
#include <errno.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/security.h>

#define	REMOVE	02
#define ADD	03
#define MASK	04

#define PATH	"PATH=:/bin:/usr/bin"
#define SUPATH	"PATH=/bin:/etc:/usr/bin"

char	*envinit[20];
extern char	**environ;
char buf[512];
char homedir[255];
char logname[255];
char profile[255];
char *strrchr(),*malloc(),*strlen();

extern int optind;
extern char *optarg;
int mode;

main( argc, argv )
char **argv;
{
priv_t	priv;
char pbuf[512];
char buf[512];
int c, i, tmp;

	mode = REMOVE;
	while ((c = getopt( argc, argv, "mra?" )) != -1 ) {
		switch(c) {
			case 'r': 
				mode = REMOVE;
				break;
			case 'a':
				mode = ADD;
				break;
			case 'm':
				mode = MASK;
				break;
			case '?':
				usage();
				return;
			default:
				error( "bad or unkown privileges" );
		}
	}

	if ( mode == ADD ) {
		if (getpriv( &priv ))
			error( "can't read privileges" );
		if (!cvt_sym_to_priv( argv[optind], &tmp, ',' ))	
			error( "bad or unknown privileges\n" );

		/* add the new privileges in */
		priv.eff |= tmp;
		if (setpriv( &priv ))
			error( "permission denied" );
	}
	else if ( mode == MASK ) {
		if (getpriv( &priv ))
			error( "can't read privileges" );
		if (!cvt_sym_to_priv( argv[optind], &tmp, ',' ))	
			error( "bad or unknown privileges\n" );

		/* add the new privileges in */
		priv.eff &= tmp;
		priv.real &= tmp;
		priv.mask = tmp;

		if (setpriv( &priv ))
			error( "permission denied" );
	}
	else if ( mode == REMOVE ) {
		if ( !argv[optind] )
			error( "bad or unknown privileges" );
		if (!cvt_sym_to_priv( argv[optind], &tmp, ',' ))
			error( "bad or unknown privileges\n" );
		if (delpriv( &tmp )) {
			if ( errno ==  EPERM ) 
				error( "permission denied");
			else
				error( "no privileges to remove" );
		}
	}
	newshell();
}

/*
 *
 * 
 */

newshell() 
{
struct passwd *pwd, *getpwuid();
char pshell[255], shell[255], sh[14];

	if (!( pwd = getpwuid( getuid()))) 
		error( "unknown user" );

	strcpy( shell, "/bin/sh" );
	strcpy( sh, "-sh" ); 

	strcpy(pshell,pwd->pw_shell);
	if (pshell[0] != '\0' && (strcmp(shell,pshell) != 0) ) {
		strcpy(shell,pshell);
		strcpy(sh,"-");
		strcat(sh, strrchr(shell,'/') + 1);
	}

	execl(shell,sh,(char*)0);

	error( "no shell" );
}

/*
 *
 *
 */

error( str )
char *str;
{
	fprintf( stderr, "%s\n", str );
	exit(errno);
}

/*
 *
 */

usage()
{
	fprintf( stderr, "usage: newpriv [<amr>]\n" );
	fprintf( stderr, "       -a add privileges to current set\n" );
	fprintf( stderr, "       -m set new process mask\n" );
	fprintf( stderr, "       -r remove privileges from the current set\n" );	
}

	
