/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) lock.c: version 25.5 created on 3/4/92 at 21:45:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)lock.c	25.5	3/4/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	lock	lock a user, group or a tty device 
 *		(C)Copyright 1989 by ARIX Corp.
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <signal.h>
#include <sys/mount.h>
#include <pwd.h>
#include <shadow.h>
#include <fcntl.h>
#include <time.h>
#include <ctype.h> 
#include <errno.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>

#define GRPMODE	1
#define USRMODE	2
#define TTYMODE	3

#define UNLOCK	0
#define LOCK	1
#define RETIRE	2
#define OVER	4

extern char *optarg;
extern int  optind;

char *mesg[] = {
	"\r\n",
	"**********************************\r\n",
	"               SORRY              \r\n",
	" This terminal has been locked !! \r\n",
	"**********************************\r\n",
	"\r\n",
	""
	};

main(argc, argv)
char **argv;
{
	int c, i, mode, prog, showmode, hangflag;
	char **p, *cmd, *strrchr();
	int pseudo = 0;
	int ret = 0;
	char bufr[80];

	mode = 0;
	showmode = 1;
	hangflag = 0;

	if ( cmd = strrchr( argv[0], '/' ))
		++cmd;
	else
		cmd = argv[0];
	
	if ( !strcmp( cmd, "unlock" ))
		prog = UNLOCK;		/* invoked with 'unlock ...' */
	else if ( !strcmp( cmd, "retire" ))
		prog = RETIRE;		/* invoked with 'retire ...' */
	else
		prog = LOCK;		/* invoked with 'lock   ...' */

	if ( ! priv ( P_SEC, getuid()))
		error( "permission denied" );

	while ((c = getopt( argc, argv, "gtul" )) != -1 ) {
		switch (c) {
			case 'g':
				if ( mode )
					usage(prog);
				mode = GRPMODE;
				break;
			case 'u':
				if ( mode )
					usage(prog);
				mode = USRMODE;
				break;
			case 't':
				if ( mode )
					usage(prog);
				mode = TTYMODE;
				break;
			case 'l':
				hangflag = 1;
				break;
			case '?':
				usage(prog);
		}
	}

	if ( argv[optind] )
		showmode = 0;
	if ( mode == 0 )
		mode = USRMODE;
	if ( hangflag )
	{
		/* can only hang for a terminal */
		if ( mode != TTYMODE || prog != LOCK )
			usage(prog);
		/* can only hang for one terminal */
		if ( optind != argc - 1 )
			usage(prog);
	}

	if ((prog == RETIRE) && (mode == TTYMODE))
		error( "can't retire a tty" );

	if ( showmode ) {
		if ( mode == TTYMODE )
			show_lcktty();
		else
			show_lckusers();
		exit(1);
	}

	p = &argv[optind];	
	switch( mode ) {
		case GRPMODE:
			if ( !p )
				error( "no group(s) specified" );
			while ( *p && p ) { 
				lock_group(*p, prog);
				p++;
			}
			break;
		case USRMODE: 
			if ( !p )
				error( "no user(s) specified" );
			while ( *p && p ) {
				lock_user(*p, mode, prog);
				p++;
			}
			break;
		case TTYMODE:
			if ( !p )
				error( "no tty(s) specified\n" );
			while ( *p && p ) {
				lock_tty(*p, prog);
				pseudo = 0;
				if(!strncmp(*p,"/dev/ttyp",9)) 
					pseudo = 1;
				if ( prog == UNLOCK )
					killprog("lock", *p); 
				if ( prog == LOCK && !pseudo ) 
				{
					lockmess(*p);
					killprog("getty", *p);
				}
				p++;
			}
			if ( hangflag  && (!pseudo))
				hang();
			break;
	}
	exit(0); 
}
/*
 *	lockmess   print a lock message out to the terminal being locked
 *		   
 */
lockmess( ttyn )
char *ttyn;
{
	int fd, i;

	if ( ( fd = open( ttyn, O_RDWR )) < 0 )
		error( "can't open %s for a message\n", ttyn );
	for ( i = 0; *mesg[i]; i++ )
		write( fd, mesg[i], strlen( mesg[i] ));
	close( fd );
}

/*
 *	killprog - kill the program that matches 'prog' name and has controlling
 *	           tty 'line'.
 */
#define PSLINELEN 1024
killprog(prog, line)
char  *prog;
char  *line;
{
	FILE  *fp;
	char  psl[PSLINELEN];
	int   pid;

	if ( (fp = popen("/bin/ps -e", "r")) == NULL )
	{
		fprintf(stderr, "Can't open pipe\n");
		exit(1);
	}

	fgets(psl, PSLINELEN, fp);		/* read and discard title */
	while ( fgets(psl, PSLINELEN, fp) )
	{
		psl[strlen(psl) - 1] = '\0';	/* strip <cr> and null term */
		pid = atoi(strtok(psl, " "));

		/* compare line against controlling tty from ps */
		if ( strcmp(strrchr(line, '/') + 1, strtok(NULL, " ")) )
			continue;

		strtok(NULL, " ");	/* strip past time */

		/* compare program to ps program */
		if ( strcmp(prog, strtok(NULL, " ")) )
			continue;

		/* match program naem and controlling tty, waste it!! */
		kill(pid, 9);
		return;
	}
}

/*
 *	hang   let the lock process hang around a bit. This is 
 *	       necessary for getty support.
 */
hang()
{
	int i;

	/* don't let signals disrupt us */
	for ( i = 0; i < MAXSIG; i++ )
		signal( i, SIG_IGN );

	while ( 1 )
		sleep( 9999 );
}

/*
 *	usage print the lock usage message on the screen. This routine
 *	      is smart enough to print the proper argv[0] as well.
 */
usage(prog)
int prog;
{
	fprintf(stderr, "usage:\n");
	switch (prog) {
	case LOCK:
		fprintf(stderr, "lock [-u] [user [user ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all users or lock named users\n");
		fprintf(stderr, "lock -g [group [group ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all users or lock members of named groups\n");
		fprintf(stderr, "lock -t [tty [tty ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all ttys or lock named ttys\n");
		fprintf(stderr, "lock -t -l tty\n");
		fprintf(stderr,
		  "\tlock named tty and wait forever (used by getty and login)\n");
		break;

	case UNLOCK:
		fprintf(stderr, "unlock [-u] [user [user ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all users or unlock named users\n");
		fprintf(stderr, "unlock -g [group [group ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all users or unlock members of named groups\n");
		fprintf(stderr, "unlock -t [tty [tty ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all ttys or unlock named ttys\n");
		break;

	case RETIRE:
		fprintf(stderr, "retire [-u] [user [user ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all users or retire named users\n");
		fprintf(stderr, "retire -g [group [group ...]]\n");
		fprintf(stderr,
		  "\tdisplay lock status of all users or retire members of named groups\n");
		break;
	default:
		error("usage: unknown command");
	}
		
	exit(1);
}
