/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) lckprm.c: version 25.4 created on 2/18/92 at 19:04:31	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)lckprm.c	25.4	2/18/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	lckprim    primitive operators for lock and unlock functions
 *		   (C)Copyright 1989 by Jeff Tofano
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <signal.h>
#include <sys/mount.h>
#include <pwd.h>
#include <grp.h>
#include <shadow.h>
#include <time.h>
#include <ctype.h> 
#include <errno.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <auth.h>

#define	LCKSTR		"*LK*"

#define UNLOCK	0
#define LOCK	1
#define RETIRE	2
#define OVER	4

extern struct passwd *getpwent();

/*
 *
 *	lock_display 
 *
 */

show_lcktty()
{
	ttyauth_t *ta;

	if (access(TTYAUTH, 0) != 0)
		error("can't find ttyauth file");

	printf("\n");	
	while (ta = gettaent()) {
		printf("%-40s", ta->ta_ttyn);
		if (ta->ta_status)
			printf("Locked at: %s", ctime(&ta->ta_status));
		else
			printf("Available\n");
	}
	endtaent(); 
}

/*
 *
 * 
 */
show_lckusers()
{
	struct passwd *pwd, *getpwent();
	usrauth_t *ua;


	if (access(USRAUTH,0) == 0) {
		while (ua = getuaent()) {
			printf("%-20s", ua->ua_name);

			if (ua->ua_passwd && *ua->ua_passwd)
				printf("PASSWD    ");
			else
				printf("NO PASSWD ");

			if (ua->ua_acctstat == LOCKED)
				printf( "LOCKED\n" );
			else if (ua->ua_acctstat == 0)
				printf("Available\n");
			else 	
				printf("Account Retired: %s",
					ctime(&ua->ua_acctstat));
		}
	} else
		while ( pwd = getpwent()) {
			if ( pwd->pw_passwd && *pwd->pw_passwd )
				printf("PASSWD    ");
			else
				printf("NO PASSWD ");
			if ( !strcmp(LCKSTR, pwd->pw_passwd))
				printf("LOCKED    ");
			else 
				printf("Unlocked  ");
			printf("%s\n", pwd->pw_name);
		}
}

/* 
 *	lock_user	lock a user account by setting the lock field
 *			in the usr_auth file or killing passwd if usr_auth 
 * 			doesn't exist
 * 
 */

lock_user( uname, mode, prog )
char *uname;
int prog, mode;
{
	FILE		*fp,
			*fopen();
	struct passwd	*pwd,
			*getpwent();
	usrauth_t	*ua;
	usrstat_t	*us,
			*getusent();
	struct stat	st;
	int		found = 0;
	int		lck_pass;
	time_t		tm;

	if (access(USRAUTH,0) == 0) {
		ua = getuanam(uname);
		if ( !ua )
		{
			enduaent();
			error("Unknown user\n");
		}

		us = getusent(ua->ua_uid);
		if ( !us )
		{
			enduaent();
			endustatent();
			error("corrupted or missing usr_stat file\n");
		}

		if ( !isokay(ua, prog) )
		{
			enduaent();
			endustatent();
			return;
		}

		if (prog == RETIRE) {
			time(&tm);
			ua->ua_acctstat = tm;
		} else if (prog == LOCK) 
			ua->ua_acctstat = LOCKED;
		else
			ua->ua_acctstat = NOLOCK;

		us->us_badtries = 0;
		updateuaent(ua, us, DO_BOTH);
		enduaent();
		endustatent();
		return;
	} else {
		if (prog == UNLOCK)
			error("can't unlock passwd %s",PASSWD);

		if (!(fp=fopen( PASSTEMP, "w" )))
			error( "can't open passwd temp file %s", PASSTEMP);

		if ((lck_pass = lcksec(PASSWD)) == -1)
			no_lock(PASSWD);

		while (pwd = getpwent()) {
			if (!strcmp(pwd->pw_name, uname)) {
				pwd->pw_passwd = LCKSTR;
				found = 1;
			}
			putpwent(pwd, fp);
		}
		fclose(fp);

		if (access(OPASSWD,0) == 0)
			if ( unlink( OPASSWD ) < 0 ) {
				ulcksec(lck_pass);
				error( "can't remove old passwd %s", OPASSWD);
			}

		if (link(PASSWD, OPASSWD) < 0) {
			ulcksec(lck_pass);
			error("can't link passwd %s to old passwd %s",
				 PASSWD, OPASSWD);
		}

		stat(PASSWD, &st);
		unlink(PASSWD);

		if (link(PASSTEMP, PASSWD) < 0) {
			ulcksec(lck_pass);
			error("can't make new passwd file %s", PASSWD);
		}

		unlink(PASSTEMP);
		chown(PASSWD, st.st_uid, st.st_gid);
		chmod(PASSWD, st.st_mode);
		ulcksec(lck_pass);
	}

	if (!found) 
		error("unknown user\n");
}

/* 
 *	lock_group	lock a group  by setting the lock field
 *			in the usr_auth file or killing passwds if usr_auth 
 * 			doesn't exist
 * 
 *	Parameter: char* grname     - group name.
 *		   int   prog       - program: lock, unlock or retire
 */

lock_group(grname, prog)
char	*grname;
int	prog; 
{
	struct passwd 	*pwd;
	struct group 	*gr, *getgrnam();
	char 		**cp;
	int		gid;


	if (gr = getgrnam(grname)) {
		 gid  = gr->gr_gid;

		/* get all the users with supplementary group membership */

		for ( cp = gr->gr_mem; cp && *cp; cp++ ) {
			if ( prog == UNLOCK )
				printf( "unlocking ");
			else if (prog == RETIRE) 
				printf("retiring  ");
			else
				printf("locking   ");

			printf("%s\n", *cp);
			lock_user(*cp, 0, prog);
		}
	}
	else {
		printf("unknown group %s\n", grname);
		endgrent();
		return;
	}

	endgrent();	

	/* get all the users who have it as thier default group */

	while (pwd = getpwent()) {
		if (pwd->pw_gid == gid ) {

			if (prog == UNLOCK)
				printf("unlocking ");
			else if (prog == RETIRE) 
				printf("retiring  ");
			else
				printf("locking   ");

			printf("%s\n", pwd->pw_name);
			lock_user(pwd->pw_name, 0, prog);
		}
	}
	endpwent();
}

/*
 * 	lock_tty 	lock a terminal by setting the lock field in the 
 *			tty_field 
 *
 */

lock_tty(ttyn, prog)
char *ttyn;
int prog;
{
	ttyauth_t	*ta;
	ttystat_t	*ts,
			*gettsent();
	priv_t		tmp;
	time_t 		tm;

	if (access(TTYAUTH, 0) != 0)
		error("no tty_auth file found");

	ta = gettanam(ttyn);
	if ( !ta )
		goto badtty;

	ts = gettsent(ta->ta_tsentry);
	if ( !ts )
		goto badtty;

	if ( prog == LOCK && ta->ta_status == 0 )
	{
		time(&tm);
		ta->ta_status = tm;
	}

	if ( prog == UNLOCK )
	{
		ta->ta_status = NOLOCK;
		ts->ts_tries = 0;
	}

	updatetaent(ta, ts, DO_BOTH );
	endtsent();
	endtaent();
	return;

badtty:
	endtsent();
	endtaent();

	/* secure the terminal */
	if ( getpriv( &tmp ) != -1 ) 
		set_file_slabel( ttyn, ta->ta_maxlabel );

	printf("unknown tty\n");
}

/*
 *
 *	isokay	decide if it's okay to lock/unlock the account 
 *
 */

isokay(ua, prog)
usrauth_t *ua;
int prog;
{
	switch (prog) {
		case UNLOCK:
			if ( ua->ua_acctstat >= RETIRE ) {
				fprintf( stderr,
					"can't unlock retired account\n" );
				return 0;
			}
			return 1;
		case LOCK:
			if ( ua->ua_acctstat >= RETIRE ) {
				fprintf( stderr,
					"can't lock retired account\n" );
				return 0;
			}
			return 1;
		case RETIRE:
		default:
			if (ua->ua_acctstat >= RETIRE) {
				fprintf( stderr, "%s is already retired\n",
					ua->ua_name );
				return 0;
			}
			return 1;
		}
}

error( str )
char *str;
{
	fprintf( stderr, "%s\n", str );
	exit(1);
}

void
no_lock (Fname)
char *Fname;
{
	(void)fprintf(stderr,"lock: %s file busy.  Try again later\n", Fname) ;
	exit (1) ;
}
