/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) lgstats.c: version 25.1 created on 12/2/91 at 17:19:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)lgstats.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	lgstats  display login stats from the usr_stat and dev_stat 
 *		 databases. If the user is the secadm, he's permitted
 *		 status on any account or device. If the user isn't the
 *		 security admin, he's only permitted stats on his own 
 *		 account or his current controlling terminal
 *
 *	(C)Copyright 1990 by ARIX Corp.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/fcntl.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/stat.h>
#include <sys/sakioctl.h>
#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <param.h>
#include <limits.h>
#include <shadow.h>
#include <auth.h>
#include <sys/security.h>


extern	int optind;
extern  char *optarg;

#define USRSTATUS		0x01
#define DEVSTATUS		0x02
#define VERBOSE			0x04
#define NETSTAT			0x10
#define SU			0x20

char buf[40];

main( argc, argv )
char **argv;
{
int c, i, mode, fd;
struct passwd *pwd, *getpwuid();
char *ttyn, *ttyname();
priv_t pv;


	mode = USRSTATUS;
	while ((c=getopt(argc, argv, "asnutv?"))!= -1 ) {
		switch(c) {
			case 'u':
				mode = USRSTATUS;
				break;
			case 't':
				mode |= DEVSTATUS;
				break;
			case 'n':
				mode |= NETSTAT;
				break;
			case 's':
				mode |= SU;
				break;
			case 'v':
				mode |= VERBOSE;
				break;
			case 'a':
				mode = USRSTATUS | VERBOSE | SU | NETSTAT;
				break;
			case '?':
			default:
				usage();
				exit(1);
		} 
	}
	
	if ( argv[optind] ) { 
		/* JTOF - since this guy is marked as suid to root,
		 * we must check the real privileges only !!
		 */
		if ( getpriv( &pv ) == -1 ) {
			if ( getuid() != 0 )
				error( "Permission denied" );
		}
		else {
			if ( ! (pv.real & P_SEC ))
				error( "Permission denied" );
		}
		for ( i = optind; i < argc; i++ ) {
			if ( mode & (USRSTATUS|VERBOSE|SU|NETSTAT) )
				usrstats( argv[i++], mode );
			if ( mode & (DEVSTATUS|VERBOSE|SU|NETSTAT) )
				devstats( argv[i++], mode );
		}
	}
	else {
		if ( mode & USRSTATUS ) {
			if (!(pwd = getpwuid( getuid() )))
				error( "unknown uid" );
			usrstats( pwd->pw_name, mode );
		}
		if ( mode & DEVSTATUS ) {
			if ( ( fd = open( "/dev/tty", O_RDONLY ))<0)
				error( "can't open controlling terminal\n" );
			if ( !( ttyn = ttyname( fd ) ))
				error( "unrecognized device\n" );
			devstats( ttyn, mode);
		}
	}
}

/*
 *	usrstats    report the user status for the indicated user	
 */

usrstats( uname, mode )
char *uname;
int mode;
{
usrauth_t *ua, *getuanam();
usrstat_t *us, *getusent();

	if ((access( USRSTAT, 0 )) || (access(USRAUTH, 0)))
		error( "no login user account status file present" );

	if (!( ua = getuanam( uname ))) 
		error( "unknown user account" );
	
	if (!(us = getusent(ua->ua_uid)))	
		error( "can't find user in account status file" ); 
	
	enduaent();
	showusr( ua, us, mode );
}

/*
 *	devstats   report the device status for the indicated device
 */

devstats( devname, mode )
char *devname;
int mode;
{
ttyauth_t *ta, *gettanam();
ttystat_t *ts, *gettsent();

	if ((access( TTYSTAT, 0 )) || (access(TTYAUTH, 0 )))
		return;

	if (!( ta = gettanam( devname ))) 
		error( "unknown device" );
	
	if (!(ts = gettsent(ta->ta_tsentry)))	
		error( "can't find device status file" ); 

	endtaent();
	showdev( ta, ts, mode );
}

/*
 *	showdev   display the formatted oupt of the dev_stat file
 *		  and any pertinent fields from the user_auth
 */
showdev( ta, ts, mode )
ttyauth_t *ta;
ttystat_t *ts;
int mode;
{
struct passwd *pwd, *getpwuid();
char buf[80];

	if ( ts->ts_lastlogin )
		printf( "Last Sucessful Login time on device:       %s",
	 		ctime( &ts->ts_lastlogin) );

	if ( ts->ts_lasttry ) {
		printf( "Last Unsuccessful Login attempt on device: %s",
			ctime( &ts->ts_lasttry) );
		printf( "Bad login attempts on device:              %d",
			ts->ts_tries );
	}

	switch ( ts->ts_reason_failed ) {
		case LOGIN_FAILED_TTY_LOCKED:
			strcpy( buf, "Login Device locked" );
			break;
		case LOGIN_FAILED_TTY_NOPERM:
			strcpy( buf, "User not authorized to use device" );
			break;
		default:
			*buf = 0;
			break;
	}
	if ( *buf )
		printf( "Reason authorization not granted:          %s\n", 
				buf );

	if ( mode & VERBOSE ) {
		if ( pwd = getpwuid( ts->ts_lastuid )) 
			printf( "Last User to Login on device:              %s\n",  
			pwd->pw_name );
		else
			printf( "Last UID to Login on device:               %d\n",
			ts->ts_lastuid );

		printf( "Failed login attempts on device:           %d\n",
				ts->ts_tries );
	}
}


/*
 *	showusr    display the formatted output of the usr_stat file
 *		   and any pertinent fields from the user_auth
 */
showusr( ua, us, mode )
usrauth_t *ua;
usrstat_t *us;
int mode;
{


	if ( us->us_lastlogin )
		printf( "Last Successful Login:                     %s",
			ctime( &us->us_lastlogin) );

	if ( us->us_ttyn )
		printf( "Port Last logged in from:                  %s\n" , 
			us->us_ttyn);

	if ( us->us_last_try )
		printf( "Last Unsuccessful Login attempt:           %s",
			ctime( &us->us_last_try) );

	if ( us->us_ttyn_try )
		printf( "Port of Last unsuccessful login attempt:   %s\n",
			us->us_ttyn_try );

	switch ( us->us_reason_failed ) {
		case LOGIN_FAILED_BADTIME:
			strcpy( buf, "login at unauthorized time" );
			break;
		case LOGIN_FAILED_BADPASWORD:
			strcpy( buf, "Bad password given" );
			break;
		case LOGIN_FAILED_BADUID:
			strcpy( buf, "Bad or unknown user id " );
			break;
		case LOGIN_FAILED_USER_LOCKED:
			strcpy( buf, "Account locked" );
			break; 
		case LOGIN_FAILED_USER_RETIRED:
			strcpy( buf, "Account retired" );
			break;
		default:
			*buf = 0;
			break;
	}
	if ( *buf )
		printf( "Reason authorization not granted:          %s\n", 
				buf );


	if ( mode & VERBOSE ) {
		printf( "Account Status:                            " );
		if ( ua->ua_acctstat == 0 )
			printf( "Unlocked\n" );
		else if ( ua->ua_acctstat == 1 )
			printf( "Locked\n" );
		else
			printf( "Retired: %s", 
				ctime( &ua->ua_acctstat ));
		printf( "Bad login attempts for account:            %d\n", 
				us->us_badtries );
	}
	if ( mode & SU ) {
		if ( us->us_lastsu )
			printf( "Last Successful su to account:             %s",
				ctime( &us->us_lastsu) );
	
		if ( us->us_ttyn_su )
			printf( "Port of Last successful su:                %s\n", 
			us->us_ttyn_su );

		if ( us->us_lastbadsu )
			printf( "Last Unsuccessful su attempt:              %s",
			ctime( &us->us_lastbadsu) );

		if ( us->us_ttyn_badsu )
			printf( "Port of Last unsuccessful su:              %s\n", 
			us->us_ttyn_badsu ); 
	}

	if ( mode & NETSTAT ) {
		if ( us->us_lastnetlogin )
			printf( "Last Successfull Network Login:            %s",
				ctime( &us->us_lastnetlogin) );
		if ( *us->us_host ) {
			printf( "Remote Host of Last network login:         %s\n",
				us->us_host );
		if ( *us->us_name ) 
			printf( "Remote User of Last network login:         %s\n",
				us->us_name );
		}
	}
}


/*
 *	usage
 */
usage()
{
	fprintf( stderr, "usage: lgstats [<uvta>] [<users>] [<devices>]\n" );
	fprintf( stderr, "       -u   display login user account status\n" );
	fprintf( stderr, "       -t   display login devices status\n" );
	fprintf( stderr, "       -v   include all information.\n" );
	fprintf( stderr, "       -n   display network login status\n" );
	fprintf( stderr, "       -a   display all database stats\n" );
	fprintf( stderr, "       -s   display su information\n" );
}

/*
 *
 */
error( str )
char *str;
{
	fprintf( stderr, "lgstats: %s\n", str );
	exit(1);
}


 

