/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) labels.c: version 25.1 created on 12/2/91 at 17:19:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)labels.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	labels    print label information.   
 *		  (C) Copyright 1989 by ARIX Corp.   
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <signal.h>
#include <sys/mount.h>
#include <pwd.h>
#include <time.h>
#include <ctype.h> 
#include <errno.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>

#define FOPS	1
#define DOPS	3
#define CLEAR	4

extern char *optarg;
extern int  optind;
extern slabelmap_t slabel_map[];

main( argc, argv )
char **argv;
{
int c, i, mode;
char *lname, buf[512];
slabel_t label;
slabelmap_t *p;

	mode = FOPS;
	lname = 0;
	while ((c = getopt( argc, argv, "cfds:?" )) != -1 ) {
		switch (c) {
			case 'd':
				mode = DOPS;
				break;
			case 'f':
				mode = FOPS;
				break;
			case 'c':
				mode = CLEAR;
				break;
			case 's':
				lname = optarg;
				break;
			case '?':
				usage();
				return;
			default:
				error( "bad or unknown options" );
		}
	}

	if ( mode == DOPS  ) {
		if ( lname ) 
			error( "bad command line option" );
			
		if ( argv[optind] )
			error( "bad command line option" );

		for ( p = slabel_map; *p->name; p++ )
			printf( "%s\n", p->name );
		return ;
	}
		
	/* display the list of static macs for files */
	if ( mode == CLEAR ) {
		label.level = 0;
		memset( label.catlst, 0, 16 );
		if ( !argv[optind] )
			error( "bad or unknown filename" );

		while ( argv[optind] ) { 
			if (set_file_slabel( argv[optind], &label ))
				error( "permission denied" ); 
			optind++;
		}
	}

	/* do a file operation....may be getting or setting label */
	if ( mode == FOPS ) {
		if ( !argv[optind])
			error( "bad or missing filename" );

		/* for each file */
		while ( argv[optind] ) {
			if ( access( argv[optind], 0) != 0 )
				error( "bad filename" );

			/* check label name - if no label must be display */
			if ( ! lname ) {
				if ( getfmac( &label, argv[optind])) {
					if ( errno == EPERM )
						error( "permission denied" ); 
					else
						error( 
						"bad or unknown filename " );
				}
				if (!cvt_slabel_sym( buf, &label ))
					error( "bad or unknown label" );

				printf( "%-20s%s\n", buf, argv[optind] );
			}
			else 	{
				if (!cvt_sym_slabel( lname, &label))
					error( "bad or unknown label\n" );
				else
					if (setfmac( &label, argv[optind])) {
						if ( errno == EPERM ) 
							error( "permission denied" );
						else
							error( "bad or unknown filename" );
						}
			}
		optind++;
		}
	}
}
				
usage()
{
	fprintf( stderr, "usage: labels [<dsfc>] [filenames]\n" );
	fprintf( stderr, "       -f specify file list to set/get labels\n");;
	fprintf( stderr, "       -s specify labels to set on file\n" ); 
	fprintf( stderr, "       -c clear any labels on file\n" );
	fprintf( stderr, "       -d display available labels\n" );
	exit(1);
}
				

error( str )
char *str;
{
	fprintf( stderr, "%s\n", str );
	exit(errno);
}
