/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) delgrp.c: version 25.2 created on 2/26/92 at 18:34:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)delgrp.c	25.2	2/26/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <grp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "auth.h"

#if !defined(TRUE)
#define 	TRUE	1	
#endif

#if !defined(FALSE)
#define 	FALSE	0
#endif

#ifdef SECON
int shadow_is_there = FALSE;
#endif /* SECON */

main(argc, argv)
int argc;
char *argv[];
{

	char *group_name;
	char **name_list;
	char *name;
	int name_index;
	int copy_index;
	int group_exists = FALSE;
	int result;
	struct group *group_entry;
	struct stat stat_buffer;

#ifdef SECON
	/* Check security */
	if (!priv(P_SEC, getuid())) {
		fprintf(stderr, "delgrp: You do not have enough privledge to run this command\n");
		return(1);
	}

	if (access(SGRPFLE, 06) >= 0)
		shadow_is_there = TRUE;

#endif /* SECON */

	/* If we have no args then do a usage */
	if (argc <= 1)
		usage();
		/* NOT REACHED */

	argv++;				/* Skip pass the command name */
	group_name = *(argv++);		/* Next comes the group name */
	name_list = argv;		/* Next a list of member names */

	if ((group_entry = getgrnam(group_name)) == (struct group *)NULL) {
		fprintf(stderr, "delgrp: group %s does not exist\n",group_name);
		return(1);
	}

	if (*name_list == NULL) {
		report_status(group_entry);
		return(0);
	}

	/* Make sure our names are valid, remove any that aren't */
	check_names(name_list);	

	if (*name_list == NULL) {
		/* If check_names removed ALL our names */
		fprintf(stderr, "delgrp: No valid members left to delete\n");
		return(1);
	}

	result = delete_group_members(group_entry, name_list);

	return(result);
}

delete_group_members(group_entry, name_list)
struct group *group_entry;
char *name_list[];
{
	char **new_member_list;
	char **group_index, **name_index;
	char new_name[BUFSIZ], new_passwd[BUFSIZ];
	char *new_member_buffer, *next_pointer;
	char *null_pointer = NULL;
	int size_of_list;
	int size_of_member_list;
	int result;
	struct group new_entry;
	extern char *malloc();

#ifdef SECON
	char new_auth_passwd[BUFSIZ];
	struct grpauth	new_auth_entry;
	struct grpauth	*group_auth_entry;
	extern struct grpauth *getganam();
#endif /* SECON */

	remove_members(group_entry->gr_mem, name_list);

	/* Save the current set of members */
	size_of_member_list = full_list_size(group_entry->gr_mem);
	if ((new_member_buffer = malloc(size_of_member_list + 1)) == NULL) {
		fprintf(stderr, "delgrp: ran out of memory\n");
		return(1);
	}

	next_pointer = new_member_buffer; 
	for (group_index = group_entry->gr_mem; *group_index != NULL; 
								group_index++) {
		strcpy(next_pointer, *group_index);
		*group_index = next_pointer;
		next_pointer += (strlen(*group_index) + 1);
	}
		
	size_of_list = list_size(group_entry->gr_mem);

	/* Make a space to for new list */
	if ((new_member_list = 
		(char **)malloc(sizeof(char *)*(size_of_list + 1))) == NULL) {
		fprintf(stderr, "delgrp: ran out of memory\n");
		return(1);
	}

	/* Copy the current member list into the new member list */
	name_index = new_member_list;
	for (group_index = group_entry->gr_mem; *group_index != NULL;
								group_index++)
		*name_index++ = *group_index;

	*name_index = NULL;

	/* make a new copy of the group struct because the current entry points
	 * to static memory in getgrent(). Since update_group_file() uses
	 * getgrent() to parse the file, it will over write our entry unless
	 * we save it some where.
	 */
	strcpy(new_name, group_entry->gr_name);
	strcpy(new_passwd, group_entry->gr_passwd);
	new_entry.gr_name = new_name;
	new_entry.gr_passwd = new_passwd;
	new_entry.gr_gid = group_entry->gr_gid;
	new_entry.gr_mem = new_member_list;
#ifdef SECON
	if (shadow_is_there) {
		if ((group_auth_entry = getganam(new_name)) == NULL) {
			fprintf(stderr, "delgrp: can't access the %s file\n",
								SGRPFLE);
			return(1);
		}

		new_auth_entry.ga_name = new_name;
		strcpy(new_auth_passwd, group_auth_entry->ga_passwd);
		new_auth_entry.ga_passwd = new_auth_passwd;
		new_auth_entry.ga_gid = group_auth_entry->ga_gid;
		new_auth_entry.ga_mem = new_member_list;
		new_auth_entry.ga_acctstat = group_auth_entry->ga_acctstat;
	}
#endif /* SECON */

	result = update_group_file(&new_entry);

#ifdef SECON
	if (result == 0 && shadow_is_there)
		result = updategaent(&new_auth_entry);
#endif /* SECON */

	return(result);
}

update_group_file(new_entry)
struct group *new_entry;
{
	FILE *temp_file;
	struct group *group_entry;
	int found_entry = FALSE;

	/* Create and Open the temp file */
	if ((temp_file = fopen(GRPTMP, "w")) == NULL) {
		fprintf(stderr, "delgrp: can't open or access %s\n", GRPTMP);
		return(1);
	}

	/* read the real group file writing the entries to the temp file
	 * until we find our entry, then write our entry.
	 */
	setgrent();
	while ((group_entry = getgrent()) != NULL) {
		if (strcmp(group_entry->gr_name, new_entry->gr_name) == 0) {
			putgrent(new_entry, temp_file);
			found_entry = TRUE;
		}
		else
			putgrent(group_entry, temp_file);
	}
	endgrent();
	fclose(temp_file);

	/* If we didn't find it then the file has changed since we did our
	 * getgrnam() call in main(). Can't really do anything about that.
	 */
	if (found_entry == FALSE) {
		fprintf(stderr, "delgrp: group %s disappeared before I got a chance to update it\n", new_entry->gr_name);
		unlink(GRPTMP);
		return(1);
	}

	/* Replace the current group file with the temp version */
	if (rename(GRPFLE, OGRPFLE) < 0) {
		perror("delgrp");
		unlink(GRPTMP);
		return(1);
	}

	if (rename(GRPTMP, GRPFLE) < 0) {
		perror("delgrp");
		return(1);
	}
	return(0);
}

/* How many entries in a list, don't count the NULL */
list_size(list)
char **list;
{
	int size_of_list;

	for(size_of_list = 0; *list != NULL; list++, size_of_list++);

	return(size_of_list);
}

/* Total size of all entries in the list */
full_list_size(list)
char **list;
{
	int full_size_of_list = 0;

	for(full_size_of_list = 0; *list != NULL; list++)
		full_size_of_list += strlen(*list) + 1;

	return(full_size_of_list);
}

/* Report the status of the group, name, gid, members and optionally the
 * security status.
 */
report_status(group_entry)
struct group *group_entry;
{
	char **name_index;
#ifdef SECON
	struct grpauth *group_auth_entry;
#endif /* SECON */

	printf("Group name: %s\n", group_entry->gr_name);
	printf("Group ID: %u\n", group_entry->gr_gid);
	printf("Group Members: ");

	for (name_index = group_entry->gr_mem;*name_index != NULL;name_index++){
		fputs(*name_index, stdout);
		if (*(name_index + 1) != NULL)
			putchar(',');
	}
	putchar('\n');

#ifdef SECON
	if (shadow_is_there) {
		if((group_auth_entry = getganam(group_entry->gr_name)) == NULL){
			fprintf(stderr, "delgrp: can't access shadow entry\n");
			return;
		}
		printf("Group Status: ");
		switch (group_auth_entry->ga_acctstat) {
			case 0:		printf("UNLOCKED\n");
					break;
			case 1:		printf("LOCKED\n");
					break;
			default:	printf("RETIRED on %s", 
					ctime(&(group_auth_entry->ga_acctstat)));
					break;
		}
	}
#endif /* SECON */
}

/* remove out of the original_list, the contents of members_to_remove
 *
 * I know, I know, there are more efficient ways to do this.
 */
remove_members(original_list, members_to_remove)
char *original_list[];
char **members_to_remove;
{
	char *name;
	char **remove_index;
	int name_index;
	
	/* Go down the remove list and check it against the original list */
	for (remove_index = members_to_remove; *remove_index != NULL; 
								remove_index++)
		for (name_index = 0; original_list[name_index] != NULL;
								name_index++) 
			if (strcmp(*remove_index, original_list[name_index])
									== 0) {
				skip_name(original_list, name_index);
				name_index--;
			}
}


/* Check a list of login names. Remove any that aren't valid. */
check_names(name_list)
char *name_list[];
{
	char *name;
	int name_index;
	struct passwd *name_entry;
	extern struct passwd *getpwnam();
	
	/* Go down the names and check each one */
	for (name_index = 0; name_list[name_index] != NULL; name_index++) {
		name = name_list[name_index];
		if ((name_entry = getpwnam(name)) == NULL) {
			fprintf(stderr, "delgrp: invalid member name %s, skipped\n", name);
			skip_name(name_list, name_index);
			name_index--;
		}
	}
}

/* Copy all the entries below name_index up one, effectively removing
 * the entry in name_index.
 */
skip_name(name_list, name_index)
char *name_list[];
int name_index;
{
	int copy_index;

	for (copy_index = name_index + 1; name_list[copy_index] != NULL;
						copy_index++, name_index++)
		name_list[name_index] = name_list[copy_index];
	name_list[name_index] = NULL;
}

usage()
{
	fprintf(stderr, "usage: delgrp groupname [ members ]\n");
	exit(1);
}
