/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) usrconv.c: version 25.1 created on 12/2/91 at 17:18:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)usrconv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	usrconv   convert the usr_auth database from binary to ascii and 
 *		  from ascii to binary
 *	(c) 1989, 1990 by ARIX Corp.
 * 
 *	Command Line:  
 *	  usrconv -a > ascii file   usrconv -b < ascii file
 *
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/fcntl.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/stat.h>
#include <sys/sakioctl.h>
#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <param.h>
#include <limits.h>
#include <shadow.h>
#include <auth.h>
#include <sys/security.h>

#define 	LINEMAX		1024
#define		ROLE		"/dev/roles"
#define 	UIDS		"/dev/uids"
#define USRSTATTMP "/etc/security/usrstattmp"

extern char *optarg;
extern int  optind;
char buf[PATH_MAX];

main( argc, argv )
char **argv;
{
int c, mode;

	if ( ! priv (P_SEC, getuid ())){
		fprintf (stderr, "permission denied\n");
		exit (1);
	}

	/* parse the arguments */
	mode = 0;
	while ((c = getopt( argc, argv, "bad?" )) != -1 ) {
		switch(c) {
			case 'a':
				mode++;
				uconv_btoa(); 
			  	break;
			case 'b':
				mode++;
				uconv_atob();
				downld_roles();
				downld_uids();
			  	break;
			case '?': 
				 usage();
				 exit();
			case 'd':
				mode++;
				downld_roles();
				downld_uids();
				break;        
			default:
				usage();
				exit();
			
		}
	 }

	if (!mode)
		uconv_btoa();
}

/*
 *	uconv_btoa   convert the binary file to an ascii file
 * 
 */
uconv_btoa()
{
usrauth_t *ua, *getuaent();

	/* create the output file */
	while ( ua = getuaent() ) {
		ua_btoa( ua, buf );
		fprintf( stdout, "%s\n", buf );
	}
	return 0;
}

/*
 *	uconv_atob   convert a ascii file to a binary file 
 *
 */

uconv_atob()
{
register usrstat_t *us;
FILE *fopen();
int fd,fd1,fd2, cnt;
usrauth_t ua;
usrstat_t ustat;
struct passwd *pwd,*getpwnam(),pword;
slabel_t label;
FILE *fdp;
kern_uidmap_t ku;
int ret;

	/* open the destination file */
	if (( fd = open( USRAUTH, O_RDWR | O_TRUNC | O_CREAT, 0600 )) < 0 ) {
		fprintf( stderr,"usrconv: can't open %s\n", USRAUTH );
		fprintf( stderr,"usrconv: errno - %d\n", errno );
		return -1;
	}

	if (( fd2 = open( USRSTATTMP, O_RDWR | O_TRUNC | O_CREAT, 0600 )) < 0 ) {
		fprintf( stderr,"usrconv: can't open %s\n", USRSTATTMP );
		fprintf( stderr,"usrconv: errno - %d\n", errno );
		return -1;
	}

	if (( fdp = fopen( PASSTEMP, "w" )) < 0 ) {
		fprintf( stderr,"usrconv: can't open %s\n", PASSTEMP );
		fprintf( stderr,"usrconv: errno - %d\n", errno );
		return -1;
	}



	cnt = 0;
	/* for each line in ascii file convert and write to binary */
	while ( fgets( buf, PATH_MAX, stdin ) ) {
		ua_atob( &ua, buf );
		if ( ( ret = putuaent( fd, &ua ) ) < 0 ) {
			printf("Couldn't write to the %s file/n",USRAUTH);
			return -1;
		}
		
		if(( pwd = getpwnam(ua.ua_name) ) == NULL ) 
			pwd = &pword;

		pwd->pw_name = ua.ua_name;
		pwd->pw_passwd = "*";
		pwd->pw_age = "";
		pwd->pw_gecos = ua.ua_gecos;
		pwd->pw_dir = ua.ua_defdir;
		pwd->pw_shell = ua.ua_defshell;
		pwd->pw_uid = ua.ua_uid;
		pwd->pw_gid = ua.ua_gid;

		if( ( us = getusent(ua.ua_uid) ) == NULL ) {

			us = &ustat;
			us->us_uid = ua.ua_uid;
			us->us_badtries = 0;

			us->us_lastlogin = 0;
			us->us_ttyn[0] = 0;
			us->us_last_try = 0;
			us->us_ttyn_try[0] = 0;
			us->us_pwdchg = DAY_NOW;

		}
		/* JTOF - if we pass in the uid for the index, the file
	         * gets very large very very fast...instead, pass in 
		 * an index...we know what it should be 
		 */
		if ( ( ret = putusent( fd2, us, cnt++ ) ) < 0 ) {
			printf("Couldn't write to the %s file/n",USRSTATTMP);
			return -1;
		}
		

		if ( ( ret = putpwent( pwd , fdp) ) < 0 ) {
			printf("Couldn't write to the file/n");
			return -1;
		}

	}

	close( fd );
	close( fd2 );
	fclose( fdp );

	if( unlink(PASSWD) ) {
		fprintf( stderr, "Cannot unlink %s:  error # %d\n",PASSWD,errno);
		exit(1);
	}

	if ( link(PASSTEMP,PASSWD) ) {
		fprintf( stderr, "Cannot link password files %s : error # %d\n",PASSWD,errno);
		exit(1);
	}

	if( unlink(PASSTEMP) )  {
		fprintf( stderr, "Cannot unlink %s:  error # %d\n",PASSTEMP,errno);
		exit(1);
	}

	if( chmod(PASSWD,0444) )  {
		fprintf( stderr, "Cannot chmod on  %s:  error # %d\n",PASSWD,errno);
		exit(1);
	}

	if( unlink(USRSTAT) ) {
		fprintf( stderr, "Cannot unlink %s:  error # %d\n",USRSTAT,errno);
		exit(1);
	}

	if ( link(USRSTATTMP,USRSTAT) ) {
		fprintf( stderr, "Cannot link stat files %s : error # %d\n",USRSTAT,errno);
		exit(1);
	}

	if( unlink(USRSTATTMP) )  {
		fprintf( stderr, "Cannot unlink %s:  error # %d\n",USRSTATTMP,errno);
		exit(1);
	}

	if (!cvt_sym_slabel( "SYS_SEC", &label)) 
		fprintf( stderr, "cannot change label on %s and %s\n", 
				USRAUTH, USRSTAT );
	else {
		set_file_slabel( USRAUTH, &label );
		set_file_slabel( USRSTAT, &label );
	}
	return 0;
}

/*
 *
 */
usage()
{
	fprintf( stderr, "usage:  usrconv [<abd>] [<>filename]\n" );
	fprintf( stderr, "        -b convert ascii file to %s\n", USRAUTH );
	fprintf( stderr, "        -a convert %s to ascii file\n", USRAUTH );
	fprintf( stderr, "        -d do role/uid download only\n" );
}

/*
 *	downld_roles copy the contents of the roles database to the
 *	             kernel
 */
downld_roles()
{
kern_role_t krole;
roldef_t *rp, *getrolent();
int i, fd;
priv_t tmp;

	/* don't waste download time if no privileges */
	if ( getpriv( &tmp ) == -1 )
		return -1;

	/* open the roles database */
	if ( ( fd = open( ROLE, O_WRONLY )) < 0 ) {
		fprintf( stderr, "Can't open %s\n", ROLE );
		return -1;
	}

	i = 1;		/* record counter for error messages */
	setrlent();
	while ( rp = getrolent() ) {
		krole.role = rp->r_rolenumber;
		memcpy( &krole.priv, &rp->r_priv, sizeof( priv_t ));
		memcpy( &krole.minlabel, &rp->r_minlabel, sizeof( slabel_t));
		memcpy( &krole.maxlabel, &rp->r_maxlabel, sizeof( slabel_t));
		krole.status = 0;
		if (write( fd, &krole, sizeof(kern_role_t))!= 
				sizeof(kern_role_t)) {
			fprintf( stderr, "Record %d: Can't download to%s\n", 
				i, ROLE );
				return -1;
		}
		i++;
	}
	endrlent();	
	close(fd);
	fprintf( stderr, "%i Roles loaded to kernel\n", i-1 );
}

/*
 *	downld_uids   dowload the user id's to the kernel. This is 
 *		      done as an after thought for compatabity
 */	
downld_uids()
{
kern_uidmap_t uids;
usrauth_t *ua, *getuaent();
struct passwd *pwd, *getpwent();
priv_t tmp;
int i, fd;

	/* don't waste download time if no privileges */
	if ( getpriv( &tmp ) == -1 )
		return;

	/* open the roles database */
	if ( ( fd = open( UIDS, O_WRONLY )) < 0 ) {
		fprintf( stderr, "Can't open %s\n", ROLE );
		return -1;
	}

	/* if the userauth file exists use it for the download */
	if ( access( USRAUTH, 0 ) == 0 ) {
		i = 1;
		while ( ua = getuaent() ) {
			uids.uid = ua->ua_uid;
			uids.role = ua->ua_role;
			uids.status = ua->ua_acctstat;
			if ( write( fd, &uids, sizeof( kern_uidmap_t)) != 
				sizeof( kern_uidmap_t)) {
				fprintf( stderr, "Rec %d: Can't dwnload to%s\n",					UIDS ); 
				return -1;
			}	
		i++; 
		}
	}
	/* user the /etc/passwd file for the download */
	else {
		i = 1;  
		while ( pwd = getpwent() ) {
			uids.uid = pwd->pw_uid;
			uids.role = 0;
			uids.status = 1;
			if ( write( fd, &uids, sizeof( kern_uidmap_t)) != 
				sizeof( kern_uidmap_t)) {
				fprintf( stderr, "Rec %d: Can't dwnload to%s\n",					UIDS ); 
				return -1;
			}
		i++; 
		}
	}
	close( fd );
	endpwent();
	fprintf( stderr, "% Uids downloaded to kernel\n", i-1 );
	return 0;
}
	
