/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) roleconv.c: version 25.1 created on 12/2/91 at 17:18:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)roleconv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	roleconv   do ascii/binary converions of the role database and
 *		   perform downloading of all the databases, role, uid
 *		   and gid
 *	(C)Copyright 1990 by ARIX Corp.
 *
 */

#include "sys/types.h"
#include "sys/priv.h"
#include "sys/mls.h"
#include "sys/stat.h"
#include "sys/security.h"
#include "pwd.h"
#include "stdio.h"
#include "fcntl.h"
#include "limits.h"
#include "auth.h"
#include "errno.h"

#define 	LINEMAX		1024
#define		ROLE		"/dev/roles"
#define 	UIDS		"/dev/uids"
#define		ROLEDEF		"/etc/roledef"
#define		TMPROLEDEF	"/etc/tmproledef"
#define		TMPROLES	"/etc/security/tmproles"
extern uint 	optind;
extern char	*optarg;

char buf[LINEMAX];
char realname[PATH_MAX];
char maskname[PATH_MAX];
char minlabel[40];
char maxlabel[40];

main( argc, argv )
char **argv;
{
int c;
int arg = 0;

	while ((c = getopt( argc, argv, "ab?" ))!= -1 ) {
		switch( c ) {
			case 'a':
				arg++;
				role_ascii();
				break;
			case 'b':
				arg++;
				ascii_role();
				downld_roles();
				downld_uids();
				break;
			default:
				usage();
				return;
		}
	}
	if ( !arg )
		role_ascii();
}

/*
 *	role_ascii   convert the role database to an ascii database. This
 *	             will be printed to stdout so that a user can redirect
 *		     the output to a file and edit it.
 */
role_ascii()
{
roldef_t *rp, *getrolent();
int i;

#ifndef DEBUG
	if (! priv( P_SEC, getuid())) {
		fprintf( stderr, "permission denied\n" );
		exit(1);
	}
#endif

	i = 1;
	while ( rp = getrolent() ) { 
		if ( (i-1) != rp->r_rolenumber )
			fprintf( stderr, "line %d: bad rolenumber\n" );

		if (! cvt_slabel_sym( minlabel, &rp->r_minlabel )) {
			fprintf( stderr, "line %d: unknown min label\n", i );
			exit(1);
		}
		if (! cvt_slabel_sym( maxlabel, &rp->r_maxlabel )) {
			fprintf( stderr, "line %d: unknown max label\n", i );
			exit(1);
		}
		*realname = 0;
		if (! cvt_priv_to_sym( rp->r_priv.real, realname, 1, ' ' )) {
			fprintf( stderr, "line %d: unkwown real priv\n", i ); 
			exit(1);
		}

		*maskname = 0;
		if (! cvt_priv_to_sym( rp->r_priv.mask, maskname, 1, ' ' )) {
			fprintf( stderr, "line %d: unknown priv mask\n", i );
			exit(1);
		}

		printf( "%-12s%-4d%-12s%-12s", rp->r_name, rp->r_rolenumber,
			minlabel, maxlabel );
		printf( "%s   %s\n", realname, maskname );
		i++; 
	}
	fprintf( stderr, "Converted %d Roles from Role Database\n", i-1 );
	return;
}

/*
 *
 */
ascii_role()
{
roldef_t role;
slabel_t label;
int fd, rdfd, i, tmp;


	if ( (fd = creat(TMPROLES, 0)) == -1 ) {
		fprintf(stderr, "can't open role database\n");
		exit(1);
	}
	if ( (rdfd = creat(TMPROLEDEF, 0)) == -1 ) {
		fprintf(stderr, "can't open %s\n", ROLEDEF);
		exit(1);
	}

	i = 1;
	while ( fgets( buf, LINEMAX, stdin ) ) {
		sscanf( buf, "%s%d%s%s%s%s", role.r_name, &(role.r_rolenumber),
			minlabel, maxlabel, realname, maskname );
		if ( role.r_rolenumber != (i-1)) {
			fprintf( stderr, "line %d: bad rolenumber passed", 
				role.r_rolenumber );
			fprintf( stderr, " - adjusting to %d\n", i - 1 );
			role.r_rolenumber = i - 1;
		}
		if (!cvt_sym_slabel( minlabel, &role.r_minlabel )) {
			fprintf( stderr, "line %d: unknown min label\n", i );
			exit(1);
		}
		if (!cvt_sym_slabel( maxlabel, &role.r_maxlabel )) {
			fprintf( stderr, "line %d: unknown max label\n", i );
			exit(1);
		}
		tmp = 0;
		if (!cvt_sym_to_priv( realname, &tmp, ' ' )) {
			fprintf( stderr, "line %d: unknown real priv\n", i );
			exit(1);
		}
		role.r_priv.real = tmp;
		role.r_priv.eff = 0;
		tmp = 0;
		if (!cvt_sym_to_priv( maskname, &tmp, ' ' )) {
			fprintf( stderr, "line %d: unknown mask priv\n", i );
			exit(1);
		}
		role.r_priv.mask = tmp;

		if (putrlent( fd, &role ) < 0) {
			fprintf( stderr, "Can't Write to role database\n");
			exit(1);

		}
		if ( write(rdfd, buf, strlen(buf)) != strlen(buf) ) {
			fprintf( stderr, "Can't Write to %s\n", ROLEDEF);
			exit(1);
		}
		i++;
	}
	close(fd);
	close(rdfd);
	rename(TMPROLEDEF, ROLEDEF);
	rename(TMPROLES, ROLES);
	chmod(ROLEDEF, 0444);
	chmod(ROLES, 0400);
	chown(ROLEDEF, 0, 3);
	chown(ROLES, 0, 3);

	if (! cvt_sym_slabel( "SYS_SEC", &label )) {
		fprintf( stderr, "Can't secure %s with label\n", ROLE );
		exit(1);
	}
	set_file_slabel( ROLE, &label );
	fprintf( stderr, "%d Roles in Role Database\n", i-1 );
	return;
}

/*
 *	downld_roles copy the contents of the roles database to the
 *	             kernel
 */
downld_roles()
{
kern_role_t krole;
roldef_t *rp, *getrolent();
int i, fd;
priv_t tmp;

	/* don't waste download time if no privileges */
	if ( getpriv( &tmp ) == -1 ) {
		fprintf(stderr, "non secure kernel\n");
		exit(1);
	}

	/* open the roles database */
	if ( ( fd = open( ROLE, O_WRONLY )) < 0 ) {
		fprintf( stderr, "Can't open %s\n", ROLE );
		exit(1);
	}

	i = 1;		/* record counter for error messages */
	if ( setrlent() == -1 ) {
		fprintf( stderr, "can't open role database\n");
		exit(1);
	}
	while ( rp = getrolent() ) {
		krole.role = rp->r_rolenumber;
		memcpy( &krole.priv, &rp->r_priv, sizeof( priv_t ));
		memcpy( &krole.minlabel, &rp->r_minlabel, sizeof( slabel_t));
		memcpy( &krole.maxlabel, &rp->r_maxlabel, sizeof( slabel_t));
		krole.status = 0;
		if (write( fd, &krole, sizeof(kern_role_t))!= 
				sizeof(kern_role_t)) {
			fprintf( stderr, "Record %d: Can't download to%s\n", 
				i, ROLE );
				exit(1);
		}
		i++;
	}
	endrlent();	
	close(fd);
	fprintf( stderr, "%i Roles loaded to kernel\n", i - 1 );
}

/*
 *	downld_uids   dowload the user id's to the kernel. This is 
 *		      done as an after thought for compatabity
 */	
downld_uids()
{
kern_uidmap_t uids;
usrauth_t *ua, *getuaent();
struct passwd *pwd, *getpwent();
priv_t tmp;
int i, fd;

	/* don't waste download time if no privileges */
	if ( getpriv( &tmp ) == -1 ) {
		fprintf(stderr, "non secure kernel\n");
		exit(1);
	}

	/* open the roles database */
	if ( ( fd = open( UIDS, O_WRONLY )) < 0 ) {
		fprintf( stderr, "Can't open %s\n", ROLE );
		exit(1);
	}

	/* if the userauth file exists use it for the download */
	if ( access( USRAUTH, 0 ) == 0 ) {
		i = 0;
		while ( ua = getuaent() ) {
			uids.uid = ua->ua_uid;
			uids.role = ua->ua_role;
			uids.status = ua->ua_acctstat;
			if ( write( fd, &uids, sizeof( kern_uidmap_t)) != 
				sizeof( kern_uidmap_t)) {
				fprintf( stderr, "Rec %d: Can't dwnload to%s\n",					UIDS ); 
				exit(1);
			}	
		i++; 
		}
	}
	/* user the /etc/passwd file for the download */
	else {
		i = 0;   
		while ( pwd = getpwent() ) {
			uids.uid = pwd->pw_uid;
			uids.role = 0;
			uids.status = 1;
			if ( write( fd, &uids, sizeof( kern_uidmap_t)) != 
				sizeof( kern_uidmap_t)) {
				fprintf(stderr, "Rec %d: Can't dwnload to %s\n",
				  UIDS ); 
				exit(1);
			}
		i++; 
		}
	}
	close( fd );
	endpwent();
	fprintf( stderr, "%d Uids downloaded to kernel\n", i );
	return;
}
	

/*
 *	usage    
 */
usage()
{
	fprintf( stderr, "usage: roleconv [<ab>]\n" );
	fprintf( stderr, "       -a convert binary role file to ascii\n" );
	fprintf( stderr, "       -b convert ascii file to binary role\n" );
}
