/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) devconv.c: version 25.1 created on 12/2/91 at 17:17:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)devconv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	devconv   convert the device database from binary to ascii and 
 *		  from ascii to binary
 *
 *	(c) 1989, 1990 by ARIX Corp.
 * 
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/fcntl.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/stat.h>
#include <sys/sakioctl.h>
#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <param.h>
#include <limits.h>
#include <auth.h>

#define BTOA	0
#define ATOB	1

extern char *optarg;
extern int  optind;

/*
 *  The "ta_ascii" string must be long enough to contain an entry from the
 *  dev_auth file.  The worst case will have MAXUG groups and MAXUG
 *  users. The length of the fields in the devauth file may change (esp
 *  the ttyname field), but there aren't any other good defines to use.
 */
#define TA_ASCII_LEN (1000 + (MAXUG * NAME_MAX * 2))
char ta_ascii[TA_ASCII_LEN];

main( argc, argv )
char **argv;
{
int c, mode;

	/* setup the defaults */
	mode = BTOA;

	/* parse the arguments */
	while ((c = getopt( argc, argv, "ba?" )) != -1 ) {
		switch(c) {
			case 'a': mode = BTOA;
			  	break;
			case 'b': mode = ATOB;
			  	break;
			case '?':  usage();
				  exit();
			default:
				usage();
				exit();
			
		}
	 }

	if ( ! priv (P_SEC, getuid ())){

		fprintf (stderr, "permission denied\n");
		exit (1);
	}

	if(mode == BTOA)
		conv_btoa();
	else
		conv_atob();
}

/*
 *	conv_btoa   convert the binary file to an ascii file
 * 
 */
conv_btoa()
{
ttyauth_t *ta, *gettaent();

	/* create the output file */
	while ( ta = gettaent() ) {
		ta_btoa( ta, ta_ascii );
		fprintf( stdout, "%s\n", ta_ascii );
	}
	return 0;
}

/*
 *	conv_atob   convert a ascii file to a binary file 
 *
 */

conv_atob()
{
FILE *fp, *fopen();
int fd,fd1,i;
ttyauth_t ta;
ttystat_t ts;
slabel_t label;


	/* open the destination file */
	if (( fd = open( TTYAUTH, O_RDWR | O_TRUNC | O_CREAT, 0600 )) < 0 ) {
		fprintf( stderr,"devconv: can't open %s\n", TTYAUTH );
		fprintf( stderr,"devconv: errno - %d\n", errno );
		return -1;
	}

	if (( fd1 = open( TTYSTAT, O_RDWR | O_TRUNC | O_CREAT, 0600 )) < 0 ) {
		fprintf( stderr,"devconv: can't open %s\n", TTYSTAT );
		fprintf( stderr,"devconv: errno - %d\n", errno );
		return -1;
	}
	/* for each line in ascii file convert and write to binary */
	i = 0;
	while ( fgets( ta_ascii, TA_ASCII_LEN, stdin ) ) {
		ta_atob( &ta, ta_ascii );
		ta.ta_tsentry = i;
		if ( puttaent( fd, &ta ) < 0 )
			return -1;
		if ( puttsent( fd1, &ts ) < 0 )
			return -1;
		i++;
	}
	close( fd );
	close( fd1 );
	
	if (!cvt_sym_slabel( "SYS_SEC", &label) )
		fprintf(stderr, "cannot change label on %s and %s\n", 
			TTYAUTH, TTYSTAT );
	else {
		set_file_slabel( TTYAUTH, &label );
		set_file_slabel( TTYSTAT, &label );
	}
	
	return 0;
}

/*
 *
 */
usage()
{
	fprintf( stderr, "usage: devconv -a > file | devconv -b < file\n" );
	fprintf( stderr, "        -b convert ascii file to %s\n", TTYAUTH );
	fprintf( stderr, "        -a convert %s to ascii file\n", TTYAUTH );
}
	

	


