/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chpriv.c: version 25.1 created on 12/2/91 at 17:17:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chpriv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	chpriv	change the privilege of a file
 *		  (C) Copyright 1989 by ARIX Corp.   
 *
 *	Version 2:  Rework done to this utility for new privileges
 *		    mechanism. Also made arguments and usage messages
 *		    much cleaner.
 */

#ident "chpriv: Version 2"
 
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <signal.h>
#include <sys/mount.h>
#include <pwd.h>
#include <time.h>
#include <ctype.h> 
#include <errno.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>

#define FOPS	1
#define DOPS	2
#define COPS	3


extern char *optarg;
extern int  optind;
extern priv_sym_t priv_pmap[], priv_cmap[];

main( argc, argv )
char **argv;
{
int c, i, mode, clrmode;
char *lname, buf[512];
uint priv;

	mode = FOPS;
	lname = 0;
	clrmode = 0;
	while ((c = getopt( argc, argv, "fdc?s:" )) != -1 ) {
		switch (c) {
			case 'd':
				mode = DOPS;
				break;
			case 'f':
				mode = FOPS;
				break;
			case 's':
				lname = optarg;
				break;
			case 'c':
				clrmode = 1;	
				break;
			case '?':
				usage();
				return;
			default:
				error( "bad or unknown option" );
		}
	}

	/* display possible privileges */
	if ( mode == DOPS ) {
		if ( lname )
			error( "invalid option combination" );

		if ( argv[optind] )
			error( "bad or unknown filename" );

		listprivs();
	}

	/* set or display file privileges */	
	if ( mode == FOPS ) {
		/* if no file names passwd give error message */
		if ((argv[optind] == 0) || (*argv[optind] == 0 ))
			error( "bad or unknown filename" );
	
		while ( argv[optind] ) {
			priv = 0;
			if ( ( ! lname ) && ( clrmode == 0 )) {
				if (get_file_priv( argv[optind], &priv )) 
					error( "permission denied" ); 
				if ( priv == 0 ) 
					strcpy( buf, "no privileges" );
				else if (!cvt_priv_to_sym( priv, buf, 0, ' ')) 
					error( "bad or unknown privilege" );
				printf( "%-20s %s\n", argv[optind], buf );
			}
			else if (!lname && clrmode) {
				if (set_file_priv( argv[optind], &priv ))
					error( "permission denied" );
			}
			/* set the privilege */
			else 	{
				if (!mkpriv( lname, &priv))
					error( "bad or invalid privilege" );
#ifdef DEBUG
				printf( "setting %s - 0x%x\n", 
					argv[optind], &priv );
#else
				if (set_file_priv( argv[optind], &priv ))
					error( "permission denied" );
#endif
			}
		optind++;
		}
	}
}

/*
 *	listprivs
 */

listprivs()
{
int i;
char buf[512];

	/* show the primitive privilege map */
	printf( "\nPrimitive Privileges:\n" );
	for ( i = 0; *priv_pmap[i].p_name; i++ ) 
		printf( "%s\n", priv_pmap[i].p_name );

	/* show the combination privilege map */
	printf( "\nCombinational Privileges:" );
	for ( i = 0; *priv_cmap[i].p_name; i++ ) {
		if (!cvt_priv_to_sym( priv_cmap[i].p_priv, buf, 0, ' ' ))
			error( "bad or unknown privilege" );
		printf( "\n%s -> (%s)\n", priv_cmap[i].p_name, buf );
	}
}

/*
 *	mkpriv    take a command line argument, comma seperated and 
 *		  make a privilege from it 
 * 
 */

mkpriv( name, priv )
char *name;
uint *priv;
{
char *p, *tmp, *strchr();
uint tpriv;

	p = name;
	while ( *p && p  ) {
		if (tmp = strchr( p, ',' )) {
			*tmp++ = 0;
			if (!cvt_sym_to_priv( p, &tpriv, ',' ))
				return 0;
			p = tmp;
		}
		else {
			if (!cvt_sym_to_priv( p, &tpriv, ',' ))
				return 0;
			p = 0;
		}
		*priv |= tpriv;
	}
	return 1;
}

/*
 *
 *
 */

usage()
{
	fprintf( stderr, "usage: chpriv [<dscf>] [filenames]\n" );
	fprintf( stderr, "       -d display all known privilege\n" );
	fprintf( stderr, "       -s specify privilege list for file\n" );
	fprintf( stderr, "       -c clear file privileges\n" );
	fprintf( stderr, "       -f specify file list\n" );
	exit(1);
}
				
/*
 *
 *
 */

error( str )
char *str;
{
	fprintf( stderr, "%s\n", str );
	exit(errno);
}
