/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) valid.c: version 23.2 created on 2/7/91 at 14:48:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)valid.c	23.2	2/7/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <stdio.h>
#include <time.h>
#include <termio.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/tty.h>
#include <sys/utsname.h>
#include <sys/synch.h>
#include <sys/mls.h>
#include <sys/priv.h>
#include <sys/audit.h>



int sizes[AUD_MAX_DEF];


void
validate_init()
{
			/*use -1 for variable length records*/

	sizes[AUD_FORK] =  sizeof(sat_fork_t) ;	
	sizes[AUD_EXEC] =  sizeof(sat_exec_t) ;
	sizes[AUD_EXIT] =  sizeof(sat_exit_t) ;	
	sizes[AUD_SETUID] =  sizeof(sat_setuid_t) ;
	sizes[AUD_SETGID] =  sizeof(sat_setgid_t) ;	
	sizes[AUD_SETSID] =  sizeof(sat_setsid_t) ;	
	sizes[AUD_SUPPL] =  sizeof(sat_setsupp_t) ;	
	sizes[AUD_ROLE] =  sizeof(sat_setrole_t) ;	
	sizes[AUD_PRIV] =  sizeof(sat_priv_t) ;	
	sizes[AUD_LABEL] =  sizeof(sat_label_t) ;	
	sizes[AUD_CHROOT] =  sizeof(sat_chroot_t) ;	
	sizes[AUD_CTTY] =  sizeof(sat_ctty_t) ;	
	sizes[AUD_KILL] =  sizeof(sat_kill_t) ;	
	sizes[AUD_ACCSR] =  sizeof(sat_access_t) ;	
	sizes[AUD_ACCSW] =  sizeof(sat_access_t) ;	
	sizes[AUD_ACCFR] =  sizeof(sat_access_t) ;	
	sizes[AUD_ACCFW] =  sizeof(sat_access_t) ;	
	sizes[AUD_MKNOD] =  sizeof(sat_mknod_t) ;	
	sizes[AUD_PIPE] =  sizeof(sat_pipe_t) ;	
	sizes[AUD_CREAT] =  sizeof(sat_create_t) ;	
	sizes[AUD_LINK] =  sizeof(sat_link_t) ;	
	sizes[AUD_RENAME] =  sizeof(sat_rename_t) ;	
	sizes[AUD_UNLINK] =  sizeof(sat_unlink_t) ;	
	sizes[AUD_CHMOD] =  sizeof(sat_chmod_t) ;	
	sizes[AUD_CHOWN] =  sizeof(sat_chown_t) ;	
	sizes[AUD_CHGRP] =  sizeof(sat_chgrp_t) ;	
	sizes[AUD_FILEPRIV] =  sizeof(sat_filepriv_t) ;	
	sizes[AUD_FILELABEL] =  sizeof(sat_filelabel_t) ;	
	sizes[AUD_ACL] =  sizeof(sat_acl_t) ;	
	sizes[AUD_MOUNT] =  sizeof(sat_mount_t) ;	
	sizes[AUD_UMOUNT] =  sizeof(sat_umount_t) ;	
	sizes[AUD_SYSERR] =  sizeof(sat_syserr_t) ;	
	sizes[AUD_CLOCK] =  sizeof(sat_clock_t) ;	
	sizes[AUD_IPCREATE] =  sizeof(sat_ipccreat_t) ;	
	sizes[AUD_IPCACCESS] =  sizeof(sat_ipcaccess_t) ;	
	sizes[AUD_IPCRM] =  sizeof(sat_ipcrm_t) ;	
	sizes[AUD_IPCLABEL] =  sizeof(sat_ipclabel_t) ;	
	sizes[AUD_IPCDAC] =  sizeof(sat_ipcdac_t) ; 	
	sizes[AUD_IPCACL] =  sizeof(sat_acl_t) ;	
	sizes[AUD_LOGIN] =  sizeof(sat_login_t) ;	
	sizes[AUD_AUDIT] =  sizeof(sat_audit_t) ; 	
	sizes[AUD_USRINFO] =  sizeof(sat_usrinfo_t) ;	
	sizes[AUD_DEVINFO] =  sizeof(sat_devinfo_t) ;	
	sizes[AUD_ULI] =  0;
	sizes[AUD_LP] =  sizeof(sat_lp_t) ;	
	sizes[AUD_CRON] =  sizeof(sat_cron_t) ;	
	sizes[AUD_UUCP] =  0;
	sizes[AUD_TCP] =  0;
	sizes[AUD_NFS] = 0;
	sizes[AUD_RFS] = 0;
	sizes[AUD_SLINK] =  -1;  /*variable length record*/

}

re_sync(hdr)
sat_hdr_t *hdr;
{

	char	buf,*skip;
	int	cnt=0;

	printf("\n\nData sync error: ");
	fflush(stdout);
	fprintf(stderr," ***The data is out of sync, attempting to re_syncronize.\n");

	while (fread((char *)&buf, 1, 1, stdin)){


		cnt++;
		for(skip = (char *) hdr; skip +1 != (char *) (hdr + 1); skip++)
			*skip = *(skip+1);

		*skip= buf;

		if(validate(hdr)){
			printf("\n%d bytes skipped:  ",cnt);
			fflush(stdout);
			fprintf(stderr,"***The data is back in sync, %d bytes were skipped.\n",cnt);
			printf("\n");
			return(1);
		}
	}	
	
	printf("End_of_file %d bytes skipped:  ", cnt);
	fflush(stdout);
	fprintf(stderr,"***The End_of_file was reached.\n");
	fprintf(stderr,"%d bytes of data were skipped over.\n",
	   cnt);
	
	printf("\n");
	exit(0);

}
	
extern int *rcnt;
validate(hdr)
sat_hdr_t *hdr;
{


	if ((hdr->event == AUD_RFS) || (hdr->event == AUD_NFS) ||
	    (hdr->event == AUD_ULI) || (hdr->event == AUD_TCP) ||
	    (hdr->event == AUD_UUCP))
		return 0;

	if ((hdr->event < 0) || (hdr->event >= AUD_MAX_DEF))
		return 0;

	if (hdr->time == (time_t)0)
		return 0;

	if ( hdr->seq < rcnt[hdr->event] )
		return 0;

	if ((sizes[hdr->event] != -1) && (hdr->size != sizes[hdr->event]))
	 	return 0;  

	if ((hdr->pid  < 0 )  || (hdr->pid > MAXPID))
		return 0;  

   /*MBM what is the cpu? the slot #? 

	if ((hdr->cpu <0 ) || (hdr->cpu >?))
		return 0;

	*/

	return 1;
}


