/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) username.c: version 25.1 created on 12/2/91 at 17:17:30	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)username.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <signal.h>
#include <stdio.h>
#include <search.h>

/* username mapping function -- username, username_init
 *
 * Uname efficiently returns a pointer to the symbolic name
 * of the user having the user id provided.  The number must be in
 * unsigned short format.  If the user is not known by name,
 * username returns a pointer to a string of the form "(n)" where
 * n is the numeric value of the user id passed in the argument.

 * The function username_init initializes the table of names with the
 * names from the passwd file.  If the same user id is listed by more
 * than one name, the last encountered is used.

 * The static function "comp" is local to this module and used only
 * with the tsearch routines when dealing with the username table.
 */

#define NAMSIZ 16		/* maximum name size -1 recorded/reported */
				/* also change '%15s' in scanf below */
struct uentry {
	ushort	uid;		/* user number */
	char	name[NAMSIZ+1];	/* user name */
};

#define NUSERS 1000			/* names kept for up to NUSERS */
static struct uentry tbl[NUSERS];	/* table of user name entries */
static int nel;				/* number of entries actually used */

#define EQUAL(A, B)	!strncmp((A),(B),NAMSIZ)

static int comp(a,b)		/* comparison routine used in bsearch */
struct uentry *a, *b;
{
	return (a->uid - b->uid);
}

char *username(n)   /* return the symbolic name of user number "n" */
ushort n;
{
    static struct uentry q, *p;	/* static: one element cache */
    if (( q.uid != n ) || ( p == NULL )) {
	q.uid = n;	/* cache miss, refill */
		/* lookup user in table and set pointer if found */
	if((p = (struct uentry *)bsearch((char *)(&q), (char *) tbl,
	     nel, sizeof(struct uentry), comp)) == NULL)
	{	/* if not in table, invent suitable cache value!! */
	    sprintf(q.name,"(%d)", q.uid);
	    p = &q;
	}
    }
    return p->name;	/* always returns pointer to cached entry */
}

getuid(user)	/* return the uid for symbolic name user */
char *user;
{
	int i;

	for (i=0; i<nel; i++)
		if (EQUAL(tbl[i].name, user))
			return(tbl[i].uid);
	return(-1);
}

username_init(f)	/* initialize the table of user id -> name entries */
FILE *f;		/* initialization file */
{
    int n;
    char nm[NAMSIZ+1];
    FILE *pipe;
    if (f != NULL)
	pipe = f;
    else{
	fprintf(stderr,"Auditfmt: username: Bad stream\n"); 
	exit(1);
    }
    nel = 0;

    while ((fread(&n,sizeof(n),1,pipe) == 1)
		&& (fscanf(pipe,"%s ",nm) == 1) && (nel<NUSERS) && (n>=0)) {
/*printf("Users:read a user of <%d> <%s>\n",n,nm);*/
	tbl[nel].uid = n;
	strncpy(tbl[nel].name,nm,NAMSIZ);
	nel++;
    }
    if (f == NULL)
	pclose(pipe);
    if( nel == NUSERS )
	fprintf(stderr, "Warning! -- increase NUSERS in username.c");
}

/*
 * insert_user ( char *ulibuf )
 *
 * insert a new user in user table from ULI record ulibuf
 * warning! -- sequence counter already stripped from ulibuf
 */
insert_user ( ulibuf )
char *ulibuf;
{
    short new_uid;
    char new_name[NAMSIZ+1];
    int i;

    sscanf(ulibuf, "%*s %s %hd", new_name, &new_uid);
    if ( new_uid == 0 ) /* yet another name for root */
	return;
    new_name[strlen(new_name) - 1] = '\0';  /* erase colon */
    if (nel == NUSERS) {
	printf(stderr, "Warning! -- too many users, %s not inserted; %s\n",
			new_name, "increase NUSERS in username.c");
    	return;
    }
    i = nel++;
    while (tbl[--i].uid > new_uid) {
	tbl[i+1].uid = tbl[i].uid;
	strncpy(tbl[i+1].name, tbl[i].name, NAMSIZ);
    }
    i++;
    tbl[i].uid = new_uid;
    strncpy(tbl[i].name,new_name,NAMSIZ);
}

/*
 * rm_user ( char *ulibuf )
 *
 * remove a user from user table
 *
 */
rm_user(ulibuf) 
char *ulibuf;
{
    int i;
    struct uentry q, *p;

    sscanf(ulibuf, "%*s %s %hd", q.name, &q.uid);
    
    if ( p = (struct uentry *)bsearch((char *)&q, (char *)tbl, nel,
			sizeof(struct uentry), comp))   /* found it */ {
	nel--;
	for ( i = p - tbl ; i < nel ; i++ ) {
	   tbl[i].uid = tbl[i+1].uid;
	   strncpy(tbl[i].name, tbl[i+1].name, NAMSIZ);
	}
    }
}

/*
 * chkpt_names( int fildes )
 *
 * write number of usernames; then write in-use portion of username table to
 * checkpoint file, fildes; all in binary
 *
 */
chkpt_names(fildes)
int fildes;
{
	write(fildes, (char *) &nel, sizeof(int));
	write(fildes, (char *) tbl, nel * sizeof(struct uentry));
}

/*
 * restore_names( int fildes )
 *
 * read number of usernames; read uid, username pairs into username table; all
 * in binary
 * put zeroth entry into cache in case cached entry no longer exists and number
 * was reused
 *
 */
restore_names(fildes)
int fildes;
{
	read(fildes, (char *) &nel, sizeof(int));
	read(fildes, (char *) tbl, nel * sizeof(struct uentry));
	username(0);
}


