/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ttyname.c: version 25.1 created on 12/2/91 at 17:17:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ttyname.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <signal.h>
#include <sys/dir.h>
#include <stdio.h>
#include <search.h>

/* ttyname mapping function -- ttyname, ttyname_init
 *
 * Ttyname efficiently returns a pointer to the symbolic name
 * of the character device in directory /dev that has the matching
 * major/minor device number.  The number must be provided in dev_t
 * format (see sys/types.h).  If the device is not known by name,
 * ttyname returns a pointer to a string of the form "(m,n)" where
 * m and n are the major and minor device numbers taken from the
 * argument.

 * The function ttyname_init initializes the table of names with the
 * names from the directory.  If the same device is listed by more
 * than one name, the first encountered is used.

 * The static function "comp" is local to this module and used only
 * with the tsearch routines when dealing with the ttyname table.
 */

struct ttyentry {
	dev_t	dev;		/* device number, major*256 + minor */
	char	name[DIRSIZ];	/* file name */
};

#define NTTYS 2048			/* names will be kept for up to NTTYS */
static struct ttyentry tbl[NTTYS];	/* table of tty entries */
static int nel;				/* number of entries actually used */

static int comp(a,b)		/* comparison routine used in bsearch */
struct ttyentry *a, *b;
{
	return (a->dev - b->dev);
}

char *ttyname(n)   /* return the symbolic name of tty device number "n" */
dev_t n;
{
    static struct ttyentry q, *p;	/* static: one element cache */
    if (( q.dev != n ) || ( p == NULL )) {
	q.dev = n;	/* cache miss, refill */
		/* lookup device in table and set pointer if found */
	if((p = (struct ttyentry *)bsearch((char *)(&q), (char *) tbl,
	     nel, sizeof(struct ttyentry), comp)) == NULL)
	{	/* if not in table, invent suitable cache value!! */
	    if ( n != -1 )
		sprintf(q.name,"(%d,%d)",(q.dev >> 8)&0377, q.dev&0377);
	    else
		strcpy(q.name, "-NONE-");
	    p = &q;
	}
    }
    return p->name;	/* always returns pointer to cached entry */
}

ttyname_init(f)	/* initialize the table of tty id -> name entries */
FILE *f;		/* initialization file */
{
    int n;
    char nm[DIRSIZ];
    FILE *pipe;
    if (f != NULL)
	pipe = f;
    else{
	fprintf(stderr,"Auditfmt: ttyname: Bad stream\n");
	exit(1);
    }
    nel = 0;

    while ((fread(&n,sizeof(n),1,pipe) == 1) && (fscanf(pipe,"%s ",nm) == 1)
		&& (nel<NTTYS) && (n>=0)) {
/*printf("TTYs:read a tty of <%d> <%s>\n",n,nm);*/
	tbl[nel].dev = n;
	strncpy(tbl[nel].name,nm,DIRSIZ);
	nel++;
    }
    if (f == NULL)
	pclose(pipe);
    if( nel == NTTYS )
	fprintf(stderr, "Warning! -- increase NTTYS in ttyname.c");
}

/*
 * chkpt_ttys( int fildes )
 *
 * write number of ttynames; then write in-use portion of ttyname table to 
 * checkpoint file; all in binary
 *
 */
chkpt_ttys(fildes)
int fildes;
{
	write(fildes, (char *) &nel, sizeof(int));
	write(fildes, (char *) tbl, nel * sizeof(struct ttyentry));
}

/*
 * restore_ttys( int fildes )
 *
 * read number of ttynames; read in-use portion of ttyname table; all in binary
 * put first entry into cache in case cached entry no longer exists and dev
 * number was reused
 *
 */
restore_ttys(fildes)
int fildes;
{
	read(fildes, (char *) &nel, sizeof(int));
	read(fildes, (char *) tbl, nel * sizeof(struct ttyentry));
	ttyname(0);
}


