/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) roles.c: version 25.1 created on 12/2/91 at 17:17:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)roles.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <signal.h>
#include <sys/dir.h>
#include <stdio.h>
#include <search.h>
#include <sys/synch.h>
#include <auth.h>
#include <sys/audit.h>

/* roles mapping function -- roles, role_init
 *
 * Roles efficiently returns a pointer to a roledef_t (auth.h) structure
 * that has a role_number matching  r_rolenumber provided.  The number 
 * must be in unsigned short format.  If the privilege is not known by name,
 * roles returns a pointer to a string of the form "(n)" where
 * n is the numeric value of the role id passed in the argument.
 *
 * The function roles_init initializes the table of names with the
 * names read from the audit file.  If the same role id is listed by more
 * than one name, the last encountered is used.

 * The static function "comp" is local to this module and used only
 * with the bsearch routines when dealing with the roles table.
 */

/* The following shell script is used in a popen call to obtain a sorted
 * list of the unique role id numbers and role names.
 */

#define NAMSIZ 16		/* maximum name size -1 recorded/reported */
				/* also change '%15s' in scanf below */
#define NROLES 1000			/* names kept for up to NROLES */


static roldef_t tbl[NROLES];	/* table of role name structures */
static int nel;				/* number of entries actually used */
static roldef_t q, *p;	/* static: one element cache -- used by roles() */




static int comp(a,b)		/* comparison routine used in bsearch */
roldef_t *a, *b;
{
	return (a->r_rolenumber - b->r_rolenumber);
}


char *roles(n)         /* return the symbolic name of role number "n" */
unsigned n;
{
    if (( q.r_rolenumber != n ) || ( p == NULL )) {
	q.r_rolenumber = n;	 /* cache miss, refill */
		/* lookup role in table and set pointer if found */
	if((p = (roldef_t *)bsearch((char *)(&q), (char *) tbl,
	     nel, sizeof(roldef_t), comp)) == NULL)
	{	/* if not in table, invent suitable cache values!! */
	    sprintf(q.r_name,"(%d)", q.r_rolenumber);
	    p = &q;
	}
    }
    return p->r_name;	/* always returns pointer to cached entry */
}


roles_init(f)	/* initialize the table of role id -> name entries */
FILE *f; 		/* initialization file */
{

    nel = 0;

/*MBM the use of rnum < 99999 is a temp workaround cause of the unsigned*/

    while ((fread(&tbl[nel],sizeof(roldef_t),1,f) == 1)
		&& (nel<NROLES) && (tbl[nel].r_rolenumber < 999999)) {
	nel++;
    }

}



/*
 * insert_role (char *ulibuf)
 *
 * insert a new role in role table from ULI record ulibuf
 * warning! sequence number has already been deleted from ulibuf
 */
/*MBM skiped this routine (insert_role)  for now.*/
insert_role ( ulibuf )
char *ulibuf;
{
	ushort new_gid;
	char new_name[NAMSIZ];
	int i;

	sscanf(ulibuf, "%*s %s %hd: ", new_name, &new_gid);
	new_name[strlen(new_name)-1] = '\0';  /* erase colons */
	if (nel == NROLES ) {
	   printf(stderr, "Warning! -- too many roles, %s not inserted; %s\n",
		new_name, "increase NROLES in roles.c");
	   return;
	}
	i = nel++;
	while (tbl[--i].r_rolenumber > new_gid) {
	   tbl[i+1].r_rolenumber = tbl[i].r_rolenumber;
	   strncpy(tbl[i+1].r_name, tbl[i].r_name, NAMSIZ);
	}
	if (tbl[i].r_rolenumber < new_gid) {  /* normal case -- gid not reused */
	   i++;
	   tbl[i].r_rolenumber = new_gid;
	   strncpy(tbl[i].r_name,new_name,NAMSIZ);
	}
	else {
	   strncpy(tbl[i].r_name,new_name,NAMSIZ);
	   i += 1;
	   while ( ++i < nel-1 ) {  /* didn't need the space */
		tbl[i].r_rolenumber = tbl[i+1].r_rolenumber;
		strncpy(tbl[i].r_name, tbl[i+1].r_name, NAMSIZ);
	   }
	   nel--;
	}
}


/*
 * chkpt_roles( int fildes )
 *
 * write number of rolenames; then write in-use portion of rolename table
 * to checkpoint file; all in binary
 *
 */
chkpt_roles(fildes)
int fildes;
{
	write(fildes, (char *) &nel, sizeof(int));
	write(fildes, (char *) tbl, nel * sizeof(roldef_t));
}

/*
 * restore_names( int fildes )
 *
 * read number of rolenames; read roleid, rolename pairs into rolename table;
 * all in binary
 * put first entry into cache in case cached entry no longer exists and number
 * was reused
 *
 */
restore_roles(fildes)
int fildes;
{
	read(fildes, (char *) &nel, sizeof(int));
	read(fildes, (char *) tbl, nel * sizeof(roldef_t));
	roles(0);
}

