/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) malloc.c: version 25.1 created on 12/2/91 at 17:17:16	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)malloc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)libc-port:gen/malloc.c	1.14"
/* FILE:	malloc.c
**
 * OLD DESCRIPTION:
 * C storage allocator 
 * circular first-fit strategy
 * works with noncontiguous, but monotonically linked, arena
 * each block is preceded by a ptr to the (pointer of) 
 * the next following block
 * blocks are exact number of words long 
 * aligned to the data type requirements of ALIGN
 * pointers to blocks must have BUSY bit 0
 * bit in ptr is 1 for busy, 0 for idle
 * gaps in arena are merely noted as busy blocks
 * last block of arena (pointed to by alloct) is empty and
 * has a pointer to first
 * idle blocks are coalesced during space search
 *
 * a different implementation may need to redefine
 * ALIGN, NALIGN, BLOCK, BUSY, INT
 * where INT is integer type to which a pointer can be cast
**
** 
** CONTENTS:	 This malloc() is the standard 1.14 libc malloc 
** with one extension. This extension divides the data region 
** into two arenas. The first arena (arena[0]) is intended for use 
** by any library that may be used by satfmt (e.g., stdio, libc, etc).
** The second arena (arena[1]), is intended solely for use by satfmt 
** and its routines.
** 
** This extension was needed because satfmt needs to control its data 
** region for checkpoints and restarts. When satfmt does a checkpoint, it
** takes a snapshot of the second arena and writes this to a file. When
** satfmt does a restart/goto, it takes this snapshot and reloads it into
** arena[1].  Now, if the libraries were allowed to allocate memory from 
** this arena, the restart/goto would have a strong possibility of thrashing
** some of their pointers, or the libraries could thrash satfmt's 
** pointers/data.
**
** A program including this malloc MUST now call 
** malloc_init(size_of_arena[0]) to set the size limit of arena[0].
** Once set, any growth behond this limit will cause the program to
** abort; so, be generous.
**
** CONSTRAINTS:	Once the limit for arena[0] is set, it is set for the life
** of the program. Any attempt to grow behond the limit will cause 
** the program to abort(). The routine malloc_init() must be the first call 
** in the program.
** 
*/

#include "shlib.h"

#ifdef DEBUG
#include <stdio.h>
#endif

#include <values.h>

/*LINTLIBRARY*/
#define NDEBUG

#ifdef debug
#undef NDEBUG
#endif

#include <assert.h>

#undef malloc
#undef free
#undef realloc

/*	avoid break bug */
#if pdp11
#define GRANULE 64
#else
#define GRANULE 0
#endif

#if u370
#define BLOCK 4096	/* a multiple of WORD*/
#else
#define BLOCK 1024	/* a multiple of WORD*/
#endif

/*
	wtk addition to define MAXALLOC - (M68020)
	mbm -change to m68k (for 020 and 0400
*/
#if pdp11 || vax || u3b || M32 || m68k
/* this make the assumption that MAXINT is one less than an
   even block */
#define MAXALLOC (MAXINT-BLOCK+1)
#endif

#define INT int
#define ALIGN int
#define NALIGN 1
#define WORD sizeof(union store)

#define MAXUNINT	(unsigned int) ~0	/* max unsigned int value */

/* MAXNBYTES is the maximum value that nbytes can be and 
** not have overflow during the execution of the malloc calculations	
*/
#define MAXNBYTES  (unsigned int)(((MAXUNINT/BLOCK) * (BLOCK/WORD) - 2) * WORD)
#define BUSY 1
#define NULL 0
#define testbusy(p) ((INT)(p)&BUSY)
#define setbusy(p) (union store *)((INT)(p)|BUSY)
#define clearbusy(p) (union store *)((INT)(p)&~BUSY)
#define e1 "malloc: Arena 0 memory fault.\nIncrease the size of arena 0's memory area.\n"


union store {
	union store *ptr;
	ALIGN dummy[NALIGN];
	int calloc;		/*calloc clears an array of integers*/
};
#if DEBUG
int malloc_trace=0; 	/* Turns on malloc tracing */
int malloc_thread=0;    /* Turns on malloc threading, dependent on trace */
#endif

extern char *sbrk(), *memcpy();
extern end;

static char *s_endds; 	/* end of arena 0 data section	*/

static struct mem_seg {
	union store allocs[2];	/*initial arena*/
	union store *allocp;	/*search ptr*/
	union store *alloct;	/*arena top*/
	union store *allocx;	/*for benefit of realloc*/
	union store *allocend;	/*the last block, if it is free, or *alloct */
	} arena[2];


/* char *malloc(unsigned x)
** 
** Intercept all calls to malloc, these are actually request for memory
** from arena[0].
*/
char *
malloc(x) 
unsigned x; 
{ 
	char *s_malloc(); 
	return((char *) s_malloc(x, 0)); 
}

/* char *s_malloc(unsigned x, sec)
** 
** Allocate memory from arena[sec] and return a pointer to the allocated
** storage space.
*/
char *
s_malloc(nbytes, sec)
unsigned nbytes;
int sec;
{
	register union store *p, *q;
	register int nw;
	register struct mem_seg *aptr;
	register unsigned int temp;
	register unsigned int incr = 0;
	unsigned int sav_temp;
	unsigned int siz_a0;
	static int first_time;

#ifdef DEBUG
	if ( malloc_trace ) {	
		malloc_debug("s_malloc(): start");
		if ( malloc_thread )
			thread("s_malloc(): start");
	}
#endif
	if (nbytes > MAXNBYTES)
		return (NULL);
	/* Set the arena pointer */
	if (sec == 0)
		aptr = arena;
	else
		aptr = arena+1;

	if(aptr->allocs[0].ptr == 0) {		/*first time*/
		aptr->allocs[0].ptr = setbusy(&aptr->allocs[1]);
		aptr->allocs[1].ptr = setbusy(&aptr->allocs[0]);
		aptr->alloct = &aptr->allocs[1];
		aptr->allocp = &aptr->allocs[0];
		aptr->allocend = aptr->alloct;
		/* We only want to allocate memory for arena[0] once. */
		/* Hopefully, the program called malloc_init() */
		if (sec == 0)
			first_time=1;
	}
	nw = (nbytes+WORD+WORD-1)/WORD;
	assert(aptr->allocp >= aptr->allocs && aptr->allocp <= aptr->alloct);
	assert(aptr->allock());
	/* Set p to the first memory block that we want to search */
	for(p=aptr->allocp; ; ) {
		for(temp=0; ; ) {
			/* Check to see if the block is being used */
			if(!testbusy(p->ptr)) {
				/* Set q to point at the next block in 
				 * the list, and check to see if its busy.
				 * If it isn't busy consolidate the memory
				 * blocks. Repeat this until we find a busy
				 * block.
				 */
				while(!testbusy((q=p->ptr)->ptr)) {
					assert(q > p && q < aptr->alloct);
					aptr->allocp = p;
					p->ptr = q->ptr;
					if (aptr->allocend == q) aptr->allocend = p;
				}
				/* Do we have enough memory? */
				if(q >= p+nw && p+nw >= p)
					goto found;
#if DEBUG
				if ( malloc_trace )
					fprintf(stderr, 
					   "q = 0x%x p = 0x%x p+nw = 0x%x\n", 
					   q, p,p+nw);
#endif
			}
			/* Check the pointers for corruption, kickbacks, 
			 * payoffs, etc. 
			 */
			q = p;
			p = clearbusy(p->ptr);
			if(p > q)
				assert(p <= aptr->alloct);
			else if(q != aptr->alloct || p != aptr->allocs) {
				assert(q == aptr->alloct && p == aptr->allocs);
#if DEBUG
				if ( malloc_trace ) {
				    fprintf(stderr, 
				    "MALLOC WARNING--POINTER CORRUPTION\n");
				    fprintf(stderr, "q = 0x%x p = 0x%x\n", 
					q, p);
				}
#endif
				return(NULL);
			} else if(++temp > 1)
				break;
		}
		/* We need to allocate some memory from system pool sbrk() 
		*/
		p = aptr->allocend; 	/* set block to search next */
		q = (union store *)sbrk(0);
		if (q != aptr->alloct+1)  {
			/* the addition must be done in words to
			   prevent overflow.  Also, use temporaries,
			   since order of operations may be changed,
			   otherwise. */
			temp = ((nw+BLOCK/WORD - 1)/(BLOCK/WORD));
			temp = temp * BLOCK;
			if (((INT)q%WORD) != 0)  {
				incr = (WORD-(INT)q%WORD);
				q = (union store *)((char *)q + incr);
				temp += incr;
			} 
		}  else  {
			temp = nw - (aptr->alloct - aptr->allocend);
			temp = ((temp+BLOCK/WORD)/(BLOCK/WORD));
			temp = temp * BLOCK;
		}
		if(((unsigned int)q)+temp+GRANULE < (unsigned int)q) {
			return(NULL);
		}
		
		sav_temp = temp;
		if (temp > MAXALLOC)  {
			/* If a request for memory is in arena 0 
			** and it isn't the first malloc for this
			** arena and we need to alloc behond the size
			** of the arena, report the error and fail.
			*/
			if (sec == 0 && !first_time) {
				siz_a0 = (unsigned)s_endds - (unsigned)&end;
				write(2, e1, 74);
				abort();
			}
			else if (sec == 0)
				first_time = 0;

			if ((INT)sbrk(MAXALLOC) == -1)
				return NULL;
			temp -= MAXALLOC;
		}
		if (sec == 0 && !first_time) {
			siz_a0 = (unsigned)s_endds - (unsigned)&end;
			write(2, e1, 74);
			abort();
		}
		else if (sec == 0)
			first_time = 0;
		if((INT)sbrk((int) temp) == -1) {
			brk((char *)q - incr); 		/* move brkval back */
			return(NULL);
		}
		aptr->allocend = q;
		assert(q > aptr->alloct);
		aptr->alloct->ptr = q;
		/* must subtract incr, since both q and temp had
		   incr added */
		q->ptr = (union store *)
			   ((unsigned char *)q + sav_temp - incr) - 1;
		if(q != aptr->alloct+1)
			aptr->alloct->ptr = setbusy(aptr->alloct->ptr);
		aptr->alloct = q->ptr;
		aptr->alloct->ptr = setbusy(aptr->allocs);
		q = p;
		/* Now we go back and search again. */
	}
found:
	aptr->allocp = p + nw;
	assert(aptr->allocp <= aptr->alloct);
	if(q > aptr->allocp) {
		aptr->allocx = aptr->allocp->ptr;
		aptr->allocp->ptr = p->ptr;
	}
	p->ptr = setbusy(aptr->allocp);
	/* move last block ptr, if necessary */
	if (aptr->allocend == p)  aptr->allocend = aptr->allocp;
#ifdef DEBUG
	if ( malloc_trace ) {	
		malloc_debug("s_malloc(): end");
		if ( malloc_thread )
			thread("s_malloc(): end");
	}
#endif
	return((char*)(p+1));
}

/*      freeing strategy tuned for LIFO allocation 
 * 	When free() is called, it is a request to release
 *	storage in arena[0].
 */

void
free(ap) 
char *ap; 
{ 
	void s_free();
	s_free(ap, 0);
}

void
s_free(ap, sec)
register char *ap;
int sec;
{
	register struct mem_seg *aptr;
	register union store *p = (union store *)ap;

	if (sec == 0)
		aptr = arena;
	else
		aptr = arena+1;

	if (ap == NULL) 
		return;
	assert(p > clearbusy(aptr->allocs[1].ptr) && p <= aptr->alloct);
	assert(aptr->allock());
	aptr->allocp = --p;
	assert(testbusy(p->ptr));
	/* if just freed last block in arena */
	p->ptr = clearbusy(p->ptr);
	if (p->ptr == aptr->alloct)  aptr->allocend = p;
	assert(p->ptr > aptr->allocp && p->ptr <= aptr->alloct);
	assert(aptr->allocend <= aptr->alloct);
#ifdef DEBUG
	if ( malloc_trace ) {	
		malloc_debug("free(): end");
		if ( malloc_thread )
			thread("free(): end");
	}
#endif
}

/*
 *	realloc(p, nbytes) reallocates a block obtained from malloc()
 *	and freed since last call of malloc()
 *	to have new size nbytes, and old content
 *	returns new location, or 0 on failure
 */

char * 
realloc(p, nbytes) 
char	*p; 
unsigned nbytes; 
{ 
	char * s_realloc();
	return(s_realloc(p, nbytes, 0));
}

char *
s_realloc(p, nbytes, sec)
char	*p;
unsigned nbytes;
int sec;
{
	register char *q;
	register union store *ap, *aq;
	register unsigned nw;
	register struct mem_seg *aptr;
	unsigned onw;

	if (sec == 0)
		aptr = arena;
	else
		aptr = arena+1;

	ap = (union store *)p;
	if(testbusy(ap[-1].ptr))
		free(p);
	onw = ap[-1].ptr - ap;
	q = malloc(nbytes);
	if(q == NULL || q == p)
		return(q);
	nw = (nbytes+WORD-1)/WORD;
	if(nw < onw)
		onw = nw;
	aq = (union store *) memcpy(q, p, onw * WORD);
	if(aq < ap && aq+nw >= ap)
		(aq+(aq+nw-ap))->ptr = aptr->allocx;
	return(q);
}

#ifdef debug
allock()
{
	return(s_allock(0));
}

s_allock(sec)
int sec;
{
#ifdef longdebug
	register union store *p;
	register struct mem_seg *aptr;
	int x;

	if (sec == 0)
		aptr = arena;
	else
		aptr = arena+1;

	x = 0;
	for(p= &aptr->allocs[0]; clearbusy(p->ptr) > p; p=clearbusy(p->ptr)) {
		if(p == aptr->allocp)
			x++;
	}
	assert(p == aptr->alloct);
	return(x == 1 || p == aptr->allocp);
#else
	return(1);
#endif
}
#endif
malloc_init(nbytes)
register nbytes;
{
        char *s_malloc(), *ptr0, *ptr1;

#ifdef DEBUG
	if ( malloc_trace ) {	
		malloc_debug ("malloc_init(): starting");
		if ( malloc_thread )
			thread("malloc_init(): starting");
	}
#endif
        if ( (ptr0 = s_malloc(nbytes, 0)) == NULL) {
                write(2,
                    "mem_init(): Failed to initialize memory arena 0\n",48);
                exit(-1);
        }
        s_endds =  sbrk(0); /* A write once variable */
        s_free(ptr0, 0);
}
/*	For debugging purposes only
/*rstalloc()
/*{
/*	
/*	aptr->allocs[0].ptr = 0;
/*	brk(clearbusy(aptr->allocs[1].ptr));
/*}
*/

/*
 * chkpt_malloc(int fildes)
 *
 * write malloc's static variables to checkpoint file, in binary;
 * plus all dynamically allocated memory from s_end (top of arena[1]
 * allocation for program to the top of the heap
 *
 */

chkpt_malloc(fildes)
int fildes;
{
	register struct mem_seg *aptr;
	char *endds = sbrk(0);

	aptr = arena+1;

#ifdef DEBUG
	if ( malloc_trace ) {	
		malloc_debug("chkpt_malloc(): start");
		if ( malloc_thread )
			thread("chkpt_malloc(): start");
	}
#endif
	write(fildes, &endds, sizeof(char *));
	write(fildes, aptr, sizeof(struct mem_seg));
	write(fildes, s_endds, ((int) ((unsigned)endds - (unsigned)s_endds))); 
}

/*
 * restore_malloc(int fildes)
 *
 * restore malloc's static variables from checkpoint file,fildes, in binary;
 * plus all dynamically allocated memory from s_end (top of arena[1]
 * allocation for program to the top of the heap
 * at time of checkpoint; reset top of heap to old value.
 *
 */
restore_malloc(fildes)
int fildes;
{
	char *endds;
	register struct mem_seg *aptr;

	aptr = arena+1;
#ifdef DEBUG
	if ( malloc_trace ) {	
		malloc_debug("restore_malloc(): start");
		if ( malloc_thread )
			thread("restore_malloc(): start");
	}
#endif
	read(fildes, &endds, sizeof(char *));
	read(fildes, aptr, sizeof(struct mem_seg));
	read(fildes, s_endds, ((int) ((unsigned)endds - (unsigned)s_endds)));
	brk(endds);
#ifdef DEBUG
	if ( malloc_trace ) {	
		malloc_debug("restore_malloc(): end");
		if ( malloc_thread )
			thread("restore_malloc(): end");
	}
#endif
}


#ifdef DEBUG
malloc_debug(str)
char *str;
{
   /* These should be calls to write, but I'm lazy. */

    fprintf(stderr, "malloc_debug(): Called from %s\n", str);
    fprintf(stderr, "arena[0].allocs[0].ptr = 0x%x\n",arena[0].allocs[0].ptr);
    fprintf(stderr, "arena[0].allocs[1].ptr = 0x%x\n",arena[0].allocs[1].ptr);
    fprintf(stderr, "arena[0].allocp = 0x%x\n",arena[0].allocp);
    fprintf(stderr, "arena[0].alloct = 0x%x\n",arena[0].alloct);
    fprintf(stderr, "arena[0].allocx = 0x%x\n",arena[0].allocx);
    fprintf(stderr, "arena[0].allocend = 0x%x\n",arena[0].allocend);
    fprintf(stderr, "arena[1].allocs[0].ptr = 0x%x\n",arena[1].allocs[0].ptr);
    fprintf(stderr, "arena[1].allocs[1].ptr = 0x%x\n",arena[1].allocs[1].ptr);
    fprintf(stderr, "arena[1].allocp = 0x%x\n",arena[1].allocp);
    fprintf(stderr, "arena[1].alloct = 0x%x\n",arena[1].alloct);
    fprintf(stderr, "arena[1].allocx = 0x%x\n",arena[1].allocx);
    fprintf(stderr, "arena[1].allocend = 0x%x\n\n",arena[1].allocend);
}
thread(str)
char *str;
{
	register union store *p, *q, *START;
	register struct mem_seg *ptr;
	int i;

	fprintf(stderr, "thread(): Called from %s\n", str);

	for(i=0; i<2; i++) {
		ptr = arena+i;
		START = clearbusy(ptr->allocs[0].ptr);
		if ( START == NULL) {
			fprintf(stderr, "Arena %d not initialized\n", i);
			continue;
		}
		p = clearbusy(START->ptr);
		fprintf(stderr, "Start address = 0x%x, points to 0x%x\n", 
			START, p);
		if (p != START) {
			while ((q = (clearbusy(p->ptr))) != START) {
				fprintf(stderr, "p = 0x%x, points to 0x%x\n", 
				 	p, q);
				p = q;
			}
			fprintf(stderr, "p = 0x%x, points to 0x%x\n", p, q);
		}
	}

}
#endif
