/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) keys.c: version 25.1 created on 12/2/91 at 17:17:09	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)keys.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <fcntl.h>
#include <stdio.h>
#include <time.h>
#include <termio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/tty.h>
#include <sys/synch.h>
#include <sys/mls.h>
#include "auditfmt.h"
#include <sys/audit.h>

#define KEYS 100
#define IPCMSG 49
#define IPCSHM 52
#define IPCSEM 53

struct keys {
	int id;
	int msg_key;
	int msg_gid;
	int shm_key;
	int shm_gid;
	int sem_key;
	int sem_gid;
} keys[KEYS];

get_key(id, sysno)
{
	int i;

	for(i = 0; i < KEYS; i++) {
	    if (keys[i].id == id)
		switch (sysno) {
		case IPCMSG:
			return(keys[i].msg_key);
		case IPCSHM:
			return(keys[i].shm_key);
		case IPCSEM:
			return(keys[i].sem_key);
		default:
			fprintf(stderr, "not an IPC sysno (%d)\n", sysno);
		}
	}
	return(-1); /* no key */
}

get_keygid(id, sysno)
{
	int i;

	for(i = 0; i < KEYS; i++) {
	    if (keys[i].id == id)
		switch (sysno) {
		case IPCMSG:
			return(keys[i].msg_gid);
		case IPCSHM:
			return(keys[i].shm_gid);
		case IPCSEM:
			return(keys[i].sem_gid);
		default:
			fprintf(stderr, "not an IPC sysno (%d)\n", sysno);
		}
	}
	return(-1); /* no key */
}

add_key(ipc,gid)
sat_ipccreat_t *ipc;
{
	int i;

	if (get_key(ipc->id, ipc->sysno) != -1)
	    switch (ipc->sysno) {
		case IPCMSG:
			fprintf(stderr, "MESSAGE QUEUE KEY (%d) EXISTS!\n",
			    ipc->key);
			return;
		case IPCSHM:
			fprintf(stderr, "SHARED MEMORY KEY (%d) EXISTS!\n",
			    ipc->key);
			return;
		case IPCSEM:
			fprintf(stderr, "SEMAPHORE KEY (%d) EXISTS!\n",
			    ipc->key);
			return;
		default:
			fprintf(stderr, "not an IPC sysno (%d)\n", ipc->sysno);
			return;
	    }

	for(i = 0; i < KEYS; i++)
	    if (keys[i].id == ipc->id)
		switch (ipc->sysno) {
		case IPCMSG:
			keys[i].msg_key = ipc->key;
			keys[i].msg_gid = gid;
			return;
		case IPCSHM:
			keys[i].shm_key = ipc->key;
			keys[i].shm_gid = gid;
			return;
		case IPCSEM:
			keys[i].sem_key = ipc->key;
			keys[i].sem_gid = gid;
			return;
		default:
			fprintf(stderr, "not an IPC sysno (%d)\n", ipc->sysno);
			return;
		}

	for(i = 0; i < KEYS; i++) {
	    if (keys[i].id == -1)
		switch (ipc->sysno) {
		case IPCMSG:
			keys[i].id  = ipc->id;
			keys[i].msg_key = ipc->key;
			return;
		case IPCSHM:
			keys[i].id  = ipc->id;
			keys[i].shm_key = ipc->key;
			return;
		case IPCSEM:
			keys[i].id  = ipc->id;
			keys[i].sem_key = ipc->key;
			return;
		default:
			fprintf(stderr, "not an IPC sysno (%d)\n", ipc->sysno);
			return;
		}
	}
	fprintf(stderr, "KEYS array is full\n");
}

rm_key(ipc)
sat_ipcrm_t *ipc;
{
	int i;

	for(i = 0; i < KEYS; i++) {
	    if (keys[i].id == ipc->id) {
		switch (ipc->sysno) {
		case IPCMSG:
			keys[i].msg_key = -1;
			break;
		case IPCSHM:
			keys[i].shm_key = -1;
			break;
		case IPCSEM:
			keys[i].sem_key = -1;
			break;
		default:
			fprintf(stderr, "not an IPC sysno (%d)\n", ipc->sysno);
			return;
		}
		if ( keys[i].msg_key == -1
		  && keys[i].shm_key == -1
		  && keys[i].sem_key == -1 ) keys[i].id = -1;
	    return;
	    }
	}
	fprintf(stderr, "Key doesn't exist\n");
}

initkeys()
{
	int i;

	for (i = 0; i < KEYS; i++) {
		keys[i].id = -1;
		keys[i].msg_key = -1;
		keys[i].shm_key = -1;
		keys[i].sem_key = -1;
	}
}

/*
 * chkpt_keys (int fildes)
 *
 * write contents of key array to checkpoint file, fildes, in binary
 *
 */

chkpt_keys(fildes)
int fildes;
{
	write(fildes, (char *)keys , KEYS * sizeof(struct keys));
}

/*
 * restore_keys (int fildes)
 *
 * read keys array from binary file, fildes
 *
 */

restore_keys(fildes)
int fildes;
{
	read(fildes, (char *)keys , KEYS * sizeof(struct keys));
}

ipc_chgrp(p)
sat_ipcdac_t *p;
{
	int i;

	for (i = 0; i < KEYS; i++) 
	    if (keys[i].id == p->id) {
		switch (p->sysno) {
		case IPCMSG:
			keys[i].msg_gid = p->new_gid;
			break;
		case IPCSHM:
			keys[i].shm_gid = p->new_gid;
			break;
		case IPCSEM:
			keys[i].sem_gid = p->new_gid;
			break;
		default:
			break;
		}
	    return;
	    }
}
