/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) interface.c: version 25.1 created on 12/2/91 at 17:17:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)interface.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/param.h>
#include <signal.h>
#include <termio.h>
#include <sys/tty.h>
#include <sys/synch.h>
#include <sys/mls.h>
#include "auditfmt.h"
#include <sys/audit.h>
#include <pwd.h>

#define IFE(m,ch) if (( (ch < 32)? (m[0] & (1<<ch)) : (m[1] & (1<<(ch-32)))))
#define IOERR(x) if (x == -1) {\
                 perror("Auditfmt:"); \
 	         exit(1); }

extern FILE *ctrltty;
extern int interactive;
extern void get_out();
extern struct termio tty_norm;
extern struct termio tty_cbreak;

#ifdef DEBUG
extern int malloc_trace;
extern int malloc_thread;
#endif

static int paused;  /* needs to be outside checkcmds so getextcmd can access */

checkcmds()
{
	static int n= -1;
	int c;
	switch ( (c=getc(ctrltty)) ) {
	case 'R':		/* raw only mode */
		raw = 1;
		verbose = 0;
		sensitive = 0;
		break;
	case 'V':		/* verbose only mode */
		raw = 0;
		verbose = 1;
		sensitive = 0;
		break;
	case 'S':		/* sensitive only mode */
		raw = 0;
		verbose = 0;
		sensitive = 1;
		break;
	case 'T':		/* time in real time format only */
		realtime = 1;
		lbolttime = 0;
		break;
	case 'L':		/* time in lbolt format only */
		realtime = 0;
		lbolttime = 1;
		break;
	case 'r':		/* toggle raw mode */
		raw ^= 1;
		break;
	case 'v':		/* toggle verbose mode */
		verbose ^= 1;
		break;
	case 's':		/* toggle sensitive mode */
		sensitive ^= 1;
		break;
	case 't':		/* toggle time in real time format */
		realtime ^= 1;
		break;
	case 'l':		/* toggle time in lbolt format */
		lbolttime ^= 1;
		break;
#if DEBUG
	case 'M':
		malloc_trace ^=1; /* toggle malloc trace */
		break;
	case 'm':
		malloc_thread ^=1; /* toggle malloc thread, dependent on trace */
		break;
#endif
	case 'q':
		get_out(0);	/* quit */
		break;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		if (n >= 0) {
			n = n * 10 + (c - '0');
			if (n >= AUD_MAX_DEF) {
				fprintf(stderr,"Illegal event number, %d\n", n);
				n = -1;
				break;
			}
			IFE(initial_mask,n){
printf("eor ing on event %d\n",n);
				if ( skiptime )
					if (n > 31)
						mask_save[1] ^= (01 << (n-32));
					else
						mask_save[0] ^= (01 << n);
				else
					if (n > 31)
						mask[1] ^= (01 << (n-32));
					else
						mask[0] ^= (01 << n);
			}
			else 
				fprintf(stderr, "Event %d is not enabled in Security Audit Trail\n", n);
			n = -1;
		}
		else n = c - '0';
		break;
	case '\n':		/* put extended commands here */
		getextcmd();
		break;
	case ' ':		/* pause screen */
		if ( ! paused ) {
			paused = TRUE;
			fcntl(fileno(ctrltty),F_SETFL,O_RDWR);
			checkcmds();
			fcntl(fileno(ctrltty),F_SETFL,O_RDWR|O_NDELAY);
			paused = FALSE;
		}
		break;
	}
}

getextcmd()
{
	char input[100];
	char *p;
	int c, i, hr, min, sec;
	time_t ltime;
	struct tm *tm;
	struct passwd  *pw;
	struct passwd  *getpwnam();

	fcntl(fileno(ctrltty),F_SETFL,O_RDWR);
	IOERR(ioctl(fileno(ctrltty),TCSETAF,&tty_norm));
	fprintf(stderr,
	    "----Command (Checkpoint file, Restart file,\n\t\t\t %s): ",
	    "Goto hh:mm, N username, Status");
	fgets(input, sizeof(input), ctrltty);
	p = input;
scan:
	switch ((c = (int) *p++)) {
	case 0 :
	case '\n':
		break;
	case ' ':
	case '\t':
		goto scan;
	case 'c':
	case 'C':
		checkpoint();
		printf("checkpoint complete\n");
		break;
	case 'r':
	case 'R':
		restart();
		/*  doesn't work
		printf("initial state restored -- reset options if desired; <space> to restart\n");
		paused = TRUE;
		fcntl(fileno(ctrltty),F_SETFL,O_RDWR);
		checkcmds();
		fcntl(fileno(ctrltty),F_SETFL,O_RDWR|O_NDELAY);
		paused = FALSE;
*/
		break;
	case 'g':
	case 'G':
		if (go_to(p)) {
			fprintf(stderr, "usage: G[oto] hh:mm ");
			fgets(input, sizeof(input), ctrltty);
			p = input;
			goto scan;
		}
		break;
	case 'n':
	case 'N':
		/* get Name of suspect user */
		while ( *p == ' ' )
			p++;
		if (strlen(p) == 1){		/* no name provided */
			userflagged = 0;
		}
		else {
			p[strlen(p) - 1] = '\0';
			if ( pw = getpwnam(p) ) {
				userflagged = 1;
				fuid = pw->pw_uid;
			}
			else 
				fprintf(stderr, "no user with name '%s'\n", p);
		}
		break;
	case 's':
	case 'S':
		if (realtime) {
			ltime = (event_time/HZ) + basetime;
			tm = localtime (&ltime);
			printf("current time in SAT: %.2d/%.2d/%.2d %.2d:%.2d:%.2d\n", 
			    tm->tm_mon+1, tm->tm_mday, tm->tm_year, 
			    tm->tm_hour, tm->tm_min, tm->tm_sec);
		}
		else {
			ltime = event_time;
			hr = ltime/(3600*HZ);
			ltime = ltime%(3600*HZ);
			min = ltime/(60*HZ);
			ltime = ltime%(60*HZ);
			sec = ltime/HZ;
			ltime = ltime%HZ;
			printf("current time in SAT: +%.2d:%.2d:%.2d.%.2d\n",
			    hr, min, sec, (int) ltime);
		}
		printf("output format mode(s): %s %s %s\n",
		    (verbose) ? "verbose" : "",
		    (sensitive) ? "sensitive" : "",
		    (raw) ? "raw" : "");
		printf("timestamp format mode(s): %s %s\n",
		    (realtime) ? "realtime" : "",
		    (lbolttime) ? "lbolttime" : "");
		if ( skiptime ) {
			printf("skiptime, enabled events:\n\t");
			for ( i = 0; i < AUD_MAX_DEF; i++ )
				IFE(mask_save,i) printf("%d ",i);
		}
		else {
			printf("enabled events:\n\t");
			for ( i = 0; i < AUD_MAX_DEF; i++ )
				IFE(mask,i) printf("%d ",i);
		}
		printf("\n");
		if (userflagged)
			printf("tracking user %s\n",username(fuid));
		printf("\n");
		break;
	default:
		fprintf(stderr, "----Not a valid command.\n");
		break;
	}
	IOERR(ioctl(fileno(ctrltty),TCSETAF,&tty_cbreak));
	IOERR(fcntl(fileno(ctrltty),F_SETFL,O_RDWR|O_NDELAY));
}

go_to(p)
char *p;
{
  
	int month, day, hour, minute, year;
	time_t ltime;
	struct tm *tm;
	char input[8];

	/* convert string p to hr & min */
	while ( strlen(p) && !isdigit(*p) )
		p++;                  /* skip possible 'oto' */
	if ( !strlen(p) )  return(1); /* ill formed string */
	hour = (int)*p++ - '0';
	if ( isdigit(*p) )
		hour = hour*10 + ((int)*p++ - '0');
	if ( *p++ != ':' || !isdigit(*p) ) return(1);  /* ill formed string */
	minute = (int)*p++ - '0';
	if ( isdigit(*p) )
		minute = minute*10 + (int)*p - '0';
	/* assume current month, day, and year */
	ltime = (event_time/HZ) + basetime;
	tm = localtime(&ltime);
	month = tm->tm_mon+1;
	day = tm->tm_mday;
	year = tm->tm_year;
	printf("assuming current month, day, and year: %.2d/%.2d/%.2d\n", 
	    month, day, year);
	printf("is this correct (y/n)? ");
	fgets(input, sizeof(input), ctrltty);
	if ( input[0] == 'n' ) {
		printf("month = ");
		fgets(input, sizeof(input), ctrltty);
		sscanf(input, "%d", &month);
		printf("day = ");
		fgets(input, sizeof(input), ctrltty);
		sscanf(input, "%d", &day);
		printf("year = ");
		fgets(input, sizeof(input), ctrltty);
		sscanf(input, "%d", &year);
	}
	printf("skipping to %.2d:%.2d %.2d/%.2d/%.2d\n", hour, minute, month, 
	    day, year);
	skip_to(month, day, hour, minute, year);
	return(0);
}

interactive_setup()
{
	IOERR(ioctl(fileno(ctrltty),TCGETA,&tty_norm) );
	IOERR(ioctl(fileno(ctrltty),TCGETA,&tty_cbreak));
	interactive = 1;
	if (signal(SIGINT, get_out) == SIG_IGN)
		signal(SIGINT,SIG_IGN);
	if (signal(SIGHUP, get_out) == SIG_IGN)
		signal(SIGHUP,SIG_IGN);
	if (signal(SIGQUIT,get_out) == SIG_IGN)
		signal(SIGQUIT,SIG_IGN);
	if (signal(SIGTERM,get_out) == SIG_IGN)
		signal(SIGTERM,SIG_IGN);
	tty_cbreak.c_lflag = ISIG;	/* do not ignore signals   */
	tty_cbreak.c_cc[VMIN] = 1;		/* only 1 character needed */
	IOERR(ioctl(fileno(ctrltty),TCSETAF,&tty_cbreak));
	fcntl(fileno(ctrltty),F_SETFL,O_RDWR|O_NDELAY);
}
