/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) gname.c: version 25.1 created on 12/2/91 at 17:17:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)gname.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <signal.h>
#include <sys/dir.h>
#include <stdio.h>
#include <search.h>

/* gname mapping function -- gname, gname_init
 *
 * Gname efficiently returns a pointer to the symbolic name
 * of the privilege having the gid provided.  The number must be in
 * unsigned short format.  If the privilege is not known by name,
 * gname returns a pointer to a string of the form "(n)" where
 * n is the numeric value of the group id passed in the argument.
 *
 * The function gname_init initializes the table of names with the
 * names from the groups file.  If the same group id is listed by more
 * than one name, the last encountered is used.

 * The static function "comp" is local to this module and used only
 * with the bsearch routines when dealing with the gname table.
 */


#define NAMSIZ 16		/* maximum name size -1 recorded/reported */
				
struct gentry {
	ushort	gid;		/* group number */
	char	name[NAMSIZ+1];	/* group name */
};

#define NGRPS 1000			/* names kept for up to NGRPS */
static struct gentry tbl[NGRPS];	/* table of group name entries */
static int nel;				/* number of entries actually used */

static int comp(a,b)		/* comparison routine used in bsearch */
struct gentry *a, *b;
{
	return (a->gid - b->gid);
}

static struct gentry q, *p;	/* static: one element cache --
				   used by gname() */

char *gname(n)   /* return the symbolic name of group number "n" */
ushort n;
{
    if (( q.gid != n ) || ( p == NULL )) {
	q.gid = n;	/* cache miss, refill */
		/* lookup group in table and set pointer if found */
	if((p = (struct gentry *)bsearch((char *)(&q), (char *) tbl,
	     nel, sizeof(struct gentry), comp)) == NULL)
	{	/* if not in table, invent suitable cache values!! */
	    sprintf(q.name,"(%d)", q.gid);
	    p = &q;
	}
    }
    return p->name;	/* always returns pointer to cached entry */
}


gname_init(f)	/* initialize the table of group id -> name entries */
FILE *f;		/* initialization file */
{
    int n;
    char nm[NAMSIZ+1];
    FILE *pipe;

    if (f != NULL)
	pipe = f;
    else{
	fprintf(stderr,"Auditfmt: gname: bad stream\n"); 
	exit(1);
    }
    nel = 0;
    while ((fread(&n,sizeof(n),1,pipe) == 1) && (fscanf(pipe,"%s ",nm) == 1)
		&& (nel<NGRPS) && (n>=0)) {
/*printf("Groups:read a group of <%d> <%s>\n",n,nm);*/
	tbl[nel].gid = n;
	strncpy(tbl[nel].name,nm,NAMSIZ);
	nel++;
    }
    if (f == NULL)
	pclose(pipe);
    if( nel == NGRPS )
	fprintf(stderr, "Warning! -- increase NGRPS in gname.c");
}

/*
 * insert_group (char *ulibuf)
 *
 * insert a new group in group table from ULI record ulibuf
 * warning! sequence number has already been deleted from ulibuf
 */
insert_group ( ulibuf )
char *ulibuf;
{
	ushort new_gid;
	char new_name[NAMSIZ+1];
	int i;

	sscanf(ulibuf, "%*s %s %hd: ", new_name, &new_gid);
	new_name[strlen(new_name)-1] = '\0';  /* erase colons */
	if (nel == NGRPS ) {
	   printf(stderr, "Warning! -- too many groups, %s not inserted; %s\n",
		new_name, "increase NGRPS in gname.c");
	   return;
	}
	i = nel++;
	while (tbl[--i].gid > new_gid) {
	   tbl[i+1].gid = tbl[i].gid;
	   strncpy(tbl[i+1].name, tbl[i].name, NAMSIZ);
	}
	if (tbl[i].gid < new_gid) {  /* normal case -- gid not reused */
	   i++;
	   tbl[i].gid = new_gid;
	   strncpy(tbl[i].name,new_name,NAMSIZ);
	}
	else {
	   strncpy(tbl[i].name,new_name,NAMSIZ);
	   i += 1;
	   while ( ++i < nel-1 ) {  /* didn't need the space */
		tbl[i].gid = tbl[i+1].gid;
		strncpy(tbl[i].name, tbl[i+1].name, NAMSIZ);
	   }
	   nel--;
	}
}


/*
 * chkpt_gnames( int fildes )
 *
 * write number of groupnames; then write in-use portion of groupname table
 * to checkpoint file; all in binary
 *
 */
chkpt_gnames(fildes)
int fildes;
{
	write(fildes, (char *) &nel, sizeof(int));
	write(fildes, (char *) tbl, nel * sizeof(struct gentry));
}

/*
 * restore_names( int fildes )
 *
 * read number of groupnames; read gid, groupname pairs into groupname table;
 * all in binary
 * put first entry into cache in case cached entry no longer exists and number
 * was reused
 *
 */
restore_gnames(fildes)
int fildes;
{
	read(fildes, (char *) &nel, sizeof(int));
	read(fildes, (char *) tbl, nel * sizeof(struct gentry));
	gname(0);
}


