/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) filename.c: version 25.1 created on 12/2/91 at 17:16:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)filename.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <signal.h>
#include <sys/dir.h>
#include <sys/sysmacros.h>
#include <sys/errno.h>
#include <ctype.h>
#include <stdio.h>
#include <auth.h>
#include <sys/synch.h>
#include <sys/mls.h>
#include <sys/priv.h>
#include <sys/audit.h>

/* filename mapping function -- filename, filename_init
 *
 * Filename efficiently prints on stdout the full pathname of the
 * file specified by inode number on the filesystem with the matching
 * major/minor device number.  The number must be provided in dev_t
 * format (see sys/types.h).  If the device/inode is not known by name,
 * filename returns a pointer to a string of the form "(m,n,o)" where
 * m and n are the major and minor device numbers taken from the
 * device number argument, and o is the inode number provided.

 * The function filename_init initializes the table of names with the
 * names from the initialization file (fsmap format).  If the same inode
 * is listed by more than one path name, a linked list is built.
 * filename prints all paths when dealing with a multiply linked inode.
 */

#define MAX_MAJOR	(major( (dev_t)~0 ) + 1)
#define MAX_MINOR	(minor( (dev_t)~0 ) + 1)
#define MALLOC_TRYS	3 	/* number of times to recall malloc if */
				/* errno = EAGAIN see brk(2)	*/

/* filename node, linked list of names for given inode */
struct filename {
	struct filename *next;	/* pointer to next filename for this inode */
	ushort		dino;		/* inode number of directory containing name */
	char		name[DIRSIZ+1];	/* file name */
	uint 		priv;           /* The privilege attched to the file */ 
	slabel_t 	label;          /* the label on the file*/ 
	uint		is_sym_link;    /* 0 = not a symbolic link. else this is */
		                        /* the length of the target */
	char		*target;		/* The destination file for a sym link*/
	};

/* major device index array */
struct filename ***major_dev[MAX_MAJOR];

/*      alloc - allocate and clear memory block
*/

extern char *s_malloc(), *memset();
extern int errno;

char *
alloc(size)
unsigned size;
{
	register char *mp;
	register char *t;
	register int try=0;
	int get_out();

tryagain:

	errno = 0;
	if((mp = s_malloc(size, 1)) != NULL)
		(void)memset(mp, 0, size);
	else {
		if ( errno == ENOMEM ) {
			perror("auditfmt: filename.c : alloc()");
			fprintf(stderr, 
			   "UNABLE TO OBTAIN NEEDED MEMORY\n");
			fprintf(stderr, 
			   "Current memory size: 0x%x Amount requested 0x%x\n", 
				(unsigned int) sbrk(0), size);
			get_out(4);
		}
		else if ( try++ < MALLOC_TRYS )
			goto tryagain;
		else {
			perror("auditfmt: filename.c : alloc()");
			fprintf(stderr, 
			   "TRIED TO OBTAIN MEMORY %d TIMES AND FAILED\n", try);
			fprintf(stderr, 
			   "Current memory size: 0x%x Amount requested 0x%x\n", 
				(unsigned int) sbrk(0), size);
			get_out(5);
		}
	}

	return(mp);
}

/* print the symbolic name of the specified file */

filename(dev, ino, dino, name, flag)
dev_t dev;
ino_t ino, dino;
char *name;
int flag;
{
	char **p;
	struct filename *ip;
	if ((p = (char **) major_dev[major(dev)]) == NULL ) goto bad;
	if ((p = (char **) p[minor(dev)]) == NULL ) goto bad;
	if ( ino < 2 || ino >= (int) p[0] ) goto bad;
	if ((ip = (struct filename *) p[ino]) == NULL) goto bad;

	   /* handle special case of mount point */
	if ( ino == 2 ) {
		if ( strlen(ip->name) > 0 )	/* if not root */
                        printf("\t/%s\n",ip->name);
		else
                        printf("\t/\n");       /*It is root*/
		return(0);
	}

	   /* handle case of unknown parent directory */
	if ( dino == 0 && ip != NULL ) {
		while ( ip != NULL )
		{
		  if (flag == 0) {
		    if ( strlen(name) == 0 || strncmp(ip->name,name,14) == 0 )
			filename(dev,ino,ip->dino,ip->name,0);
		    ip = ip->next;
		  }
		  else {
		    if ( strncmp(ip->name,name,14) )
			filename(dev,ino,ip->dino,ip->name,0);
		    ip = ip->next;
		  }
		}
		return(0);
	}

	   /* search for the specific inode wanted */
	while ( ip != NULL &&
		( ip->dino != dino || strncmp(ip->name,name,14) )
			) ip = ip->next;
	if (ip == NULL) {
		warn("filename: access of file not in name map");
		goto bad;
	}

	   /* print out directory path to this inode, then it's name */
	if ( dirname(dev, dino) ) {
		if ( strlen(name) == 0 )
			name="???";
		if ( dino == 0 )
		  printf("/.14%s (%d,%d,???/%d)\n",name,major(dev),minor(dev),ino);
		else
		  printf("/.14%s (%d,%d,%d/%d)\n",name,major(dev),minor(dev),dino,ino);
		return(-2);
	}
	printf("/%.14s\n",ip->name);
	if (ip->is_sym_link)
		printf("This is a SYMBOLIC link to %s\n",ip->target);

	return(0);

bad:
	if ( strlen(name) == 0 )
		name="???";
	if ( dino == 0 )
	 printf("\t.../%.14s (%d,%d,???/%d)\n",name,major(dev),minor(dev),ino);
	else
	 printf("\t.../%.14s (%d,%d,%d/%d)\n",name,major(dev),minor(dev),dino,ino);
	return(-1);
}

	/* directories don't have links, therefore no ip->next */

static
dirname(dev, ino)
dev_t dev;
ino_t ino;
{
	char **p;
	struct filename *ip;
	int rval;
	if ((p = (char **) major_dev[major(dev)]) == NULL ) goto bad;
	if ((p = (char **) p[minor(dev)]) == NULL ) goto bad;
	if ( ino < 2 || ino >= (int) p[0] ) {
		warn("dirname: inode out of range");
		goto bad;
	}
	if ((ip = (struct filename *) p[ino]) == NULL) goto bad;
	if ( ip->next != NULL )
		warn("dirname: directory found with multiple links!");
	if ( ino == 2) {	/* mount point */
		if ( strlen(ip->name) > 0 )	/* if not root */
			printf("\t/%s",ip->name);
		else
			printf("\t");
		return(0);
	}
	if ( ino == ip->dino ) quit("dirname: cycle in ino/dino",ip);
	rval = dirname(dev, ip->dino);
	printf("/%s",ip->name);
	return(rval);
bad:
	printf("\t.../(%d,%d,%d)",major(dev),minor(dev),ino);
	return(-1);
}

/* return pointer to device name associated with device dev and stored
   in location 1 of major_dev[mj][mi].  Returns NULL if error. */

char *
device_name(dev)
dev_t dev;
{
	char **p;

	if ( ((p = (char **) major_dev[major(dev)]) == NULL ) ||
	     ((p = (char **) p[minor(dev)]) == NULL ) || (p[1] == NULL) )
		return(NULL);

	return( ((struct filename *)p[1])->name );
}

file_mknd(dev, ino, dino, name, priv, label)
dev_t dev;
ino_t ino, dino;
char *name;
uint priv;
slabel_t *label;
{
	char **p;
	struct filename *ip;
	if ((p = (char **) major_dev[major(dev)]) == NULL ) return(-1);
	if ((p = (char **) p[minor(dev)]) == NULL ) return(-2);
	if ( ino < 2 || ino > (int) p[0] ) return(-3);
	if ((ip = (struct filename *) p[ino]) != NULL) {
		warn("mknd: create on inode already in use (made link)");
		file_link(dev, ino, dino, name, priv, label);
		return(0);
	}
	ip=(struct filename *)alloc(sizeof(struct filename));
	p[ino] = (char *) ip;
	ip->next = NULL;
	ip->dino = dino;
	ip->priv = priv;
	ip->is_sym_link =0; 
	ip->label.level = label->level;
	memcpy(ip->label.catlst,label->catlst,MAXCATLST);
	strcpy(ip->name, name);
	return(1);
}

file_build(dev, ino, dino, name, priv, label, sym_link, target) 
dev_t dev;
ino_t ino, dino;
char *name;
uint priv;
slabel_t *label;
uint sym_link;
char *target;
{
	char **p;
	struct filename *ip;
	if ((p = (char **) major_dev[major(dev)]) == NULL ) quit("bad major",1);
	if ((p = (char **) p[minor(dev)]) == NULL ) quit("bad minor",2);
	if ( ino < 2 || ino > (int) p[0] ) quit("bad ino",3);
	if ((ip = (struct filename *) p[ino]) != NULL) {
		file_link(dev, ino, dino, name, priv, label);
		return(0);
	}
	ip=(struct filename *)alloc(sizeof(struct filename));
	p[ino] = (char *) ip;
	ip->next = NULL;
	ip->dino = dino;
	ip->priv = priv;
	if (ip->is_sym_link = sym_link){
		ip->target = (char *) alloc(sym_link);
		strncpy(ip->target,target,sym_link);
	}
	ip->label.level = label->level;
	memcpy(ip->label.catlst,label->catlst,MAXCATLST);
	strncpy(ip->name, name,NAME_MAX);
	return(1);
}




file_link(dev, ino, dino, name, priv, label)
dev_t dev;
ino_t ino, dino;
char *name;
uint priv;
slabel_t *label;
{
	char **p;
	struct filename *ip;
	if ((p = (char **) major_dev[major(dev)]) == NULL ) return(-1);
	if ((p = (char **) p[minor(dev)]) == NULL ) return(-2);
	if ( ino < 2 || ino >= (int) p[0] ) return(-3);
	if ((ip = (struct filename *) p[ino]) == NULL) {
		warn("link: link on inode never created (made mknd)");
		file_mknd(dev, ino, dino, name, priv, label);
		return(0);
	}
	while ( ip->next != NULL )
		ip = ip->next;
	ip->next=(struct filename *)alloc(sizeof(struct filename));
	ip = ip->next;
	ip->next = NULL;
	ip->dino = dino;
	ip->priv = priv;
	ip->is_sym_link = 0;
	ip->label.level = label->level;
	memcpy(ip->label.catlst,label->catlst,MAXCATLST);
	strcpy(ip->name, name);
	return(1);
}







file_label(labelbuf)
sat_filelabel_t *labelbuf;
{
	char **p;
	struct filename *ip;
	if ((p = (char **) major_dev[major(labelbuf->dev)]) == NULL ) quit("bad major",1);
	if ((p = (char **) p[minor(labelbuf->dev)]) == NULL ) quit("bad minor",2);
	if ( labelbuf->ino < 2 || labelbuf->ino > (int) p[0] ) quit("bad ino",3);
	if ((ip = (struct filename *) p[labelbuf->ino]) == NULL) {
		file_build(labelbuf->dev, labelbuf->ino, 1, "UNKNOWN", 0, &labelbuf->new_label);
		return(1);
	}
	ip->label.level = labelbuf->new_label.level;
	memcpy(ip->label.catlst,labelbuf->new_label.catlst,MAXCATLST);
	return(1);
}






file_priv(privbuf)
sat_filepriv_t *privbuf;
{
	slabel_t blank;
	char **p;
	struct filename *ip;
	blank.level = 0;
	blank.catlst[0] = '\0'; 
	if ((p = (char **) major_dev[major(privbuf->dev)]) == NULL ) quit("bad major",1);
	if ((p = (char **) p[minor(privbuf->dev)]) == NULL ) quit("bad minor",2);
	if ( privbuf->ino < 2 || privbuf->ino > (int) p[0] ) quit("bad ino",3);
	if ((ip = (struct filename *) p[privbuf->ino]) == NULL) {
		file_build(privbuf->dev, privbuf->ino, 1, "UNKNOWN", privbuf->new_priv, &blank);
		return(1);
	}
	ip->priv = privbuf->new_priv;
	return(1);
}





file_rename(dev, ino, dino, name, label) 
dev_t dev;
ino_t ino, dino;
char *name;
slabel_t *label;
{
	char **p;
	struct filename *ip;
	if ((p = (char **) major_dev[major(dev)]) == NULL ) quit("bad major",1);
	if ((p = (char **) p[minor(dev)]) == NULL ) quit("bad minor",2);
	if ( ino < 2 || ino > (int) p[0] ) quit("bad ino",3);
	if ((ip = (struct filename *) p[ino]) == NULL) {
		file_build(dev, ino, dino, name, 0, label, 0, "");
		return(1);
	}
	ip->dino = dino;
	ip->label.level = label->level;
	memcpy(ip->label.catlst,label->catlst,MAXCATLST);
	strcpy(ip->name, name);
	return(1);
}


file_ulrm(dev, ino, dino, name)
dev_t dev;
ino_t ino, dino;
char *name;
{
	char **p;
	struct filename *ip, **pp;
	if ((p = (char **) major_dev[major(dev)]) == NULL ) return(-1);
	if ((p = (char **) p[minor(dev)]) == NULL ) return(-2);
	pp = (struct filename **) p + ino;
	ip = *pp;
	while ( ip != NULL && 
		( ip->dino != dino || strncmp(ip->name,name,14) ) ) {
			pp = &ip->next;
			ip = ip->next;
	}
	if (ip == NULL) {
		warn("ulrm on inode never created (ignored)");
		return(0);
	}
	*pp = ip->next;
	if (ip->is_sym_link)
		s_free(ip->target,1);
	s_free(ip, 1);
	return(1);
}


static char nm[DIRSIZ];
static char dummy[PATH_MAX];
static char mntpt[PATH_MAX];
static char devname[PATH_MAX];

filename_init(f)	/* initialize the table of inode -> name entries */
FILE *f;		/* initialization file */
{
	int n, mj, mi, ninodes, is_secure_fs;
	char **p, *ptr, c;
	ino_t ino ;
	struct filename newf;

start:
	   /* find and decode header */
	while (fscanf(f, "filesystem: %s %s %d,%d %d %d",
	    mntpt,devname,&mj,&mi,&ninodes,&is_secure_fs) != 6)
		if (fgets(dummy, sizeof(dummy),f) == NULL) {
			warn("filename_init: filesystem marker not found");
			warn("filename_init: no initialization done");
	}
	getc(f);	/* gobbal up \n */

	fprintf(stderr, "loading inode/name map for %s\n", devname);

	if ( mj < 0 || mj > MAX_MAJOR-1 )
		quit("filename_init: major number out of range",1);

	   /* allocate minor device number index array */
	if ((p = (char **) major_dev[mj]) == NULL) {
		p = (char **) alloc((unsigned)MAX_MINOR * sizeof(char *));
		major_dev[mj] = (struct filename ***) p; }

	if ( mi < 0 || mi > MAX_MINOR-1 )
		quit("filename_init: minor number out of range",2);

	if ( p[mi] != NULL)
		quit("filename_init: same device initialized twice",3);

	   /* allocate inode array */
	p[mi] = (char *) alloc((unsigned)(ninodes+1) * sizeof(struct filename *));
	p = (char **) p[mi];

	   /* record the maximum inode number */
	p[0] = (char *) ninodes; /* reuse entry 0 as size marker */

	   /* build device name entry */
	p[1] = (char *) alloc(sizeof(struct filename));
	((struct filename *)p[1])->dino = 1;
	((struct filename *)p[1])->priv = is_secure_fs; /*this is doubling as a*/
								                    /*flag for a secure fs*/
	((struct filename *)p[1])->next = NULL;
	strcpy(((struct filename *)p[1])->name, devname);

	   /* build mount point entry */
	p[2] = (char *) alloc(sizeof(struct filename));
	((struct filename *)p[2])->dino = 2;
	((struct filename *)p[2])->next = NULL;
	strcpy(((struct filename *)p[2])->name, &mntpt[1]); /* skip / */



	while (fread(&ino,sizeof(ino),1,f) == 1 && ino != (ino_t) ~0){
		freadE(&newf.dino,sizeof(newf.dino),1,f);
		freadE(&newf.priv,sizeof(newf.priv),1,f);
		freadE(&newf.label,sizeof(newf.label),1,f);          
		freadE(newf.name,DIRSIZ,1,f);
        freadE(&newf.is_sym_link,sizeof(uint),1,f);
		if (newf.is_sym_link){
			newf.target = (char *) alloc(newf.is_sym_link+1);
        	freadE(newf.target,newf.is_sym_link,1,f);
		}

		/* We assume the file name is NULL terminated, unless it is */
        /* DIRSIZ, then we need to add a null */

		n = strlen(newf.name);
		if ( n >= DIRSIZ)
			newf.name[DIRSIZ+1] = (char) NULL;

		file_build((dev_t)((mj<<8)+mi), ino, newf.dino, newf.name,
                    newf.priv, &newf.label, newf.is_sym_link, newf.target);
/*MBM free up target after call to file_build*/
	}

	   /* need to skip over end_of_filesystem marker */
	fscanf(f, "%s", dummy);
	if ( strcmp("end_of_filesystem", dummy) !=0) /* Check the marker */
		fprintf(stderr, "unknown end_of_filesystem marker \"%s\"\n",
			dummy);

	   /* skip over white space */
	while ((c = getc(f)) == ' ' || c == '\t' || c == '\n' || c == '\0');
	ungetc(c, f);

	   /* see if next string is another filesystem header... */
	for ( n=1, ptr="filesystem:"; *ptr == getc(f) ; ptr++ , n++) ;

	   /* backup over string read */
	fseek(f, (long) -n, 1);

	   /* if whole header string matched... */
	if ( *ptr == '\0' ) goto start;
}

static char buf[512];  /* circular buffer of unprocessed entries */
static int head=0, tail=0, count=0;
static int mj, mi;
static dev_t dev;
static int ninodes;

/* initialize data structures for processing file system mount on
 * the fly.
 */
start_mount(info, num_chars)
char *info;
int num_chars;
{
	int i=0;
	char temp[8];
	char **q;

	/* pick off header info */
	while ( !isspace(mntpt[i++] = *info++) )
		num_chars--;
	num_chars--;
	mntpt[--i]='\0';
	i=0;
	while ( !isspace(devname[i++] = *info++) )
		num_chars--;
	num_chars--;
	devname[--i]='\0';
	i=0;
	while( isdigit(temp[i++] = *info++) )
		num_chars--;
	num_chars--;
	temp[--i]='\0';
	mj = atoi(temp);
	if ( mj < 0 || mj > MAX_MAJOR-1 ) {
		warn("start_mount: major number out of range");
		return(-1);
	}
	i=0;
	while( isdigit(temp[i++] = *info++) )
		num_chars--;
	num_chars--;
	temp[--i]='\0';
	mi = atoi(temp);
	if ( mi < 0 || mi > MAX_MINOR-1 ) {
		warn("start_mount: minor number out of range");
		return(-1);
	}
	dev = (dev_t)((mj<<8)+mi);
	i=0;
	while (isdigit(temp[i++] = *info++) )
		num_chars--;
	num_chars--;
	temp[--i]='\0';
	ninodes = atoi(temp);
	/* initialize filename table arrays */
	if ( (char *) major_dev[mj] == NULL ) {
		major_dev[mj]  = (struct filename ***) alloc((unsigned)MAX_MINOR * sizeof(char *));
	}
	if ( major_dev[mj][mi] ) { /* attempt to mount a mounted file system --
				  mount will fail */
		return(-1);
	}
	q = (char **)alloc((unsigned)(ninodes+1) * sizeof(struct filename *));

	major_dev[mj][mi] = (struct filename **) q;

	q[0] = (char *) ninodes; /* use entry 0 as size marker */
	/* build device name entry */
	q[1] = (char *) alloc(sizeof(struct filename) );
	((struct filename *)q[1])->dino = 1;
	((struct filename *)q[1])->next = NULL;
	strcpy(((struct filename *)q[1])->name, devname);
	/* build mount point entry */
	q[2] = (char *) alloc(sizeof(struct filename) );
	((struct filename *)q[2])->dino = 2;
	((struct filename *)q[2])->next = NULL;
	strcpy(((struct filename *)q[2])->name,&mntpt[1]);  /* skip / */

	/* start the map -- returns -1 if out-of-range inode detected */
	return(build_mount(info,num_chars));
}


/* build the next piece of the file system map -- abort the map and return
 * -1 if out-of-range inode detected. */
build_mount(info, num_chars)
char *info;
int num_chars;
{
	slabel_t blank_lab;
	int i;
	int ino,dino;
	char nm[DIRSIZ];

	/* read new info into buffer */
	for ( i = 0 ; i < num_chars ; i++, tail++ ) {
		tail %= 512;
		buf[tail] = info[i];
	}
	count += num_chars;
	while ( count > 128 ) {  /* protect against running off the end of
				    the buffer with an incomplete record 
				    (128 = buffer size/4) */

		/* get info for next file */
		i = 0;
		while( isdigit(nm[i++]=buf[head++]) ) {
			head %= 512; count--;
		}
		nm[--i]='\0';
		ino = atoi(nm);
		head %= 512; count--; i = 0;
		while( isdigit(nm[i++]=buf[head++]) ) {
			head %= 512; count--;
		}
		nm[--i]='\0';
		dino = atoi(nm);
		head %= 512; count--; i = 0;
		/* Get the null termianted file name */
		while( (nm[i++]=buf[head++]) != NULL ) {
			head %= 512; count--;
		}
		head %= 512; count--; 
		if ( (ino >= 2) && (ino <= ninodes) && (dino >=2) &&
						 (dino <= ninodes) ) {
			/* put it in the map */
/*MBM  where do I get the priv and mac to pass to file_build?? */
			file_build(dev,(ino_t)ino,(ino_t)dino, nm,0,&blank_lab);
		} else {
			abort_mount();
			return(-1);
		}
	}
	return(0);
}

/* finish building the inode-filename map for this file system */
mount_commit()
{
	slabel_t	 blank_lab;
	int i;
	int ino,dino;
	char nm[DIRSIZ];

	/* finish entering filename map into system */
	while ( count > 4 ) {  /* the last record is at least 5 characters
					long */

		/* get info for next file */
		i = 0;
		while( isdigit(nm[i++]=buf[head++]) ) {
			head %= 512; count--;
		}
		nm[--i]='\0';
		ino = atoi(nm);
		head %= 512; count--; i = 0;
		while( isdigit(nm[i++]=buf[head++]) ) {
			head %= 512; count--;
		}
		nm[--i]='\0';
		dino = atoi(nm);
		head %= 512; count--; i = 0;
		while( (nm[i++]=buf[head++]) != NULL ) {
			head %= 512; count--;
		}
		head %= 512; count--; 
		/* put it in the map */
      		if ( (ino >= 2) && (ino <= ninodes) && (dino >=2) &&
                                                 (dino <= ninodes) ) {
                        /* put it in the map */
/*MBM  where do I get the priv and mac to pass to file_build?? */
                        file_build(dev,(ino_t)ino,(ino_t)dino, nm,0,&blank_lab);
		} else {
                        abort_mount();
                        return(-1);
		}
	}
	/* reinitialize for next mount */
	head = tail = count = 0;
	mj = mi = ninodes = 0;
	return(0);
}

abort_mount()
{
	int ino;
	struct filename **fs;
	struct filename *p;
	struct filename *q;

	head = tail = count = 0;
	if ( (major_dev[mj] == NULL) || (major_dev[mj][mi] == NULL) ) 
		return;
	fs = major_dev[mj][mi];
	for (ino=1; ino < (int)fs[0]; ino++) {
		p = fs[ino];
		while (p) {
			q = p;
			p = p->next;
			s_free(q, 1);
		}
	}
	s_free(fs, 1);
	major_dev[mj][mi] = NULL;
}

/* remove unmounted file system from file name map
 */
char *
do_unmount(fsdev, mtptdev, mtptino)
int fsdev, mtptdev, mtptino;
{
	struct filename *p;
	struct filename *q;
	int mj,mi,ino;
	struct filename **fs;
	char *devname;

	/* compute major_dev, minor numbers */
	mj = major(fsdev);
	mi = minor(fsdev);
	if ( (major_dev[mj] == NULL) || (major_dev[mj][mi] == NULL) ) {
		fprintf(stderr, 
			"WARNING: unmounting filesystem %d, %d; not in filesystem name map\n",
			mj, mi);
		return(0);
	}
	fs = major_dev[mj][mi];
	/* remember device name of filesystem */
	/* allocate enough space for the device name and a terminating null */
	devname = (char *)alloc(strlen(((struct filename *)fs[1])->name)+sizeof(char));
	strcpy(devname,((struct filename *)fs[1])->name);
	for (ino=1; ino < (int)fs[0]; ino++) {
		p = fs[ino];
		while (p) {
			q = p;
			p = p->next;
			if (q->is_sym_link)
				s_free(q->target,1);
			s_free(q, 1);
		}
	}
	s_free(fs, 1);
	major_dev[mj][mi] = NULL;
	return(devname);
}

static 
warn(str)
char *str;
{
	fprintf(stderr,"WARNING!  %s\n",str);
}

static 
quit(str,code)
char *str;
int code;
{
	fprintf(stderr,"Error!  %s\n",str);
	exit();
}

/******************
 *
 * checkpointing functions
 *
 ******************/

/*
 * chkpt_files ( int fildes )
 *
 * write the filesystem description to checkpoint file, fildes, in binary;
 * actually writes the major device index array.
 *
 */
chkpt_files(fildes)
int fildes;
{

	write(fildes, (char *) major_dev, MAX_MAJOR * sizeof(struct filename ***));
}

/*
 * restore_files ( int fildes )
 *
 * restore the filesystem description from checkpoint file, fildes, in binary;
 * read the major device index array.
 *
 */
restore_files(fildes)
int fildes;
{

	read(fildes, (char *) major_dev, MAX_MAJOR * sizeof (struct filename ***));
}



/*MBM remove the on the fly mount stuff */
int mountflag, mountpid;

/* chkpt_mount ( int fildes )
 *
 * save information about any in-progress mount
 */
chkpt_mount(fildes)
int fildes;
{
	write(fildes, &mountflag, sizeof(int));
	write(fildes, &mountpid, sizeof(int));
	write(fildes, buf, 512);
	write(fildes, &head, sizeof(int));
	write(fildes, &tail, sizeof(int));
	write(fildes, &count, sizeof(int));
	write(fildes, &mj, sizeof(int));
	write(fildes, &mi, sizeof(int));
	write(fildes, &dev, sizeof(dev_t));
	write(fildes, &ninodes, sizeof(int));
}

/* restore_mount (int fildes)
 *
 * restore information about in-progress mount
 */
restore_mount(fildes)
int fildes;
{
        read(fildes, &mountflag, sizeof(int));
        read(fildes, &mountpid, sizeof(int));
        read(fildes, buf, 512);
        read(fildes, &head, sizeof(int));
        read(fildes, &tail, sizeof(int));
        read(fildes, &count, sizeof(int));
        read(fildes, &mj, sizeof(int));
        read(fildes, &mi, sizeof(int));
        read(fildes, &dev, sizeof(dev_t));
	read(fildes, &ninodes, sizeof(int));
}


/*
 *  freadE does an fread and then checks the return code for an error
 */
freadE(buffer,item_size,count,stream)
char	*buffer;
int 	item_size,count;
FILE	*stream;
{  

	if (item_size)
		if (fread(buffer,item_size,count,stream) != count){
			fprintf(stderr,"auditmap: filename: ERROR reading filesystem"
			               "  data from header\n");
			exit(-1); 
		}
}

