/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chkpt.c: version 25.1 created on 12/2/91 at 17:16:53	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chkpt.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* chkpt.c
 *
 * functions for maintaing the checkpoint file for satfmt
 *
 */

#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/synch.h>
#include <sys/mls.h>
#include "auditfmt.h"
#include <sys/audit.h>

#define tempdir "/usr/tmp"
#define prefix  "chkpt"


/* local data structures and functions for maintaining checkpoint files */
char *tempnam();
struct chkpt_file {
	int fildes;
	char* file_name;
};

struct chkpt_file file[10];
int index = 0;
time_t earliest_time;  
long ftell(), lseek();
struct tm *localtime();

#define   dysize(A)	(((A)%4)? 365: 366)
int dmsize[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};


init_chkpt_files()
/* initialize checkpoint file array; open checkpoint files
 * set earliest_time to current time which should be first time in SAT file */
{
	int i;

	for ( i = 0; i < 10; i++ ) {
		file[i].file_name = tempnam(tempdir,prefix);
		file[i].fildes = open(file[i].file_name,O_RDWR | O_CREAT,0777);
		if ( file[i].fildes == -1) {
			fprintf(stderr, "init_chkpt_files() open failed file # %d\n", i);
			perror("init_chkpt_files()");
		}
		else
			unlink(file[i].file_name);
	}
	earliest_time = event_time;
}

checkpoint()
/* create a checkpoint file for current time */
{
	int chkpt_file;
	time_t ltime = (event_time/HZ) + basetime;
	struct tm *tm;
	long SAT_posn = ftell(stdin);  /* current position in stdin =
						SAT file */

	if (index > 9) {
		printf("satfmt: checkpoint: too many checkpoints");
		return;
	}
	chkpt_file = file[index++].fildes;
	tm = localtime (&ltime);   	/* assume realtime */

	printf("checkpointing at time %.2d/%.2d/%.2d %.2d:%.2d\n", tm->tm_mon+1,
			tm->tm_mday, tm->tm_year, tm->tm_hour, tm->tm_min);


	write(chkpt_file, (char *) &event_time, sizeof(event_time));
	write(chkpt_file, (char *) &SAT_posn, sizeof(long));
	write(chkpt_file, (char *) rcnt, 32 * sizeof(int));
	write(chkpt_file, (char *) proc, MAXPID * sizeof(struct proc_entry *));
	chkpt_mount(chkpt_file);
	chkpt_keys(chkpt_file);
	chkpt_names(chkpt_file);
	chkpt_gnames(chkpt_file);
	chkpt_ttys(chkpt_file);
	chkpt_files(chkpt_file);
	chkpt_malloc(chkpt_file);

	/* return to beginning of checkpoint file */
	lseek(chkpt_file, 0L, 0);
}

restart()
/* restore state to beginning of audit trail records */
{
	struct tm *tm;
	time_t ltime;
	long SAT_posn;
	int chkpt_file = file[0].fildes;

	read(chkpt_file, (char *) &event_time, sizeof(event_time));
	ltime = (event_time/HZ) + basetime;    /* assume realtime */
	tm = localtime(&ltime);
	printf("restarting at time %.2d/%.2d/%.2d %.2d:%.2d\n", tm->tm_mon+1,
		tm->tm_mday, tm->tm_year, tm->tm_hour, tm->tm_min);

	read(chkpt_file, (char *) &SAT_posn, sizeof(long));
	fseek(stdin, SAT_posn, 0);

	read(chkpt_file, (char *) rcnt, 32 * sizeof(int));
	read(chkpt_file, (char *) proc, MAXPID * sizeof(struct proc_entry *));
	restore_mount(chkpt_file);
	restore_keys(chkpt_file);
	restore_names(chkpt_file);
	restore_gnames(chkpt_file);
	restore_ttys(chkpt_file);
	restore_files(chkpt_file);
	restore_malloc(chkpt_file);
	lseek(chkpt_file, 0L, 0);

        if ( skiptime ) {		/* if skip */
		mask[0] = mask_save[0];	/* restore printing */
		mask[1] = mask_save[1];	/* restore printing */
		mask_save[0] = 0;		/* prepare for next time */
		mask_save[1] = 0;		/* prepare for next time */
		skiptime = 0;
	}
	index = 1;
}

skip_to(month, day, hour, minute, year)
int month, day, hour, minute, year;
{
    time_t new_time;
    int  i;
    long SAT_posn;
    int chkpt_file;
    time_t ltime;
    struct tm* tm;
    int m = month;

    /* compute new_time */
    year += 1900;
    new_time = 0;
    for ( i=1970; i<year; i++ )
	new_time += dysize(i); /* add up days in years from 1970 to year */
    if (dysize(year)==366 && month>=3)
	new_time += 1;         /* correct for leap year */
    while (--m)
	new_time += dmsize[m-1];	/* days from 1/1/1970 to month */
    new_time += (day-1);		/* days since 1/1/1970 */
    new_time *= 24;
    new_time += hour;			/* hours since 1/1/1970 */

    new_time *= 60;
    new_time += minute;			/* minutes since 1/1/1970 */
    new_time *= 60;			/* seconds */

    /* correct for timezone */
    new_time += timezone;
    /* correct for daylight savings, if applicable */
    /* if you know a better way -- please fix */
    if ( localtime(&new_time) -> tm_isdst )
	new_time -= 3600;  /* subtract an hour */

    new_time -= basetime;		/* seconds since boot time */

    new_time *= HZ;			/* clock ticks since boot */

    if (new_time < event_time)  /* must back up */
    {
	/* no nonsense check */
	if (new_time < earliest_time)
	{
	    struct tm *tm;
	    int temp_time;

	    temp_time = (earliest_time/HZ) + basetime;
	    tm = localtime(&temp_time);
	    printf("cannot back up to %.2d/%.2d/%.2d %.2d:%.2d:00;\n", month,
		day, year, hour, minute);
	    printf("%s is %.2d/%.2d/%.2d %.2d:%.2d:%.2d\n", 
		"earliest time in audit trail", tm->tm_mon+1, tm->tm_mday,
		tm->tm_year, tm->tm_hour, tm->tm_min, tm->tm_sec);
	    return;
	}
	/* else (earliest_time < new_time < current time) */
	/* find appropriate checkpoint */
	while (event_time > new_time)
	{
	    read(file[--index].fildes, (char *) &event_time, sizeof(event_time));
	    lseek(file[index].fildes, 0L, 0);
	}
	chkpt_file = file[index++].fildes;
	lseek(chkpt_file, sizeof(int), 0);
	read(chkpt_file, (char *) &SAT_posn, sizeof(long));
	fseek(stdin, SAT_posn, 0);
	read(chkpt_file, (char *) rcnt, 32 * sizeof(int));
	read(chkpt_file, (char *) proc, MAXPID * sizeof(struct proc_entry *));
	restore_mount(chkpt_file);
	restore_keys(chkpt_file);
	restore_names(chkpt_file);
	restore_gnames(chkpt_file);
	restore_ttys(chkpt_file);
	restore_files(chkpt_file);
	restore_malloc(chkpt_file);
	lseek(chkpt_file, 0L, 0);
    }

    if ( skiptime ) {		/* if already processing a goto */
	mask[0] = mask_save[0];	/* reset flags */
	mask[1] = mask_save[1];	/* reset flags */
	mask_save[0] = mask_save[1] = 0;
	skiptime = 0;
    }

    if (new_time > event_time)
	skiptime = (time_t)new_time;
}
