/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) auditprint.c: version 25.1 created on 12/2/91 at 17:16:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)auditprint.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* auditprint.c
 *
 * auditfmt output formatting functions
 *
 */
/*MBM a number of events have aino's in them.  when the audit trail finally
      iets acl's in it, we need to use these */

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/mls.h>
#include <sys/inode.h>
#include <sys/synch.h>
#include <sys/file.h>
#include "auditfmt.h"

#include <sys/audit.h>

#define USER(X)			username((uint) X)
#define GROUP(X)		gname((uint) X)
#define TTY_NM			ttyname((dev_t) p->ctty)

#define PRINT_HDR		printf("\nProcess ID : %d \t%s\n",pid,hdr)
#define PRINT_LN2(A,B,C,D,E)	printf("Auid : %s  Euid : %s  Ruid : %s \tEgid : %s  Rgid : %s\n",USER(A),USER(B),USER(C),GROUP(D),GROUP(E))

print_syserr(p)
sat_syserr_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %d %d\n", rawhdr,
		    pid, (int) p->sysno, (int) p->errno);

	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		if (p->errno < sys_nerr)
			if (p->sysno < sys_ncall){
				printf("System Call : %s\n",
				    sys_calllist[(int) p->sysno]);
				printf("Event : System call error \n");
				printf("Result : %s\n",sys_errlist[p->errno]);
			}
			else{  /* sysno out of range */
				printf("System Call : System call number %d\n",
				    p->sysno);
				printf("Event : System call number unknown or out of range\n");
				printf("Result : %s\n",sys_errlist[p->errno]);
			}
		else if	/* errno out of range */
		(p->sysno < sys_ncall){
			printf("System Call : %s\n",
			    sys_calllist[(int) p->sysno]);
			printf("Event : System call error number out of range\n");
			printf("Result : Error number %d\n",p->errno);
		}
		else{  /* sysno also out of range */
			printf("System Call : System call number %d\n",
			    p->sysno);
			printf("Event : System call number and error number out of range\n");
			printf("Result : Error number %d\n",p->errno);
		}
	}
}

print_clock(p)
sat_clock_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %lu\n", rawhdr, pid, p->time);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Time Sync %s\n",ctime(&(p->time)));
	}
}

print_exec(p)
sat_exec_t *p;
{
	int indx;

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw ){
		printf("%s %d %d %u %u %u %d %u %u %u %u %u %u ", 
		    rawhdr, p->auid, pid, 
		    (uint) p->priv.real, 
		    (uint) p->priv.eff,
		    (uint) p->priv.mask, (dev_t) p->ctty,
		    (uint) p->ruid, (uint) p->rgid, (uint) p->euid,
		    (uint) p->egid, (uint) p->dev, (uint) p->ino);
		for(indx=0;(indx < NGROUPS_MAX) && ((ushort)p->groups[indx] != NEG_ONE);indx++){
			printf("%d",p->groups[indx]);
			if((indx+1 < NGROUPS_MAX) && ((ushort)p->groups[indx+1] != NEG_ONE))
				printf(",");
			else
				printf(" ");
		}
		printf("%u ",p->role);
		printf("%u %s ",p->minlabel.level, p->minlabel.catlst);
		printf("%u %s ",p->maxlabel.level, p->maxlabel.catlst);

		printf("%s\n",p->name);

	}
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(p->auid,p->euid,
		    p->ruid,p->egid,p->rgid);
		for(indx=0;(indx < NGROUPS_MAX) && ((ushort)p->groups[indx] != NEG_ONE);indx++){
			if(indx == 0) printf("Supplementry Groups : ");
			printf("%s",GROUP(p->groups[indx]));
			if((indx+1 < NGROUPS_MAX) && ((ushort)p->groups[indx+1] != NEG_ONE))
				printf(",");
			else
				printf("\n");
		}
		printf("System Call : Exec \n");
		if (p->ctty == NEG_ONE){
			printf("Event : Kernel executed file : ");
			filename(p->dev, p->ino, (dev_t) 0, p->name, 0);
		}
		else{
			printf("Event : On tty \(%s\) file executed :",TTY_NM);
			filename(p->dev, p->ino, (dev_t) 0, p->name, 0);
		}
		printf("Role: %s\n",roles(p->role));
		audit_print_priv("Privileges (real)",p->priv.real);
		audit_print_priv("Privileges (eff) ",p->priv.eff);
		audit_print_priv("Privileges (mask)",p->priv.mask);

		audit_print_label("Minlabel: ",&(p->minlabel) );
		audit_print_label("Maxlabel: ",&(p->maxlabel) );
		


	}
	if ( sensitive && procstate(S_START) ) {
		PRINT_HDR;
		PRINT_LN2(p->auid,p->euid,
		    p->ruid,p->egid,p->rgid);
		printf("Event : %s/%s\tSession Start\n", 
		    USER(p->ruid), TTY_NM);
	}
	if ( sensitive && ( (p->ruid != p->euid) ||
	    (p->euid != proc[pid]->session_data->uid) ) ) {
		PRINT_HDR;
		PRINT_LN2(p->auid,p->euid,
		    p->ruid,p->egid,p->rgid);
		printf("Event : Exec - euid != owner of file :\n");
		filename(p->dev, p->ino, (dev_t) 0, p->name, 0);
	}
}

print_fork(p)
sat_fork_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )		
		printf("%s %d %d %u %u %u\n", rawhdr,
		    (int) p->ppid, pid, p->priv.real, p->priv.eff,
		    p->priv.mask);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Fork - Parent pid = %d Child pid = %d\n",
		    (int) p->ppid, pid);
		audit_print_priv("Privileges (real)",p->priv.real);
		audit_print_priv("Privileges (eff) ",p->priv.eff);
		audit_print_priv("Privileges (mask)",p->priv.mask);
	}
}

print_exit(p)
sat_exit_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s%d %d %d %u\n", rawhdr,
		    pid, (int) p->flag, (int) p->status, p->pused);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Exit - Exit Status (%d,%d)\t%s\n",
		    (int) p->status>>8,
		    (int) p->status&0377,
		    flag((int) p->flag) );
		audit_print_priv("Privileges Used: ",p->pused);
	}
	if ( sensitive && procstate(S_STOP) ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Exit - %s/%s\tSession Finished\n",
		    username((int) proc[pid]->session_data->uid),
		    ttyname(proc[pid]->session_data->ttydev));
	}
	if ( sensitive && procstate(S_LOGIN) ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : ???/%s\tLogin Attempt Failed\n", 
		    ttyname(proc[pid]->session_data->ttydev));
	}
}

print_unlink(p)
sat_unlink_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %d %d %d %u %s %.14s\n", rawhdr,
		    pid, (int) p->dev, (int) p->ino, (int) p->dino, 
		    p->label.level, p->label.catlst, p->name);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Unlinking of file \n");
		filename(p->dev, p->ino, p->dino, p->name, 0);
		/* print all OTHER links; flag = 1 */
		filename(p->dev, p->ino, (dev_t) 0, p->name, 1);
		audit_print_label("Label: ",&(p->label));
	}
}

print_mknod(p)
sat_mknod_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %o %u %u %u %u %u %s %.14s\n", rawhdr,
		    pid, (int) p->mode,
		    (int) p->dev, (int) p->ino,
		    (int) p->dino, (int) p->aino, p->label.level,
		    p->label.catlst, p->name);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Make/Create node (Mode: %o) \n",
		    (int) p->mode);
		filename(p->dev, p->ino, p->dino, p->name, 0);
		audit_print_label("Label: ",&(p->label));

	}
}

print_link(p)
sat_link_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u %u %u %s %.14s\n", rawhdr,
		    pid, (int) p->dev, (int) p->ino, (int) p->dino, 
		    p->label.level, p->label.catlst, p->name);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Linking File \n");
		/* print new link */
		filename(p->dev, p->ino, p->dino, p->name, 0);
		/* print all OTHER links; flag = 1 */
		filename(p->dev, p->ino, (dev_t) 0, p->name, 1);
		audit_print_label("Label: ",&(p->label));
		
	}
}


print_access(p, ch)
sat_access_t *p;
int ch;
{
int	failed;

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %x %x %d %d\n", rawhdr,
		    pid, (int) p->mode, p->type,
		    (int) p->dev, (int) p->ino);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		failed = 0;
		switch (ch) {
			case AUD_ACCSR:
				printf("Event : Successfull Read.  Filename =");
				break;
			case AUD_ACCSW:
				printf("Event : Successfull Write. Filename =");
				break;
			case AUD_ACCFR: {
				printf("Event : Unsuccessfull Read. Filename =");
				failed = 1;
			}
				break;
			case AUD_ACCFW:{
				printf("Event : Unsuccessfull Write. Filename =");
				failed = 1;
			}
				break;
		}

		filename(p->dev, p->ino, (dev_t) 0, "", 0);
		if (failed)
			printf("Access Failed Due to: ");
		else
			printf("Access Succeded Due to: ");

		if (p->mode & ACCMODE)
			printf("mode_bits   ");
		if (p->mode & ACCPRIV)
			printf("privileges   ");
		if (p->mode & ACCACL)
			printf("acls   ");
		if (p->mode & ACCMAC)           /*should be hit olny if fail*/
			printf("invalid label   ");
		if (p->mode & ACCTIME)
			printf("bad time   ");
		if (p->mode & ACCOWNER)         /*should be hit olny if pass*/
			printf("ownership   ");
		printf("\n");
	}
}

print_ipccreat(p)
sat_ipccreat_t *p;
{
	char *ipc_op();

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %d 0x%x %d %o %d %u %s\n", rawhdr,
		    pid, p->id, p->key, p->uid, p->mode, (int) p->sysno,
		    p->label.level, p->label.catlst);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Creation of IPC %s  Id=%d  Key=0x%x  Mode=%o Owner=%s\n",
		    ipc_op(p->sysno), p->id, p->key, 
		    (int) p->mode,username(p->uid) );
		audit_print_label("Label: ",&(p->label));
	}
}

print_ipcaccs(p)
sat_ipcaccess_t *p;
{
	char *ipc_op();

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %c %d %u %d %d %s\n", rawhdr,
		    pid, p->mode, p->id, p->ipcmode, (int) p->sysno, 
		    p->label.level, p->label.catlst);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : IPC Access - "); /*MBM expand IPCACCESS*/
	}
}


print_ipcrm(p)
sat_ipcrm_t *p;
{
	char *ipc_op();

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s%u %d %d %d %u %s\n", rawhdr,
		    pid, p->id, (int) p->sysno, p->key, p->label.level,
		    p->label.catlst);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Removal of IPC %s  Id=%d	 Key=0x%x\n",
		    ipc_op(p->sysno),
		    p->id, p->key );
		audit_print_label("Label: ",&(p->label));
	}
}


print_mount(p)
sat_mount_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %d %d %d %d %d \n", rawhdr, 
		    pid, p->mode, (int) p->mtptdev, (int) p->mtptino,
		    (int) p->fsdev, p->fsrootdev, p->fsrootino);
	if (verbose || sensitive) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : File system \n");
		filename(p->fsrootdev, p->fsrootino, 
		    (dev_t) 0, "", 0);
		printf("Event : Mounted on ");
		filename(p->mtptdev, p->mtptino, (dev_t) 0, "", 0);
	}
}


print_unmount(devname, p)
char *devname;
sat_umount_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %d %d %d\n", rawhdr, 
		    pid, p->mode, (int) p->mptdev, (int) p->mptptino,
		    (int) p->fsdev);
	if ( devname == 0 ) {
		devname = (char *)alloc(12);
		sprintf(devname, "%d,%d", major(p->mptdev),
		    minor(p->mptdev));
	}
	if (verbose || sensitive){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Filesystem %s Unmounted from\n", 
		    devname);
		filename(p->mptdev, p->mptptino, (dev_t) 0, "", 0);
	}
}

print_kill(p)
sat_kill_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u\n", rawhdr,
		    pid, (uint) p->from_pid, (uint) p->signal);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Signal %u sent to process %u from process %u\n",
	    	    (uint) p->signal, pid, (uint) p->from_pid);
	}
}

print_pipe(p)
sat_pipe_t *p;
{
	char *name, *device_name();

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s%u %d %u %u\n", rawhdr,
		    pid, (uint)p->dev, (uint)p->ino);
	if (verbose) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		if (name = device_name((dev_t)p->dev))
			printf("Event : Unnamed pipe: Inode %u on Device %s\n",
			    (uint)p->ino, name);
		else
			printf("Event : Unnamed pipe: Inode %u on Device ????\n",
			    (uint)p->ino);
	}
}

print_setuid(p)
sat_setuid_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u %u %u %u %u %u\n", rawhdr,
		    pid, (uint)p->auid, (uint)p->ruid,
		    (uint)p->euid, (uint)p->role, p->priv.real,
		    p->priv.eff, p->priv.mask);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Set user identification (uid) \n");
		printf("Old effective/real uid = %s/%s\nNew effective/real uid = %s/%s\n",
		    username( (uint)proc[pid]->euid ),
		    username( (uint)proc[pid]->ruid ),
		    username( (uint)p->euid ),
		    username( (uint)p->ruid ) );
		printf("Old Role = %s   New Role = %s\n",
		    roles(proc[pid]->role),roles(p->role));
		audit_print_priv("Old Privileges (eff): ",proc[pid]->priv.eff);
		audit_print_priv("New Privileges (eff): ",p->priv.eff);

	}
}

print_setgid(p)
sat_setgid_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u\n", rawhdr,
		    pid, (uint)p->egid, (uint)p->rgid);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Set group identification (gid) \n");
		printf("Old effective/real gid = %s/%s; New effective/real gid = %s/%s\n",
		    gname( (uint)proc[pid]->egid),
		    gname( (uint)proc[pid]->rgid),
		    gname( (uint)p->egid ),
		    gname( (uint)p->rgid ) );
	}
}

print_chown(p)
sat_chown_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u %u %u\n", rawhdr,
		    pid, (int) p->dev,
		    (int) p->ino, (int) p->old_uid, (int) p->new_uid);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Owner change -  previous owner: %s; new owner: %s\n",
		    username((int) p->old_uid),
		    username((int) p->new_uid));
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
	}
	if ( sensitive ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		if ( (p->old_uid < 100) || (p->new_uid < 100) ) {
			printf("Event : Owner change on administrative id - old uid = %d; new uid = %d\n",
			    (uint) p->old_uid, (uint) p->new_uid);
			filename(p->dev, p->ino, (dev_t) 0, "", 0);
		}
	}
}

print_chmod(p)
sat_chmod_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u %u %u %u\n", rawhdr,
		    pid, (int) p->dev,
		    (int) p->ino, (int) p->old_mode, (int) p->new_mode);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Change file mode - previous mode: %o; new mode: %o\n",
		    (int) p->old_mode, (int) p->new_mode);
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
	}
	if ( sensitive &&
	    ((p->old_mode & (ISUID|ISGID)) != (p->new_mode & (ISUID|ISGID))) ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Change file mode setuid/setgid - old mode = %o; new mode = %o\n",
		    (uint) p->old_mode, (uint) p->new_mode);
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
	}
}

print_chgrp(p)
sat_chgrp_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u %u %u\n", rawhdr,
		    pid, (int) p->dev, (int) p->ino,
		    (int) p->old_gid, (int) p->new_gid);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Group change - old name: %s; new name: %s\n",
		    gname((int) p->old_gid), gname((int) p->new_gid));
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
	}
	if ( sensitive && ((p->old_gid < 100) || (p->new_gid < 100))) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Group change on administrative id - old gid = %d; new gid = %d\n",
		    (uint) p->old_gid, (uint) p->new_gid);
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
	}
	if (sensitive){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Group change - old gid = %d; new gid = %d\n",
		    (uint) p->old_gid, (uint) p->new_gid);
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
	}
}


print_priv(p)
sat_priv_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %#X %#X %u\n", rawhdr,
		    pid, (uint) p->priv.real, (uint) p->priv.eff,
		    (uint) p->priv.mask);

	if ( verbose || sensitive ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Changing privilege\n");
		audit_print_priv("Old Privileges (real)",proc[pid]->priv.real);
		audit_print_priv("Old Privileges (eff) ",proc[pid]->priv.eff);
		audit_print_priv("Old Privileges (mask)",proc[pid]->priv.mask);

		audit_print_priv("New Privileges (real)",p->priv.real);
		audit_print_priv("New Privileges (eff) ",p->priv.eff);
		audit_print_priv("New Privileges (mask)",p->priv.mask);
	}
}

print_supp(p)
sat_setsupp_t *p;
{
	int indx;

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw ){
		printf("%s %d", rawhdr, pid);
		for(indx=0;(indx < NGROUPS_MAX) && ((ushort)p->groups[indx] != NEG_ONE);indx++){
			printf("%d",p->groups[indx]);
			if((indx+1 < NGROUPS_MAX) && ((ushort)p->groups[indx+1] != NEG_ONE))
				printf(",");
			else
				printf("\n");
		}
	}

	if ( sensitive || verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Modification to supplementary group(s)\n");
		for(indx=0;(indx < NGROUPS_MAX) && ((ushort)p->groups[indx] != NEG_ONE);indx++){
			printf("%s",GROUP(p->groups[indx]));
			if((indx+1 < NGROUPS_MAX) && ((ushort)p->groups[indx+1] != NEG_ONE))
				printf(",");
			else
				printf("\n");
		}

		if ( indx == 0){
			printf("No supplementary group(s) assigned to uid\n");
		}
	}
}

print_chroot(p)
sat_chroot_t *p;
{
	char *name, *device_name();

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %d %d\n", rawhdr, pid, p->dev, p->ino);

	if ( sensitive || verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);

		if (name = device_name((ushort) p->dev))
			printf("Event : Change to root (chroot) Inode : %u on Device :  %s\n",(uint)p->ino, name);
		else
			printf("Event : Change to root (chroot) Inode : %u on Device :  ????\n",(uint)p->ino);
	}
}

print_filepriv(p)
sat_filepriv_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s%u %d %d %d %u %u\n", rawhdr,
		     pid, (ushort) p->dev, (ushort) p->ino,
		    (uint) p->old_priv, (uint) p->new_priv);
	if ( verbose || sensitive ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid, 
		    proc[pid]->ruid, proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Changing file privilege on file  ");
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
		audit_print_priv("Old privilege:",p->old_priv);
		audit_print_priv("New Privilege:",p->new_priv);
	}
}


print_filelabel(p)
sat_filelabel_t *p;
{

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw ){
		printf("%s %d %d %d %s %d %s\n ", rawhdr, pid, 
		    (ushort) p->dev, (ushort) p->ino, 
		    (ushort) p->old_label.level, p->old_label.catlst,
		    (ushort) p->new_label.level, p->new_label.catlst);
	}
	if ( verbose || sensitive ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid, 
		    proc[pid]->ruid, proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Set MAC Label for file ");
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
		audit_print_label("Old label",&(p->old_label));
		audit_print_label("New label",&(p->new_label));
	}
}

print_acl(p)
sat_acl_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %d %d %d %d %d\n", rawhdr, pid, 
		    (ushort) p->dev, (ushort) p->ino, 
		    (ushort) p->aino, p->aclsize);
	if ( verbose || sensitive ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid, 
		    proc[pid]->ruid, proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Set ACL for file\n");
/*MBM  print the acl here...this routine needs another parameter to pass
       the contents of the acl ....what format?? */
		filename(p->dev, p->ino, (dev_t) 0, "", 0);
	}
}


print_ipcdac(p)
sat_ipcdac_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %d %o %d %d %o %d %d\n", rawhdr, pid,
		    (int) p->old_uid, (int) p->old_gid, (int) p->old_mode,
		    (int) p->new_uid, (int) p->new_gid, (int) p->new_mode,
		    (int) p->id, (int)p->sysno);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		if (p->old_uid != p->new_uid) {
			printf("Event : IPC owner change - previous owner: ");
			printf("%s; new owner: %s  id=%d\n",
			    username((int) p->old_uid),
			    username((int) p->new_gid), p->id );
		}
		else if (p->old_gid != p->new_gid) {
			printf("Event : IPC group change - old gid: ");
			printf("%s new gid: %s  id=%d\n",
			    gname((int) p->old_gid), gname((int) p->new_gid)
			    , p->id); 
		}
		else if (p->old_mode != p->new_mode) {
			printf("Event : IPC mode change - previous modes: ");
			printf("%o; new modes: %o  id=%d\n",
			p->old_mode & 0777, p->new_mode & 0777,  p->id );
			
		}else
			printf("Event : IPC DAC change: **No change**");


	}
	if ( sensitive ) {
		if ( (p->old_uid != p->new_uid) && 
		     (p->old_uid < 100) || (p->new_uid < 100) ) {
			PRINT_HDR;
			PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
			    proc[pid]->ruid,proc[pid]->egid,
			    proc[pid]->rgid);
			printf("Event : IPC owner change on administrative id - old uid = %d; new uid = %d\n",
			    (uint) p->old_uid, (uint) p->new_uid);
		} else
		if ( (p->old_gid != p->new_gid) && 
		     (p->old_gid < 100) || (p->new_gid < 100) ) {
			PRINT_HDR;
			PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    	    proc[pid]->ruid,proc[pid]->egid,
		    	    proc[pid]->rgid);
			printf("Event : IPC group change on administrative id - old gid = %d; new gid = %d\n",
		    	    (uint) p->old_gid, (uint) p->new_gid);
		}
	}
}

print_setsid(p)
sat_setsid_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %d %d %d %d\n", rawhdr,
		    pid, (uint) p->mode,(uint) p->old_sessid,
		    (uint) p->old_pgrp, (int) p->old_ctty, (int) p->new_ctty);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		if(p->mode)
			printf("Event : Set Session Id - old sid = %d, new sid = %d\n",	
	    	    	    (uint) p->old_sessid, (uint) pid);
		else
			printf("Event : Set Process Group Id - old pgid = %d, new pgid = %d\n",	
	    	    	    (uint) p->old_pgrp, (uint) pid);
		printf("Controling tty change - old = %s, new = %s\n",
	    	    ttyname(p->old_ctty),ttyname(p->new_ctty));
	}
}


print_setrole(p)
sat_setrole_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u %u %u\n", rawhdr,
		    pid, (uint) p->new_role,
		    p->priv.real, p->priv.eff, p->priv.mask);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    		proc[pid]->ruid,proc[pid]->egid,
	    		proc[pid]->rgid);
		printf("Event : Set role - New role = %s, Old role = %s\n", 
	    		roles(p->new_role), roles(proc[pid]->role));
		audit_print_priv("Old Privileges (real)",proc[pid]->priv.real);
		audit_print_priv("Old Privileges (eff) ",proc[pid]->priv.eff);
		audit_print_priv("New Privileges (real)",p->priv.real);
		audit_print_priv("New Privileges (eff) ",p->priv.eff);
	}

}
print_label(p)
sat_label_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u\n", rawhdr, pid, 
		    (uint) p->minlabel.level, p->minlabel.catlst,
		    (uint) p->maxlabel.level, p->maxlabel.catlst);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Set process label  \n"); 
/*MBM when the slabel_t is put in proc we need to un-comment the next two lines
		audit_print_label("Old Minlabel: ",proc[pid]->minlabel );
		audit_print_label("Old Maxlabel: ",proc[pid]->maxlabel );
*/
		audit_print_label("New Minlabel: ",&(p->minlabel) );
		audit_print_label("New Maxlabel: ",&(p->maxlabel) );
		
		printf("%s %d %u %u\n", rawhdr, pid, 
	    	    (uint) p->minlabel.level, p->minlabel.catlst,
	    	    (uint) p->maxlabel.level, p->maxlabel.catlst);
	}
}


print_create(p)
sat_create_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %o %u %s %u %u %u %s\n", rawhdr, pid, 
		(uint) p->mode, (uint) p->label.level, p->label.catlst,
		(uint) p->ino, (uint)p->dino, (uint)p->aino, p->name);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Creat System Call \n"); 
		printf("New file name is ");
		filename(p->dev,p->ino,p->dino,p->name,0);
		audit_print_label("New file label is ",p->label);

	}
}

print_slink(p)
sat_slink_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %s %u %u %s %d %s\n", rawhdr, pid, 
		(uint) p->label.level, p->label.catlst, (uint) p->ino, 
		(uint)p->dino, p->name, p->path_length, p->target);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Create A Symbolic Link\n"); 
		printf("New file name is ");
		filename(p->dev,p->ino,p->dino,p->name,0);
		audit_print_label("New file label is ",p->label);
		printf("The target for this symbolic link is %s\n",p->target);

	}
}


print_rename(p)
sat_rename_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u\n", rawhdr, pid, 
		    (int) p->dev, (uint) p->ino, (uint)p->dino,
		    (uint)p->label.level, p->label.catlst, p->name);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
		    proc[pid]->ruid,proc[pid]->egid,
		    proc[pid]->rgid);
		printf("Event : Rename (raw) -\n"); /*MBM expand*/
		printf("%s %d %u %u\n", rawhdr, pid, 
		    (int) p->dev, (uint) p->ino, (uint)p->dino,
		    (uint)p->label.level, p->label.catlst, p->name);
	}
}


print_ipclabel(p)
sat_ipclabel_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %d %d %d %u %s %u %s\n", rawhdr, pid, 
		    p->id, p->key, p->sysno, 
		    (uint) p->new_label.level, p->new_label.catlst,
		    (uint) p->old_label.level, p->old_label.catlst);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Set IPC Label (raw) -\n"); /*MBM expand*/
		printf("%s %d %d %d %d %u %s %u %s\n", rawhdr, pid, 
		    p->id, p->key, p->sysno, 
		    (uint) p->new_label.level, p->new_label.catlst,
		    (uint) p->old_label.level, p->old_label.catlst);
	}
}


print_login(p)
sat_login_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %#x %s %u \n", rawhdr, pid, 
		    (uint) p->mode, p->tty, p->uname, (uint)p->flag);
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Login/Su Audit Information  ");

	/*Networking stuff can't always see it's tty*/ 
		if (p->tty == 0 ) 
			printf("user=%s\n", p->uname); 
		else
			printf("user=%s, tty=%s\n", p->uname, ttyname(p->tty)); 

	/*Print out the flag bits*/
		if(p->flag & SU_ID)
			printf("Su ");
		else 	
			printf("Login ");
		if (! (p->flag & LOGIN_FAIL))
			printf("Successfull. \n");
		else {
			printf("Failed. ");

	/*Print out the mode bits */
			if (p->mode & LOGIN_BADTIME)
				printf("Failure due to bad time.\n");
			if (p->mode & LOGIN_BADPWD)
				printf("Failure due to bad password.\n");
			if (p->mode & LOGIN_BADUID)
				printf("Failure due to bad uid.\n");
			if (p->mode & LOGIN_LOCKED)
				printf("Failure due to locked account.\n");
			if (p->mode & LOGIN_RETIRED)
				printf("Failure due to retired account.\n");
			if (p->mode & LOGIN_TTY_LOCK)
				printf("Failure due to locked tty.\n");
			if (p->mode & LOGIN_TTY_NOPERM)
				printf("Failure due to no permission on tty.\n");
		}

	}
}


print_audit(p)
sat_audit_t *p;
{ 

	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %u %u %u\n", rawhdr, pid, 
		    (uint) p->mode, (uint)p->version, (uint)p->mask[0],
		    (uint) p->mask[1]);
	if ( verbose ) {
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : AUDIT System Call.\n");

		if (p->mode & AUDMASK)
			printf("Audit trail mask changed. Old mask = %0#x%0#x, New mask = %0#x%0#x\n", mask[0],mask[1],p->mask[0],p->mask[1]); 
		else if (p->mode & AUDSTART)
			printf("Audit trail started\n");
		else if (p->mode & AUDSTOP)
			printf("Audit trail stopped\n");
		else
			printf("Unknown Audit trail action\n");
	} 
}


print_usrinfo(p)
sat_usrinfo_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf(stderr, "%s %u %u %s\n", rawhdr,pid,
			p->mode, p->uname);
	if ( verbose || sensitive ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Change to User Account DataBase\n");
		printf(stderr, "%s %u %u %s\n", rawhdr,pid,
			p->mode, p->uname);

	}
}


print_devinfo(p)
sat_devinfo_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		fprintf(stderr, "%s %u %u %s\n", rawhdr,pid,
			p->mode, p->ttyn);

	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : Change to dev_auth (raw)\n"); /*MBM expand*/
		fprintf(stderr, "%s %u %u %s\n", rawhdr,pid,
			p->mode, p->ttyn);
	}
}

print_lp(p)
sat_lp_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf(stderr, "%s %u %u %u %u %d %u %d %u %s\n",
			rawhdr,pid,p->mode, p->uid, p->gid,
			(int)p->file_dev, p->file_ino,
			(int)p->pr_dev, p->pr_ino, p->pname);
        
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : LP  (raw)\n"); /*MBM expand*/
		printf(stderr, "%s %u %u %u %u %d %u %d %u %s\n",
			rawhdr,pid,p->mode, p->uid, p->gid,
			(int)p->file_dev, p->file_ino,
			(int)p->pr_dev, p->pr_ino, p->pname);
	}
}


print_cron(p)
sat_cron_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		fprintf(stderr, "%s %d %d %u\n", rawhdr,pid,
			p->mode, p->uid, (int) p->file_dev, p->file_ino);
  
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : CRON (raw)\n"); /*MBM expand*/
		fprintf(stderr, "%s %d %d %u\n", rawhdr,pid,
			p->mode, p->uid, (int) p->file_dev, p->file_ino);
	}
}
print_uucp(p)
char *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf(stderr, "%s %d %s\n", rawhdr,pid,&p);
 
	if ( verbose ){
		PRINT_HDR;
		PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    	    proc[pid]->ruid,proc[pid]->egid,
	    	    proc[pid]->rgid);
		printf("Event : UUCP (raw)\n"); /*MBM expand*/
		printf(stderr, "%s %d %s\n", rawhdr,pid,&p);
	}
}


print_ctty(p)
sat_ctty_t *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %u %d\n", rawhdr,
		    pid, (uint) p->sessid, (int) p->ctty);
	if ( verbose ){
		PRINT_HDR;
	PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    proc[pid]->ruid,proc[pid]->egid,
	    proc[pid]->rgid);
	printf("Event : Change Controling tty - sessid = %u ctty = %s\n", 
	    (uint) p->sessid, ttyname(p->ctty));
	}
}


print_uli(p)
char *p;
{
	if (userflagged && !FLAGGED_USER(proc[pid]->ruid))             
		return;
	if ( raw )
		printf("%s %d %s\n", rawhdr, pid, p);
	if ( verbose ){
		PRINT_HDR;
	PRINT_LN2(proc[pid]->auid,proc[pid]->euid,
	    proc[pid]->ruid,proc[pid]->egid,
	    proc[pid]->rgid);
	printf("Event : User Level General Audit Information\n");
	printf("User String = <%s>\n",p);
	}
}


print_unknown_rec(p, event)
char *p;
uchar event;
{
printf("Event: unknown record...Event number = %d\n",(uint)event);
}


audit_print_priv(str,priv)
char *str;
uint priv;
{
	char sym_priv[512]; 

	sym_priv[0] = '\0';
	if (cvt_priv_to_sym(priv,sym_priv,1,' '))
		printf("%s %s\n",str,sym_priv);
	else
		printf("%s %u\n",str,priv);
}


audit_print_label(str,label)
char *str;
slabel_t *label;
{
	char sym_label[80]; 

	sym_label[0] = '\0';
	if (cvt_slabel_sym(sym_label,label))
		printf("%s %s\n",str,sym_label);
	else
		printf("%s %u %s\n",str,label->level, label->catlst);

}

