/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) auditfmt.h: version 25.1 created on 12/2/91 at 17:16:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)auditfmt.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/priv.h>

extern int raw;
extern int verbose;
extern int sensitive;
extern int realtime;
extern int lbolttime;
extern int userflagged;
extern int prefix;

extern int ch, size, pid, cpu;
extern uint seq;
extern time_t event_time;
extern int fuid;
extern int mask_save[2];

extern int rcnt[];

extern char hdr[], rawhdr[], ulibuf[], user[];

extern char *username();
extern char *gname();
extern char *roles();
extern char *ttyname();
extern char *flag();
extern int sys_ncall;
extern char *sys_calllist[];

extern int sys_nerr;                /* see PERROR(3C) */
extern char *sys_errlist[];
extern int rcnt[];

#define FALSE	0
#define TRUE	1
#define NEG_ONE 0xffff

extern int mask[2];
extern int initial_mask[2];

extern time_t basetime;
extern time_t skiptime;

/* session state flags */
#define S_NEW		0	/* forked from init, no exec yet */
#define S_GETTY		1	/* getty seen */
#define S_LOGIN		2	/* login seen */
#define S_START		4	/* started session */
#define S_STARTED	8	/* started session reported */
#define S_STOP	       16	/* terminated session */

/* is user A the flagged user? */
#define FLAGGED_USER(A)		((A) == fuid)

struct session {
	ushort	nlink;		/* number of processes in this session */
	ushort	uid;		/* owner of this session */
	ushort	ttydev;		/* tty this session was started on */
	ushort	pid;		/* process group leader at login */
	ushort 	state;		/* state of the session */
	time_t	tstart;		/* event start time */
	time_t	tfinish;	/* session finished time */
};

struct proc_entry {
	struct session *session_data;	/* Common session data */
	priv_t	priv;
	ushort	euid, auid, ruid;	/* This process user permissions*/
	ushort	egid, rgid;  		/* This process' group permissions */
	ushort	role;			
	ushort	groups[NGROUPS_MAX];	/* Supplement groups */
};

extern struct proc_entry *proc[];	/* active procs indexed by pid */
