/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) list.c: version 25.1 created on 12/2/91 at 17:16:28	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)list.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "auditmap.h"

/* @(#)list.c	8.1 System V/MLS source as of 11/15/88 13:15:35
 */

/* pointer to head of linked list */
extern struct idlist *list;
extern struct idlist *pre;
extern char  *malloc();

/* make_list()	- build a sort linked list 
 * 
 * make_list takes 2 arguments;
 *	item: a pointer to appropriate data
 *	type: type of data, USER: passwd data, GROUP: group data,
 *			    ROLE: role data, TTYS : /dev directory data
 *
 * Make_list builds a linked list that is sorted and has no duplicated data
 * stored in it.  Make_list will exit if the malloc for a new element fails.
 *
 * Make_list maintains a static pointer to the last element inserted in the
 * list as a time saving feature.  The data for the most part is already 
 * sorted and as such considerable time can be saved by using a static pointer.
 */

FILE  *conF;
void
make_list(item, type)
char *item;			/* Pointer to data */
int type;			/* Type of data    */
{
	/* Temporary pointers */
	struct idlist *new;

	/* Allocate space for new element in list
	 */
	new = (struct idlist *)malloc(sizeof(struct idlist));

	/* Malloc failed ?
	 */
	if ( new == (struct idlist *) 0 )
	{
		fprintf(conF, "Insufficent memory\n");
		exit(7);
	}

	if ( list == (struct idlist *)0 )
		list = new;
	else
		pre->next = new;

	pre = new;
	new->next = (struct idlist *) 0;

	/*
	Put values in item
	*/
	init_item(new, item, type);

	return;
}

/* init_item()	-	load a element in the linked list with data values
 *
 * init_item takes 3 arguments:
 *	ptr : pointer to element in linked list
 *	item: pointer to data
 *	type: type of data
 *
 * init_item casts the data item and loads the element in the linked list
 * with the data and returns.  Any character strings are malloc'ed. All
 * unused values in element are set to zero.
 */
void
init_item(ptr, item, type)
struct idlist *ptr;
char *item;
int type;
{
	/* Pointer to cast "item"
	 */
	usrauth_t *u;
	roldef_t *r;
	struct group *g;
	struct dirent *d;

	struct stat buf;

	switch (type)
	{
		case USER:
			/* Cast item to passwd structure
			 */
			u = (usrauth_t *) item;

			/* Load values in struct
			 */
			ptr->itm.id = u->ua_uid;
			ptr->itm.name = (char *) strdup(u->ua_name);

			break;

		case ROLE:
			/* Cast item to roldef_t structure
			 */
			r = (roldef_t *) item;

			/* Load values in struct
			 */
			ptr->itm.id = r->r_rolenumber;
			ptr->itm.name = item;     
			break;                   
						

		case GROUP:
			/* Cast item to group structure
			 */
			g = (struct group *) item;

			/* Load values in struct
			 */
			ptr->itm.id = g->gr_gid;
			ptr->itm.name = (char *) strdup(g->gr_name);
			break;

		case TTYS:
			/* Cast item to directory entry structure
			 */
			d = (struct dirent *) item;

			/* Stat file ... need device number
			 */
			(void) stat(d->d_name, &buf);

			/* Load values in struct
			 */
			ptr->itm.id = buf.st_rdev;
			ptr->itm.name = (char *) strdup(d->d_name);
			break;
	}
	return;
}

/* print_list()	-	Print the linked list
 *
 * Print_list takes 2 arguments:
 *	fp:	file pointer to output.
 *	type:	type of linked list data to be printed.
 *
 * Print_list traverses the linked list and visits each node printing
 * the data, and then frees the malloc'ed storage.
 *
 * Printing of the data is preformed by print_item().
 * Freeing of the data is preformed by free_item().
 *
 * Print_list returns the number of elements in the list.
 */
int
print_list(fp, type)
FILE *fp;
int type;
{
	/* Number of elements in list */
	int count = 0;
	int indx;
	int rindx = 0;

	/* Define functions */
	int compar();
	void qsort();

	/* Temporary pointers */
	struct idlist *cur, *save;
	struct data *plist;

	/* Set cur to head of list */
	cur = list;

	/* Traverse list */
	while ( cur != (struct idlist *) 0 ) {
		cur = cur->next;
		++count;
	}
	
	if ( (plist = (struct data *)malloc((unsigned) count * sizeof(struct data))) == NULL ) {
		fprintf(conF,"Auditmap: Out of memory\n");
		exit (0);
	}
	
	/* Reset the head of the list */
	cur = list;

	/* Load the data from a link list to an array to sort */

	for (indx = 0; indx < count; indx++){
		plist[indx].id = cur->itm.id;
		plist[indx].name = cur->itm.name;
		save = cur->next;
		free_item(cur);
		cur = save;
	}

	qsort(&plist[1], (unsigned)(count-1), sizeof(struct data), compar);

	indx = 0;
	while (indx < count){
/*MBM check return values on writes */
		if (type != ROLE){
			fwrite(&plist[indx].id,sizeof(plist[indx].id),1,fp);
			fprintf(fp,"%s ",plist[indx].name);
			free(plist[indx].name);
		} else {
			fwrite(plist[indx].name,sizeof(roldef_t),1,fp);
		}

		while (plist[indx].id == plist[indx+1].id) 
			indx++;
	

		indx++;
		rindx++;
	}

	free(plist); 
	return (rindx);
}

/* free_item() -	free the storage associated with the list element
 *
 * free_item takes 1 arguments:
 *	cur:	pointer to element to free.
 * free_item based on the type of information stored in element frees
 * the dynamically allocated storage associated with the element and
 * then frees the pointer.
 */
void 
free_item(cur)
struct idlist *cur;
{
	free(cur->itm.name);
	free(cur);
	return;
}

/*
*
* Compare function for qsort 
*
*/
int compar(pp1,pp2)
struct data *pp1, *pp2;
{
	int value;

	return(pp1->id - pp2->id);
	
}
