/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) auditd.c: version 25.5 created on 3/11/92 at 15:56:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)auditd.c	25.5	3/11/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	auditd   security audit trail deamon process. This deamon is
 *		 responsible for reading audit records from the audit 
 *		 device into the current audit trail. 
 *	(C)Copyright 1990 by ARIX Corp.
 *
 *	Version 2: This version is essentially a rewrite of the ATT V/MLS
 *	           audit deamon. This rewrite shares little in common with
 *		   the ATT version. It has been redesigned to work with
 *		   the new ARIX audit features.
 *
 */

#ident	"@(#)auditd: security audit deamon 2.0"

#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/synch.h>
#include <sys/signal.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <limits.h>
#include <sys/audit.h>
#include <sys/stat.h>
#include <sys/statfs.h>

#include <errno.h>
#include <stdio.h>
#include <sys/param.h>
#include <time.h>

extern int  optind;
extern char *optarg;

/* JTOF - changes this when testing is complete */
#define MIN_MAXFILE	4096
#define CONSOLE		"/dev/console"
#define BUFSIZE		1024
#define FOURMEG		1024 * 1024 * 4

#define SHUTDOWN		0x01
#define SESSOPEN		0x02
#define	SESSSTP			0x04
#define AUDSTRT			0x10
#define NOEXIT			0x80

#define addmask(m,a)	(((a)<32) ? (m[0]|=(1<<(a))) : (m[1]|=(1<<((a)-32))))



	
/* Notes: Sessions are defined as the combination of audit headers (snapshots
 * of the system before audit started) and one or more transaction sendfile.
 * This structure keeps track of the audit session information. Since we
 * may have multiple audit sendfile per session, options are provided to attach
 * the header for a session to the first audit file, or to create it as it's 
 * own entity. Audit sendfile may be changed at any time, and a completly new 
 * rescan (snapshot) of the system may be done by terminating the current 
 * session and starting the new one. 
 */
typedef struct {
	char	state;			/* state of current session */
	int	seq;
	int 	sessn;			/* keep track of the current session */
	int	satfd;			/* audit trail desciptor */
	int	audfd;
	int	maxcnt;			/* max size of single file */
	time_t	sess_stamp;		/* session stamp for  headers */
	char	bname[NAME_MAX];
	char	cname[NAME_MAX];
	char	path[PATH_MAX];
	char	buf[BUFSIZE];
	} aud_sess_info_t;

/* now declare the structure to keep track of things */
aud_sess_info_t  aud_sess;
char *sesname;
slabel_t label;
char *ttyn, *ttyname();
int debug;
FILE  *conF;
FILE  *audF;

extern newsess();
extern endsess();
extern rdnewfile();
extern sendfile();

/*
 * 	main   start the audit deamon. Process the command line options
 *	       and set the appropriate modes. If no actions given, startup
 *	       with default values and wait for the auditc utilitiy to tell
 *	       us what to do 
 */

main( argc, argv )
char **argv;
{
int c, n, tmp;
aud_state_t aud_info;
aud_sess_info_t *as = &aud_sess;
int ulim;
struct stat  statb;

	if ( ! priv( P_SEC, getuid()))
		error( "permission denied" );

	as->maxcnt= FOURMEG;
	/* parse the command line for options */
	while (( c = getopt( argc, argv, "dex:m:h:z:s:?")) != -1 ) {
		switch( c ) {
			case 'x':
				as->maxcnt = atoi( optarg );
				if ( as->maxcnt < MIN_MAXFILE )
					error( "max file size too small\n" );
				break;
			case 'd':
				debug = 1;
				break;
			case 'e':
				as->state |= AUDSTRT;
				break;
			case 'm':
				setamask( optarg );
				break;
			case 'z':
				audithwm( optarg );
				break;
			case 'h':
				audittmout( optarg );
				break;
			case 's':
				sesname = optarg;
				break;
			case '?':
				usage();
				return;
			default:
				error( "unknown argument" );
		}
	}

	as->audfd = -1;

	/* pick up current state of audit driver */
	if (audit_status( &aud_info )) 
	{
		as->state |= SHUTDOWN;
		acc_error( "can't get audit information" );
	}

	/* make sure we don't start twice */
	if ( aud_info.pid != 0 )
		error( "auditd already running" );

	/* let's shut down for any errors in the startup */
	as->state |= SHUTDOWN;
	/* JTOF - make sure the devices are labeled SYS_SEC at this
 	 *        point. This may be overkill, but we want to make sure
 	 *        noone can get to the device when we are running
	 */
	if (!cvt_sym_slabel( "SYS_SEC", &label ))
		error( "can't write label on /dev/sat abd /dev/satcomm " );
	set_file_slabel( SATDEV, &label );
	set_file_slabel( SATCOMM, &label );

	close(0);
	close(1);
	close(2);
	fclose(stdin);
	fclose(stdout);
	fclose(stderr);

	/* don't pay attention to the normal signals */
	for ( n = 0; n < MAXSIG; n++ )
		signal( n, SIG_IGN );

	/* find the limit for the length of the audit file */
	ulim = ulimit(1, 0);
	if ( ulim == -1 )
		acc_error("ulimit failed");
	ulim *= 512;

	/* create the new session */
	newsess( sesname );

	if (!debug ) {
		if ( fork() )
			return;
		else
			setsid();
	}

	/* now go and enable the audit records */
	if ( as->state & AUDSTRT )
		audit_start();

	/* open the sat device */
	if ((as->satfd = open( SATDEV, O_RDONLY | O_NDELAY)) < 0 ) 
		error( "can't open sat driver" );

	signal( KILLSESS, endsess );
	signal( GETFILE, sendfile );

	/* from here on in we will do shutdown's on errors */
	as->state |= SHUTDOWN;

	/* find the size of the file so far (after writing the header). */
	if ( fstat(as->audfd, &statb) == -1 )
		acc_error("stat failed\n");
	as->maxcnt = statb.st_size;

	/* this loop is a continuous read loop from the sat deamon
         * and writes to the audit trail. We will spend the large 
         * majority of the time sleeping in the read portions, and
         * we may take command signals that interrupt the sleep. In
         * such cases, we will wake up, handle the signal and restart
         * the loop.
	 */
	while ( 1 ) {
		/* read data from the sat driver */
		if ((n = read( as->satfd, as->buf, BUFSIZE)) < 0)  {
			if (( n == -1) && ( errno == EINTR ))
				continue;
			acc_error( "can't read sat driver" );
		}
		/* display the formatted contents of the buffers for
		 * debug purposes 
		 */

		if ( n > ulim - as->maxcnt )
		{
			newfile(1);
			as->maxcnt = 0;
		}

		/* put the data in the sat driver */
		if ((c = fwrite( as->buf, 1, n, audF)) != n) {
			if ((c == 0) && (errno == EINTR ))
				continue;
			else
				acc_error( "can't write audit trail" );
		}

		checkspace();
		as->maxcnt += n;
	}
}

#define LO_AUD_SPACE  500	/* # 1k blocks left when shutdown starts */
#define LO_AUD_WALL   2		/* minutes to wall warning */
#define LO_AUD_WARN   10	/* minutes to console warning to sec adm */
char  sd_cons[] = "\nThe audit trail is running out of space.\nAt the current rate the slice will fill up in %d minutes.\nThe slice should be cleaned up now or the system will be shut down.\n";

/* LO_AUD_WALL = 2 correlates to the "2 minutes" in the following string */
char  sd_wall[] = "echo \"The audit trail is running out of space.\n\
At the current rate, the audit trail will fill up in about 2 minutes.\n\
At that time the system will be brought to the single user state.\" | wall";

char sd_wall2[] = "echo \"No more space on audit slice\n\
System being shut down in 10 seconds.\nPlease log off now.\" | wall";

checkspace()
{
	struct statfs statbuf;
	static int lo_space = 0;
	long  tx;
	char current_afile[PATH_MAX];
	static long  t2 = 0;
	static int  aud_minute = 0;
	static int lastbfree = 0;
	static int shutdown_once = 0;

	strcpy( current_afile, aud_sess.path );
	strcat( current_afile, aud_sess.cname );

	if ( statfs(current_afile, &statbuf, sizeof statbuf, 0) == -1 )
		error("fstatfs fail\n");

	if ( lo_space == 0 &&
	     statbuf.f_bfree < LO_AUD_SPACE + LO_AUD_WARN * aud_minute )
	{
		lo_space++;
		fork_printf(sd_cons, LO_AUD_WARN);
	}

	if ( lo_space == 1 &&
	     statbuf.f_bfree < LO_AUD_SPACE + LO_AUD_WALL * aud_minute )
	{
		lo_space++;
		if ( fork() == 0 )
		{
			execl("/bin/sh","sh","-c",sd_wall,(char *)0);
			exit(3);
		}
	}

	tx = time(0);
	if ( tx - t2 >= 60 )
	{
		aud_minute = lastbfree - statbuf.f_bfree;
		t2 = tx;
		lastbfree = statbuf.f_bfree;
	}

	if ( shutdown_once == 0 && statbuf.f_bfree < LO_AUD_SPACE )
	{
		shutdown_once++;
		if ( fork() == 0 )
		{
			execl("/bin/sh","sh","-c",sd_wall2,(char *)0);
			exit(3);
		}
		sleep(10);
		shutdwn();
	}
}


/*
 *	newsess   create a new session marked by the name passed in. 
 */
newsess( sesname )
char *sesname;
{
aud_sess_info_t *as = &aud_sess;
int confd, fd, status;
char tmp[PATH_MAX];

	ttyn = ttyname( 0 );

	/* close any sessions previously open */
	if ((as->state & SESSOPEN ) && (as->audfd != -1 ))
		close( as->audfd );

	/* get an audit file to start */
	newfile(1);

	if ( sesname && *sesname ) {
		strcpy( tmp, as->path );
		strcat( tmp, sesname );

		/* this allocates stdout */
		if ((fd = open( tmp, O_WRONLY | O_CREAT, 0600 )) < 0 ) {
			sprintf( as->path, "can't open %s", tmp );
				error( as->path );
			set_file_slabel( tmp, &label );
		}
	}
	else
		dup( as->audfd );


	if ((conF = fopen( CONSOLE, "w" )) == NULL)
		exit(9);


	/* write the header if necessary */
	if ( !( as->state & SESSOPEN ))
		auditmap();

	fclose(conF);
	as->state |= SESSOPEN;
	signal( NEWSESS, newsess ); 
}

/*
 *	endsess  terminate the current audit session. Close all 
 *	 	     valid file descriptors and do any cleanup necessary
 */
endsess()
{
aud_sess_info_t *as = &aud_sess;

	if ( as->satfd != -1 )
		close( as->satfd );
	prt( "Audit session terminated\n");
	exit(0);
}

/*
 *	sendfile   report the current audit file and header to the
 *		   auditc utilitity
 */ 
sendfile()
{
aud_sess_info_t *as = &aud_sess;
int fd;
char tmp[PATH_MAX];

	strcpy( tmp, as->path );
	strcat( tmp, as->cname );

	if ((fd = open( SATCOMX, O_WRONLY | O_NDELAY)) < 0 )
		acc_error( "can't open /dev/satcomm\n" );

	if ( write( fd, tmp, strlen( tmp )) < 0 )
		acc_error( "can't write into pipe" );

	signal( GETFILE, sendfile );
}


rdnewfile()
{
	newfile(0);
}
/*
 *	newfile  This will be executed on request from the auditc
 *	            utility.
 */
newfile(rdflg)
uint rdflg;
{
static first;
aud_sess_info_t *as = &aud_sess;
char *p, tmp[PATH_MAX], *strrchr();
int fd, n;

	first = rdflg;
	if ( as->audfd != -1 ) {
		close( as->audfd );
		as->audfd = -1;
	}

	/* JTOF - really kludgy..first open depends on fact that somehting
	 *        may or maynot have been written into the pipe by auditc,
	 *        so we must open for N_DELAY. After the startup, we will
 	 *        always be signalled by auditc, and he will always have
	 *        written something into the pipe
	 */
	if ( first ) {
		if (( fd = open( SATCOMM, O_RDONLY | O_NDELAY)) < 0 )
			acc_error( "can't open /dev/satcomm\n" );
		first = 0;
	}
	else {
		if ((fd = open( SATCOMM, O_RDONLY )) < 0 )	
			acc_error( "can't open /dev/satcomm\n" );
	}

	/* read the pipe - if there is a new pathname, then
         * use it from here on in 
 	 */
	memset( tmp, 0, PATH_MAX );
	if ((n = read( fd, tmp, PATH_MAX )) > 0 ) {
		if ( (p=strrchr(tmp, '/')) && *(p+1)) {
			*p++ = 0;
			strcpy( as->path, tmp );
			strcpy( as->bname, p );
		}
		else {
			if ( *tmp ) {
				*as->path = 0;
				strcpy( as->bname, tmp );
			}
		}
	}
		
	close( fd );

	if ( ! *as->path )
		strcpy( as->path, AUD_PATH );
	else {
		n = strlen(as->path);
		as->path[n-1] = '/';
		as->path[n] = 0;
	}
	if ( ! *as->bname )
		strcpy( as->bname, "sat" );

	/* create an audit file name and bump sess sequence number */
	while (1) {
		sprintf( as->cname, "%s.%d.%d", 
			as->bname, as->sessn+1, ++as->seq );
		strcpy( tmp, as->path );
		strcat( tmp, as->cname );

		/* only break is file doesn't exist */
		if ( access( tmp, 0 ) != 0 )
			break;
	}

	/* open the default audit file */
	if ( (audF = fopen(tmp, "w")) == NULL ) {
		sprintf( as->path, "can't open %s", tmp );
		error( as->path );
	}
	as->audfd = fileno(audF);
	as->maxcnt = 0;
	set_file_slabel( tmp, &label );
	signal( NEWFILE, rdnewfile );
}
	
/*
 *	setamask  set the audit event mask. This allows the admin to 
 *		  custom the events recorded to only those that are
 *		  pertinent. 
 */
setamask( buf )
char *buf;
{
uint mask[2];

	mask[0] = 0;
	mask[1] = 0;
	if ( parsemask( buf, mask ))
		error( "invalid event(s) specified" );
	if (audit_set_mask( mask )) {
		acc_error( "error setting audit mask" );
	}
}



/*
 *	audithwm   set the audit high water mark
 */
audithwm( buf ) 
char *buf;
{
aud_state_t aud_info;
int hwm;

	/* read the initial status */	
	if ( audit_status( &aud_info )) {
		acc_error( "can't read audit information" );
	}
	/* convert and check the high waater mark */
	hwm = atoi( buf );
	if (( hwm < 0 ) || ( hwm > (aud_info.e - aud_info.h))) 
		error( "bad high water mark" );
	/* now set the high water mark */
	if ( audit_setconf( AUDCONF_HWM, &hwm )) {
		acc_error( "bad audit operation" );
	}
}

/*
 *	audittmout  set the amount of time drivers sleeps before
 *		    flushing internal buffers 
 */
audittmout( buf ) 
char *buf;
{
int tmout;

	tmout = atoi( buf );
	if ((tmout < 0 ) || ( tmout > 3600 ))
		error( "bad timeout value" );

	if ( audit_setconf( AUDCONF_HZ, &tmout )) {
		acc_error( "bad audit operation" );
	}
}


/*
 *	parsemask    the mask is passed to the utility as a string in the
 *		     form of comma seperated ranges or values. Examples 
 *		     would be 1-3,5,6,10-20. Note that this parser can't 
 *		     tolerate any spaces !
 */
parsemask( buf, mask )
char *buf;
uint *mask;
{
char *p, *rp, *tmp, *strchr();
uint val1, val2, i;
	
	p = buf;
	while ( p && *p ) {
		tmp = p;
		if ( p = strchr( tmp, ',' )) 
			*p++ = 0;
		else if ( p = strchr( tmp, '\n' ))
			*p++ = 0;

		/* figure out if we have a range */
		if ( rp = strchr( tmp,  '-' )) {
			*rp++ = 0;
			if ( ((val2 = atoi( rp )) < 1) ||
			     (val2 > AUD_MAX_DEF))
				return -1;
			else {
				if ( ((val1 = atoi(tmp)) < 1 ) ||
					val1 > AUD_MAX_DEF )
					return -1;

				for ( i = val1; i <= val2; i++ )
					addmask(mask, i-1 );
			}
		}
		else
		if ( ((val1 = atoi( tmp )) < 1) || ( val1 > AUD_MAX_DEF))
			return -1;
		addmask( mask, val1-1 );
	}
	return 0;
}

/*
 *	acc_error   preprocess error string based on errno 
 */
acc_error( str )
char *str;
{
	error( str );
}

/*
 *	error   print and error message and return 
 */
error( str ) 
char *str;
{
FILE *fp, *fopen();
FILE *fdup();
int rval;
int status;

	signal( GETFILE, SIG_IGN );
	/* we have to open console cause we won't have a controlling 
         * tty to write to at this point 
	 */
	if (!(fp = fopen( CONSOLE, "w" )))
		exit(-10);
	fdup(stdin);
	fdup(stdin);

	fprintf( fp, "Auditd: %s\n", str );
	if ( aud_sess.state & SHUTDOWN ) {
		fprintf( fp, "Auditd: Moving to Root for Shutdown\n" );
		shutdwn();
	}
	fclose( fp );
	if ( aud_sess.state & NOEXIT )
		return;
	wait(&status);
	exit( errno );
}

shutdwn()
{
	int  rval;
	static int  once = 0;

	if ( once++ )
	{
		return 0;
	}
	rval = fork();
	if ( rval == 0 ) {
		close( aud_sess.audfd );
		chdir( "/" );
		rval = system("/etc/shutdown -g0 -y 1>/dev/console 2>&1");
		if ( rval < 0 )
			kill(1, SIGQUIT);	/* causes init 1 */
		exit( 0 );
	}
	if ( rval == -1 )
		kill(1, SIGQUIT);
	return rval;
}

prt(str,a1,a2,a3,a4,a5)
char  *str;
{
FILE *fp, *fopen();
	if (!(fp = fopen( CONSOLE, "w" )))
		exit(-10);
	fprintf( fp, str, a1, a2, a3, a4, a5 );
	fclose( fp );

}

/*
 *
 */
usage()
{
	fprintf( stderr, "usage:  auditd [<exmshz>] [<path>]\n" );
	fprintf( stderr, "        -e enable the audit recording\n" );
	fprintf( stderr, "        -h set high water mark\n" );
	fprintf( stderr, "        -m set the audit mask\n" );
	fprintf( stderr, "        -z set timout frequency\n" );
	fprintf( stderr, "        -s set seperate header name\n" );
	fprintf( stderr, "        -x max size of a single file\n" );
}

FILE *fdup(fp)
register FILE *fp;
{
	register int newfd;
	register char *mode;

/* Dup the file descriptor for the specified stream and then */
/* convert it to a stream pointer with the modes of the original */
/* stream pointer. */
	newfd = dup(fileno(fp));
	if( newfd != -1 ) {

/* Determine the proper mode.  If the old file was _IORW, then */
/* use the "r+" option, if _IOREAD, the "r" option, or if _IOWRT */
/* the "w" option.  Note that since none of these force an lseek */
/* by "fdopen", the dupped file pointer will be at the same spot */
/* as the original. */
		if (fp->_flag & _IORW) mode = "r+";
		else if (fp->_flag & _IOREAD) mode = "r";
		else if (fp->_flag & _IOWRT) mode = "w";

/* Something is wrong, close dupped descriptor and return NULL. */
		else {
			close(newfd);
			return(NULL);
		}

/* Now have fdopen finish the job of establishing a new file pointer. */
		return(fdopen(newfd,mode));
	} else return(NULL);
}

fork_printf(format,arg1,arg2,arg3,arg4)
char *format;
int arg1,arg2,arg3,arg4;
{
	register FILE *fp;

	if ( fork() == 0 )
	{
		if ((fp = fopen("/dev/console","a")) == NULL)
			return;

		fprintf(fp,format,arg1,arg2,arg3,arg4);

		fclose(fp);
		exit(0);
	}
}
