/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) afsmap.c: version 25.2 created on 3/11/92 at 15:57:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)afsmap.c	25.2	3/11/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ino.h>
#include <sys/fs/s5param.h>
#include <sys/fs/s5filsys.h>
#include <sys/fs/s5dir.h>
#include <sys/sysmacros.h>
#include <limits.h>

extern int errno;

static int rtnv;	/* return value when writing to stdout */

struct fsinfo {
	int bsize;
	int nindir;
	int ndirect;
	int inopb;
};

static int	isize = 64;
char  	*directory, *special;

/* afsmap - file system map from raw disk device.
 *
 *	afsmap special-device mountpoint
 *
 *
 *	Currently afsmap only correctly reads System V file systems.
 */
extern FILE  *conF;
extern FILE  *audF;
afsmap(dev, filesys)
char *dev;
char *filesys;
{
	register unchar	a, b, c;
	register ino_t	imax, icnt;

	struct	dinode	*save_dip, *dip;
	struct	direct	*dir;
	struct	fsinfo	fs;
	struct	filsys	sbp;
	struct	stat	sbuf;

	long	*indr1;
	long	*indr2;
	long	*indr3;
	long	naddr, count = 0l;
	int		fd, i, k, j, ftype, major_num, minor_num;
	uint	secure_fs;          

	
	ino_t   assign_fs();
	long	getaddr();
	long	print_dir();
	char	*malloc();

	special = dev;
	directory = filesys;

	fd = open(special, O_RDONLY);
	if (fd < 0)
		error("open failed");

	/* stat device, need major & minor numbers */
	i = fstat(fd, &sbuf);
	if (i != 0 )
		error("stat failed");

	/* skip over boot block */
	(void) lseek(fd, SUPERBOFF, 0);

	/* read in the super block, for max number of inodes */
	i = read(fd, &sbp, sizeof(struct filsys));
	if (i != sizeof(struct filsys) )
		error("read superblock failed");

	/*
	 * Lets check the file system state first thing.  If it's not
	 * in a happy state, no point in going on.
	 */
	if ((sbp.s_state != FsOKAY ) && ( sbp.s_state !=  FsACTIVE))
		error("file system needs checking");

	/*
	 * returns max number of inodes on file system
	 * also returns fsinfo struct filled with appropriate values
	 * depending on the value of s_type
	 */
	
        imax = assign_fs(&sbp, &fs, fd);
	if ( imax == 0 )
		error("unkown file system type");

	/* malloc data structures and exit if any of the mallocs' fail */

	dip = (struct dinode *) malloc(isize*imax);
	if ( dip == (struct dinode *) 0 )
		error("malloc failed");

	dir = (struct direct *) malloc(sizeof(struct direct)*fs.ndirect);
	if ( dir == (struct direct *) 0 )
		error("malloc failed");

	indr1 = (long *) malloc(sizeof(long)*fs.nindir);
	if ( indr1 == (long *) 0 )
		error("malloc failed");

	indr2 = (long *) malloc(sizeof(long)*fs.nindir);
	if ( indr2 == (long *) 0 )
		error("malloc failed");

	indr3 = (long *) malloc(sizeof(long)*fs.nindir);
	if ( indr3 == (long *) 0 )
		error("malloc failed");

	/* seek to start of i-list */
	(void) lseek(fd, (2L*(long)fs.bsize), 0);

	/* read complete i-list */
	i = read(fd, dip, isize*imax);
	if ( i != (isize*imax) )
		error("read i-list failed");

	major_num = major(sbuf.st_rdev);
	minor_num = minor(sbuf.st_rdev);
	secure_fs = (isize == 128);   /*flag to tell us if this is a */
				      /* secure file system or not. */

	rtnv = fprintf(audF, "%s\t%s\t%d,%.3d %d %d\n",
	    directory, special, major_num, minor_num, imax, secure_fs);

	if (rtnv < 0)
		error("write stdout failed");
	else if (rtnv == 0)
		error("write stdout failed");
		
	save_dip=dip; 

	/* loop thru i-list looking for directories */

	/*WARNING --don't change this to dip++, because the isize is variable*/
	for (icnt=1; icnt < imax; ++icnt, dip = (int)dip + isize )
	{
		/* Skip inodes with a link count of zero. */
		if (dip->di_nlink == 0 ) 
			continue;

		ftype = dip->di_mode & S_IFMT;
		if (ftype == S_IFDIR)
		{
			/* this is direct blocks */

			for (k=0; k < 30 ; )
			{
				a = dip->di_addr[k++];
				b = dip->di_addr[k++];
				c = dip->di_addr[k++];
				naddr = getaddr(a, b, c);
				if ( naddr == 0 )
					break;
				(void) lseek(fd, (naddr*(long)fs.bsize), 0);
				(void) read(fd, dir, fs.bsize);
				count += print_dir(&fs, dir, save_dip, fd);
			}
			if ( naddr == 0 ) continue;

			/* this is single indirect block */

			a = dip->di_addr[30];
			b = dip->di_addr[31];
			c = dip->di_addr[32];
			naddr = getaddr(a, b, c);
			if ( naddr == 0 )
				continue;
			(void) lseek(fd, (naddr*(long)fs.bsize), 0);
			(void) read(fd, indr1, fs.bsize);
			for (i=0; i < fs.nindir; )
			{
				naddr = indr1[i++];
				if ( naddr == 0 ) break;
				(void) lseek(fd, (naddr*(long)fs.bsize), 0);
				(void) read(fd, dir, fs.bsize);
				count += print_dir(&fs, dir, save_dip,fd );
			}
			a = dip->di_addr[33];
			b = dip->di_addr[34];
			c = dip->di_addr[35];
			naddr = getaddr(a, b, c);
			if ( naddr == 0 ) continue;

			/* do double indirect block handling */

			(void) lseek(fd, (naddr*(long)fs.bsize), 0);
			(void) read(fd, indr1, fs.bsize);
			for (i=0; i < fs.nindir; )
			{
				naddr = indr1[i++];
				if ( naddr == 0 ) break;
				(void) lseek(fd, (naddr*(long)fs.bsize), 0);
				(void) read(fd, indr2, fs.bsize);
				for (k=0; k < fs.nindir; )
				{
					naddr = indr2[k++];
					if ( naddr == 0 ) break;
					(void) lseek(fd, (naddr*(long)fs.bsize), 0);
					(void) read(fd, dir, fs.bsize);
					count += print_dir(&fs, dir, save_dip, fd);
				}
			}
			a = dip->di_addr[36];
			b = dip->di_addr[37];
			c = dip->di_addr[38];
			naddr = getaddr(a, b, c);
			if ( naddr == 0 ) continue;

			/* do triple indirect block handling */

			(void) lseek(fd, (naddr*(long)fs.bsize), 0);
			(void) read(fd, indr1, fs.bsize);
			for (i=0; i < fs.nindir; )
			{
				naddr = indr1[i++];
				if ( naddr == 0 ) break;
				(void) lseek(fd, (naddr*(long)fs.bsize), 0);
				(void) read(fd, indr2, fs.bsize);
				for (k=0; k < fs.nindir; )
				{
					naddr = indr2[k++];
					if ( naddr == 0 ) break;
					(void) lseek(fd, (naddr*(long)fs.bsize), 0);
					(void) read(fd, indr3, fs.bsize);
					for (j=0; j < fs.nindir; )
					{
						naddr = indr3[j++];
						if ( naddr == 0 ) break;
						(void) lseek(fd, (naddr*(long)fs.bsize), 0);
						(void) read(fd, dir, fs.bsize);
						count += print_dir(&fs, dir, save_dip, fd);
					}
				}
			}
		}
	}
	(void) close(fd);
	(void) fprintf(conF, " %ld files\n", count);

	free(dip);                   /*free up all the junk we used*/
	free(dir);
	free(indr1);
	free(indr2);
	free(indr3);

	return(0);
}

/* getaddr - generate block addresses from three characters
 *	getaddr take 3 characters and shifts left the appropriate
 *	amounts to get the address.  System V disk inodes stores
 *	address in character arrays.  This function is provided
 *	for portablity reasons, other file systems may require
 *	a more elaborate algorithm.
 */
long 
getaddr(a1, a2, a3)
unchar  a1, a2, a3;
{
	return ((a1<<16) + (a2<<8) + a3);
}

/* print_dir - prints on stdout inode number and file name
 *	print_dir loops thru an array of directory entries
 *	and prints the inode number and the file name until
 *	there is a null entry in the directory or the count
 *	shows no further entries are to be found. If the file
 *  is a symbolic link, print_dir will print the name of the
 *  target file also.
 */
long
print_dir(fs, dir, di, fd)
struct fsinfo *fs;
struct direct *dir;
struct dinode *di;
int fd;
{
	register int i = -1;
	long cnt = 0;
	static ino_t pino;
	ino_t myino;
	long	naddr, getaddr();
	uint	target_len;			/*length of symlink target file*/
	char	target[PATH_MAX];	/*buffer for symlink name */

	while ( (++i < fs->ndirect) && (strcmp(dir[i].d_name, "") != 0) )
	{
		if ( strcmp(dir[i].d_name, ".") == 0 )
		{
			pino=dir[i].d_ino;
			continue;
		}
		if ( (strcmp(dir[i].d_name, "..") == 0) || (dir[i].d_ino == 0) )
			continue;

		myino = dir[i].d_ino - 1;


		if ( ( di[myino].di_mode & S_IFMT) != S_IFLNK ){
			target_len = 0;
			target[0] = '\0';
		} else {                  /*it is a symlink, so read the target*/ 
			target_len = di[myino].di_size;
			naddr = getaddr(di[myino].di_addr[0],
                            di[myino].di_addr[1],
                            di[myino].di_addr[2]);
			(void) lseek(fd, (naddr*(long)fs->bsize), 0);
			(void) read(fd, target, target_len);
		}
			

		fwriteE(&dir[i].d_ino,sizeof(dir[i].d_ino),1,audF);
		fwriteE(&pino,sizeof(pino),1,audF);
		fwriteE(&di[myino].di_priv,sizeof(di[myino].di_priv),1,audF);
		fwriteE(&di[myino].di_label,sizeof(di[myino].di_label),1,audF);
		fwriteE(dir[i].d_name,NAME_MAX,1,audF);
		fwriteE(&target_len,sizeof(uint),1,audF);
		fwriteE(target,target_len,1,audF);
		++cnt;


	}
	return (cnt);
}




/* assign_fs - assign block size, and other file system dependent values
 *	Assign_fs looks at the type field in the superblock and assigns
 *	block size accordingly.
 *	If the type field is not 1, 2, 3, 4, 6, or 7 the function return 0.
 *
 *	Arguments are:
 *			sp - filesytem structure.
 *			fs - filesystem info structure.
 *			fd - file descriptor for dfs_type().
 *				(open file descriptor for special device).
 *
 *	assign_fs returns the total number of inodes on the file system if
 *	it could determine the block size.
 */
ino_t 
assign_fs(sp, fs, fd)
struct filsys *sp;
struct fsinfo *fs;
int fd;
{

	switch (sp->s_type)
	{
	case  1: /* 512 byte physical block size */
		fs->bsize = 512;
		break;

	case  2: /* 1k byte physical block size */
		fs->bsize = 1024;
		break;

	case  3: /* 2048 byte phsyical block size */
		fs->bsize = 2048;
		break;

	case  4: /* 4096 byte phsyical block size */
		fs->bsize = 4096;
		break;

	case  6: /* 1k byte physical block size - inode size 128 */
		fs->bsize = 1024;
		isize = 128;
		break;

	case  7: /* 4k byte physical block size - inode size 128 */
		fs->bsize = 4096;
		isize = 128;
		break;

	default: /* UNKNOWN FILESYSTEM TYPE */
		fs->bsize = 0;
	}
	if (fs->bsize != 0)
	{
                fs->nindir = fs->bsize/sizeof(daddr_t);
                fs->ndirect = fs->bsize/sizeof(struct direct);
                fs->inopb = fs->bsize/isize;
                return ((ino_t)((sp->s_isize - (ushort)(SUPERB + 1))*(ushort)fs->inopb));
	}
	else
		return (0);
}


/*
 *  fwriteE - do an fwrite and check the return value for an error.
 */
fwriteE(buffer,item_size,count,stream) 
char	*buffer;
int 	item_size,count;
FILE 	*stream;
{
	if (item_size)
		if (fwrite(buffer,item_size,count,stream) != count)
			error("fwrite audF failed");
	
}

