/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) auditc.c: version 25.1 created on 12/2/91 at 17:15:58	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)auditc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	auditc   security audit control command. This command allows
 *		 a user to specify a new audit mask, enable or disable
 *		 an audit session, kill the current audit session, or
 *		 signal the deamon to start recording on a new file
 *	(C)Copright 1990 by ARIX Corp.
 *
 */


#ident	"@(#)auditc: security audit control program 2.0"

#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/synch.h>
#include <sys/signal.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/audit.h>

#include <errno.h>
#include <stdio.h>
#include <limits.h>
#include <sys/param.h>
#include <unistd.h>
#include <time.h>

#define addmask(m,a)	(((a)<32) ? (m[0]|=(1<<(a))) : (m[1]|=(1<<((a)-32))))

/* Definitions of Audit Events for Event Printouts
 */
char *EventName[] = {
	"Process Fork",
	"Process Exec",
	"Process Exit",
	"Set Process UID",
	"Set Process GID",
	"Set Process SID",
	"Set Process Group List",
	"Set Process Default Role",
	"Set Process Privilege",
	"Set Process Labels",
	"Set Process Root Directory",
	"Set Process Controlling Terminal",
	"Send Signal to a Process",
	"Successfull File Read",
	"Successfull File Write",
	"Unsuccessfull File Read",
	"Unsuccessfull File Write",
	"Create a Special Node",
	"Create a Pipe",
	"Create a New File",
	"Create a Link to a File",
	"Rename a File",
	"Remove a File",
	"Change the Mode bits on a File",
	"Change the Owner of a File",
	"Change the Group of a File",
	"Change the Effective Privilege of a File",
	"Change the Label of a File",
	"Change or Update the ACL of a File",
	"Mount a Filesystem",
	"Umount a Filesystem",
	"System Call Error",
	"Change System Clock",
	"Create an IPC Object",
	"IPC Access",
	"Remove and IPC Object",
	"Label and IPC Object",
	"Change a IPC's Mode bits",
	"Change a IPC's ACL",
	"Login/Su Audit Information",
	"Audit Specific Information",
	"Account Database Canges",
	"Device Database Changes",
	"Line Printer Audit Information",
	"Cron Audit Information",
	"UUCP Audit Information",
	"User Level General Audit Information",
	"TCP/IP Audit Information",
	"NFS Audit Information",
	"RFS Audit Inforamtion",
	"Create a Symbolic Link",
	"",
	"",
	""
	};
	
extern int  optind;
extern char *optarg;

main( argc, argv )
char **argv;
{
int c;
char all[10] ;


	if (!priv( P_SEC, getuid())) 
		error( "permission denied\n" );

	/* get the options from the user */
	while ((c = getopt( argc, argv, "lbam:f:c:edst?" )) != -1 ) {
		switch(c) {
			case 'a':
				auditstatus();
				break;
			case 'l':
				auditstatus();
				eventstatus(strcpy(&all,"1-51") );
				break;
			case 'c':
				eventstatus( optarg );
				break;
			case 'm':
				setamask( optarg );
				break; 
			case 'e':
				audit_start();
				break; 
			case 'd':
				audit_stop();
				break; 
			case 's':
				startsess( optarg );
				break; 
			case 't':
				stopaudit();
				break;  
			case 'b':
				changefile( (char *) 0 );
				break;
			case 'f':
				changefile( optarg );
				break; 
			case '?':
				usage();
				return;
			default:
				error( "bad or unknown option(s)" );
			}
	}
}

/*
 *	auditstatus   Return the overall status of the audit trail
 */
auditstatus()
{
aud_state_t aud_info;
char buf[512];
char audname[PATH_MAX];

	*audname = 0;
	if ( audit_status( &aud_info )) {
		acc_error( "can't read audit information" );
	}
	printf( "%-40s%d\n", "SAT Version:", aud_info.version );
	printf( "%-40s", "SAT Boot Time: " );
	showtime( aud_info.boot_time );

	/* are we currently enabed or disabled */
	printf( "%-40s", "Current Audit State: ");
	( aud_info.state & SAT_ENABLE ) ? 
		printf( "ENABLED\n" ) : printf( "DISABLED\n" );

	/* if deamon is running Report it */
	printf( "%-40s", "Deamon Process ID: " );
	if ( aud_info.pid != 0 ) {
		printf( "%d\n", aud_info.pid );
		if (getcfile( audname )) {
			printf( "%-40s%s\n", "Current Audit Transaction File:", 
				audname );
		}	
	}
	else
		printf( "NO DEAMON\n" );


	/* show time session was started if one exists */ 	
	printf( "%-40s", "Current Session Start Time: " );
	showtime( aud_info.start_time );
	printf( "%-40s", "Last Session Termination Time: " );
	showtime( aud_info.end_time );
	printf( "%-40s", "Last SAD Open Request: " );
	showtime( aud_info.open_time );
	printf( "%-40s", "Last SAD Close: ");
	showtime( aud_info.close_time );
	printf( "%-40s%d\n", "Records written since boot:", aud_info.tot_recs );
	printf( "%-40s%d\n", "Records written since last start:", 
			aud_info.cur_recs );
	printf( "%-40s%d\n", "Records currently in IAB:", aud_info.buf_recs );
	printf( "%-40s%d\n", "Size in Bytes of IAB:", aud_info.e - aud_info.h );	
	printf( "%-40s%d\n", "Bytes Available in IAB:", aud_info.bcnt );
	printf( "%-40s%d\n", "IAB High Water Mark (Bytes):", aud_info.hwm );
	printf( "%-40s%d\n", "IAB Flush frequency (ms):",
	  aud_info.callout * 1000 / HZ );
}


/*
 *	eventstatus   Return the current status of an event 
 */
eventstatus( buf )
char *buf;
{
evt_state_t evt;
int i;
uint mask[2];

	mask[0] = 0;
	mask[1] = 0;
	if ( parsemask( buf, mask ))
		error( "invalid event(s) specified" );
	for ( i=0; i < 64; i++ ) {
		if ( ((i<32) ? (mask[0] & (1<<i)) : (mask[1] & (1<<(i-32))))) {
			if ( audit_event_status( i, &evt ))
				acc_error( "can't read event status info" );
			printf( "\n%-4d%-40s\n", i + 1, EventName[i] );
			printf( "%-40s", "Event Status:" );
			if ( evt.state )
				printf( "ENABLED\n" );
			else
				printf( "DISABLED\n" );
			printf( "%-40s",  "Time Event Enabled/Disabled:" );
			showtime( evt.edtime );
			printf( "%-40s%d\n", "Records written since boot:", 
				evt.tot_recs );
			printf( "%-40s%d\n","Records written since enabled:",
				evt.cur_recs ); 
		}
	}
}

/*
 *	setamask  set the audit event mask. This allows the admin to 
 *		  custom the events recorded to only those that are
 *		  pertinent. 
 */
setamask( buf )
char *buf;
{
aud_state_t aud_info;
uint mask[2];

	mask[0] = 0;
	mask[1] = 0;

	if ( parsemask( buf, mask ))
		error( "invalid event(s) specified" );
	
	/* clear the mask */
	if (( mask[0] == 0 ) && ( mask[1] == 0 )) {
		audit_set_mask( mask );
		return;
	}

	if ( mask[0] && mask[1] ) {
		if ( audit_status( &aud_info )) 
			acc_error( "can't read audit information" );

		mask[0] |= aud_info.mask[0];
		mask[1] |= aud_info.mask[1];
	}

	if ( audit_set_mask( mask )) 
		acc_error( "error setting audit mask" );
}


/*
 *	startses    this command starts the audit trail session. It can
 *		    be used to restart the audit session as well, without
 *		    an intervening stop. Fname is the default pathname to
 *		    begin the session under.
 */
startsess(sesname)
char *sesname;
{
aud_state_t aud_info;
int status, fd;


	if ( audit_status( &aud_info ))
		acc_error( "can't read audit information" );

	if ( aud_info.pid == 0 ) {
		if (fork())  {
			if ( execl( "/etc/auditd", "auditd", (char *) 0 ) < 0 )
				acc_error( "can't start audit deamon" );
		}
		else
			wait( &status );
	}

	if ((aud_info.pid != 0 ) && ((sesname && *sesname)))
		sendmesg(NEWFILE, aud_info.pid, sesname );
}


/*
 *	stopaudit  stop the audit trail. This is a complete session stop,
 * 		   and requires a complete session restart 
 */
stopaudit()
{
aud_state_t aud_info;

	if ( audit_status( &aud_info ))
		acc_error( "can't read audit information" );
	/* disable the audit trail */
	audit_stop();
	if ( aud_info.pid != 0 ) 
		if ( kill( aud_info.pid, KILLSESS ) < 0 )
			acc_error( "can't send signal to deamon\n" );
}

/*
 *	changefile  force the current audit trail to be changed. The 
 *		    session id is retained. The file may be automatically
 *		    bumped via a sequence number or a new filename can be
 *		    passed.
 */
changefile( fname )
char *fname;
{
aud_state_t aud_info;
int status, fd;
int n;


	if ( audit_status( &aud_info ))
		acc_error( "can't read audit information" );
	
	/* if we just want to bump the file */
	if (( aud_info.pid != 0 ) && ( fname == NULL )) {
		sendmesg( NEWFILE, aud_info.pid, "" );
		return;
	}

	/* if we want to change the path */
	if ( aud_info.pid != 0 ) 
		sendmesg( NEWFILE, aud_info.pid, fname );
}

/*
 *	getcfile	ask the audit deamon the name of the current
 *		        audit file and hdr file
 */
getcfile( audname )
char  *audname;
{
int fd;
aud_state_t aud_info;

	if ( audit_status( & aud_info ) )
		acc_error( "can't read audit information" );

	if ( aud_info.pid != 0 )
		return getmesg(GETFILE, aud_info.pid, audname );

	return 0;
} 

/*
 * 	showtime  print out statistics on the times 
 */
showtime( time )
{
struct tm *tim, *localtime();
char *asctime();

	tim = localtime( &time );	
	if ( time == 0 )
		printf( "NEVER\n" );
	else
		printf( "%s", asctime( tim ));
}


/*
 *	parsemask    the mask is passed to the utility as a string in the
 *		     form of comma seperated ranges or values. Examples 
 *		     would be 1-3,5,6,10-20. Note that this parser can't 
 *		     tolerate any spaces !
 */
parsemask( buf, mask )
char *buf;
uint *mask;
{
char *p, *rp, *tmp, *strchr();
uint val1, val2, i;
	
	p = buf;
	if ( *p == '0' ) {
		mask[0] = mask[1] = 0;
		return 0;
	}
	while ( p && *p ) {
		tmp = p;
		if ( p = strchr( tmp, ',' )) 
			*p++ = 0;
		else if ( p = strchr( tmp, '\n' ))
			*p++ = 0;

		/* figure out if we have a range */
		if ( rp = strchr( tmp,  '-' )) {
			*rp++ = 0;
			if ( ((val2 = atoi( rp )) < 1) ||
			     (val2 > AUD_MAX_DEF))
				return -1;
			else {
				if ( ((val1 = atoi(tmp)) < 1 ) ||
					val1 > AUD_MAX_DEF )
					return -1;

				for ( i = val1; i <= val2; i++ ) {
					addmask(mask, i-1);
				}
			}
		}
		else {
			if ( ((val1 = atoi( tmp )) < 1) ||
				 ( val1 > AUD_MAX_DEF))
				return -1;
			addmask( mask, val1-1 );
		}
	}
	return 0;
}

/*
 *
 */
acc_error( str )
char *str;
{
	if ( errno == EPERM )
		error( "permission denied" );
	else if ( errno == EINVAL )
		error( "invalid arguments" );
	else if ( errno == EACCES )
		error( "invalid access attempt" );
	else
		error( str );
}

/*
 *	error   print and error message and return 
 */
error( str ) 
char *str;
{
	fprintf( stderr, "%s\n", str );
	exit( errno );
}

/*
 *	sendmesg   send a message down the pipe and signal the process
 *		   to look at it.
 */
sendmesg( sig, pid, mesg )
int pid, sig;
char *mesg;
{
int fd;

	if ( kill( pid, sig ) < 0 )
		acc_error( "can't send signal to deamon\n" );

	if ( (fd = open( SATCOMM, O_WRONLY )) < 0 )
		acc_error( "can't open /dev/satcomm\n" );

	if ( mesg && *mesg )
		write( fd, mesg, strlen(mesg) );
	close(fd);
}	

/*
 *	getmesg   get a message from the comx pipe 
 */
getmesg( sig, pid, buf )
int sig, pid;
char *buf;
{
int fd, n, i;

	if ( (fd = open( SATCOMX, O_RDONLY | O_NDELAY )) < 0 )
		acc_error( "can't open deamon comx pipe" );
	kill( pid, GETFILE );
	while ( (n = read( fd, buf, PATH_MAX)) <= 0) {
		if ( i++ < 30 )
			break;
		sleep(1);
	}
}

/*
 *
 */
usage()
{
	fprintf( stderr, "usage:  auditc [<hzacmedstfb>] [<mask|filename>]\n" );
	fprintf( stderr, "        -e enable the audit session\n" );
	fprintf( stderr, "        -d disable the audit session\n" );
	fprintf( stderr, "        -f change currnet audit file to xxx\n" );
	fprintf( stderr, "        -b bump to next audit file in sequence\n" );
	fprintf( stderr, "        -s start new audit session\n" );
	fprintf( stderr, "        -t terminate current audit session\n" );
	fprintf( stderr, "        -a display audit trail status\n" );
	fprintf( stderr, "        -l display audit trail status\n" );
	fprintf( stderr, "        -c display events status\n" );
	fprintf( stderr, "        -m change the audit mask\n" );
}



