/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) addgrp.c: version 25.2 created on 2/26/92 at 18:49:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)addgrp.c	25.2	2/26/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <grp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <auth.h>

#if !defined(TRUE)
#define 	TRUE	1	
#endif

#if !defined(FALSE)
#define 	FALSE	0
#endif

#define GROUP_PASSWD_STRING	"*"	/* The default group password */
#define GROUP_INITIAL_VALUE	99	/* The gid to start searching at */

int group_flag = FALSE;
int new_group_id;

int shadow_is_there = FALSE;

main(argc, argv)
int argc;
char *argv[];
{

	char *group_name;
	char **name_list;
	char *name;
	int name_index;
	int copy_index;
	int group_exists = FALSE;
	int result;
	int c;
	struct group *group_entry;
	struct stat stat_buffer;
	extern char *optarg;
	extern int optind;

	if (!priv(P_SEC, getuid())) {
		fprintf(stderr, "addgrp: You do not have enough privledge to run this command\n");
		return(1);
	}

	if (access(SGRPFLE, 06) >= 0)
		shadow_is_there = TRUE;

	while ((c = getopt(argc, argv, "g:")) != EOF)
		switch(c) {
			case 'g':	group_flag = TRUE;
					new_group_id = atoi(optarg);
/* FIX THIS --plaease do some checking on the value in new_group_id
*/
					if ((group_entry = getgrgid(new_group_id)) != NULL) {
						fprintf(stderr, "addgrp: group %s (id = %d), already exists, you must delete it first\n", group_entry->gr_name, new_group_id);
						return(1);
					}
					break;
			case '?':
			default:
					usage();
					break;
		}

	/* If we have no args then do a usage */
	if (argc <= optind)
		usage();
		/* NOT REACHED */

	group_name = argv[optind++];	/* Next comes the group name */
	name_list = &(argv[optind]);	/* Next a list of member names */

	if ((group_entry = getgrnam(group_name)) != (struct group *)NULL) {
		group_exists = TRUE;
		if (*name_list == NULL) {
			/* user was trying to just add a group, but its already
			 * there.
			 */
			fprintf(stderr, "addgrp: group %s already exists\n",
								group_name);
			return(1);
		}
	}

	/* Make sure our names are valid, remove any that aren't */
	check_names(name_list);	

	if (group_exists == TRUE) {
		if (*name_list == NULL) {
			/* If check_names removed ALL our names */
			fprintf(stderr,
				"addgrp: No valid members left to add\n");
			return(1);
		}
		else
			result = add_group_members(group_entry, name_list);
	}
	else
		result = add_new_group(group_name, name_list);

	return(result);
}

add_group_members(group_entry, name_list)
struct group *group_entry;
char *name_list[];
{
	char **combined_list;
	char **group_index, **name_index, **combined_index;
	char new_name[BUFSIZ], new_passwd[BUFSIZ];
	char *new_member_buffer, *next_pointer;
	int size_of_old, size_of_new;
	int size_of_member_list;
	int result;
	struct group new_entry;
	extern char *malloc();

	char new_auth_passwd[BUFSIZ];
	struct grpauth	new_auth_entry;
	struct grpauth	*group_auth_entry;
	extern struct grpauth *getganam();

	/* Save the current set of members */
	size_of_member_list = full_list_size(group_entry->gr_mem);
	if ((new_member_buffer = malloc(size_of_member_list + 1)) == NULL) {
		fprintf(stderr, "addgrp: ran out of memory\n");
		return(1);
	}

	next_pointer = new_member_buffer; 
	for (group_index = group_entry->gr_mem; *group_index != NULL; 
								group_index++) {
		strcpy(next_pointer, *group_index);
		*group_index = next_pointer;
		next_pointer += (strlen(*group_index) + 1);
	}
		
	size_of_old = list_size(group_entry->gr_mem);
	size_of_new = list_size(name_list);

	/* Make a space to combine the names */
	if ((combined_list = 
		(char **)malloc(sizeof(char *)*(size_of_old + size_of_new + 1)))
								== NULL) {
		fprintf(stderr, "addgrp: ran out of memory\n");
		return(1);
	}
	/* Copy the current member list into the combined list */
	combined_index = combined_list;
	for (group_index = group_entry->gr_mem; *group_index != NULL;
								group_index++)
		*combined_index++ = *group_index;

	/* Copy the new members into the combined list */
	for (name_index = name_list; *name_index != NULL; name_index++)
		*combined_index++ = *name_index;
	*combined_index = NULL;

	/* make a new copy of the group struct because the current entry points
	 * to static memory in getgrent(). Since update_group_file() uses
	 * getgrent() to parse the file, it will over write our entry unless
	 * we save it some where.
	 */
	strcpy(new_name, group_entry->gr_name);
	strcpy(new_passwd, group_entry->gr_passwd);
	new_entry.gr_name = new_name;
	new_entry.gr_passwd = new_passwd;
	new_entry.gr_gid = group_entry->gr_gid;
	new_entry.gr_mem = combined_list;
	if (shadow_is_there) {
		if ((group_auth_entry = getganam(new_name)) == NULL) {
			fprintf(stderr, "addgrp: can't access the %s file\n",
								SGRPFLE);
			return(1);
		}

		new_auth_entry.ga_name = new_name;
		strcpy(new_auth_passwd, group_auth_entry->ga_passwd);
		new_auth_entry.ga_passwd = new_auth_passwd;
		new_auth_entry.ga_gid = group_auth_entry->ga_gid;
		new_auth_entry.ga_mem = combined_list;
		new_auth_entry.ga_acctstat = group_auth_entry->ga_acctstat;
	}

	result = update_group_file(&new_entry);

	if (result == 0 && shadow_is_there)
		result = updategaent(&new_auth_entry);

	return(result);
}

add_new_group(group_name, name_list)
char *group_name;
char **name_list;
{
	FILE *group_file;
	struct group group_entry;

	struct grpauth	group_auth_entry;
	FILE *group_auth_file;

	group_entry.gr_name = group_name;
	group_entry.gr_passwd = GROUP_PASSWD_STRING;
	group_entry.gr_gid = find_new_gid();
	group_entry.gr_mem = name_list;

	if (shadow_is_there) {
		group_auth_entry.ga_name = group_name;
		group_auth_entry.ga_passwd = GROUP_PASSWD_STRING;
		group_auth_entry.ga_gid = group_entry.gr_gid;
		group_auth_entry.ga_mem = name_list;
		group_auth_entry.ga_acctstat = NOLOCK;
	}

	if ((group_file = fopen(GRPFLE, "a+")) == NULL) {
		fprintf(stderr, "addgrp: can't open or access %s\n", GRPFLE);
		return(1);
	}

	if (shadow_is_there) {
		if ((group_auth_file = fopen(SGRPFLE, "a+")) == NULL) {
			fclose(group_file);
			fprintf(stderr, "addgrp: can't open or access %s\n", SGRPFLE);
			return(1);
		}
	}

	/* This will add the entry at the bottom of the file */
	if (putgrent(&group_entry, group_file) < 0) {
		perror("addgrp");
		return(1);
	}
	fclose(group_file);

	if (shadow_is_there) {
		if (putgaent(group_auth_file, &group_auth_entry) < 0) {
			perror("addgrp");
			return(1);
		}
		fclose(group_auth_file);
	}
	
	return(0);
}

update_group_file(new_entry)
struct group *new_entry;
{
	FILE *temp_file;
	struct group *group_entry;
	int found_entry = FALSE;

	/* Create and Open the temp file */
	if ((temp_file = fopen(GRPTMP, "w")) == NULL) {
		fprintf(stderr, "addgrp: can't open or access %s\n", GRPTMP);
		return(1);
	}

	/* read the real group file writing the entries to the temp file
	 * until we find our entry, then write our entry.
	 */
	setgrent();
	while ((group_entry = getgrent()) != NULL) {
		if (strcmp(group_entry->gr_name, new_entry->gr_name) == 0) {
			putgrent(new_entry, temp_file);
			found_entry = TRUE;
		}
		else
			putgrent(group_entry, temp_file);
	}
	endgrent();
	fclose(temp_file);

	/* If we didn't find it then the file has changed since we did our
	 * getgrnam() call in main(). Can't really do anything about that.
	 */
	if (found_entry == FALSE) {
		fprintf(stderr, "addgrp: group %s disappeared before I got a chance to update it\n", new_entry->gr_name);
		unlink(GRPTMP);
		return(1);
	}

	/* Replace the current group file with the temp version */
	if (rename(GRPFLE, OGRPFLE) < 0) {
		perror("addgrp");
		unlink(GRPTMP);
		return(1);
	}

	if (rename(GRPTMP, GRPFLE) < 0) {
		perror("addgrp");
		return(1);
	}
	return(0);
}

/* How many entries in a list, don't count the NULL */
list_size(list)
char **list;
{
	int size_of_list;

	for(size_of_list = 0; *list != NULL; list++, size_of_list++);

	return(size_of_list);
}

/* Total size of all entries in the list */
full_list_size(list)
char **list;
{
	int full_size_of_list;

	for(full_size_of_list = 0; *list != NULL; list++)
		full_size_of_list += strlen(*list) + 1;

	return(full_size_of_list);
}

/* Return the largest group ID + 1 */
find_new_gid()
{
	struct group *group_entry;
	int maximum_group_id = GROUP_INITIAL_VALUE;

	if (group_flag)
		return(new_group_id);

	setgrent();

	while ((group_entry = getgrent()) != NULL)
		if ((int)group_entry->gr_gid > (int)maximum_group_id)
			maximum_group_id = group_entry->gr_gid;
	endgrent();
	
	return(maximum_group_id + 1);
}

/* Check a list of login names. Remove any that aren't valid. */
check_names(name_list)
char *name_list[];
{
	char *name;
	int name_index;
	struct passwd *name_entry;
	extern struct passwd *getpwnam();
	
	/* Go down the names and check each one */
	for (name_index = 0; name_list[name_index] != NULL; name_index++) {
		name = name_list[name_index];
		if ((name_entry = getpwnam(name)) == NULL) {
			fprintf(stderr, "addgrp: invalid member name %s, skipped\n", name);
			skip_name(name_list, name_index);
			name_index--;
		}
	}
}

/* Copy all the entries below name_index up one, effectively removing
 * the entry in name_index.
 */
skip_name(name_list, name_index)
char *name_list[];
int name_index;
{
	int copy_index;

	for (copy_index = name_index + 1; name_list[copy_index] != NULL;
						copy_index++, name_index++)
		name_list[name_index] = name_list[copy_index];
	name_list[name_index] = NULL;
}

usage()
{
	fprintf(stderr, "usage: addgrp -g new_gid groupname [ members ]\n");
	exit(1);
}
