#	START NEW ARIX SCCS HEADER
#
#	@(#) mach.mk: version 25.1 created on 12/2/91 at 17:15:23
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mach.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#

#ident	"@(#)sdb/mach:mach.mk	25.1"

#		Copyright (c) 1985 AT&T		#
#		All Rights Reserved		#
#	OLD MOT:makefile	6.8	
include $(IROOT)/macdefs

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

#FPS=M68881
FPS=NOFPU

PROCESSOR=M68020

#LOCAL_CFLAGS=	-Xstrwrite -DDEBUG
#LOCAL_CFLAGS=	-Xstrwrite -DDEBUG=2
LOCAL_CFLAGS =	-Xstrwrite

DEFINES= -Dm68k -DFLEXNAMES -I$(INCSRC)/inc -I$(INCSRC)/inc/common \
	 -D$(PROCESSOR) -DSDB -D$(FPS) -DDEBUG=4

UBIN = $(ROOT)/usr/bin
TESTDIR = ..
INSDIR =
INCSRC = $(SROOT)/cmd/sgs
DISDIR = $(INCSRC)/dis/mach
DISDIRP = $(DISDIR)/$(FAMILY)
DISINC = -I$(DISDIR) -I$(DISDIRP) -I$(INCSRC)/inc -I$(INCSRC)/common

DIS.H=	$(DISDIR)/dis.h	$(DISDIRP)/names.h
DIS.C=	$(DISDIRP)/text_dis.c	$(DISDIRP)/names.c	$(DISDIRP)/881_gen.c \
	$(DISDIRP)/cp_gen.c	$(DISDIRP)/extended.c	dis_utils.c

DIS.O=	text_dis.o names.o 881_gen.o cp_gen.o extended.o dis_utils.o

OBJS=	main.o re.o fio.o bio.o decode.o docomm.o sub.o  \
	access.o pcs.o runpcs.o setup.o message.o \
	symt.o display.o prvar.o xeq.o version.o \
	opset.o optab.o machdep.o udef.o \
	debug.o

COM= ../com
SOURCE=	$(COM)/main.c $(COM)/re.c $(COM)/fio.c $(COM)/bio.c $(COM)/decode.c  \
	$(COM)/docomm.c $(COM)/sub.c $(COM)/access.c $(COM)/pcs.c  \
	$(COM)/runpcs.c $(COM)/setup.c $(COM)/message.c  \
	$(COM)/symt.c $(COM)/display.c $(COM)/prvar.c $(COM)/xeq.c  \
	$(COM)/version.c $(COM)/opset.c $(COM)/optab.c  \
	$(COM)/machdep.c $(COM)/udef.c $(COM)/debug.c 

CSOURCE= $(COM)/machdep.h $(COM)/access.c $(COM)/machdep.c $(COM)/opset.c \
	$(COM)/optab.c $(COM)/runpcs.c $(COM)/setup.c $(COM)/xeq.c

compile all: $(TESTDIR)/sdb

$(TESTDIR)/sdb:	$(OBJS) $(DIS.O)
	$(CC) $(DEFINES) -o $(TESTDIR)/sdb $(OBJS) $(DIS.O) $(LIBFLAGS) $(LDFLAGS) $(CFLAGS)


COFF.H= $(COM)/coff.h $(INCSRC)/inc/mach/sgs.h 
MACHDEP.H= $(COM)/machdep.h 
MODE.H= $(COM)/mode.h
HEAD.H= $(COM)/head.h $(COM)/bio.h $(MODE.H) $(MACHDEP.H) 


decode.o:	$(HEAD.H) $(COM)/decode.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/decode.c

docomm.o:	$(HEAD.H) $(COFF.H) $(COM)/docomm.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/docomm.c

main.o:		$(HEAD.H) $(COM)/main.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/main.c

sub.o:		$(HEAD.H) $(COFF.H) $(COM)/sub.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/sub.c

re.o:		$(HEAD.H) $(COM)/re.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/re.c

fio.o:		$(HEAD.H) $(COM)/fio.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/fio.c

bio.o:		$(COM)/bio.h $(COM)/bio.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/bio.c

access.o:	$(HEAD.H) $(COM)/access.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/access.c

pcs.o:		$(HEAD.H) $(COM)/pcs.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/pcs.c

runpcs.o:	$(HEAD.H) $(COM)/runpcs.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/runpcs.c

xeq.o:		$(HEAD.H) $(COFF.H) $(COM)/xeq.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/xeq.c

setup.o:	$(HEAD.H) $(COFF.H) $(COM)/setup.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/setup.c

message.o:	$(MODE.H) $(COM)/message.c
		$(CC) $(DEFINES) $(CFLAGS) -Xnostrwrite -c $(COM)/message.c

symt.o:		$(HEAD.H) $(COFF.H) $(COM)/symt.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/symt.c

display.o:	$(HEAD.H) $(COFF.H)  $(COM)/display.c
		$(CC) -g $(DEFINES) -c $(CFLAGS) $(COM)/display.c

prvar.o:	$(HEAD.H) $(COFF.H) $(COM)/prvar.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/prvar.c

version.o:	$(COM)/version.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/version.c

opset.o:	$(HEAD.H) $(COM)/opset.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/opset.c

optab.o:	$(MODE.H) $(MACHDEP.H)  $(COM)/optab.c
		$(CC) $(DEFINES) $(CFLAGS) -Xnostrwrite -c $(COM)/optab.c

machdep.o:	$(HEAD.H) $(COFF.H) $(COM)/machdep.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/machdep.c

udef.o:		$(HEAD.H) $(COFF.H) $(COM)/udef.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/udef.c

#
#			Build files for disassembler.
#			source is from the utility 'dis'.
#
disobjs:	$(DIS.O) $(DIS.H)
text_dis.o: $(DISDIRP)/text_dis.c $(DIS.H)
	$(CC) $(DISINC) $(DEFINES) -c $(CFLAGS) $(DISDIRP)/text_dis.c

names.o: $(DISDIRP)/names.c $(DIS.H)
	$(CC) $(DEFINES) -c $(CFLAGS) $(DISINC) $(DISDIRP)/names.c

extended.o: $(DISDIRP)/extended.c $(DIS.H)
	$(CC) $(DEFINES) -c $(CFLAGS) $(DISINC) $(DISDIRP)/extended.c

881_gen.o: $(DISDIRP)/881_gen.c $(DIS.H)
	$(CC) $(DEFINES) -c $(CFLAGS) $(DISINC) $(DISDIRP)/881_gen.c

cp_gen.o: $(DISDIRP)/cp_gen.c $(DIS.H)
	$(CC) $(DEFINES) -c $(CFLAGS) $(DISINC) $(DISDIRP)/cp_gen.c

dis_utils.o: dis_utils.c $(DIS.H)
	$(CC) $(DEFINES) -c $(CFLAGS) $(DISINC) dis_utils.c
#
#			End of disassembler related files
#

debug.o:	$(COM)/head.h $(COFF.H) $(COM)/debug.c
		$(CC) $(DEFINES) -c $(CFLAGS) $(COM)/debug.c

install:	all
		$(INS) $(TESTDIR)/sdb $(ROOT)/bin/sdb
		chmod 755 $(ROOT)/bin/sdb
		chgrp bin $(ROOT)/bin/sdb
		chown bin $(ROOT)/bin/sdb

clean :
		-rm -f $(OBJS) $(DIS.O)

clobber: clean
		-rm -f $(TESTDIR)/sdb

		-rm -f greplist tags
SOURCES= $(DIS.C) $(SOURCE) $(CSOURCE)
ctags:
	ctags $(SOURCES)
	echo 'grep $$* \\' >greplist
	for i in $(SOURCES)	;\
	do echo "$$i \\"	;\
	done >> greplist
	echo /dev/null >> greplist
	chmod +x greplist
