
#   Arete/5.0   6/30/84   /usr/src/cmd/arete/savefiles.sh
#		modified 1/28/87 - kelly

#ident	"@(#)savefiles:savefiles.sh	25.1"

# Use this shell script to save site dependent files on magnetic tape BEFORE
# installing new root and /usr file systems.  The system administrator must
# create a text file which contains, at a minimum, the files and directories
# listed in /local/bin/savelist.
#
# This shell script takes two arguments: first is the name of the
# aforementioned text file; second is the name of the tape drive (rewind).

# Begin shell script.
#
if [ ! $# -eq 2 -o ! -r $1 -o ! -f $1 ]
then
	echo "\nUsage: $0  file  rewind tape device"
	echo "where file is a list of files or directories to be saved."
	echo "and rewind tape device is the device used on your system.\n"
	exit 1
fi

# Copy the files and directories to a temporary directory.
#
DIR=/tmp/save$$
mkdir ${DIR}
cat $1 | while read i	# jc0
do
	find $i -depth -print 
done | cpio -pd ${DIR}

# Append a hyphen (-) to the end of each file name or directory name.
#
cd ${DIR}
find . -type f -print | while read i
do
	mv ./${i} ./${i}-
done

# Save the files on magnetic tape.
#
find . -print | cpio -ovB>$2

# Remove the temporary directory.
#
cd ..
rm -fr ${DIR}

# This shell script is complete at this point.  Go ahead and install the new
# file systems.  To extract files from the tape, enter the following commands:
#
#	cd /
#	cpio -idvBm < <rewind device>
#
# The names of the files or directories extracted will end with a hyphen to
# distinguish them from the default files.  To use an extracted file, remove
# the default file and rename the extracted file.
