#	START NEW ARIX SCCS HEADER
#
#	@(#) sadmin.mk: version 25.1 created on 12/2/91 at 17:03:22
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)sadmin.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT:#ident	"sadmin:sadmin.mk	2.4"

#ident	"@(#)sadmin:sadmin.mk	25.1"

#	Overall Makefile shipped administrative pieces

IROOT =
include $(IROOT)/macdefs

ADMINHOME =$(ROOT)/usr/admin
BIN =	$(ROOT)/usr/bin
LBIN =	$(ROOT)/usr/lbin
DIRS =	$(ROOT) $(ROOT)/usr # $(ROOT)/install **hh1 comments (see README.ses)**
# DEVS =	$(ROOT)/dev/SA/diskette1 $(ROOT)/dev/rSA/diskette1
ETC =	$(ROOT)/etc

PARTS =	tools shell include csub cmain check etc admin

FILES = README sadmin.mk

nfs:	
	cd admin; make

all:	ALL

ALL: \
		$(PARTS)
	cd tools;  make
	cd shell;  make
	cd include;  make
	cd csub;  make
	cd cmain;  make
	cd check;  make
	cd etc;  make
	cd admin;  make

install: \
		ALL $(DIRS)
	cd shell;  make DIR=$(LBIN) $@
	cd etc;  make DIR=$(ETC) $@
	cd cmain;  make DIR=$(LBIN) $@
	cd check;  make DIR=$(LBIN) $@
	cd admin;  make BIN=$(BIN) ADMINHOME=$(ADMINHOME) $@

product productdir:
	cd tools;    make DIR=$(LBIN) $@  && \
	cd ../shell;  make DIR=$(LBIN) $@  && \
	cd ../cmain;  make DIR=$(LBIN) $@  && \
	cd ../check;  make DIR=$(LBIN) $@  && \
	cd ../etc;    make DIR=$(ETC) $@  && \
	cd ../admin;  make BIN=$(BIN) ADMINHOME=$(ADMINHOME) $@

clean clobber newmakefile remove:
	cd tools;  make DIR=$(LBIN) $@
	cd shell;  make DIR=$(LBIN) $@
	cd include;  make DIR=$(LBIN) $@
	cd csub;   make DIR=$(LBIN) $@
	cd cmain;  make DIR=$(LBIN) $@
	cd check;  make DIR=$(LBIN) $@
	cd etc;    make DIR=$(ETC) $@
	cd admin;  make BIN=$(BIN) ADMINHOME=$(ADMINHOME) $@

$(DIRS):
	mkdir $@;  chmod 775 $@

# $(DEVS):
# 	@echo The following device needs to be created: $@
# 	@echo It is created by linking the largest removable disk slice to $@ .

partslist:	$(PARTS)
	@echo $(FILES)  |  tr ' ' '\012'
	cd tools;    make DIR=$(LBIN) $@  |  sed 's;^;tools/;'  && \
	cd ../shell;    make DIR=$(LBIN) $@  |  sed 's;^;shell/;'  && \
	cd ../include;  make DIR=$(LBIN) $@  |  sed 's;^;include/;'  && \
	cd ../csub;  make DIR=$(LBIN) $@  |  sed 's;^;csub/;'  && \
	cd ../cmain;  make DIR=$(LBIN) $@  |  sed 's;^;cmain/;'  && \
	cd ../check;  make DIR=$(LBIN) $@  |  sed 's;^;check/;'  && \
	cd ../etc;    make DIR=$(ETC) $@  |  sed 's;^;etc/;'  && \
	cd ../admin;  make BIN=$(BIN) ADMINHOME=$(ADMINHOME) $@  |  sed 's;^;admin/;'  && \

srcaudit:
	@ls -d $(PARTS) $(FILES) 2>&1 >/dev/null
	cd tools;    make DIR=$(LBIN) $@  |  sed 's;^;tools/;'  && \
	cd ../shell;    make DIR=$(LBIN) $@  |  sed 's;^;shell/;'  && \
	cd ../include;  make DIR=$(LBIN) $@  |  sed 's;^;include/;'  && \
	cd ../csub;  make DIR=$(LBIN) $@  |  sed 's;^;csub/;'  && \
	cd ../cmain;  make DIR=$(LBIN) $@  |  sed 's;^;cmain/;'  && \
	cd ../check;  make DIR=$(LBIN) $@  |  sed 's;^;check/;'  && \
	cd ../etc;    make DIR=$(ETC) $@  |  sed 's;^;etc/;'  && \
	cd ../admin;  make BIN=$(BIN) ADMINHOME=$(ADMINHOME) $@  |  sed 's;^;admin/;'  && \

proto:
	make -f sadmin.mk ROOT=$(ROOT) productdir product  |  \
		tools/mkproto -u0 -g3 >PROTO

cmdsused:
	( cd shell;    make partslist  |  sed 's;^;shell/;'  && \
	cd ../etc;    make partslist  |  sed 's;^;etc/;'  && \
	cd ../admin;  make partslist |  sed 's;^;admin/;' )  | \
	xargs cat  |  tools/cmdsused
