/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) spclsize.c: version 25.1 created on 12/2/91 at 17:01:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)spclsize.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"sadmin:cmain/spclsize.c    1.3.1.2"	*/

#ident	"@(#)sadmin/admin/cmain:spclsize.c	25.1"

/*	
	Determine the current size of a disk file system by using the
	appropriate ioctl.  The ATT version of this utility handled
	block and character device, the ARIX version only handles character
	disk devices. -- joe s
*/

#include	<cmderr.h>
#include	<fcntl.h>
#include	<stdio.h>
#include	<values.h>
#include	"sys/ioctl.h"


static int	debug = 0;


main(argc, argv)
int	argc;
char	*argv[];
{
	int		c;
	int		errflg = 0;
	char		*filename = 0;
	extern int	optind;
	int		scale = 1024;

	pgm_name = *argv;
	while( ( c = getopt( argc, argv, "bfx" ) ) != EOF ) {
		switch( c ) {
		case 'b':	/* report in blocks */
			scale = 1;
			break;
		case 'f':	/* preceed value with file name */
			filename = *argv;
			break;
		case 'x':	/* unadvertised debug option */
			printf("ARIX 3.2 p2 version, debug not supported\n");
			exit(1);
		default:
			errflg = 1;
		}
	}
	while( optind-- ) {
		argc--;
		argv++;
	}
	if( errflg  ||  argc < 1 ) {
		fprintf( stderr, "Usage:  %s [ -b ] [ -f ] file ...\n",
			 pgm_name );
		exit( 1 );
	}

	for( ;  *argv;  argv++ ) {
		if( filename )
			filename = *argv;
		process( *argv, filename, scale );
	}
	exit( 0 );
}

static
process(file, filename, scale)
char	*file;
char	*filename;
int	scale;
{
	int	slice_size;
	int	fd;

	if ( (fd = open( file, O_RDONLY )) == -1 )
		cmderr( CHALT, "open() failure, cannot open %s\n", file);
	else if ( (slice_size = ioctl( fd, GET_DISK_SIZE )) == -1 )
		cmderr( CHALT, "ioctl() failure, GET_DISK_SIZE of %s\n", file);
	else {
		report( filename, slice_size, scale );
		exit(0);
	}
	exit(1);
}

static
report(filename, size, scale)
char	*filename;
long	size;
int	scale;
{
	if( filename )
		printf( "%s\t", filename );
	printf( "%ld\n", (size * scale) );
}
