/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sar.c: version 25.1 created on 12/2/91 at 16:54:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sar.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	AT&T: #ident	"sa:sar.c	1.28"			*/
/* sw0 2/28/86 david stone: divide all devio[x][2] references   */
/*				 by 2     			*/
/* sw1		because devio[x][2] now contains hsdt 	        */
/*				ticks which are lbolts/2    	*/
/* eb0 1/16/87 ed baumann: added support to report slave 	*/
/*				activity			*/
/* sw2 9/17/87 judy chu: temperary changed for rfs, which only 	*/
/*		           	run on master cpu now		*/
/* kd0 1/28/88 kelly: the total value of freemem was larger than*/
/*				a long. make it a double	*/
/* ca0 2/28/89 Charles: Averages are reported as 100 percent    */
/*                      instead of values greater than 100      */
/*                      A macro (LIMIT) was added to ensure     */
/*                      this will not occur.                    */

#ident	"@(#)sa:sar.c	25.1"

/*	sar.c 1.28 of 6/26/86	*/
/*
	sar.c - It generates a report either
		from an input data file or
		by invoking sadc to read system activity counters 
		at the specified intervals.
	usage: sar [-ubdycwaqvmpr] [-o file] t [n]    or
	       sar [-ubdycwaqvmpr][-s hh:mm][-e hh:mm][-i ss][-f file]
*/
#include <stdio.h>
#include <sys/param.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/sysinfo.h>
#include <sys/utsname.h>
#include <sys/fcntl.h>
#include <sys/flock.h>
#include "sa.h"

#define SADC 	"/usr/lib/sa/sadc"

struct sa nx,ox,ax,bx;
double zero, one;
struct tm *localtime(), *curt,args,arge;
struct utsname name;
int	sflg, eflg, iflg, oflg, fflg;
int	dflg = 0;
float	Isyscall, Isysread, Isyswrite, Isysexec, Ireadch, Iwritech;
float	Osyscall, Osysread, Osyswrite, Osysexec, Oreadch, Owritech;
float 	Lsyscall, Lsysread, Lsyswrite, Lsysexec, Lreadch, Lwritech;
int	realtime;
int	passno;
int	t = 0;
int	n = 0;
int	cpu;
int	rcnt = 0;
double 	magic = 4.294967296e9;
int	hz;
int	recsz, tblmap[SINFO];
int	j, i;
int	tabflg;
char	options[15], fopt[15];
char	cc;
int	cpu;
float	tdiff, Tdiff, TTdiff; /* eb0 */
float	stime, etime, isec;
int	fin, fout, childid;
int	pipedes[2];
char	arg1[10], arg2[10];
int	strlen(), strdmp();
char	*strcpy(), *strncat(), *strncpy(), *strchr();
extern  int optind;
extern  char *optarg;

main (argc, argv)
char	**argv;
int	argc;
{
	char    flnm[50], ofile[50];
	char	ccc;
	long    temp;
	int	jj = 0;
	int	cpu_alive;
	float	convtm();
	long	lseek();
	extern time_t time();

/*      process options with arguments and pack options 
	without arguments  */
	while ( ( i = getopt(argc, argv, "uybdvcwaqmprACDSo:s:e:i:f:" ) ) 
			!= EOF )
		switch( ccc = i ) {
		case 'D':
			dflg++;
			break;
		case 'o':
			oflg++;
			sprintf( ofile, "%s", optarg );
			break;
		case 's':
			if ( sscanf( optarg, "%d:%d:%d",
			&args.tm_hour, &args.tm_min, &args.tm_sec ) < 1 )
				pillarg();
			else {
				sflg++,
				stime = args.tm_hour * 3600.0 +
					args.tm_min * 60.0 +
					args.tm_sec;
			}
			break;
		case 'e':
			if ( sscanf( optarg, "%d:%d:%d",
			&arge.tm_hour, &arge.tm_min, &arge.tm_sec ) < 1 )
				pillarg();
			else {
				eflg++;
				etime = arge.tm_hour * 3600.0 +
					arge.tm_min * 60.0 +
					arge.tm_sec;
			}
			break;
		case 'i':
			if ( sscanf( optarg, "%f", &isec ) < 1 )
				pillarg();
			else{
			if ( isec > 0.0 )
				iflg++;
			}
			break;
		case 'f':
			fflg++;
			sprintf( flnm, "%s", optarg );
			break;
		case '?':
			fprintf(stderr,"usage: sar [-ubdycwaqvmprACDS][-o file] t [n]\n");
			fprintf(stderr,"       sar [-ubdycwaqvmprACDS][-s hh:mm][-e hh:mm][-i ss][-f file]\n");
			exit(2);
			break;
		default:
			strncat ( options, &ccc, 1 );
			break;
		}

	/*   Are starting and ending times consistent?  */

	if ( ( sflg ) && ( eflg ) && ( etime <= stime ) )
		pmsgexit( "etime <= stime" );

	/*   Determine if t and n arguments are given,
	and whether to run in real time or from a file   */

	switch( argc - optind ) {
	case 0:			/*   Get input data from file   */
		if ( fflg == 0 ) {
			temp = time( ( long * ) 0 );
			curt = localtime( &temp );
			sprintf( flnm, "/usr/adm/sa/sa%.2d", curt->tm_mday );
		}
		if ( ( fin = open( flnm, 0 ) ) == -1 ) {
			fprintf( stderr, "sar:Can't open %s\n", flnm );
			exit( 1 );
		}
		break;
	case 1:			/*   Real time data; one cycle   */
		realtime++;
		t = atoi( argv[optind] );
		n = 2;
		break;
	case 2:			/*   Real time data; specified cycles   */
	default:
		realtime++;
		t = atoi( argv[optind] );
		n = 1 + atoi( argv[optind+1] );
		break;
	}

	/*	"u" is default option to display cpu utilization   */

	if ( strlen( options ) == 0 )
		strcpy( options, "u" );

	/*    'A' means all data options   */

	if ( strchr( options, 'A' ) != NULL ) {
		strcpy( options, "udqbwcayvmprCS" );
		dflg++;
	}
	else if ( ( dflg )
	     && ( strchr( options, 'u' ) == NULL )
	     && ( strchr( options, 'b' ) == NULL )
	     && ( strchr( options, 'c' ) == NULL ) ) strcat( options, "u" );

	if ( realtime ) {

	/*	Get input data from sadc using a temp file   eb0 */

		if ( ( t <= 0 ) || ( n < 2 ) )
			pmsgexit( "args t & n <= 0" );
		sprintf( arg1, "%d", t );
		sprintf( arg2, "%d", n );
		if ( tmpnam( flnm ) == ( char * ) 0 ) {
			fprintf( stderr, "sar: tmpnam\(\) failed\n" );
			perrexit();
		}
		if ( ( fout = open( flnm, O_WRONLY | O_CREAT, 0666 ) ) == -1 ) {
			fprintf( stderr, "sar: Could not open %s\n", flnm );
			perrexit();
		}

		if ( ( childid = fork() ) == 0 ) {	/*  child:   */
			close( 1 );       /*  shift pipedes[write] to stdout  */
			dup( fout );
			if ( execlp ( SADC, SADC , arg1, arg2, 0 ) == -1 )
				perrexit();
		}
		else {			/*   parent:   */
			wait( ( int * ) 0 );
			close( fout);
		}

	}

	if ( ( fin = open( flnm, O_RDONLY ) ) == -1 ) {
		fprintf( stderr, "Can't open %s\n", flnm );
		perrexit();
	}

	if ( oflg ) {
		if ( strcmp( ofile, flnm ) == 0 )
			pmsgexit( "ofile same as ffile" );
		fout = creat( ofile, 00644 );
	}

/*      read the header record and compute record size */

	if ( read( fin, tblmap, sizeof( tblmap ) ) < 0 )
		perrexit ();
	for ( i = 0; i < SINFO; i++ )
		recsz += tblmap[i];
	recsz = sizeof (struct sa) - sizeof nx.devio +
		recsz * sizeof nx.devio[0];

	if ( oflg )
		write( fout, tblmap, sizeof ( tblmap ) );

	/*   Make multiple passes, one for each option   */

	for ( cpu = 0; cpu < NCPU; ++cpu ) {		/* eb0 */
		passno = jj = 0;			/* eb0 */
		cpu_alive = 1;
		while ( cpu_alive && strlen( strncpy( fopt, &options[jj++], 1 ) ) > 0 ) {
			lseek( fin, (long)(sizeof ( tblmap ) ), 0 );
			passno++;
			cpu_alive = prpass();
		}
	}
	if ( realtime )
		unlink( flnm );
	exit( 0 );
}

/*****************************************************/

/*	Read records from input, classify, and decide on printing   */
prpass(){
	int lines = 0;
	int recno = 0;
	float tnext = 0;
	float trec;

/* if we are not doing the master cpu, and the data is
   only appropriate for the master, then just return	eb0 */

	if ( ( cpu > 0 ) && masteronly() )
		return( 1 );


	if ( sflg )
		tnext = stime;

	while ( read( fin, &nx, ( unsigned ) recsz ) > 0 ) {
		if (nx.si[cpu].cpu[0] == NOT_ALIVE)
			return( 0 );
		curt = localtime( &nx.ts );
		trec = curt->tm_hour * 3600.0
			+ curt->tm_min * 60.0
			+ curt->tm_sec;
		if ( ( recno == 0 ) && ( trec < stime ) )
			continue;
		if ( ( eflg ) && ( trec > etime ) )
			break;
		if ( ( oflg ) && ( passno == 1 ) )
			write( fout, &nx, ( unsigned ) recsz );
		if ( recno == 0 ) {
			if ( passno == 1 ) {
				uname( &name );
				printf("\n%s %s %s %s %s    %.2d/%.2d/%.2d\n",
					name.sysname,
					name.nodename,
					name.release,
					name.version,
					name.machine,
					curt->tm_mon + 1,
					curt->tm_mday,
					curt->tm_year);
			}
			prthdg();
			recno = 1;
			if ( ( iflg ) && ( tnext == 0 ) )
				tnext = trec;
		}
		if ( nx.si[cpu].cpu[0] == SYS_RESET ) { 	/* eb0 */
		/*  This dummy record signifies system restart
		    New initial values of counters follow in next record  */
			prttim();
			printf(" \tsyst restarts\n" );
			recno = 1;
			continue;
		}
		if ( ( iflg ) && ( trec < tnext ) )
			continue;

		if ( recno++ > 1 ) {		 /* eb0 */
			tdiff =   nx.si[cpu].cpu[0] - ox.si[cpu].cpu[0]
				+ nx.si[cpu].cpu[1] - ox.si[cpu].cpu[1]
				+ nx.si[cpu].cpu[2] - ox.si[cpu].cpu[2]
				+ nx.si[cpu].cpu[3] - ox.si[cpu].cpu[3];
			if ( tdiff <= 0.0 ) 
				continue;	
			prtopt();	/*  Print a line of data  */
			lines++;
		}
		ox = nx;		/*  Age the data	*/
		if ( isec > 0 )
			while ( tnext <= trec )
				tnext += isec;
	}
	rcnt = recno;
	if ( lines > 1 )
		prtavg();
	ax = bx;		/*  Zero out the accumulators   */
	return( 1 );
}

/************************************************************/
masteronly() 		/* eb0 */
{
	char	ccc;

	ccc = fopt[0];
	switch( ccc ) {
		case 'b':
		case 'c':
		case 'u':
			return( 0 );
		break;
		default:
		return(1);
		break;
	}
}

/************************************************************/
/*      print time label routine	*/
prttim()
{
	curt = localtime( &nx.ts );
	printf("%.2d:%.2d:%.2d",
		curt->tm_hour,
		curt->tm_min,
		curt->tm_sec);
	tabflg = 1;
}

/***********************************************************/

/*      test if 8-spaces to be added routine    */
tsttab()
{
	if (tabflg == 0) 
		printf("        ");
	else
		tabflg = 0;
}

/************************************************************/

/*      print report heading routine    */
prthdg()
{
	int	jj=0;
	static  last_cpu=-1;
	char	ccc;

	/*printf("\n");
	if((passno == 1) && (last_cpu != cpu)) {
		last_cpu = cpu;
		printf("CPU # %d\n\n",cpu);
	}
	*/
	prttim();
	while((ccc = fopt[jj++]) != NULL)
	switch(ccc){
	case 'u':
		tsttab();
		if (dflg) {
			printf(" %7s %7s %7s %7s %7s\n",
				"%usr",
				"%sys",
				"%sys",
				"%wio",
				"%idle");
			tsttab();
			printf(" %7s %7s %7s\n",
				"",
				"local",
				"remote");
			break;
		}
		printf(" %7s %7s %7s %7s\n",
			"%usr",
			"%sys",
			"%wio",
			"%idle");
		break;
	case 'y':
		tsttab();
		printf(" %7s %7s %7s %7s %7s %7s\n",
			"rawch/s",
			"canch/s",
			"outch/s",
			"rcvin/s",
			"xmtin/s",
			"mdmin/s");
		break;
	case 'b':
		tsttab();
		printf(" %7s %7s %7s %7s %7s %7s %7s %7s\n",
			"bread/s",
			"lread/s",
			"%rcache",
			"bwrit/s",
			"lwrit/s",
			"%wcache",
			"pread/s",
			"pwrit/s");
		break;
	case 'd':
		tsttab();
		printf(" %7s %7s %7s %7s %7s %7s %7s\n",
			"device",
			"%busy",
			"avque",
			"r+w/s",
			"blks/s",
			"avwait",
			"avserv");
		break;
	case 'v':
		tsttab();
		printf(" %s %s %s %s\n",
			"proc-sz ov",
			"inod-sz ov",
			"file-sz ov",
			"lock-sz   ");
		break;
	case 'c':
		tsttab();
		printf(" %7s %7s %7s %7s %7s %7s %7s\n",
			"scall/s",
			"sread/s",
			"swrit/s",
			"fork/s",
			"exec/s",
			"rchar/s",
			"wchar/s");
		break;
	case 'w':
		tsttab();
		printf(" %7s %7s %7s %7s %7s\n",
			"swpin/s",
			"bswin/s",
			"swpot/s",
			"bswot/s",
			"pswch/s");
		break;
	case 'a':
		tsttab();
		printf(" %7s %7s %7s\n",
			"iget/s",
			"namei/s",
			"dirbk/s");
		break;
	case 'q':
		tsttab();
		printf(" %7s %7s %7s %7s\n",
			"runq-sz",
			"%runocc",
			"swpq-sz",
			"%swpocc");
		break;
	case 'm':
		tsttab();
		printf(" %7s %7s\n",
			"msg/s",
			"sema/s");
		break;
	case 'r':
		tsttab();
		printf(" %7s %7s\n",
			"freemem",
			"freeswp");
		break;
	case 'S':
		tsttab();
		printf("%11s %9s %9s %9s %9s\n",
			"serv/lo-hi",
			"request",
			"request",
			"server",
			"server");
		tsttab();
		printf("%6s %d %1s %d %9s %9s %9s %9s\n",
			"",
			nx.minserve,
			"-",
			nx.maxserve,
			"%busy",
			"avg lgth",
			"%avail",
			"avg avail");
		break;
	case 'C':
		tsttab();
		printf(" %11s %11s %11s %11s %11s %11s\n",
			"snd-inv/s",
			"snd-msg/s",
			"rcv-inv/s",
			"rcv-msg/s",
			"dis-bread/s",
			"blk-inv/s");
		break;
	case 'p':
		tsttab();
		printf(" %7s %7s %7s %7s\n",
			"vflt/s",
			"pflt/s",
			"pgfil/s",
			"rclm/s");
		break;
	}
	if(jj > 2)	printf("\n");
}

/**********************************************************/

/*      print options routine   */
prtopt()
{
	register int ii, kk, mm;
	long	readch, writech, iget;
	float	temp1, temp2; 			/* eb1 */
	float a, b, c, d, e, f;			/* sw2 */
	short ncpus;
	int jj = 0;
	char ccc;

	a = b = c = d = e = f = 0.0;

	if ( strcmp( fopt, "d") == 0)
		printf("\n");

	prttim();
	for ( ii = 0; ii < 4; ii++ )
		ax.si[cpu].cpu[ii] += nx.si[cpu].cpu[ii] - ox.si[cpu].cpu[ii];
	if (dflg) cpu ? (ax.di[cpu].serve = 0) : (ax.di[cpu].serve += nx.di[cpu].serve   - ox.di[cpu].serve);	/* sw2 */
	
	while((ccc = fopt[jj++]) != NULL)
	switch(ccc){
	case 'u':
		tsttab();
	if (dflg) {
		if (nx.apstate) {
			printf(" %7.0f %7.0f %7.0f %7.0f %7.0f\n",
			LIMIT( ( (float)(nx.si[cpu].cpu[1] - 
				ox.si[cpu].cpu[1]) / ( 2 * tdiff ) * 100.0) ),
			LIMIT( ( (float)( (nx.si[cpu].cpu[2] - 
				ox.si[cpu].cpu[2] - ( cpu ? 0 : 
				(nx.di[cpu].serve - ox.di[cpu].serve ) ) ) / 
				( 2 * tdiff ) * 100.0 ) ) ),
			LIMIT( ( (float)( cpu ? 0 : (nx.di[cpu].serve - 
				ox.di[cpu].serve) / ( 2 * tdiff ) * 100.0 ) ) ),
			LIMIT( ( (float)(nx.si[cpu].cpu[3] - 
				ox.si[cpu].cpu[3]) / ( 2 * tdiff ) * 100.0 ) ),
			LIMIT( ( (float)(nx.si[cpu].cpu[0] - 
				ox.si[cpu].cpu[0]) / ( 2 * tdiff ) * 100.0 ) ) );	/* sw2 */
		} else {
			printf(" %7.0f %7.0f %7.0f %7.0f %7.0f\n",
			LIMIT( ( (float)(nx.si[cpu].cpu[1] - 
				ox.si[cpu].cpu[1]) / tdiff * 100.0 ) ),

			LIMIT( ( (float)( (nx.si[cpu].cpu[2] - 
				ox.si[cpu].cpu[2] - (cpu ? 0 : 
				(nx.di[cpu].serve - ox.di[cpu].serve ) ) ) / 
				tdiff * 100.0 ) ) ),
			LIMIT( ( (float)( cpu ? 0 : (nx.di[cpu].serve - 
				ox.di[cpu].serve) / tdiff * 100.0 ) ) ),
			LIMIT( ( (float)(nx.si[cpu].cpu[3] - 
				ox.si[cpu].cpu[3]) / tdiff * 100.0 ) ),
			LIMIT( ( (float)(nx.si[cpu].cpu[0] - 
				ox.si[cpu].cpu[0]) / tdiff * 100.0 ) ) );	/* sw2 */
		}
		break;
		}
		if (nx.apstate)
		{
			printf(" %7.0f %7.0f %7.0f %7.0f\n",
			LIMIT( ( (float)(nx.si[cpu].cpu[1] - 
				ox.si[cpu].cpu[1]) / ( 2 * tdiff ) * 100.0 ) ),
			LIMIT( ( (float)(nx.si[cpu].cpu[2] - 
				ox.si[cpu].cpu[2]) / ( 2 * tdiff ) * 100.0 ) ),
			LIMIT( ( (float)(nx.si[cpu].cpu[3] - 
				ox.si[cpu].cpu[3]) / ( 2 * tdiff ) * 100.0 ) ) ,
			LIMIT( ( (float)(nx.si[cpu].cpu[0] - 
				ox.si[cpu].cpu[0]) / ( 2 * tdiff ) * 100.0 ) ) );
		}
		else {
		printf(" %7.0f %7.0f %7.0f %7.0f\n",
		LIMIT( ( (float)(nx.si[cpu].cpu[1] - 
			ox.si[cpu].cpu[1]) / tdiff * 100.0 ) ),
		LIMIT( ( (float)(nx.si[cpu].cpu[2] -  
			ox.si[cpu].cpu[2]) / tdiff * 100.0 ) ),
		LIMIT ( ( (float)(nx.si[cpu].cpu[3] - 
			ox.si[cpu].cpu[3]) / tdiff * 100.0 ) ) ,
		LIMIT( ( (float)(nx.si[cpu].cpu[0] - 
			ox.si[cpu].cpu[0]) / tdiff * 100.0 ) ) );
		}
		break;
	case 'y':
		tsttab();
		printf(" %7.0f %7.0f %7.0f %7.0f %7.0f %7.0f\n",
		(float)(nx.si[cpu].rawch - ox.si[cpu].rawch) / tdiff * HZ,
		(float)(nx.si[cpu].canch - ox.si[cpu].canch) / tdiff * HZ,
		(float)(nx.si[cpu].outch - ox.si[cpu].outch) / tdiff * HZ,
		(float)(nx.si[cpu].rcvint - ox.si[cpu].rcvint) / tdiff * HZ,
		(float)(nx.si[cpu].xmtint - ox.si[cpu].xmtint) / tdiff * HZ,
		(float)(nx.si[cpu].mdmint - ox.si[cpu].mdmint) / tdiff * HZ);

		ax.si[cpu].rawch += nx.si[cpu].rawch - ox.si[cpu].rawch;
		ax.si[cpu].canch += nx.si[cpu].canch - ox.si[cpu].canch;
		ax.si[cpu].outch += nx.si[cpu].outch - ox.si[cpu].outch;
		ax.si[cpu].rcvint += nx.si[cpu].rcvint - ox.si[cpu].rcvint;
		ax.si[cpu].xmtint += nx.si[cpu].xmtint - ox.si[cpu].xmtint;
		ax.si[cpu].mdmint += nx.si[cpu].mdmint - ox.si[cpu].mdmint;
		break;
	case 'b':
		tsttab();
		if ( dflg ) {
			if ( ( nx.si[cpu].lread - ox.si[cpu].lread ) == 0 )
			printf(" %7s %7s %7s", "  ", "  ", "  ");
		else printf("\n   local  %4.0f %7.0f %7.0f",
				(float)(nx.si[cpu].bread - ox.si[cpu].bread) /
					tdiff * HZ,
				(float)(nx.si[cpu].lread - ox.si[cpu].lread) /
					tdiff * HZ,
				LIMIT( ( ( ( (float)(nx.si[cpu].lread - 
					ox.si[cpu].lread) -
					  (float)(nx.si[cpu].bread - 
						ox.si[cpu].bread ) ) /
					  (float)(nx.si[cpu].lread - 
						ox.si[cpu].lread ) * 
						100.0 ) ) ) );
			if ( ( nx.si[cpu].lwrite - ox.si[cpu].lwrite ) == 0 )
			printf(" %7s %7s %7s", "  ", "  ", "  ");
			else printf(" %7.0f %7.0f %7.0f",
				(float)(nx.si[cpu].bwrite - 
					ox.si[cpu].bwrite) / tdiff * HZ,
				(float)(nx.si[cpu].lwrite - 
					ox.si[cpu].lwrite) / tdiff * HZ,
				LIMIT( ( ( ( (float)(nx.si[cpu].lwrite - 
					ox.si[cpu].lwrite) -
				  	(float)(nx.si[cpu].bwrite - 
						ox.si[cpu].bwrite ) ) /
				  	(float)(nx.si[cpu].lwrite - 
						ox.si[cpu].lwrite ) * 
						100.0 ) ) ) );
			printf(" %7.0f %7.0f\n", 
				(float)(nx.si[cpu].phread - 
					ox.si[cpu].phread) / tdiff * HZ,
				(float)(nx.si[cpu].phwrite - 
					ox.si[cpu].phwrite) / tdiff * HZ );

			ax.si[cpu].bread += nx.si[cpu].bread - ox.si[cpu].bread;
			ax.si[cpu].bwrite += nx.si[cpu].bwrite - ox.si[cpu].bwrite;
			ax.si[cpu].lread += nx.si[cpu].lread - ox.si[cpu].lread;
			ax.si[cpu].lwrite += nx.si[cpu].lwrite - ox.si[cpu].lwrite;
			ax.si[cpu].phread += nx.si[cpu].phread - ox.si[cpu].phread;
			ax.si[cpu].phwrite += nx.si[cpu].phwrite - ox.si[cpu].phwrite;
			if ( cpu ) {	/* sw2 */
			printf("   remote %4.0f %7.0f %7.0f %7.0f %7.0f %7.0f \n",
				a,b,c,d,e,f);
			ax.rc[cpu].cbread = ax.rc[cpu].cbwrite = 0;
			ax.rc[cpu].clread = ax.rc[cpu].clwrite = 0;
			}
			else {
			if ( ( nx.rc[cpu].clread - ox.rc[cpu].clread ) == 0 )
			printf(" %7s %7s %7s", "  ", "  ", "  ");
			else
			printf("   remote %4.0f %7.0f %7.0f\n",
				(float)(nx.rc[cpu].cbread - 
					ox.rc[cpu].cbread) / tdiff * HZ,
				(float)(nx.rc[cpu].clread - 
					ox.rc[cpu].clread) / tdiff * HZ,
				LIMIT( ( ( ( (float)(nx.rc[cpu].clread - 
					ox.rc[cpu].clread ) -
					(float)(nx.rc[cpu].cbread - 
						ox.rc[cpu].cbread ) ) /
					(float)( ( nx.rc[cpu].clread - 
						ox.rc[cpu].clread) ?
						(nx.rc[cpu].clread - 
						ox.rc[cpu].clread) : 1 ) * 
						100.0 ) ) ) );
			if ( ( nx.rc[cpu].clwrite - ox.rc[cpu].clwrite) == 0 )
			printf(" %7s %7s %7s", "  ", "  ", "  ");
			else
			printf(" %7.0f %7.0f %7.0f\n",
				(float)(nx.rc[cpu].cbwrite - 
					ox.rc[cpu].cbwrite) / tdiff * HZ,
				(float)(nx.rc[cpu].clwrite - 
					ox.rc[cpu].clwrite) / tdiff * HZ,
				LIMIT( ( ( ( (float)(nx.rc[cpu].clwrite - 
					ox.rc[cpu].clwrite) -
					(float)(nx.rc[cpu].cbwrite - 
						ox.rc[cpu].cbwrite) ) /
					(float)( ( nx.rc[cpu].clwrite - 
						ox.rc[cpu].clwrite) ?
						(nx.rc[cpu].clwrite - 
						ox.rc[cpu].clwrite ) : 1 ) *
						100.0 ) ) ) );

			ax.rc[cpu].cbread += nx.rc[cpu].cbread - ox.rc[cpu].cbread;
			ax.rc[cpu].cbwrite += nx.rc[cpu].cbwrite - ox.rc[cpu].cbwrite;
			ax.rc[cpu].clread += nx.rc[cpu].clread - ox.rc[cpu].clread;
			ax.rc[cpu].clwrite += nx.rc[cpu].clwrite - ox.rc[cpu].clwrite;
			}
			break;
		}

			if ( ( nx.si[cpu].lread - ox.si[cpu].lread ) == 0 )
			printf(" %7s %7s %7s", "  ", "  ", "  ");
			else
			printf(" %7.0f %7.0f %7.0f",
			(float)(nx.si[cpu].bread - ox.si[cpu].bread) / 
				tdiff * HZ,
			(float)(nx.si[cpu].lread - ox.si[cpu].lread) /
				tdiff * HZ,
			LIMIT( ( ( ( (float)(nx.si[cpu].lread - 
				ox.si[cpu].lread) -
				(float)(nx.si[cpu].bread - 
					ox.si[cpu].bread ) ) /
				(float)(nx.si[cpu].lread - 
					ox.si[cpu].lread) * 100.0 ) ) ) );

			if ( ( nx.si[cpu].lwrite - ox.si[cpu].lwrite ) == 0 )
			printf(" %7s %7s %7s", "  ", "  ", "  ");
			else
			printf(" %7.0f %7.0f %7.0f",
			(float)(nx.si[cpu].bwrite - ox.si[cpu].bwrite) / 
				tdiff * HZ,
			(float)(nx.si[cpu].lwrite - ox.si[cpu].lwrite) /
				tdiff * HZ,
			LIMIT( ( ( ( (float)(nx.si[cpu].lwrite - 
				ox.si[cpu].lwrite) -
				(float)(nx.si[cpu].bwrite - 
					ox.si[cpu].bwrite ) ) /
				(float)(nx.si[cpu].lwrite - 
					ox.si[cpu].lwrite) * 100.0 ) ) ) );
			printf(" %7.0f %7.0f\n",
			(float)(nx.si[cpu].phread - ox.si[cpu].phread) / 
				tdiff * HZ,
			(float)(nx.si[cpu].phwrite - ox.si[cpu].phwrite) /
				tdiff * HZ );

		ax.si[cpu].bread += nx.si[cpu].bread - ox.si[cpu].bread;
		ax.si[cpu].bwrite += nx.si[cpu].bwrite - ox.si[cpu].bwrite;
		ax.si[cpu].lread += nx.si[cpu].lread - ox.si[cpu].lread;
		ax.si[cpu].lwrite += nx.si[cpu].lwrite - ox.si[cpu].lwrite;
		ax.si[cpu].phread += nx.si[cpu].phread - ox.si[cpu].phread;
		ax.si[cpu].phwrite += nx.si[cpu].phwrite - ox.si[cpu].phwrite;
		break;
	case 'd':
		ii = 0;
		hz = HZ;
		for ( j = 0; j < SINFO; j++ ) {
			for ( kk = 0; kk < tblmap[j]; kk++ ) {
				if (((nx.devio[ii][0] - ox.devio[ii][0]) > 0) 
				&& ((nx.devio[ii][2] - ox.devio[ii][2]) > 0)){
				tsttab();
		if (j == DKS) 
			printf(" %4s%-3d", devnm[j], kk);
		 else
			printf(" %5s%-2d", devnm[j], kk);
		/* eb1 */
		temp1=(float)((nx.devio[ii][2]-ox.devio[ii][2])>>1)/tdiff*100.0;
		temp2=((float)(nx.devio[ii][3] - ox.devio[ii][3]) -
			(float)((nx.devio[ii][2] -ox.devio[ii][2])>>1))/
			(float)(nx.devio[ii][0] - ox.devio[ii][0])/ HZ * 1000.;
/* sw0 */
		printf(" %7.0f %7.1f %7.0f %7.0f %7.1f %7.1f\n",
			  (temp1 < 100.) ? temp1 : 100.,	/* eb1 */
			/* eb0 print zero if delta is zero */
			(((nx.devio[ii][2] - ox.devio[ii][2])>>1) > 0) ?
			(float)(nx.devio[ii][3] - ox.devio[ii][3])/
			   (float)((nx.devio[ii][2] - ox.devio[ii][2])>>1) : 0,
			(float)(nx.devio[ii][0] - ox.devio[ii][0])/tdiff* HZ,
			(float)(nx.devio[ii][1] - ox.devio[ii][1])/tdiff *HZ,
/*			(temp2>0.) ? temp2 : 1.,		 eb1 */
			temp2 < 0. ? 0. : temp2,		/* shen #2483*/

			(float)((nx.devio[ii][2] - ox.devio[ii][2])>>1)/
				(float)(nx.devio[ii][0] - ox.devio[ii][0] )/
				HZ * 1000.);
				for(mm=0;mm<4;mm++)
				ax.devio[ii][mm] +=
				nx.devio[ii][mm] - ox.devio[ii][mm];
				}
				ii++;
			}
		}
		break;
	case 'v':
		tsttab();
		printf(" %3d/%3d%3ld %3d/%3d%3ld %3d/%3d%3ld %3d/%3d\n",
			nx.szproc, nx.mszproc, (nx.procovf - ox.procovf),
			nx.szinode, nx.mszinode, (nx.inodeovf - ox.inodeovf),
			nx.szfile, nx.mszfile, (nx.fileovf - ox.fileovf),
			nx.szlckr, nx.mszlckr);
		break;
	case 'c':
		tsttab();
	if (dflg) {
		if (cpu) { /* sw2 */
		Isyscall = Osyscall = 0;
		Lsyscall = (float)(nx.si[cpu].syscall - ox.si[cpu].syscall )/tdiff * HZ -
				(Isyscall + Osyscall);
		Isysread = Osysread = 0;
		Lsysread = (float)(nx.si[cpu].sysread - ox.si[cpu].sysread )/tdiff * HZ -
				(Isysread + Osysread);
		Isyswrite = Osyswrite = 0;
		Lsyswrite = (float)(nx.si[cpu].syswrite - ox.si[cpu].syswrite )/tdiff * HZ -
				(Isyswrite + Osyswrite);
		Isysexec = Osysexec = 0;
		Lsysexec = (float)(nx.si[cpu].sysexec - ox.si[cpu].sysexec )/tdiff * HZ -
				  (Isysexec + Osysexec);
		Ireadch = Oreadch = 0;
		Lreadch = (float)(nx.si[cpu].readch - ox.si[cpu].readch )/tdiff * HZ -
				(Ireadch + Oreadch);

		Iwritech = Owritech = 0;
		}
		else {
		Isyscall = (float)(nx.di[cpu].isyscall - ox.di[cpu].isyscall)/tdiff * HZ;
		Osyscall = (float)(nx.di[cpu].osyscall - ox.di[cpu].osyscall)/tdiff * HZ;
		Lsyscall = (float)(nx.si[cpu].syscall - ox.si[cpu].syscall )/tdiff * HZ -
				(Isyscall + Osyscall);

		Isysread = (float)(nx.di[cpu].isysread - ox.di[cpu].isysread)/tdiff * HZ;
		Osysread = (float)(nx.di[cpu].osysread - ox.di[cpu].osysread)/tdiff * HZ;
		Lsysread = (float)(nx.si[cpu].sysread - ox.si[cpu].sysread )/tdiff * HZ -
				(Isysread + Osysread);

		Isyswrite = (float)(nx.di[cpu].isyswrite - ox.di[cpu].isyswrite)/tdiff * HZ;
		Osyswrite = (float)(nx.di[cpu].osyswrite - ox.di[cpu].osyswrite)/tdiff * HZ;
		Lsyswrite = (float)(nx.si[cpu].syswrite - ox.si[cpu].syswrite )/tdiff * HZ -
				(Isyswrite + Osyswrite);

		Isysexec = (float)(nx.di[cpu].isysexec - ox.di[cpu].isysexec)/tdiff * HZ;
		Osysexec = (float)(nx.di[cpu].osysexec - ox.di[cpu].osysexec)/tdiff * HZ;
		Lsysexec = (float)(nx.si[cpu].sysexec - ox.si[cpu].sysexec )/tdiff * HZ -
				  (Isysexec + Osysexec);

		Ireadch = (float)(nx.di[cpu].ireadch - ox.di[cpu].ireadch)/tdiff * HZ;
		Oreadch = (float)(nx.di[cpu].oreadch - ox.di[cpu].oreadch)/tdiff * HZ;
		Lreadch = (float)(nx.si[cpu].readch - ox.si[cpu].readch )/tdiff * HZ -
				(Ireadch + Oreadch);

		Iwritech = (float)(nx.di[cpu].iwritech - ox.di[cpu].iwritech)/tdiff * HZ;
		Owritech = (float)(nx.di[cpu].owritech - ox.di[cpu].owritech)/tdiff * HZ;
		}
		Lwritech = (float)(nx.si[cpu].writech - ox.si[cpu].writech )/tdiff * HZ -
				(Iwritech + Owritech);

		printf("\n%-8s %7.0f %7.0f %7.0f %7s %7.2f %7.0f %7.0f\n",
			"   in", Isyscall,Isysread,Isyswrite,"",Isysexec,
			Ireadch,Iwritech);
		printf("%-8s %7.0f %7.0f %7.0f %7s %7.2f %7.0f %7.0f\n",
			"   out",Osyscall,Osysread,Osyswrite,"",Osysexec,
			Oreadch,Owritech);
		printf("%-8s %7.0f %7.0f %7.0f %7.2f %7.2f %7.0f %7.0f\n",
			"   local", Lsyscall, Lsysread, Lsyswrite,
			(float)(nx.si[cpu].sysfork - ox.si[cpu].sysfork)/tdiff * HZ,
			Lsysexec, Lreadch, Lwritech);
		if (cpu) {	/* sw2 */
		ax.di[cpu].isyscall = ax.di[cpu].osyscall = 0;
		ax.si[cpu].syscall += nx.si[cpu].syscall - ox.si[cpu].syscall;
 
		ax.di[cpu].isysread = ax.di[cpu].osysread = 0;
		ax.si[cpu].sysread += nx.si[cpu].sysread - ox.si[cpu].sysread;
		ax.di[cpu].isyswrite = ax.di[cpu].osyswrite = 0;
		ax.si[cpu].syswrite += nx.si[cpu].syswrite - ox.si[cpu].syswrite;
		ax.di[cpu].isysexec = ax.di[cpu].osysexec = 0;
		ax.si[cpu].sysexec += nx.si[cpu].sysexec - ox.si[cpu].sysexec;
 
		ax.di[cpu].ireadch = ax.di[cpu].oreadch = 0;
		ax.si[cpu].readch += nx.si[cpu].readch - ox.si[cpu].readch;
		ax.di[cpu].iwritech = ax.di[cpu].owritech = 0;
		}
		else {
		ax.di[cpu].isyscall += nx.di[cpu].isyscall - ox.di[cpu].isyscall;
		ax.di[cpu].osyscall += nx.di[cpu].osyscall - ox.di[cpu].osyscall;
		ax.si[cpu].syscall += nx.si[cpu].syscall - ox.si[cpu].syscall;
 
		ax.di[cpu].isysread += nx.di[cpu].isysread - ox.di[cpu].isysread;
		ax.di[cpu].osysread += nx.di[cpu].osysread - ox.di[cpu].osysread;
		ax.si[cpu].sysread += nx.si[cpu].sysread - ox.si[cpu].sysread;
 
		ax.di[cpu].isyswrite += nx.di[cpu].isyswrite - ox.di[cpu].isyswrite;
		ax.di[cpu].osyswrite += nx.di[cpu].osyswrite - ox.di[cpu].osyswrite;
		ax.si[cpu].syswrite += nx.si[cpu].syswrite - ox.si[cpu].syswrite;
 
		ax.di[cpu].isysexec += nx.di[cpu].isysexec - ox.di[cpu].isysexec;
		ax.di[cpu].osysexec += nx.di[cpu].osysexec - ox.di[cpu].osysexec;

		ax.si[cpu].sysexec += nx.si[cpu].sysexec - ox.si[cpu].sysexec;
 
		ax.di[cpu].ireadch += nx.di[cpu].ireadch - ox.di[cpu].ireadch;
		ax.di[cpu].oreadch += nx.di[cpu].oreadch - ox.di[cpu].oreadch;
		ax.si[cpu].readch += nx.si[cpu].readch - ox.si[cpu].readch;
	 
		ax.di[cpu].iwritech += nx.di[cpu].iwritech - ox.di[cpu].iwritech;
		ax.di[cpu].owritech += nx.di[cpu].owritech - ox.di[cpu].owritech;
		}
		ax.si[cpu].writech += nx.si[cpu].writech - ox.si[cpu].writech;

		ax.si[cpu].sysfork += nx.si[cpu].sysfork - ox.si[cpu].sysfork;

		break;
	}
		if(!cpu) {	/* if master, total readch and writech eb0 */
			ncpus = readch = writech = 0;
			for(ii=0;ii<NCPU;ii++)
				if(nx.si[ii].cpu[0] != NOT_ALIVE)
					++ncpus;
			for(ii=0;ii<ncpus;ii++) {
				readch += nx.si[ii].readch - ox.si[ii].readch;
				writech+=nx.si[ii].writech - ox.si[ii].writech;
			}
		}
		printf(" %7.0f %7.0f %7.0f %7.2f %7.2f %7.0f %7.0f\n",
			(float)(nx.si[cpu].syscall - ox.si[cpu].syscall)/tdiff *HZ,
			(float)(nx.si[cpu].sysread - ox.si[cpu].sysread)/tdiff *HZ,
			(float)(nx.si[cpu].syswrite - ox.si[cpu].syswrite)/tdiff *HZ,
			cpu ? 0 : (float)(nx.si[cpu].sysfork - ox.si[cpu].sysfork)/tdiff *HZ,
			cpu ? 0 : (float)(nx.si[cpu].sysexec - ox.si[cpu].sysexec)/tdiff *HZ,
			cpu ? 0 : (float)(nx.si[cpu].readch - ox.si[cpu].readch)/tdiff * HZ,
			cpu ? 0 : (float)(nx.si[cpu].writech - ox.si[cpu].writech)/tdiff * HZ);

		ax.si[cpu].syscall += nx.si[cpu].syscall - ox.si[cpu].syscall;
		ax.si[cpu].sysread += nx.si[cpu].sysread - ox.si[cpu].sysread;
		ax.si[cpu].syswrite += nx.si[cpu].syswrite - ox.si[cpu].syswrite;
		ax.si[cpu].sysfork += (cpu ? 0 : nx.si[cpu].sysfork - ox.si[cpu].sysfork);
		ax.si[cpu].sysexec += (cpu ? 0 : nx.si[cpu].sysexec - ox.si[cpu].sysexec);
		ax.si[cpu].readch += (cpu ? 0 : nx.si[cpu].readch - ox.si[cpu].readch);
		ax.si[cpu].writech += (cpu ? 0 : nx.si[cpu].writech - ox.si[cpu].writech);
		break;
	case 'w':
		tsttab();
		printf(" %7.2f %7.1f %7.2f %7.1f %7.0f\n",
			(float)(nx.si[cpu].swapin - ox.si[cpu].swapin)/tdiff * HZ,
			(float)(nx.si[cpu].bswapin -ox.si[cpu].bswapin)/tdiff * HZ,
			(float)(nx.si[cpu].swapout - ox.si[cpu].swapout)/tdiff * HZ,
			(float)(nx.si[cpu].bswapout - ox.si[cpu].bswapout)/tdiff * HZ,
			(float)(nx.si[cpu].pswitch - ox.si[cpu].pswitch)/tdiff * HZ);

		ax.si[cpu].swapin += nx.si[cpu].swapin - ox.si[cpu].swapin;
		ax.si[cpu].swapout += nx.si[cpu].swapout - ox.si[cpu].swapout;
		ax.si[cpu].bswapin += nx.si[cpu].bswapin - ox.si[cpu].bswapin;
		ax.si[cpu].bswapout += nx.si[cpu].bswapout - ox.si[cpu].bswapout;
		ax.si[cpu].pswitch += nx.si[cpu].pswitch - ox.si[cpu].pswitch;
		break;
	case 'a':
		tsttab();
		printf(" %7.0f %7.0f %7.0f\n",
			(float)(nx.si[cpu].iget - ox.si[cpu].iget)/tdiff * HZ,
			(float)(nx.si[cpu].namei - ox.si[cpu].namei)/tdiff * HZ,
			(float)(nx.si[cpu].dirblk - ox.si[cpu].dirblk)/tdiff * HZ);

		ax.si[cpu].iget += nx.si[cpu].iget - ox.si[cpu].iget;
		ax.si[cpu].namei += nx.si[cpu].namei - ox.si[cpu].namei;
		ax.si[cpu].dirblk += nx.si[cpu].dirblk - ox.si[cpu].dirblk;
		break;
	case 'S':
		tsttab();
		if (cpu){ 	/* sw2 */
		printf("%11.0f %9.1f %9.0f ", a,b,c);
		printf("%9.1f %9.0f\n", a, b);
		}
		else {
		printf("%11.0f %9.1f %9.0f ",
			(float)(nx.di[cpu].nservers - ox.di[cpu].nservers) /
				tdiff * HZ,
			( ( ( nx.di[cpu].rcv_occ - ox.di[cpu].rcv_occ) /
				tdiff * HZ * 100.0) > 100) ? 100.0 :
				(float)(nx.di[cpu].rcv_occ - 
					ox.di[cpu].rcv_occ) / 
					tdiff * HZ * 100.0,
			(nx.di[cpu].rcv_occ - ox.di[cpu].rcv_occ <= 0) ? 
				0.0 : ((nx.di[cpu].rcv_que - 
				ox.di[cpu].rcv_que <= 0) ?
				0.0 : (float)(nx.di[cpu].rcv_que - 
				ox.di[cpu].rcv_que) /
				(float)(nx.di[cpu].rcv_occ - 
					ox.di[cpu].rcv_occ ) ) );
		printf("%9.1f %9.0f\n",
			( ( ( nx.di[cpu].srv_occ - ox.di[cpu].srv_occ ) /
				tdiff * HZ * 100.0) > 100) ? 100.0 :
				(float)(nx.di[cpu].srv_occ - 
				ox.di[cpu].srv_occ) / tdiff * HZ * 100.0,
			(nx.di[cpu].srv_occ - ox.di[cpu].srv_occ == 0 ) ? 
				0.0 : (float)(nx.di[cpu].srv_que - 
				ox.di[cpu].srv_que) /
				(float)(nx.di[cpu].srv_occ - 
				ox.di[cpu].srv_occ ) );
 
		}	

		if ( cpu ) {		/* sw2 */
		ax.di[cpu].nservers = ax.di[cpu].rcv_occ = 0;
		ax.di[cpu].rcv_que = ax.di[cpu].srv_occ = 0;
		ax.di[cpu].srv_que = 0;
		}
		else {
		ax.di[cpu].nservers += nx.di[cpu].nservers - ox.di[cpu].nservers;
		ax.di[cpu].rcv_occ += nx.di[cpu].rcv_occ - ox.di[cpu].rcv_occ;
		ax.di[cpu].rcv_que += nx.di[cpu].rcv_que - ox.di[cpu].rcv_que;
		ax.di[cpu].srv_occ += nx.di[cpu].srv_occ - ox.di[cpu].srv_occ;
		ax.di[cpu].srv_que += nx.di[cpu].srv_que - ox.di[cpu].srv_que;
		}
		break;
	case 'C':
		tsttab();
		if (cpu) {	/* sw2 */
		printf("%11.1f %11.1f %11.1f %11.1f %11.1f %11.1f\n",
				a,b,c,d,e,f);
		ax.rc[cpu].snd_dis = ax.rc[cpu].snd_msg = 0;
		ax.rc[cpu].rcv_dis = ax.rc[cpu].rcv_msg = 0;
		ax.rc[cpu].dis_bread = ax.rc[cpu].blk_inval = 0;
		}
		else {
		printf("%11.1f %11.1f %11.1f %11.1f %11.1f %11.1f\n",
			(float)(nx.rc[cpu].snd_dis - ox.rc[cpu].snd_dis) /
				tdiff * HZ,
			(float)(nx.rc[cpu].snd_msg - ox.rc[cpu].snd_msg) /
				tdiff * HZ,
			(float)(nx.rc[cpu].rcv_dis - ox.rc[cpu].rcv_dis) /
				tdiff * HZ,
			(float)(nx.rc[cpu].rcv_msg - ox.rc[cpu].rcv_msg) /
				tdiff * HZ,
			(float)(nx.rc[cpu].dis_bread - ox.rc[cpu].dis_bread) /
				tdiff * HZ,
			(float)(nx.rc[cpu].blk_inval - ox.rc[cpu].blk_inval) /
				tdiff * HZ );

		ax.rc[cpu].snd_dis += nx.rc[cpu].snd_dis - ox.rc[cpu].snd_dis;
		ax.rc[cpu].snd_msg += nx.rc[cpu].snd_msg - ox.rc[cpu].snd_msg;
		ax.rc[cpu].rcv_dis += nx.rc[cpu].rcv_dis - ox.rc[cpu].rcv_dis;
		ax.rc[cpu].rcv_msg += nx.rc[cpu].rcv_msg - ox.rc[cpu].rcv_msg;
		ax.rc[cpu].dis_bread += nx.rc[cpu].dis_bread - ox.rc[cpu].dis_bread;
		ax.rc[cpu].blk_inval += nx.rc[cpu].blk_inval - ox.rc[cpu].blk_inval;
		}
		break;

	
	case 'q':
		tsttab();
		if ((nx.si[cpu].runocc - ox.si[cpu].runocc) == 0)
			printf(" %7s %7s", "  ", "  ");
		else {
			printf(" %7.1f %7.0f",
			(float)(nx.si[cpu].runque -ox.si[cpu].runque)/
				(float)(nx.si[cpu].runocc - ox.si[cpu].runocc),
			LIMIT( ( (float)(nx.si[cpu].runocc -ox.si[cpu].runocc)/
				tdiff * HZ * 100.0 ) ) );	/* ca0 */
			ax.si[cpu].runque += nx.si[cpu].runque - ox.si[cpu].runque;
			ax.si[cpu].runocc += nx.si[cpu].runocc - ox.si[cpu].runocc;
		}
		if ( ( nx.si[cpu].swpocc - ox.si[cpu].swpocc ) == 0 )
			printf(" %7s %7s\n","  ","  ");
		else {
			printf(" %7.1f %7.0f\n",
			(float)(nx.si[cpu].swpque -ox.si[cpu].swpque)/
				(float)(nx.si[cpu].swpocc - ox.si[cpu].swpocc),
			LIMIT( ( (float)(nx.si[cpu].swpocc -ox.si[cpu].swpocc) /
				tdiff *HZ *100.0 ) ) );
			ax.si[cpu].swpque += nx.si[cpu].swpque - ox.si[cpu].swpque;
			ax.si[cpu].swpocc += nx.si[cpu].swpocc - ox.si[cpu].swpocc;

		}
		break;
	case 'm':
		tsttab();
		printf(" %7.2f %7.2f\n",
			(float)(nx.si[cpu].msg - ox.si[cpu].msg) / tdiff * HZ,
			(float)(nx.si[cpu].sema - ox.si[cpu].sema) / tdiff * HZ);

		ax.si[cpu].msg += nx.si[cpu].msg - ox.si[cpu].msg;
		ax.si[cpu].sema += nx.si[cpu].sema - ox.si[cpu].sema;
		break;

 	{
	unsigned long k0, k1, x;
	case 'r':
		tsttab();
		k1 = (nx.mi.freemem[1] - ox.mi.freemem[1]);
		if (nx.mi.freemem[0] >= ox.mi.freemem[0]) {
			k0 = nx.mi.freemem[0] - ox.mi.freemem[0]; 
		}
		else
		{ 	k0 = 1 + (~(ox.mi.freemem[0] - nx.mi.freemem[0]));
			k1--; 
		}
		printf(" %7.0f %7.0f\n",
			(double)(k0 + magic * k1) / tdiff, 
			(float)nx.mi.freeswap);

/*kd0*/
		x = zero;
		zero += k0;
		one += k1;
		if ( x > zero)
			one++;
		ax.mi.freeswap += nx.mi.freeswap;
		break;
 	}


	case 'p':
		tsttab();
		printf(" %7.2f %7.2f %7.2f %7.2f\n",
			(float)(nx.mi.vfault - ox.mi.vfault) / tdiff * HZ,
			(float)(nx.mi.pfault - ox.mi.pfault) / tdiff * HZ,
			(float)(nx.mi.file - ox.mi.file) / tdiff * HZ,
			(float)(nx.mi.freedpgs - ox.mi.freedpgs) / tdiff * HZ);
		ax.mi.vfault += nx.mi.vfault - ox.mi.vfault;
		ax.mi.pfault += nx.mi.pfault - ox.mi.pfault;
		ax.mi.file += nx.mi.file - ox.mi.file;
		ax.mi.freedpgs += nx.mi.freedpgs - ox.mi.freedpgs;
	}
	if(jj > 2)	printf("\n");
}

/**********************************************************/

/*      print average routine  */
prtavg()
{
	register int ii,kk;
	int	jj=0;
	char	ccc;
	float	temp1,temp2;		/* eb1 */
	float	a,b,c,d,e,f;		/* sw2 */

	a=b=c=d=e=f=0.0;
	tdiff = ax.si[cpu].cpu[0] + ax.si[cpu].cpu[1] + ax.si[cpu].cpu[2] + ax.si[cpu].cpu[3];
	if (nx.apstate)	
		tdiff = tdiff / 2;
	if (tdiff <= 0.0)
		return;
	printf("\n");

	while ( ( ccc = fopt[jj++] ) != NULL )
	switch( ccc ) {
	case 'u':
		if ( dflg ) {
			if ( nx.apstate )
				printf("Average  %7.0f %7.0f %7.0f %7.0f %7.0f\n",
					LIMIT( ( (float)ax.si[cpu].cpu[1] /
						(2 * tdiff) * 100.0 ) ),
					LIMIT( ( (float)(ax.si[cpu].cpu[2] - 
						ax.si[cpu].serve)/
						(2 * tdiff) * 100.0 ) ),
					LIMIT( ( (float)(ax.si[cpu].serve) /
						(2 * tdiff) * 100.0 ) ),
					LIMIT( ( (float)ax.si[cpu].cpu[3] / 
						(2 * tdiff) * 100.0 ) ),
					LIMIT( ( (float)ax.si[cpu].cpu[0] /
						(2 * tdiff) * 100.0 ) ) );
			else
				printf("Average  %7.0f %7.0f %7.0f %7.0f %7.0f\n",
					LIMIT( ( (float)ax.si[cpu].cpu[1] / 
						tdiff * 100.0 ) ),
					LIMIT( ( (float)(ax.si[cpu].cpu[2] - 
						ax.si[cpu].serve) / 
						tdiff * 100.0 ) ),
					LIMIT( ( (float)(ax.si[cpu].serve) /
						tdiff * 100.0 ) ),
					LIMIT( ( (float)ax.si[cpu].cpu[3] /
						tdiff * 100.0 ) ),
					LIMIT( ( (float)ax.si[cpu].cpu[0] /
						tdiff * 100.0 ) ) );
		break;
		}
		if ( nx.apstate )
			printf("Average  %7.0f %7.0f %7.0f %7.0f\n",
				LIMIT( ( (float)ax.si[cpu].cpu[1] /
					( 2 * tdiff ) * 100.0 ) ),
				LIMIT( ( (float)ax.si[cpu].cpu[2] /
					( 2 * tdiff ) * 100.0) ),
				LIMIT( ( (float)ax.si[cpu].cpu[3] /
					( 2 * tdiff ) * 100.0 ) ),
				LIMIT( ( (float)ax.si[cpu].cpu[0] /
					( 2 * tdiff ) * 100.0 ) ) );
		else
			printf("Average  %7.0f %7.0f %7.0f %7.0f\n",
				LIMIT( ( (float)ax.si[cpu].cpu[1] /
					tdiff * 100.0 ) ),
				LIMIT( ( (float)ax.si[cpu].cpu[2] /
					tdiff * 100.0 ) ),
				LIMIT( ( (float)ax.si[cpu].cpu[3] /
					tdiff * 100.0 ) ),
				LIMIT( ( (float)ax.si[cpu].cpu[0] /
					tdiff * 100.0 ) ) );
		break;
	case 'y':
		printf("Average  %7.0f %7.0f %7.0f %7.0f %7.0f %7.0f\n",
			(float)ax.si[cpu].rawch / tdiff *HZ,
			(float)ax.si[cpu].canch / tdiff *HZ,
			(float)ax.si[cpu].outch / tdiff *HZ,
			(float)ax.si[cpu].rcvint / tdiff *HZ,
			(float)ax.si[cpu].xmtint / tdiff *HZ,
			(float)ax.si[cpu].mdmint / tdiff *HZ);
		break;
	case 'b':
		if (dflg) {
			printf("Average\n   local  %4.0f %7.0f %7.0f %7.0f %7.0f %7.0f %7.0f %7.0f\n",
				(float)ax.si[cpu].bread / tdiff *HZ,
				(float)ax.si[cpu].lread / tdiff *HZ,
				LIMIT( ( (float)(ax.si[cpu].lread - 
					ax.si[cpu].bread) /
					(float)(ax.si[cpu].lread) * 100.0 ) ),
				(float)ax.si[cpu].bwrite / tdiff * HZ,
				(float)ax.si[cpu].lwrite / tdiff * HZ,
				LIMIT( ( (float)(ax.si[cpu].lwrite - 
					ax.si[cpu].bwrite) /
					(float)(ax.si[cpu].lwrite) * 100.0 ) ),
				(float)ax.si[cpu].phread / tdiff * HZ,
				(float)ax.si[cpu].phwrite / tdiff * HZ);
			if ( cpu ) {	/* sw2 */
			printf("   remote %4.0f %7.0f %7.0f %7.0f %7.0f %7.0f\n",
				a,b,c,d,e,f);
			}
			else {
			printf("   remote %4.0f %7.0f %7.0f %7.0f %7.0f %7.0f\n",
				(float)ax.rc[cpu].cbread / tdiff * HZ,
				(float)ax.rc[cpu].clread / tdiff * HZ,
				(float)(ax.rc[cpu].clread - ax.rc[cpu].cbread) /
				LIMIT( ( (float)(ax.rc[cpu].clread ? 
					(ax.rc[cpu].clread) : 1 ) * 100.0 ) ),
				(float)ax.rc[cpu].cbwrite / tdiff * HZ,
				(float)ax.rc[cpu].clwrite / tdiff * HZ,
				LIMIT( ( (float)(ax.rc[cpu].clwrite - 
					ax.rc[cpu].cbwrite)/
					(float)(ax.rc[cpu].clwrite ?
						(ax.rc[cpu].clwrite) :
						1 ) * 100.0 ) ) );
				}
				break;
		}
		printf("Average  %7.0f %7.0f %7.0f %7.0f %7.0f %7.0f %7.0f %7.0f\n",
			(float)ax.si[cpu].bread / tdiff * HZ,
			(float)ax.si[cpu].lread / tdiff * HZ,
			LIMIT( ( (float)(ax.si[cpu].lread - ax.si[cpu].bread) /
				(float)(ax.si[cpu].lread) * 100.0 ) ),
			(float)ax.si[cpu].bwrite / tdiff * HZ,
			(float)ax.si[cpu].lwrite / tdiff * HZ,
			LIMIT( ( (float)(ax.si[cpu].lwrite - 
				ax.si[cpu].bwrite) /
				(float)(ax.si[cpu].lwrite) * 100.0 ) ),
			(float)ax.si[cpu].phread / tdiff * HZ,
			(float)ax.si[cpu].phwrite / tdiff * HZ );
		break;
	case 'd':
		ii = 0;
		hz = HZ;
		printf("Average ");
		tabflg = 1;
		for ( j = 0; j < SINFO; j++ ) {
		    for ( kk = 0; kk < tblmap[j]; kk++ ) {
			if ( ( ax.devio[ii][0] > 0 )  &&
			   (ax.devio[ii][2] > 0 ) ) {
				tsttab();
				if ( j == DKS )
					printf( " %4s%-3d", devnm[j], kk );
				else
					printf( " %5s%-2d", devnm[j], kk );
/* sw1 */
				/* eb1 */
				temp1 = (float)(ax.devio[ii][2] >> 1 ) / 
					tdiff * 100.0;
				temp2 = (ax.devio[ii][3] - 
					( ax.devio[ii][2] >> 1 ) ) /
					(float)ax.devio[ii][0] / HZ * 1000.;
				printf(" %7.0f %7.1f %7.0f %7.0f %7.1f %7.1f\n",
					 (temp1 < 100.) ? temp1 : 100.,
					(float)ax.devio[ii][3] /
						(float)(ax.devio[ii][2] >> 1 ),
					(float)ax.devio[ii][0] / tdiff * HZ,
					(float)ax.devio[ii][1] / tdiff * HZ,
					(temp2 > 0.) ? temp2 : 1.,	/* eb1*/
					(float)(ax.devio[ii][2] >> 1 ) /
						(float)ax.devio[ii][0] / 
							HZ * 1000. );
			}
			ii++;
		    }
		}
		break;
	case 'v':
		break;
	case 'c':
		if (dflg) {
			if (cpu) { 	/* sw2 */
			Isyscall = Osyscall = 0;
			Lsyscall = (float)(ax.si[cpu].syscall / tdiff * HZ) -
					(Isyscall + Osyscall);

			Isysread = Osysread = 0;
			Lsysread = (float)(ax.si[cpu].sysread / tdiff * HZ) -
					(Isysread + Osysread);

			Isyswrite = Osyswrite = 0;
			Lsyswrite = (float)(ax.si[cpu].syswrite / tdiff * HZ) -
					(Isyswrite + Osyswrite);

			Isysexec = Osysexec = 0;
			Lsysexec = (float)(ax.si[cpu].sysexec / tdiff * HZ) -
					(Isysexec + Osysexec);

			Ireadch = Oreadch = 0;
			Lreadch = (float)(ax.si[cpu].readch / tdiff * HZ) -
					(Ireadch + Oreadch);

			Iwritech = Owritech = 0;
			Lwritech = (float)(ax.si[cpu].writech / tdiff * HZ) -
					(Iwritech + Owritech);
			}
			else {
			Isyscall = (float)(ax.di[cpu].isyscall / tdiff * HZ );
			Osyscall = (float)(ax.di[cpu].osyscall / tdiff * HZ );
			Lsyscall = (float)(ax.si[cpu].syscall / tdiff * HZ ) -
					(Isyscall + Osyscall);

			Isysread = (float)(ax.di[cpu].isysread / tdiff * HZ );
			Osysread = (float)(ax.di[cpu].osysread / tdiff * HZ );
			Lsysread = (float)(ax.si[cpu].sysread / tdiff * HZ ) -
					(Isysread + Osysread);

			Isyswrite = (float)(ax.di[cpu].isyswrite / tdiff * HZ );
			Osyswrite = (float)(ax.di[cpu].osyswrite / tdiff * HZ );
			Lsyswrite = (float)(ax.si[cpu].syswrite / tdiff * HZ ) -
					(Isyswrite + Osyswrite);

			Isysexec = (float)(ax.di[cpu].isysexec / tdiff * HZ );
			Osysexec = (float)(ax.di[cpu].osysexec / tdiff * HZ );
			Lsysexec = (float)(ax.si[cpu].sysexec / tdiff * HZ ) -
					(Isysexec + Osysexec);

			Ireadch = (float)(ax.di[cpu].ireadch / tdiff * HZ );
			Oreadch = (float)(ax.di[cpu].oreadch / tdiff * HZ );
			Lreadch = (float)(ax.si[cpu].readch / tdiff * HZ ) -
					(Ireadch + Oreadch);

			Iwritech = (float)(ax.di[cpu].iwritech / tdiff * HZ );
			Owritech = (float)(ax.di[cpu].owritech / tdiff * HZ );
			Lwritech = (float)(ax.si[cpu].writech / tdiff * HZ ) -
					(Iwritech + Owritech);
			}

			printf("Average\n%-8s %7.0f %7.0f %7.0f %7s %7.2f %7.0f %7.0f\n",
				"   in", Isyscall,Isysread,Isyswrite,"",Isysexec,
				Ireadch,Iwritech);
			printf("%-8s %7.0f %7.0f %7.0f %7s %7.2f %7.0f %7.0f\n",
				"   out",Osyscall,Osysread,Osyswrite,"",Osysexec,
				Oreadch,Owritech);
			printf("%-8s %7.0f %7.0f %7.0f %7.2f %7.2f %7.0f %7.0f\n",
				"   local", Lsyscall, Lsysread, Lsyswrite,
				(float)ax.si[cpu].sysfork / tdiff * HZ,
				Lsysexec, Lreadch, Lwritech);
			break;
		}

		printf("Average  %7.0f %7.0f %7.0f %7.2f %7.2f %7.0f %7.0f\n",
			(float)ax.si[cpu].syscall / tdiff * HZ,
			(float)ax.si[cpu].sysread / tdiff * HZ,
			(float)ax.si[cpu].syswrite / tdiff * HZ,
			(float)ax.si[cpu].sysfork / tdiff * HZ,
			(float)ax.si[cpu].sysexec / tdiff * HZ,
			(float)ax.si[cpu].readch / tdiff * HZ,
			(float)ax.si[cpu].writech / tdiff * HZ );
		break;
	case 'w':
		printf("Average  %7.2f %7.1f %7.2f %7.1f %7.0f\n",
			(float)ax.si[cpu].swapin / tdiff * HZ,
			(float)ax.si[cpu].bswapin / tdiff * HZ,
			(float)ax.si[cpu].swapout / tdiff * HZ,
			(float)ax.si[cpu].bswapout / tdiff * HZ,
			(float)ax.si[cpu].pswitch / tdiff * HZ);
		break;
	case 'a':
		printf("Average  %7.0f %7.0f %7.0f\n",
			(float)ax.si[cpu].iget / tdiff * HZ,
			(float)ax.si[cpu].namei / tdiff * HZ,
			(float)ax.si[cpu].dirblk / tdiff * HZ);
		break;
	case 'S':
		if (cpu)
		{ /* sw2 */
		printf("Average %11.0f %9.0f %9.0f %9.0f %9.0f\n",
			a,b,c,d,e);
		}
		else
		{
		printf("Average %11.0f %9.0f %9.0f %9.0f %9.0f\n",
			(float)ax.di[cpu].nservers / tdiff * HZ,
			((ax.di[cpu].rcv_occ / tdiff * HZ * 100.0) > 100) ? 
				100.0 : (float)ax.di[cpu].rcv_occ / 
				tdiff * HZ * 100.0,
			(ax.di[cpu].rcv_occ == 0) ? 0.0 :
				(float)ax.di[cpu].rcv_que / 
				(float)ax.di[cpu].rcv_occ,
			((ax.di[cpu].srv_occ / tdiff * HZ * 100.0) > 100) ? 
				100.0 : (float)ax.di[cpu].srv_occ / 
				tdiff * HZ * 100.0,
			(ax.di[cpu].srv_occ == 0 ) ? 0.0 :
				(float)ax.di[cpu].srv_que / 
				(float)ax.di[cpu].srv_occ );
		}
		break;
	case 'C':
		if (cpu) { /* sw2 */
		printf("Average %11.1f %11.1f %11.1f %11.1f %11.1f %11.1f\n",
			a,b,c,d,e,f);
		}
		else {
		printf("Average %11.1f %11.1f %11.1f %11.1f %11.1f %11.1f\n",
			(float)(ax.rc[cpu].snd_dis) / tdiff * HZ,
			(float)(ax.rc[cpu].snd_msg) / tdiff * HZ,
			(float)(ax.rc[cpu].rcv_dis) / tdiff * HZ,
			(float)(ax.rc[cpu].rcv_msg) / tdiff * HZ,
			(float)(ax.rc[cpu].dis_bread) / tdiff * HZ,
			(float)(ax.rc[cpu].blk_inval) / tdiff * HZ);
		}
		break;
	case 'q':
		if (ax.si[cpu].runocc == 0)
			printf("Average  %7s %7s ","  ","  ");
		else {
			printf( "Average  %7.1f %7.0f ",
			(float)ax.si[cpu].runque /
				(float)ax.si[cpu].runocc,
			LIMIT( ( (float)ax.si[cpu].runocc /
				tdiff * HZ * 100.0 ) ) );
		}
		if ( ax.si[cpu].swpocc == 0 )
			printf("%7s %7s\n","  ","  ");
		else {
			printf("%7.1f %7.0f\n",
			(float)ax.si[cpu].swpque/
				(float)ax.si[cpu].swpocc,
			LIMIT( ( (float)ax.si[cpu].swpocc/
				tdiff * HZ * 100.0 ) ) );

		}
		break;
	case 'm':
		printf("Average  %7.2f %7.2f\n",
			(float)ax.si[cpu].msg / tdiff * HZ,
			(float)ax.si[cpu].sema / tdiff * HZ );
		break;
	case 'r':
		printf("Average  %7.0f",
			(double)(zero + magic * one) / tdiff);	/*kd0*/
		if(rcnt > 2)
		  printf("%7.0f\n",(float)(ax.mi.freeswap) / ( rcnt - 2 ) );
		else printf("\n");
		break;
	case 'p':
		printf("Average  %7.2f %7.2f %7.2f %7.2f\n",
			(float)(ax.mi.vfault / tdiff * HZ),
			(float)(ax.mi.pfault / tdiff * HZ),
			(float)(ax.mi.file / tdiff * HZ),
			(float)(ax.mi.freedpgs / tdiff * HZ));
	}
}

/**********************************************************/

/*      error exit routines  */
pillarg()
{
	fprintf(stderr,"%s -- illegal argument for option  %c\n",
		optarg,cc);
	exit( 1 );
}

perrexit()
{
	perror("sar");
	exit( 1 );
}

pmsgexit(s)
char	*s;
{
	fprintf(stderr, "%s\n", s);
	exit( 1 );
}
