/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sadc.c: version 25.1 created on 12/2/91 at 16:54:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sadc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	AT&T: #ident	"sa:sadc.c	1.30.1.2"		*/

#ident	"@(#)sa:sadc.c	25.1"

/*	sadc.c 1.30.1.2 of 8/25/86  */
/*
	sadc.c - writes system activity binary data from /dev/kmem to a
		file or stdout.
	Usage: sadc [t n] [file]
		if t and n are not specified, it writes
		a dummy record to data file. This usage is
		particularly used at system booting.
		If t and n are specified, it writes system data n times to
		file every t seconds.
		In both cases, if file is not specified, it writes
		data to stdout.
*/
/* sw0 9/16/87 :  added support to report slave activity */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/ioctl.h>
#include <sys/immu.h>
#include <sys/stdio.h>
#include <sys/var.h>
#include <sys/iobuf.h>
#include <sys/stat.h>
#include <sys/elog.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/proc.h>
#include <sys/sysinfo.h>
#include <sys/fcntl.h>
#include <sys/flock.h>
#include "sa.h"

#ifdef S3000
#define SYSTEM "/arix"
#else
#define SYSTEM "/syst"
#endif                   /* JAS#1, 9/14/88 */

struct stat ubuf,syb;
struct var tbl;
struct syserr err;

int dkcnt, mtcnt;
int cpu_cnt;
struct iotime dk[NDSK];
struct iotime mt[NMTP];
struct sario sario;

struct sa d;
struct flckinfo flckinfo;
char *flnm = "/tmp/sa.adrfl";
char *loc;
static int fa = 0;
unsigned tblloc;
char *malloc();
static int tblmap[SINFO];
extern	time_t	 time();
int i,j,k;
static int recsz, tmpsz;
int fdsar;		/* file descriptor for /dev/sar */
long lseek();
int f;

main(argc, argv)
char **argv;
int argc;
{
	int ct;
	unsigned ti;
	int fp;
	long min;
	long rem;
	struct stat buf;
	char *fname;

	ct = argc >= 3? atoi(argv[2]): 0;
	min = time((long *) 0);
	ti = argc >= 3? atoi(argv[1]): 0;

/*	check if the address file is there and not older
	than /syst (SYSTEM), if so, read the offsets in.
	Otherwise, search /syst (SYSTEM) name list to get the offsets
	and create an address file for later usage.
	*/
	stat (SYSTEM, &syb);   		/* JAS#2, 9/13/88 */
	if ((stat(flnm,&ubuf) == -1) ||
		 (ubuf.st_mtime <= syb.st_ctime))
			goto creafl;
	fa = open(flnm,2);
	if (read(fa,setup,sizeof setup) != sizeof setup){
		close(fa);
		unlink(flnm);
creafl:
		i = umask(0);
		fa = open(flnm, O_RDWR|O_CREAT|O_TRUNC, 0664);
		umask(i);
		chown(flnm, 0, getegid());

/*		search name list to get offsets	*/

		nlist(SYSTEM, setup);   /* JAS#3, 9/13/88 */


/*		write offsets to address file	*/
		write(fa,setup,sizeof setup);
		close (fa);
	}
	if((fdsar = open("/dev/sar", 0)) == -1)
		perrexit("sadc");

/*	open /dev/kmem	*/
	if((f = open("/dev/kmem", 0)) == -1)
		perrexit("sadc");

/*	get number of disk drives on rl, ra, and general disk drivers.	*/
	if (setup[DKCNT].n_value != 0){
		lseek(f,(long)setup[DKCNT].n_value, 0);
		if (read(f,&dkcnt,sizeof dkcnt) == -1)
			perrexit("sadc");
	}else	dkcnt = 0;

	if (setup[MTCNT].n_value != 0){
		lseek(f,(long)setup[MTCNT].n_value, 0);
		if (read(f,&mtcnt,sizeof mtcnt) == -1)
			perrexit("sadc");
	}else	mtcnt = 0;

	if(!dkcnt && !mtcnt) {
		fprintf(stderr, "sadc: No disks or tapes defined\n");
		exit(2);
	}


/*	construct tblmap and compute record size	*/
	tblmap[DKS] = dkcnt;
	tblmap[MTS] = mtcnt;
	recsz = tblmap[DKS] + tblmap[MTS];
	recsz = sizeof(struct sa) - sizeof(d.devio) + recsz * sizeof d.devio[0];
	if (argc == 3 || argc == 1){

/*	no data file is specified, direct data to stdout	*/
		fp = 1;
		/*	write header record	*/
		write(fp,tblmap,sizeof tblmap);
	}
	else {
		fname = (argc==2)? argv[1]: argv[3];
		/*	check if the data file is there	*/
		/*	check if data file is too old	*/
		if ((stat(fname,&buf) == -1) ||
		 ((min - buf.st_mtime) > 86400) ||
		 (fp = open(fname,2)) == -1){
/*			data file does not exist:
			create one and write the header record.	*/
			if ((fp = creat(fname,00644)) == -1)
				perrexit("sadc");
			close(fp);
			fp = open (fname,2);
			lseek(fp,0L,0);
			write (fp,tblmap,sizeof tblmap);
		}
		else{

/*			data file exist:
			position the write pointer to the last good record.  */
			lseek(fp,-(long)((buf.st_size - sizeof tblmap) % recsz),2);
		}
	}
/*	Figure out how many cpu's are reporting data  sw0 */
	for(cpu_cnt=0;cpu_cnt<NCPU;cpu_cnt++){
		sario.cpu = cpu_cnt;
		sario.addr = (char *)&d.si[cpu_cnt];
		if(ioctl(fdsar, GET_SYSINFO, &sario) < 0)
			break;
	}

/*	if n =0 , write the additional dummy record	sw0  */
	if (ct == 0){
		for (j = 0; j < cpu_cnt; j++)
			d.si[j].cpu[0] = SYS_RESET;
		for (j = cpu_cnt; j < NCPU; j++)
			d.si[j].cpu[0] = NOT_ALIVE;
		d.ts = min;
		write(fp,&d,recsz);
	}

/*	get memory for tables	*/
	if(lseek(f,(long)setup[V].n_value,0) == -1)
		perrexit("sadc");
	if(read(f,&tbl,sizeof tbl) == -1)
		perrexit("sadc");
	if (tblloc < sizeof(struct inode)*tbl.v_inode)
		tblloc =sizeof(struct inode)*tbl.v_inode;
	if (tblloc < sizeof(struct file)*tbl.v_file)
		tblloc = sizeof (struct file)*tbl.v_file;
	if (tblloc < sizeof (struct proc)*tbl.v_proc)
		tblloc = sizeof (struct proc)*tbl.v_proc;
	
	loc = malloc(tblloc);
	if (loc == NULL){
		perrexit("sadc");
	}

	for(;;) {
/*		transfer gc info from gcmem to kmem */
		if(ioctl(fdsar, GC_GETSAR ,0) < 0)
			perrexit("sadc");

		for(k=0;k<cpu_cnt;k++){		/* sw0 */
			sario.cpu = k;
			sario.addr = (char *)&d.si[k];
			if(ioctl(fdsar, GET_SYSINFO, &sario) < 0)
				break;
			d.si[k].bswapin = ctod(d.si[k].bswapin);
			d.si[k].bswapout = ctod(d.si[k].bswapout);

			sario.addr = (char *)&d.serr[k];
			if(ioctl(fdsar, GET_SYSERR, &sario) < 0)
				perrexit("sadc");
		}
		/* flag remaining structures as not reporting data 	sw0 */
		for(k=cpu_cnt;k<NCPU;k++)
			d.si[k].cpu[0] = NOT_ALIVE;

/*		transfer hsdt info from hsdtmem to kmem */
		if(dkcnt) {
			if(ioctl(fdsar, DK_GETSAR ,0) < 0)
				perrexit("sadc");

			lseek(f,(long)setup[DKS].n_value,0);
			if (read(f,dk,sizeof(struct iotime)*dkcnt) == -1)
				perrexit("sadc");
		}
		if(mtcnt) {
			lseek(f,(long)setup[MTS].n_value,0);
			if (read(f,mt,sizeof(struct iotime)*mtcnt) == -1)
				perrexit("sadc");
		}
/*	Distributed Unix info	*/
		if (setup[DINFO].n_value != 0)  {
			lseek( f, (long)setup[DINFO].n_value, 0);
			if (read( f, d.di, sizeof d.di) == -1)
				perrexit("sadc");
		}
		if (setup[MINSERVE].n_value != 0)	{
			lseek( f, (long)setup[MINSERVE].n_value, 0);
			if (read( f, &d.minserve, sizeof d.minserve) == -1)
				perrexit("sadc");
		}
		if (setup[MAXSERVE].n_value != 0)	{
			lseek( f, (long)setup[MAXSERVE].n_value, 0);
			if (read( f, &d.maxserve, sizeof d.maxserve) == -1)
				perrexit("sadc");
		}
/*	Client Caching info	 */
		if (setup[RCINFO].n_value !=0) {
			lseek( f, (long)setup[RCINFO].n_value, 0);
			if (read( f, d.rc, sizeof d.rc) == -1)
				perrexit("sadc");
		}

/*	virtual memory	*/
		if (setup[MINFO].n_value != 0)	{
			lseek( f, (long)setup[MINFO].n_value, 0);
			if (read( f, &d.mi, sizeof d.mi) == -1)
				perrexit("sadc");
		}

/*		compute size of system table	*/
		d.szinode = inodetbl(loc);
		d.szfile = filetbl(loc);
		d.szproc = proctbl(loc);

/* file lock info		*/
		if ( setup[FLCK].n_value != 0 ) {
			lseek( f, (long) setup[FLCK].n_value, 0 );
			if (read(f, &flckinfo, sizeof(struct flckinfo)) == -1) {
				perrexit("sadc");
			}
		}
		/* record system table sizes */
		d.szlckr = flckinfo.reccnt;
		/* record maximum sizes of system tables */
		d.mszlckr = flckinfo.recs;

/*		record maximum sizes of system tables	*/
		d.mszinode = tbl.v_inode;
		d.mszfile = tbl.v_file;
		d.mszproc = tbl.v_proc;

		/*	get time stamp	*/
		d.ts = time ((long *) 0);
		i = 0;
		for(k=0;k<dkcnt;k++){		/* sw3 */
			d.devio[i][0] = dk[k].io_cnt;
			d.devio[i][1] = dk[k].io_bcnt;
			d.devio[i][2] = dk[k].io_act;
			d.devio[i][3] = dk[k].io_resp;
			i++;
		}
		for(k=0;k<mtcnt;k++){		/* sw3 */
			d.devio[i][0] = mt[k].io_cnt;
			d.devio[i][1] = mt[k].io_bcnt;
			d.devio[i][2] = mt[k].io_act;
			d.devio[i][3] = mt[k].io_resp;
			i++;
		}

/*	write data to data file from structure d	*/
		write(fp,&d,recsz);
		if(--ct > 0)
			sleep(ti);
		else {
			close(fp);
			exit(0);
		}
	}
}


inodetbl(x)
register struct inode *x;
{
	register i,n;
	lseek(f,(long)setup[INO].n_value,0);
	read(f,x,tbl.v_inode*sizeof(struct inode));

	for (i=n=0;i<tbl.v_inode;i++,x++)

		if (x->i_count != 0)
			n++;

	return(n);
}
filetbl(x)
register struct file *x;
{
	register i,n;
	lseek(f,(long)setup[FLE].n_value,0);
	read(f,x,tbl.v_file*sizeof(struct file));
	for (i=n=0;i<tbl.v_file; i++,x++)
		if (x->f_count != 0)
			n++;
	return(n);
}
proctbl(x)
register struct proc *x;
{
	register i,n;
	lseek(f,(long)setup[PRO].n_value,0);
	read (f,x,tbl.v_proc*sizeof(struct proc));
	for (i=n=0;i<tbl.v_proc;i++,x++)
		if(x->p_stat !=NULL)
			n++;
	return(n);
}

perrexit(s)
char *s;
{
	perror(s);
	exit(2);
}
