#	START NEW ARIX SCCS HEADER
#
#	@(#) sa.mk: version 25.1 created on 12/2/91 at 16:54:03
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)sa.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT:#ident	"sa:sa.mk	1.6.1.6"

#ident	"@(#)sa:sa.mk	25.1"

#/*	sa.mk 1.6.1.6 of 2/25/86	*/
#
# The sadc and sadp modules must be able to read /dev/kmem,
# which standardly has restricted read permission.
# They must have set-group-ID mode
# and have the same group as /dev/kmem.
# The chmod and chgrp commmands below ensure this.
#

IROOT =
SROOT =
include $(IROOT)/macdefs

INSDIR = $(ROOT)/usr/lib/sa
INSBIN = $(ROOT)/usr/bin
CRONDIR= $(ROOT)/usr/spool/cron/crontabs
CRONTAB= $(ROOT)/usr/spool/cron/crontabs/sys
ENTRY1= '0 * * * 0-6 /usr/lib/sa/sa1'
ENTRY2= '20,40 8-17 * * 1-5 /usr/lib/sa/sa1'
ENTRY3= '5 18 * * 1-5 /usr/lib/sa/sa2 -s 8:00 -e 18:01 -i 1200 -A'
INSMAINS= inssadc inssar inssa1 inssa2 insperf instimex inssag inssadp

all:	sadc sar sa1 sa2 perf timex sag

sadc: sadc.c sa.h 
	$(CC) -D$(MACH) $(CFLAGS) -o sadc sadc.c  $(LDFLAGS)

sar: sar.c sa.h
	$(CC) -D$(MACH) $(CFLAGS) -o sar sar.c $(LDFLAGS)

sa2: sa2.sh
	cp sa2.sh sa2

sa1: sa1.sh
	cp sa1.sh sa1
 
perf: perf.sh
	cp perf.sh perf

timex:	timex.o
	$(CC) -o timex timex.o $(LDFLAGS) 
timex.o:timex.c
	$(CC) -D$(MACH) $(CFLAGS) -c timex.c 

sag:	saga.o sagb.o
	$(CC) -D$(MACH) $(CFLAGS) -o sag saga.o sagb.o  $(LDFLAGS)

saga.o:	saga.c saghdr.h
	$(CC) -c $(CFLAGS) saga.c

sagb.o:	sagb.c saghdr.h
	$(CC) -c $(CFLAGS) sagb.c

sadp: sadp.c 
	$(CC) -D$(MACH) $(CFLAGS) -o sadp sadp.c $(LDFLAGS)

install: all Mkdir $(INSMAINS)

Mkdir:
	if [ ! -d $(INSDIR) ];\
	then	mkdir $(INSDIR);\
		chmod 775 $(INSDIR);\
		chown adm $(INSDIR);\
		chgrp bin $(INSDIR);\
	fi;

inssadc:
	$(INS) sadc $(INSDIR)/sadc
	chmod 2755 $(INSDIR)/sadc
	chgrp sys $(INSDIR)/sadc
	chown root $(INSDIR)/sadc

inssar:
	$(INS) sar $(INSBIN)/sar
	chmod 755 $(INSBIN)/sar
	chgrp bin $(INSBIN)/sar
	chown bin $(INSBIN)/sar

inssa2:
	$(INS) sa2 $(INSDIR)/sa2
	chmod 755 $(INSDIR)/sa2
	chgrp bin $(INSDIR)/sa2
	chown bin $(INSDIR)/sa2

inssa1:
	$(INS) sa1 $(INSDIR)/sa1
	chmod 755 $(INSDIR)/sa1
	chgrp bin $(INSDIR)/sa1
	chown bin $(INSDIR)/sa1

insperf:
	$(INS) perf $(ROOT)/etc/init.d/perf
	chmod 444 $(ROOT)/etc/init.d/perf
	chgrp sys $(ROOT)/etc/init.d/perf
	chown root $(ROOT)/etc/init.d/perf
	ln $(ROOT)/etc/init.d/perf $(ROOT)/etc/rc2.d/S21perf

instimex:
	$(INS) timex $(ROOT)/usr/bin/timex
	chmod 755 $(ROOT)/usr/bin/timex
	chgrp bin $(ROOT)/usr/bin/timex
	chown bin $(ROOT)/usr/bin/timex

inssag:
	$(INS) sag $(ROOT)/usr/bin/sag
	chmod 755 $(ROOT)/usr/bin/sag
	chgrp bin $(ROOT)/usr/bin/sag
	chown bin $(ROOT)/usr/bin/sag

inssadp:
	echo sadp: NOT YET SUPPORTED
#	$(INS) sadp $(ROOT)/usr/bin/sadp
#	chmod 2755 $(ROOT)/usr/bin/sadp
#	chgrp sys $(ROOT)/usr/bin/sadp
#	chown root $(ROOT)/usr/bin/sadp

clean:
	-rm -f *.o
 
clobber:	clean
		-rm -f sadc sar sa1 sa2 perf sag timex sadp

