#	START NEW ARIX SCCS HEADER
#
#	@(#) startday.sh: version 25.1 created on 12/2/91 at 16:53:33
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)startday.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#
# This shell script is to be run at the start of every working
# day to record the system configuration running that day, and
# the name of the system activity file for the current day.
# This file name is saved because the scripts that save this data
# for possible archival may not be run until the next day, and it
# is easier to save the name of the file, than to calculate the
# name of the previous days file.
#
# It is expected to have this script run by cron every morning,
# and to have standard output and standard error redirected to the
# file $_archivdir/sysconfig
#
# Before saving this data, move all of the previous days data to the
# "saved" directory.  This is where the "xxx" utility picks up data
# when archiving it to tape.

_archivdir=/usr/adm/archive
cd $_archivdir

# First, clear out the previous days "saved" files if they exist
rm -f saved/*

# The "safilename"  file is created by this script.  If it exists,
# and the file it points to exists, copy the file it points to, to
# the "saved" directory
if [ -r safilename -a -r `cat safilename` ] 
then cp `cat safilename` saved
fi

# "sysconfig" is the name of the file where the output of this script
# is expected to be written when run by cron every morning
if [ -r sysconfig ]
then mv sysconfig saved
fi

# The script /usr/lib/acct/runacct copies all pacct files here for
# us before processing them
if [ -r pacct1 ] 
then mv pacct* saved
fi

# The file "userload" contains the cumulative output from the script
# "userload" which is expected to be run every hour by cron
if [ -r userload ]
then mv userload saved
fi

# Generate todays "safilename" file
DATE=`date +%d`
SAFILE=/usr/adm/sa/sa$DATE
echo $SAFILE > safilename

#
# Now, generate the output for todays sysconfig file
#

echo "======================================================
=============== Hardware Configuration ===============
======================================================"
/etc/css
echo "======================================================
================ Kernel Configuration ================ 
======================================================"
/etc/sysdef
echo "======================================================
================= Disk Configuration ================= 
======================================================"
/etc/disks -p
echo "======================================================
============= File System Configuration ==============
======================================================"
/bin/df -t
