/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sar_print.c: version 25.2 created on 3/12/93 at 23:37:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sar_print.c	25.2	3/12/93 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <stdio.h>
#include <sys/param.h>
#include <time.h>
#include <sys/types.h>
#include <sys/sysinfo.h>
#include <sys/utsname.h>
#include <sys/fcntl.h>
#include <math.h>
#include "sa.h"
	
#define	MIN(A, B)	((A) < (B) ? (A) : (B))
#define	MAX(A, B)	((A) > (B) ? (A) : (B))
#define DIV(num, denom) (float)((denom) ? ((float)(num) / (float)(denom)) : 0)
#define	DELTA(field)	((uint)(new->field) - (uint)(old->field))
#define SEC		(tdiff / HZ)

extern int	rfs_flag;
extern sa_t 	nx,
		ox;
extern uint	tblmap[NIOTYPE];

static char *devnm[] = {
	"smd- ",
	"tape-",
	"scsi-",
	"dsdb-",
};
/*
 * io_scale defines the scaling factor for each of the values in devio
 */
static uint io_scale[NIOTYPE][4] = {
/*	cnt	bcnt	act	resp	*/
	1,	1,	100,	SPM_HZ,		/* smd */
	1,	1,	100,	SPM_HZ,		/* tape */
	1,	1,	100,	SPM_HZ,		/* scsi */
	1,	1,	78125,	78125,		/* dsdb */
};

extern  void	u_header(), y_header(), b_header(), d_header(), v_header(),
		c_header(), w_header(), a_header(), q_header(), m_header(), 
		r_header(), S_header(), C_header(), p_header(),
		u_print(), y_print(), b_print(), d_print(), v_print(), 
		c_print(), w_print(), a_print(), q_print(), m_print(), 
		r_print(), S_print(), C_print(), p_print();

static struct optfunc {
	char		option;
	void		(*header_func)();
	void		(*print_func)();
} optfunc[] = {
	'u', u_header, u_print,
	'y', y_header, y_print,
	'b', b_header, b_print,
	'd', d_header, d_print,
	'v', v_header, v_print,
	'c', c_header, c_print,
	'w', w_header, w_print,
	'a', a_header, a_print,
	'q', q_header, q_print,
	'm', m_header, m_print,
	'r', r_header, r_print,
	'S', S_header, S_print,
	'C', C_header, C_print,
	'p', p_header, p_print,
};

extern struct optfunc	*get_optfunc_p();

static uint	outlines;
static float	pdiff,		/* incremented by each processor each clock */
		tdiff;		/* pdiff/num_pms - time in HZ */
static sa_t	ax,
		zx;

prthdg(optlist)
char *optlist;
{
	char	*option;

	outlines = 0;
	ax = zx;			/* zero averages */

	printf("\n");

	prttim();

	for (option = optlist; *option; option++)
		(*(get_optfunc_p(*option)->header_func))();
}

prtopt(optlist)
char *optlist;
{
	int	time_i;
	char	*option;

	if (!get_tdiff(&nx, &ox, &ax))
		return;

	outlines++;
	ax.si.num_pms = nx.si.num_pms;

	prttim();

	for (option = optlist; *option; option++) {
		(*(get_optfunc_p(*option)->print_func))(&nx, &ox, &ax);
	}
}

prtavg(optlist)
char *optlist;
{
	char	*option;

	if (outlines < 2)
		return;

	if (!get_tdiff(&ax, &zx, NULL))
		return;

	for (option = optlist; *option; option++) {
		printf("\nAverage ");
		(*(get_optfunc_p(*option)->print_func))(&ax, &zx, NULL);
	}
}

prtname(time_stamp)
time_t time_stamp;
{
	struct utsname	name;
	struct tm	*tm_p;

	uname(&name);
	tm_p = localtime(&time_stamp);

	printf("\n%s %s %s %s %s    %.2d/%.2d/%.2d\n",
		name.sysname, name.nodename, name.release, name.version,
		name.machine, tm_p->tm_mon + 1, tm_p->tm_mday, tm_p->tm_year);
}

get_tdiff(new, old, avg)
sa_t	*new, *old, *avg;
{
	uint	time_i;

	pdiff = 0;

	for (time_i = CPU_IDLE; time_i <= CPU_SXBRK; time_i++) {
		pdiff += DELTA(si.cpu[time_i]);
		if (avg)
			avg->si.cpu[time_i] += DELTA(si.cpu[time_i]);
	}
	tdiff = pdiff / new->si.num_pms;

	return(tdiff > 0.0);
}

prttim()
{
	struct tm *tm_p = localtime(&nx.ts);

	printf("%.2d:%.2d:%.2d", tm_p->tm_hour, tm_p->tm_min, tm_p->tm_sec);
}

struct optfunc *
get_optfunc_p(option)
char option;
{
	struct optfunc *ofp;

	for (ofp = optfunc; ofp->option; ofp++)
		if (ofp->option == option)
			return(ofp);

	pmsgexit("internal error: get_optfunc_p failed to find option");
}

void
u_header()
{
	if (rfs_flag)
		printf(" %7s %7s %7s %7s %7s\n         %7s %7s %7s\n",
		       "%usr", "%sys", "%sys", "%wio", "%idle",
			"", "local", "remote");
	else
		printf(" %7s %7s %7s %7s\n", "%usr", "%sys", "%wio", "%idle");
}

void
u_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	if (!rfs_flag) {
		printf(" %7.f %7.f %7.f %7.f\n",
			MIN(1, DELTA(si.cpu[CPU_USER]) / pdiff) * 100.0,
			MIN(1, DELTA(si.cpu[CPU_KERNEL]) / pdiff) * 100.0,
			MIN(1, DELTA(si.cpu[CPU_WAIT]) / pdiff) * 100.0,
			MIN(1, DELTA(si.cpu[CPU_IDLE]) / pdiff) * 100.0);
		return;
	}
	printf(" %7.f %7.f %7.f %7.f %7.f\n",
		MIN(1, DELTA(si.cpu[CPU_USER]) / pdiff) * 100.0,
		MIN(1, (DELTA(si.cpu[CPU_KERNEL]) - DELTA(di.serve)) / pdiff)
			* 100.0,
		MIN(1, DELTA(di.serve) / pdiff) * 100.0,
		MIN(1, DELTA(si.cpu[CPU_WAIT]) / pdiff) * 100.0,	
		MIN(1, DELTA(si.cpu[CPU_IDLE]) / pdiff) * 100.0);

	if (avg)
		avg->di.serve += DELTA(di.serve);
}

void
y_header()
{
	printf(" %7s %7s %7s %7s %7s %7s\n", "rawch/s", "canch/s", 
		"outch/s", "rcvin/s", "xmtin/s", "mdmin/s");
}

void
y_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf(" %7.f %7.f %7.f %7.f %7.f %7.f\n",
		DELTA(si.rawch) / SEC, DELTA(si.canch) / SEC,
		DELTA(si.outch) / SEC, DELTA(si.rcvint) / SEC,
		DELTA(si.xmtint) / SEC, DELTA(si.mdmint) / SEC);

	if (!avg)
		return;

	avg->si.rawch += DELTA(si.rawch);
	avg->si.canch += DELTA(si.canch);
	avg->si.outch += DELTA(si.outch);
	avg->si.rcvint += DELTA(si.rcvint);
	avg->si.xmtint += DELTA(si.xmtint);
	avg->si.mdmint += DELTA(si.mdmint);
}

void
b_header()
{
	printf(" %7s %7s %7s %7s %7s %7s %7s %7s\n",
		"bread/s", "lread/s", "%rcache", "bwrit/s",
		"lwrit/s", "%wcache", "pread/s", "pwrit/s");
}

void
b_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	if (rfs_flag)
		printf("\n   local");

	printf(" %7.f %7.f %7.f %7.f %7.f %7.f %7.f %7.f\n",
		DELTA(si.bread) / SEC,
		DELTA(si.lread) / SEC,
		DIV(DELTA(si.lread) - DELTA(si.bread), DELTA(si.lread)) * 100.0,
		DELTA(si.bwrite) / SEC, 
		DELTA(si.lwrite) / SEC,
		DIV(DELTA(si.lwrite) - DELTA(si.bwrite), DELTA(si.lwrite)) 
			* 100.0,
		DELTA(si.phread) / SEC,
		DELTA(si.phwrite) / SEC);

	if (rfs_flag)
		printf("   remote %6.f %7.f %7.f %7.f %7.f %7.f \n",
			DELTA(rc.cbread) / SEC,
			DELTA(rc.clread) / SEC,
			DIV(DELTA(rc.clread) - DELTA(rc.cbread), 
				DELTA(rc.clread)) * 100.0,
			DELTA(rc.cbwrite) / SEC,
			DELTA(rc.clwrite) / SEC,
			DIV(DELTA(rc.clwrite) - DELTA(rc.cbwrite), 
				DELTA(rc.clwrite)) * 100.0);
	if (!avg)
		return;

	avg->si.bread += DELTA(si.bread);
	avg->si.bwrite += DELTA(si.bwrite);
	avg->si.lread += DELTA(si.lread);
	avg->si.lwrite += DELTA(si.lwrite);
	avg->si.phread += DELTA(si.phread);
	avg->si.phwrite += DELTA(si.phwrite);
	avg->rc.cbread += DELTA(rc.cbread);
	avg->rc.cbwrite += DELTA(rc.cbwrite);
	avg->rc.clread += DELTA(rc.clread);
	avg->rc.clwrite += DELTA(rc.clwrite);
}

void
d_header()
{
	printf(" %7s %7s %7s %7s %7s %7s %7s\n\n",
		"device", "%busy", "avque", "r+w/s",
		"blks/s", "avwait", "avserv");
}

void
d_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	float	scaled[4];	/* scaled deltas */
	uint 	devio_i = 0,
	 	io_type,
		dev_i,
		data_i;
	uint	n_printed = 0;

	for (io_type = 0; io_type < NIOTYPE; io_type++) {

		for (dev_i = 0; dev_i < tblmap[io_type]; dev_i++, devio_i++) {

			for (data_i = 0; data_i < 4; data_i++)
				scaled[data_i] = DELTA(devio[devio_i][data_i])
					/ (float)io_scale[io_type][data_i]
					/ SEC;

			if (scaled[IO_OPS] <= 0.0 || scaled[IO_ACT] <= 0.0)
				continue;

			if (n_printed++)
				printf("        ");

			printf("  %5s%-3d", devnm[io_type], dev_i);
			printf("%6.f %7.1f %7.f %7.f %7.1f %7.1f\n",
			  MIN(1, scaled[IO_ACT]) * 100.0,	/* %busy */
			  scaled[IO_RESP] / scaled[IO_ACT],	/* avque */
			  scaled[IO_OPS],			/* r+w/s */
			  scaled[IO_BCNT],			/* blks/s */
			  MAX(0, scaled[IO_RESP] - scaled[IO_ACT]) / 
			      scaled[IO_OPS] * 1000.0,		/* avwait */
			  scaled[IO_ACT] / scaled[IO_OPS] * 1000.0);/* avserv */

			if (avg)
				for (data_i = 0; data_i < 4; data_i++)
					avg->devio[devio_i][data_i] +=
						DELTA(devio[devio_i][data_i]);
		}
	}
	if (avg || !n_printed)
		printf("\n");
}

void
v_header()
{
	printf(" %s %s %s %s\n", 
		"proc-sz ov", "inod-sz ov", "file-sz ov", "lock-sz   ");
}

void
v_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	static char format[] = " %3d/%3d%3ld %3d/%3d%3ld %3d/%3d%3ld %3d/%3d\n";

	if (!avg) {
		printf(format, new->szproc / outlines, new->mszproc, 
			new->procovf / outlines,
			new->szinode / outlines, new->mszinode,
			new->inodeovf / outlines,
			new->szfile / outlines, new->mszfile, 
			new->fileovf / outlines,
			new->szlckr / outlines, new->mszlckr);
		return;
	}
	printf(format, new->szproc, new->mszproc, DELTA(procovf),
		new->szinode, new->mszinode, DELTA(inodeovf),
		new->szfile, new->mszfile, DELTA(fileovf),
		new->szlckr, new->mszlckr);

	avg->szproc += new->szproc;
	avg->szinode += new->szinode;
	avg->szfile += new->szfile;
	avg->szlckr += new->szlckr;
	avg->mszproc = new->mszproc;
	avg->mszinode = new->mszinode;
	avg->mszfile = new->mszfile;
	avg->mszlckr = new->mszlckr;
}

void
c_header()
{
	printf(" %7s %7s %7s %7s %7s %7s %7s\n",
		"scall/s", "sread/s", "swrit/s", "fork/s",
		"exec/s", "rchar/s", "wchar/s");
}

void
c_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	if (!rfs_flag) {
		printf(" %7.f %7.f %7.f %7.2f %7.2f %7.f %7.f\n",
			DELTA(si.syscall) / SEC,
			DELTA(si.sysread) / SEC,
			DELTA(si.syswrite) / SEC,
			DELTA(si.sysfork) / SEC,
			DELTA(si.sysexec) / SEC,
			DELTA(si.readch) / SEC,
			DELTA(si.writech) / SEC);
	} else {
		printf("\n   in    %7.f %7.f %7.f %7s %7.2f %7.f %7.f\n",
			DELTA(di.isyscall) / SEC,
			DELTA(di.isysread) / SEC,
			DELTA(di.isyswrite) / SEC,
			"",
			DELTA(di.isysexec) / SEC,
			DELTA(di.ireadch) / SEC,
			DELTA(di.iwritech) / SEC);
		printf("   out   %7.f %7.f %7.f %7s %7.2f %7.f %7.f\n",
			DELTA(di.osyscall) / SEC,
			DELTA(di.osysread) / SEC,
			DELTA(di.osyswrite) / SEC,
			"",
			DELTA(di.osysexec) / SEC,
			DELTA(di.oreadch) / SEC,
			DELTA(di.owritech) / SEC);
		printf("   local %7.f %7.f %7.f %7.2f %7.2f %7.f %7.f\n",
			(DELTA(si.syscall) - DELTA(di.isyscall) - 
				DELTA(di.osyscall)) / SEC,
			(DELTA(si.sysread) - DELTA(di.isysread) - 
				DELTA(di.osyscall)) / SEC,
			(DELTA(si.syswrite) - DELTA(di.isyswrite) -
				DELTA(di.osyswrite)) / SEC,
			DELTA(si.sysfork) / SEC, 
			(DELTA(si.sysexec) - DELTA(di.isysexec) - 
				DELTA(di.osysexec)) / SEC,
			(DELTA(si.readch) - DELTA(di.ireadch) - 
				DELTA(di.oreadch)) / SEC,
			(DELTA(si.writech) - DELTA(di.iwritech) -
				DELTA(di.owritech)) / SEC);
	}
	if (!avg)
		return;

	avg->si.syscall += DELTA(si.syscall);
	avg->si.sysread += DELTA(si.sysread);
	avg->si.syswrite += DELTA(si.syswrite);
	avg->si.sysfork += DELTA(si.sysfork);
	avg->si.sysexec += DELTA(si.sysexec);
	avg->si.readch += DELTA(si.readch);
	avg->si.writech += DELTA(si.writech);

	avg->di.isyscall += DELTA(di.isyscall);
	avg->di.osyscall += DELTA(di.osyscall);
	avg->di.isysread += DELTA(di.isysread);
	avg->di.osysread += DELTA(di.osysread);
	avg->di.isyswrite += DELTA(di.isyswrite);
	avg->di.osyswrite += DELTA(di.osyswrite);
	avg->di.isysexec += DELTA(di.isysexec);
	avg->di.osysexec += DELTA(di.osysexec);
	avg->di.ireadch += DELTA(di.ireadch);
	avg->di.oreadch += DELTA(di.oreadch);
	avg->di.iwritech += DELTA(di.iwritech);
	avg->di.owritech += DELTA(di.owritech);
}	

void
w_header()
{
	printf(" %7s %7s %7s %7s %7s\n",
		"swpin/s", "bswin/s", "swpot/s", "bswot/s", "pswch/s");
}

void
w_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf(" %7.2f %7.1f %7.2f %7.1f %7.f\n",
		DELTA(si.swapin) / SEC,
		DELTA(si.bswapin) / SEC,
		DELTA(si.swapout) / SEC,
		DELTA(si.bswapout) / SEC,
		DELTA(si.pswitch) / SEC);

	if (!avg)
		return;

	avg->si.swapin += DELTA(si.swapin);
	avg->si.swapout += DELTA(si.swapout);
	avg->si.bswapin += DELTA(si.bswapin);
	avg->si.bswapout += DELTA(si.bswapout);
	avg->si.pswitch += DELTA(si.pswitch);
}

void
a_header()
{
	printf(" %7s %7s %7s\n", "iget/s", "namei/s", "dirbk/s");
}

void
a_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf(" %7.f %7.f %7.f\n",
		DELTA(si.iget) / SEC,
		DELTA(si.namei) / SEC,
		DELTA(si.dirblk) / SEC);

	if (!avg)
		return;

	avg->si.iget += DELTA(si.iget);
	avg->si.namei += DELTA(si.namei);
	avg->si.dirblk += DELTA(si.dirblk);
}

void
q_header()
{
	printf(" %7s %7s %7s %7s\n",
		"runq-sz", "%runocc", "swpq-sz", "%swpocc");
}

void
q_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf(" %7.1f %7.f %7.1f %7.1f\n",
		DIV(DELTA(si.runque), DELTA(si.runocc)),
		MIN(1, DELTA(si.runocc) / SEC) * 100.0,
		DIV(DELTA(si.swpque), DELTA(si.swpocc)), 
		MIN(1, DELTA(si.swpocc) / SEC) * 100.0);

	if (!avg)
		return;

	avg->si.runque += DELTA(si.runque);
	avg->si.runocc += DELTA(si.runocc);
	avg->si.swpque += DELTA(si.swpque);
	avg->si.swpocc += DELTA(si.swpocc);
}

void
m_header()
{
	printf(" %7s %7s\n", "msg/s", "sema/s");
}

void
m_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf(" %7.2f %7.2f\n",
		DELTA(si.msg) / SEC,
		DELTA(si.sema) / SEC);

	if (!avg)
		return;

	avg->si.msg += DELTA(si.msg);
	avg->si.sema += DELTA(si.sema);
}

void
r_header()
{
	printf(" %7s %7s\n", "freemem", "freeswp");
}

void
r_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	static char	format[] = " %7.f %7.f\n";

	unsigned long	high_32,
			low_32,
			save_low;

	double result;

	if (!avg) {
		result = (double)new->mi.freemem[1] * pow(2.0, 32.0) +
			(double)new->mi.freemem[0];
		printf(format, result / (double) tdiff,
			(float)new->mi.freeswap / outlines);
		return;
	}

	low_32 = DELTA(mi.freemem[0]);
	high_32 = DELTA(mi.freemem[1]) -
		(new->mi.freemem[0] < old->mi.freemem[0]);
	result = (double)high_32 * pow(2.0, 32.0) + (double)low_32;

	printf(format, result / (double)tdiff, (float)new->mi.freeswap);

	save_low = avg->mi.freemem[0];
	avg->mi.freemem[0] += low_32;
	avg->mi.freemem[1] += high_32 + (avg->mi.freemem[0] < save_low);

	avg->mi.freeswap += new->mi.freeswap;
}

void
S_header()
{
	printf("%11s %9s %9s %9s %9s\n        ",
		"serv/lo-hi", "request", "request", "server", "server");
	printf("%5s %d %1s %d  %9s %9s %9s %9s\n",
		"", nx.minserve, "-", nx.maxserve, 
				"%busy ", "avg lgth", "%avail ", "avg avail");
}

void
S_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf("%11.f %9.1f %9.f %9.1f %9.f\n",
		DELTA(di.nservers) / SEC,
		MIN(1, DELTA(di.rcv_occ) / SEC) * 100.0,
		DIV(DELTA(di.rcv_que), DELTA(di.rcv_occ)),
		MIN(1, DELTA(di.srv_occ) / SEC) * 100.0,
		DIV(DELTA(di.srv_que), DELTA(di.srv_occ)));

	if (!avg)
		return;

	avg->di.nservers += DELTA(di.nservers);
	avg->di.rcv_occ += DELTA(di.rcv_occ);
	avg->di.rcv_que += DELTA(di.rcv_que);
	avg->di.srv_occ += DELTA(di.srv_occ);
	avg->di.srv_que += DELTA(di.srv_que);
}

void
C_header()
{
	printf(" %11s %11s %11s %11s %11s %11s\n",
		"snd-inv/s", "snd-msg/s", "rcv-inv/s",
		"rcv-msg/s", "dis-bread/s", "blk-inv/s");
}

void
C_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf("%11.1f %11.1f %11.1f %11.1f %11.1f %11.1f\n",
		DELTA(rc.snd_dis) / SEC,
		DELTA(rc.snd_msg) / SEC,
		DELTA(rc.rcv_dis) / SEC,
		DELTA(rc.rcv_msg) / SEC,
		DELTA(rc.dis_bread) / SEC,
		DELTA(rc.blk_inval) / SEC);

	if (!avg)
		return;

	avg->rc.snd_dis += DELTA(rc.snd_dis);
	avg->rc.snd_msg += DELTA(rc.snd_msg);
	avg->rc.rcv_dis += DELTA(rc.rcv_dis);
	avg->rc.rcv_msg += DELTA(rc.rcv_msg);
	avg->rc.dis_bread += DELTA(rc.dis_bread);
	avg->rc.blk_inval += DELTA(rc.blk_inval);
}

void
p_header()
{
	printf(" %7s %7s %7s %7s\n", "vflt/s", "pflt/s", "pgfil/s", "rclm/s");
}

void
p_print(new, old, avg)
sa_t	*new, *old, *avg;
{
	printf(" %7.2f %7.2f %7.2f %7.2f\n",
		DELTA(mi.vfault) / SEC,
		DELTA(mi.pfault) / SEC,
		DELTA(mi.file) / SEC,
		DELTA(mi.freedpgs) / SEC);

	if (!avg)
		return;

	avg->mi.vfault += DELTA(mi.vfault);
	avg->mi.pfault += DELTA(mi.pfault);
	avg->mi.file += DELTA(mi.file);
	avg->mi.freedpgs += DELTA(mi.freedpgs);
}
