/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sar.c: version 25.1 created on 12/2/91 at 16:53:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sar.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	sar.c 1.28 of 6/26/86	*/
/*
	sar.c - It generates a report either from an input data file or
		by invoking sadc to read system activity counters 
		at the specified intervals.
	usage: sar [-ubdycwaqvmpr] [-o file] t [n]    or
	       sar [-ubdycwaqvmpr][-s hh:mm][-e hh:mm][-i ss][-f file]
*/
#include <stdio.h>
#include <sys/param.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <sys/sysinfo.h>
#include <sys/fcntl.h>
#include "sa.h"

#define	VALID_SA(sa)		((sa).si.cpu[CPU_IDLE] > 0)
#define RESET_SA(sa)		((sa).si.cpu[CPU_IDLE] == SYS_RESET)
#define	SA_INVALIDATE(sa)	((sa).si.cpu[CPU_IDLE] = 0)

#pragma strwrite	/* Needed only if compiled with ANSI compiler.     */
			/* strwrite allows for writing of string literals. */

struct sa 	nx, ox;
uint		tblmap[NIOTYPE];
uint		rfs_flag;

static uint	recsz;
static uint	start_time,
		end_time,
		interval_secs;
static int	in_fd,
		out_fd;

main(argc, argv)
char	*argv[];
int	argc;
{
	uint	realtime;
	uint	opt_num;
	char	opt_list[15],
		*option = " ";

	realtime = parse_args(argc, argv, opt_list);

	/*
	 * read the header record and compute record size
	 */
	get_tblmap();

	if (realtime)
		prpass(opt_list);
	else 
		for (opt_num = 0; *option = opt_list[opt_num]; opt_num++) {
			lseek(in_fd, sizeof(tblmap), 0);
			prpass(option);
		}
	exit(0);
}

prpass(optlist)
char 	optlist[];
{
	static uint	pass_0 = 1;

	if (!get_new_rec(pass_0, 1))
		pmsgexit("no valid records in data file");

	if (pass_0)
		prtname(nx.ts);

	prthdg(optlist);

	do {
		if (RESET_SA(nx)) {
			prttim();
			printf("\tarix restarts\n");
		} 
		else if (VALID_SA(ox)) {
			sanity_check();
			prtopt(optlist);
		}
	} while (get_new_rec(pass_0, 0));

	prtavg(optlist);

	if (pass_0)
		pass_0 = 0;
}

get_new_rec(pass_0, rec_0)
uint	pass_0;
uint	rec_0;
{
	static uint	next_rec_time;
	uint		rec_time;

	ox = nx;

	if (rec_0 && start_time)
		next_rec_time = start_time;

	do {
		if (read(in_fd, &nx, recsz) != recsz) {
			SA_INVALIDATE(nx);
			return(0);
		}
		if (out_fd && pass_0)
			write(out_fd, &nx, recsz);

		rec_time = tm_daysec(localtime(&nx.ts));

		if (end_time && rec_time > end_time) {
			SA_INVALIDATE(nx);
			return(0);
		}

	} while (rec_time < start_time || rec_time < next_rec_time);

	if (interval_secs)
		next_rec_time = rec_time + interval_secs;

	return(1);
}

parse_args(argc, argv, options)
int	argc;
char	*argv[];
char	options[];
{
	extern  int	optind;
	extern  char	*optarg;

	char		opt;
	uint		n_args;
	char		infile[STRSIZE],
			*outfile = NULL;
	uint		realtime;

	/*
	 * process options with arguments and pack options without arguments
	 */
	while ((opt = getopt(argc, argv, "uybdvcwaqmprACDSo:s:e:i:f:")) != EOF)

		switch (opt) {
		case 'D':
			rfs_flag++;
			break;
		case 'o':
			outfile = optarg;
			break;
		case 's':
			start_time = get_time_arg(optarg);
			break;
		case 'e':
			end_time = get_time_arg(optarg);
			break;
		case 'i':
			interval_secs = atoi_check(optarg);
			break;
		case 'f':
			strcpy(infile, optarg);
			break;
		case '?':
			usage();
			break;
		default:
			strncat(options, &opt, 1);
			break;
		}

	if (start_time && end_time && end_time <= start_time)
		pmsgexit("error : end_time <= start_time");

	/*
	 * 'u' is the default option, 'A' means all options.
	 */
	if (!strlen(options))
		strcpy(options, "u");

	else if (strchr(options, 'A')) {
		strcpy(options, "udqbwcayvmprCS");
		rfs_flag++;
	}
	else if (rfs_flag && !strpbrk(options, "ubc"))
		strcat(options,"u");

	n_args = argc - optind;

	if (n_args > 2)
		usage();

	if (n_args) {		/* sar [-ubdycwaqvmprACDS][-o file] t [n] */

		if (*infile || start_time || end_time || interval_secs)
			usage();

		in_fd = open_sadc_pipe(&argv[optind], n_args);

		realtime = 1;

	} else  {
		if (outfile)
			usage();

		in_fd = open_data_file(infile);

		realtime = 0; 
	}

	if (outfile && (out_fd = creat(outfile, 0644)) < 0)
		perrexit("cannot create output file %s", outfile);

	return(realtime);
}

open_sadc_pipe(args, arg_count)
char	*args[];
uint	arg_count;
{
	FILE	*fp;
	char	cmd[STRSIZE];
	uint	count,
		interval;

	interval = atoi_check(args[0]);

	if (arg_count == 1)
		count = 2;
	else
		count = atoi_check(args[1]) + 1;

	if (interval < 1 || count < 2)
		pmsgexit("bad realtime data args : t = %d, n = %d",
			count, interval);

	sprintf(cmd, "/usr/lib/sa/sadc %d %d", interval, count);

	if (!(fp = popen(cmd, "r")))
		perrexit("popen failed");

	return(fileno(fp));
}

open_data_file(infile)
char infile[];
{
	struct tm 	*tm_p;
	time_t		time_tmp;
	int		fd;
	
	if (!*infile) {
		time_tmp = time((long *)0);
		tm_p = localtime(&time_tmp);
		sprintf(infile, "/usr/adm/sa/sa%.2d", tm_p->tm_mday);
	}

	if ((fd = open(infile, O_RDONLY)) < 0)
		perrexit("can't open input file %s", infile);

	return(fd);
}


tm_daysec(tm)
struct tm *tm; 
{
	return(tm->tm_hour * 3600 + tm->tm_min * 60 + tm->tm_sec);
}

get_tblmap()
{
	if (read(in_fd, tblmap, sizeof(tblmap)) < 0)
		perrexit("error reading data file header");

	if (out_fd)
		if (write(out_fd, tblmap, sizeof(tblmap)) < 0)
			perrexit("error writing output file");

	recsz = sizeof(nx) - sizeof(nx.devio) + sizeof(nx.devio[0]) *
		(tblmap[0] + tblmap[1] + tblmap[2] + tblmap[3]);
}

atoi_check(str)
char *str;
{
	uint	val;
	char	*cp;

	val = strtol(str, &cp, 10);

	if (*cp) {	/* character terminating scan was not \0 */
		fprintf(stderr, "sar: invalid integer argument \"%s\"\n\n",
			str);
		usage();
	}
	return(val);
}
	
sanity_check()
{
	if (nx.si.num_pms < 1 || nx.si.num_pms > MAX_PMS ||
		nx.si.num_pms != ox.si.num_pms ||
		nx.mszinode != ox.mszinode ||
		nx.mszfile != ox.mszfile ||
		nx.mszproc != ox.mszproc ||
		nx.mszlckf != ox.mszlckf ||
		nx.mszlckr != ox.mszlckr ||
		nx.ts < ox.ts )

		pmsgexit("invalid record in data - aborting");
}

get_time_arg(str)
char *str;
{
	struct tm	tm;

	switch (sscanf(str, "%d:%d:%d", &tm.tm_hour, &tm.tm_min, &tm.tm_sec)) {
	case 2:
		tm.tm_sec = 0;
	case 3:
		if (tm.tm_hour < 24 && tm.tm_min < 60 && tm.tm_sec < 60)
			break;
	default:
		pmsgexit("bad time conversion of \"%s\" - format hh:mm[:ss]", 
			str);
	}
	return(tm_daysec(&tm));
}


usage()
{
	fprintf(stderr,"Usage: sar [-ubdycwaqvmprACDS][-o file] t [n]\n");
	fprintf(stderr,"       sar [-ubdycwaqvmprACDS][-s hh:mm:ss]");
	fprintf(stderr,"[-e hh:mm:ss][-i ss][-f file]\n");
	exit(2);
}

perrexit(str, arg1, arg2, arg3)
char *str;
{
	static	char	fmtstr[STRSIZE];
	static	char	perrstr[STRSIZE];

	sprintf(fmtstr, "\nsar: %s", str);
	sprintf(perrstr, fmtstr, arg1, arg2, arg3);
	perror(perrstr);
	exit(1);
}

pmsgexit(str, arg1, arg2, arg3)
char	*str;
{
	fprintf(stderr, "\nsar: ");
	fprintf(stderr, str, arg1, arg2, arg3);
	fprintf(stderr, "\n");
	exit(1);
}
