/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sadc.c: version 25.1 created on 12/2/91 at 16:52:54	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sadc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	AT&T: #ident	"sa:sadc.c	1.30.1.2"		*/


/*	sadc.c 1.30.1.2 of 8/25/86  */
/*
	sadc.c - writes system activity binary data from /dev/kmem to a
		file or stdout.
	Usage: sadc [t n] [file]
		if t and n are not specified, it writes
		a dummy record to data file. This usage is
		particularly used at system booting.
		If t and n are specified, it writes system data n times to
		file every t seconds.
		In both cases, if file is not specified, it writes
		data to stdout.
*/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/ioctl.h>
#include <sys/immu.h>
#include <sys/var.h>
#include <sys/iobuf.h>
#include <sys/stat.h>
#include <sys/elog.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/proc.h>
#include <sys/sysinfo.h>
#include <sys/fcntl.h>
#include <sys/flock.h>
#include <sys/kmem.h>
#include <stdio.h>
#include <unistd.h>
#include <dirent.h>
#include "sa.h"
#include "sadc.h"

#define		ADDR_FILE	"/usr/adm/sa/sa.adrfl"
#define		KERNEL		"/arix"

#define		DSDB_INIT	0
#define		DSDB_GETSAR	1

/*
 * MAXEQ - analagous to += 
 */
#define		MAXEQ(lhs, rhs)  ((lhs) >= (rhs) ? (lhs) : ((lhs) = (rhs)))

extern char	*malloc();
extern time_t	time();

static uint	tblmap[NIOTYPE];

main(argc, argv)
int 	argc;
char 	*argv[];
{
	uint 		sample_count;
	unsigned	sample_interval;
	char		*ofile;
	int		outfd;
	uint		recsz;
	char		*table_buf;
	uint		table_buf_size;
	sa_t		sa;
	struct var	var;
	struct flckinfo flckinfo;

	parse_args(argc, argv, &sample_count, &sample_interval, &ofile);

	get_setup();

	build_tblmap();

	recsz = sizeof(sa_t) - sizeof(sa.devio) + sizeof(sa.devio[0]) *
	     (tblmap[DSDBS]);

	outfd = setup_ofile(ofile, recsz);

	if (sample_count == 0) {
		sa.si.cpu[CPU_IDLE] = SYS_RESET;
		sa.ts = time((long *)0);
		if (write(outfd, &sa, recsz) < 0)
			perrexit("sadc");
		sample_count = 1;
	}

	kmem_get(V, &var, sizeof(var));

	sa.mszinode = var.v_inode;
	sa.mszfile = var.v_file;
	sa.mszproc = var.v_proc;

	table_buf_size = var.v_inode * sizeof(struct inode);
	MAXEQ(table_buf_size, var.v_file * sizeof(struct file));
	MAXEQ(table_buf_size, var.v_proc * sizeof(struct proc));

	if (!(table_buf = malloc(table_buf_size)))
		perrexit("sadc: error mallocing system table buffer");

	/*
	 * The sleep here is necessary to synchronize the process with
	 * the 1 second clock.  If we don't sleep(), the interval between
	 * the first and second data record is not guaranteed to be 
	 * interval_secs.
	 */
	sleep(1);

	do {
		sar_ioctl(GET_SYSINFO, &sa.si);
		kmem_get(DINFO, &sa.di, sizeof(sa.di));
		kmem_get(MINSERVE, &sa.minserve, sizeof(sa.minserve));
		kmem_get(MAXSERVE, &sa.maxserve, sizeof(sa.maxserve));
		kmem_get(RCINFO, &sa.rc, sizeof(sa.rc));
		kmem_get(MINFO, &sa.mi, sizeof(sa.mi));
		kmem_get(FLCK, &flckinfo, sizeof(struct flckinfo)); 

		get_devio(sa.devio);

		sa.ts 		= time((long *)0);
		sa.si.bswapin 	= ctod(sa.si.bswapin);
		sa.si.bswapout 	= ctod(sa.si.bswapout);
		sa.szlckr	= flckinfo.reccnt;
		sa.mszlckr	= flckinfo.recs;
		sa.szinode	= inodetbl(var.v_inode, table_buf);
		sa.szfile	= filetbl(var.v_file, table_buf);
		sa.szproc	= proctbl(var.v_proc, table_buf);

		write(outfd, &sa, recsz);

		sleep(sample_interval);

	} while (--sample_count > 0);

	close(outfd);
	exit(0);
}

parse_args(argc, argv, countp, intervalp, ofilep)
int	argc;
char	*argv[];
int	*countp;
uint	*intervalp;
char	**ofilep;
{
	switch (argc) {		
	case 2:				/* sadc filename */
		*countp = 0;
		*intervalp = 0;
		*ofilep = argv[1];
		break;
	case 3: 			/* sadc t n */
	case 4:				/* sadc t n filename */
		*intervalp = atoi(argv[1]);
		*countp = atoi(argv[2]);
		*ofilep = (argc == 3) ? "" : argv[3];
		break;
	default:
		pmsgexit("Usage: sadc [t n] [ofile]");
		break;
	}
}

/*
 * get_setup: if the address file (/usr/adm/sa/sa.adrfl) exists and is not 
 * older than the kernel, read the existing file into the setup structure.  
 * If it doesn't exist or is not complete, get the namelist from the kernel 
 * and create a new address file.
 */
get_setup()
{
	struct stat 	abuf,
			kbuf;
	int		fd;
	mode_t		savemask;

	if (stat(KERNEL, &kbuf) < 0)
		perrexit("sadc: error attempting stat of %s", KERNEL);

	if (stat(ADDR_FILE, &abuf) >= 0) {

		if (abuf.st_mtime > kbuf.st_ctime) {

			if ((fd = open(ADDR_FILE, O_RDWR)) < 0)
				perrexit("sadc: error opening %s", ADDR_FILE);

			if (get_setup_from_file(fd))
				return;

			if (close(fd) < 0)
				perrexit("sadc: error closing %s", ADDR_FILE);
		}
		if (unlink(ADDR_FILE) < 0)
			perrexit("sadc: error unlinking %s", ADDR_FILE);
	}

	savemask = umask(0);

	if ((fd = open(ADDR_FILE, O_RDWR|O_CREAT, 0664)) < 0)
		perrexit("sadc: error creating %s", ADDR_FILE);

	umask(savemask);

	if (nlist(KERNEL, setup) < 0)
		perrexit("sadc: %s nlist error", KERNEL);

	if (write(fd, setup, sizeof(setup)) < 0)
		perrexit("sadc: error writing %s", ADDR_FILE);

	if (close(fd) < 0)
		perrexit("sadc: error closing %s", ADDR_FILE);
}

get_setup_from_file(fd)
int	fd;
{
	struct nlist	tmp_setup[NUM_SYMS];
	uint		sym;

	if (read(fd, tmp_setup, sizeof(tmp_setup)) == sizeof(tmp_setup))
		return(0);

	for (sym = 0; sym < NUM_SYMS; sym++) {

		if ((uint)tmp_setup[sym].n_name != (uint)setup[sym].n_name)
			return(0);

		setup[sym] = tmp_setup[sym];
	}

	return(1);
}

/*
 * setup_ofile: if no filename specified, use stdout.  If file doesn't exist 
 * or is too old, create a new one.  either way, write header record (tblmap).
 * Otherwise (file exists and is usable), position write pointer after last
 * good record.
 */
setup_ofile(ofile, recsz)
char	*ofile;
uint	recsz;
{
	struct stat 	buf;
	uint		min = time((long *)0);
	int		outfd;

	if (!*ofile)
		outfd = fileno(stdout);

	else if (stat(ofile, &buf) < 0 || (min - buf.st_mtime) > 86400 ||
		(buf.st_size < sizeof(tblmap) + recsz)) {

		if ((outfd = open(ofile, O_RDWR | O_CREAT, 0644)) < 0)
			perrexit("sadc: error creating %s", ofile);
	} else {
		if ((outfd = open(ofile, O_RDWR)) < 0)
			perrexit("sadc: error opening %s", ofile);

		if (lseek(outfd, -((buf.st_size - sizeof(tblmap)) % recsz),
				SEEK_END) < 0)
			perrexit("sadc: lseek in %s", ofile);

		return(outfd);
	}

	if (write(outfd, tblmap, sizeof(tblmap)) < 0)
		perrexit("sadc: error writing header to data file");

	return(outfd);
}

build_tblmap()
{
	tblmap[DSDBS] = dsdb_ctl(DSDB_INIT, 0);

	if (!tblmap[DSDBS])
		pmsgexit("sadc: No disks or tapes defined");
}

inodetbl(table_size, inodep)
uint			table_size;
register struct inode	*inodep;
{
	register uint	index;
	register uint	n_inodes = 0;

	kmem_get(INO, inodep, table_size * sizeof(struct inode)); 

	for (index = 0; index < table_size; index++, inodep++)
		if (inodep->i_count != 0)
			n_inodes++;

	return(n_inodes);
}

filetbl(table_size, filep)
uint			table_size;
register struct file 	*filep;
{
	register uint	index;
	register uint	n_files = 0;

	kmem_get(FLE, filep, table_size * sizeof(struct file));

	for (index = 0; index < table_size; index++, filep++)
		if (filep->f_count != 0)
			n_files++;

	return(n_files);
}

proctbl(table_size, procp)
uint			table_size;
register struct proc	*procp;
{
	register uint	index;
	register uint	n_procs = 0;

	kmem_get(PRO, procp, table_size * sizeof(struct proc)); 

	for (index = 0; index < table_size; index++, procp++)
		if (procp->p_stat != NULL)
			n_procs++;

	return(n_procs);
}

get_devio(devio)
uint 		devio[][5];
{
	static struct iotime	dsdb[NDSDB];
	register uint		devi;
	register uint		devio_i = 0;

	dsdb_ctl(DSDB_GETSAR, dsdb);

	for (devi = 0; devi < tblmap[DSDBS]; devi++)
		iotime_to_devio(devio[devio_i++], &dsdb[devi]); 
}

iotime_to_devio(deviop, iotp)
register uint		*deviop;
register struct iotime	*iotp;
{
	deviop[0] = iotp->io_cnt;
	deviop[1] = iotp->io_bcnt;
	deviop[2] = iotp->io_act;
	deviop[3] = iotp->io_resp;
}

dsdb_ctl(cmd, arg)
uint	cmd;
char	*arg;
{
	static int	dsdb_fd[MAX_DSDB + 1];
	static uint	dsdbcnt;
	uint 		dsdb_num;
	char 		dsdb_name[MAXNAMLEN];
	struct iotime	*dsdbp;

	switch (cmd) {
	case DSDB_INIT:
		for (dsdb_num = 0; dsdb_num < MAX_DSDB; dsdb_num++) {
			sprintf(dsdb_name,"/dev/dsdb_sar/c%d", dsdb_num);
			dsdb_fd[dsdb_num] = open(dsdb_name, O_RDONLY);
			if (dsdb_fd[dsdb_num] < 0)
				break;
			dsdbcnt += 16;
		}
		dsdb_fd[dsdb_num] = -1;
		break;

	case DSDB_GETSAR:
		dsdbp = (struct iotime *)arg;
		for (dsdb_num = 0; dsdb_fd[dsdb_num] >= 0; dsdb_num++) {
			lseek(dsdb_fd[dsdb_num], 0L, 0);
			if (read(dsdb_fd[dsdb_num], dsdbp,
					sizeof(struct iotime) * 16) < 0)
				perrexit("sadc: error reading dsdb iotime");
			dsdbp += 16;
		}
		break;
	}
	return(dsdbcnt);
}

kmem_get(setup_index, buf, size)
uint	setup_index;
char	*buf;
uint	size;
{
	static int	kmem_fd;

	if (!kmem_fd && (kmem_fd = open("/dev/kmem", O_RDONLY)) < 0)
		perrexit("sadc: error opening /dev/kmem");

	if (!setup[setup_index].n_value)
		return(0);

	if (lseek(kmem_fd, kv_to_kmem((uint)setup[setup_index].n_value), 0) < 0)
		perrexit("sadc: error seeking in /dev/kmem");

	if (read(kmem_fd, buf, size) < 0)
		perrexit("sadc: error reading in /dev/kmem");

	return(1);
}

sar_ioctl(cmd, addr)
uint	cmd;
char	*addr;
{
	static int fdsar;

	if (!fdsar && (fdsar = open("/dev/sar", 0)) < 0)
		perrexit("sadc: error opening /dev/sar");

	if (ioctl(fdsar, cmd, addr) < 0)
		perrexit("sadc: ioctl on /dev/sar failed");
}

perrexit(str, arg1, arg2, arg3)
char *str;
{
	static	char	perrstr[STRSIZE];

	sprintf(perrstr, str, arg1, arg2, arg3);
	perror(perrstr);
	exit(1);
}

pmsgexit(str, arg1, arg2, arg3)
char	*str;
{
	fprintf(stderr, str, arg1, arg2, arg3);
	fprintf(stderr, "\n");
	exit(1);
}
