/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sa.h: version 25.1 created on 12/2/91 at 16:52:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sa.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"sa:sa.h	1.19"				*/


/*	sa.h 1.19 of 6/26/86 */

#define	NIOTYPE	4  		/* number of i/o device types 	*/

#define MAX_PMS		8 	/* max number of cpu units		*/
#define	NIOTYPE		4  	/* max number of i/o device types 	*/
#define NDSK		64 	/* max number of SMD disks 		*/
#define NMTP		32 	/* max number of EDT tape drives	*/
#define NSDSK		16*14	/* max number of EDT/SCSI disks 	*/
#define MAX_DSDB	16	/* max number of IOPM/DSDBs supported	*/
#define	NDSDB  (16*16*MAX_DSDB)	/* max number of IOPM/DSDB disks */

#define NDEVS	(NDSK + NMTP + NSDSK + NDSDB)

#define STRSIZE	80
/*	
 * structure sa defines the data structure of system activity data file
 */
typedef struct sa {
	struct	sysinfo si;	/* defined in /usr/include/sys/sysinfo.h  */
	struct	minfo	mi;	/* defined in /usr/include/sys/sysinfo.h */
	struct	dinfo	di;	/* defined in /usr/include/sys/sysinfo.h */
	struct	rcinfo	rc;	/* defined in /usr/include/sys/sysinfo.h */
	uint	minserve;
	uint	maxserve;
	uint	szinode;	/* current size of inode table  */
	uint	szfile;		/* current size of file table  */
	uint	szproc;		/* current size of proc table  */
	uint	szlckf;		/* current size of file record header table */
	uint	szlckr;		/* current size of file record lock table */
	uint	mszinode;	/* maximum size of inode table  */
	uint	mszfile;	/* maximum size of file table  */
	uint	mszproc;	/* maximum size of proc table  */
	uint	mszlckf;	/* maximum size of file record header table */
	uint	mszlckr;	/* maximum size of file record lock table */
	uint	inodeovf;	/* overflows of inode table since boot  */
	uint	fileovf;	/* overflows of file table since boot  */
	uint	procovf;	/* overflows of proc table since boot  */
	struct syserr	serr;	/* not used */
	time_t	ts;		/* time stamp  */
	uint	apstate;	/* not used */

	ulong	devio[NDEVS][5]; /* device unit information  */

#define	IO_OPS	0  /* number of I /O requests since boot  */
#define	IO_BCNT	1  /* number of blocks transferred since boot */
#define	IO_ACT	2  /* cumulative time in ticks when drive is active  */
#define	IO_RESP	3  /* cumulative I/O response time in ticks since boot  */
#define	IO_ID	4
} sa_t;

/*
 * The SYS_RESET value allow sar to recognize dummy records 
 */
#define SYS_RESET	-300
