/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pwunconv.c: version 25.1 created on 12/2/91 at 16:50:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pwunconv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)pwunconv:pwunconv.c	1.5"
/*  pwunconv.c  */
/*  Conversion aid to copy appropriate fields from the	*/
/*  shadow file to the password file.			*/
							
#include <pwd.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <shadow.h>
#include <signal.h>
#include <string.h>

#ifdef SECON
#include <grp.h>
#include <auth.h>
#endif

#define PRIVILEGED	0			/* privileged id */	
#define MAX_MN		63	/* max # of weeks allowed for max and min*/
#define MAX_LSTCHG      4095 	/* 64 * 64 -1 (2 base 64 chars)          */
                             	/* max # of weeks allowed for lastchanged*/
#define DAY_WEEK	7			/* days per week */
#define SEC_WEEK	(24 * DAY_WEEK * 60 * 60)	/* seconds per week*/
#define ENTRY_LENGTH	512	/*maximum length of an /etc/passwd entry */

/* exit  code */
#define SUCCESS	0	/* succeeded */
#define NOPERM	1	/* No permission */
#define BADSYN	2	/* Incorrect syntax */
#define FMERR	3	/* File manipulation error */
#define FATAL	4	/* Old file can not be recover */
#define FBUSY	5	/* Lock file busy */
#define NOSHAD	6	/* Shadow file does not exist  */
#define TOOLONG	7	/* Entry exceeds 512-1 limit  */

#define	DELPTMP()	(void) unlink(PASSTEMP)

char *prognamp;

char ctp[128];

main(argc,argv)
int argc;
char **argv;
{
	extern	char	*strcat();
	extern	int	errno;
	extern	struct	passwd *getpwent();
	extern	char	*l64a();
	void	f_err(), f_miss(), no_recover(), no_convert();
	struct  passwd  *pwdp;
	struct	stat buf;
	FILE	*tp_fp;
	ushort  pwd_gid, pwd_uid, i;
  	int 	aging;
	time_t	now, max_wks, min_wks, lst_wks;
	int lck_pass;

#ifdef SECON
	usrauth_t *ua;
	usrstat_t *us;
	FILE *us_fp;
#endif

	/* number of weeks since 1970 */
	now = time ((long * ) 0) / SEC_WEEK;

	prognamp = argv[0];

	if ( ! priv ( P_SEC, getuid())) {
		(void)fprintf(stderr, "%s: Permission denied.\n", prognamp);
		exit(NOPERM);
	}

	/* No argument can be passed to the command*/
	if (argc > 1) {
		(void)fprintf(stderr, "%s: Invalid command syntax.\n", prognamp);
		(void)fprintf(stderr, "Usage: %s\n", prognamp);
		exit(BADSYN);
	}

	
	/* lock file so that only one process can read or write at a time */
	if ((lck_pass = lcksec(PASSWD)) == -1) { 
		(void)fprintf(stderr, "%s: Password file(s) busy.  Try again later.\n", prognamp);
		exit(FBUSY);
	}

	 /* All signals will be ignored during the execution of pwunconv */
	for (i=1; i < NSIG; i++) 
		sigset(i, SIG_IGN);
 
	/* reset errno to avoid side effects of a failed */
	/* sigset (e.g., SIGKILL) */
	errno = 0;

	/* check the file status of the password file */
	/* get the gid of the password file */
	if (stat(PASSWD, &buf) < 0) {
		(void) f_err(lck_pass);
		exit(FMERR);
	} 
	pwd_gid = buf.st_gid;
	pwd_uid = buf.st_uid;
 
	/* mode for the password file should be 444 or less */
	umask(~(buf.st_mode & 0444));

	/* open temporary password file */
	if ((tp_fp = fopen(PASSTEMP,"w")) == NULL) {
		(void) f_err(lck_pass);
		exit(FMERR);
	}

	if (chown(PASSTEMP, pwd_uid, pwd_gid) < 0) {
		DELPTMP();
		(void) f_err(lck_pass);
		exit(FMERR);
	}

	/* Reads the password file. If a correspondig entry	*/
	/* exists in the shadow file, updates the password	  */
	/* field in the password file from the shadow file.	*/

	if ( setuaent() < 0 ) {
		fprintf(stderr, "%s: Cannot open userauth file\n",prognamp);
		DELPTMP();
		(void) f_err(lck_pass);
		exit (FMERR);
	}

	while ((pwdp = getpwent()) != NULL) {
		if (( ua = getuanam(pwdp->pw_name)) != NULL ) {
			if( ua->ua_acctstat >= RETIRE)
				continue;

			/* Copy the fields in the userauth file to */
			/* the password file. */
			pwdp->pw_passwd=ua->ua_passwd;
			pwdp->pw_gecos=ua->ua_gecos;
			pwdp->pw_dir=ua->ua_defdir;
			pwdp->pw_shell=ua->ua_defshell;

			/* If a login has aging info, convert aging from */
			/* days into weeks. Adds 6 to each aging field */
			/* before it is divided by 7 to reduce the impact */
			/* of integer division. */
			/* Due to password (aging) base 64 (0 thru 63) scheme,*/
			/* the maximum week allowed for max and min is 63. */

			/* aging is on if max >= 0 */
		   	if (ua->ua_max_pwdlife >= 0) {
				max_wks = ua->ua_max_pwdlife / SEC_WEEK;
				max_wks = (max_wks > MAX_MN ? MAX_MN: max_wks); 

				/* if aging is on, min < 0, make min 0.*/
				if (ua->ua_min_pwdlife < 0) 
					ua->ua_min_pwdlife = 0;
				min_wks = ua->ua_min_pwdlife / SEC_WEEK;
				min_wks = (min_wks > MAX_MN ? MAX_MN: min_wks); 

				aging = max_wks + (min_wks <<6);
				pwdp->pw_age = l64a(aging);
			} 
			else {
				pwdp->pw_age = "";
			}

			/* Ensure that the combined length of the individual */
			/* fields will fit in a passwd entry. */
			/* The first 1 accounts for the "," */
			/*  if aging is present. */
			/* The second 1 accounts for the */
			/* newline and the 6 accounts for the colons (:'s) */
			if ((strlen  (pwdp->pw_name) + 
				strlen (pwdp->pw_passwd) +
				sprintf (ctp, "%d", pwdp->pw_uid) +
				sprintf (ctp, "%d", pwdp->pw_gid) +
				strlen (pwdp->pw_age) + (*pwdp->pw_age ? 1 : 0) + 1 +
				strlen (pwdp->pw_comment) +
				strlen (pwdp->pw_dir)	+
				strlen (pwdp->pw_shell) + 6) > (ENTRY_LENGTH-1) ) {

				DELPTMP();
				(void)fprintf(stderr,"%s: Entry for %s too long.  Conversion not done.\n",prognamp, pwdp->pw_name);
  				ulcksec(lck_pass);
				exit(TOOLONG);
			}
		}
		/* Every entry in the password file,  whether a */
		/* corresponding entry exists in the shadow file or not, */
		/* should be written to the temporary password file. */
		if ((putpwent(pwdp,tp_fp)) != 0 ) {
			(void) no_convert(lck_pass);
			exit(FMERR);
 		}
	}

	(void)fclose(tp_fp);

#ifdef SECON
	if (access(USRAUTH,0) == 0) {

		if (unlink(USRAUTH) < 0 ) {
			(void)fprintf(stderr,"%s: Unexpected failure. Conversion not done.\n",prognamp);
			DELPTMP();
			exit(FATAL);
		}
	}
	if (access(USRSTAT,0) == 0) {

		if (unlink(USRSTAT) < 0 ) {
			(void)fprintf(stderr,"%s: Unexpected failure. Conversion not done.\n",prognamp);
			DELPTMP();
			exit(FATAL);
		}
	}
#endif 

	/* delete old password file if it exists*/
	if (unlink (OPASSWD) && (access (OPASSWD, 0) == 0)) {
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	/* link password file to old password file */
	if (link(PASSWD, OPASSWD) < 0) {
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	/* delete password file */
	if (unlink(PASSWD) < 0) {
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	/* link temporary password file to password file */
	if (link(PASSTEMP, PASSWD) < 0) {
		/* link old password file to password file */
		if (link(OPASSWD, PASSWD) < 0) {
			(void) no_recover(lck_pass);
			exit(FATAL);
 		}
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	DELPTMP();
	ulcksec(lck_pass);

	exit(0);
}
 
void
no_recover(lck_fd)
int lck_fd;
{
	DELPTMP();
	(void) f_miss(lck_fd);
}

void
no_convert(lck_fd)
int lck_fd;
{
	DELPTMP();
	(void) f_err(lck_fd);
}
 
void
f_err(lck_fd)
{
	(void)fprintf(stderr,"%s: Unexpected failure. Conversion not done.\n",prognamp);
  	ulcksec(lck_fd);
}

void
f_miss(lck_fd)
int lck_fd;
{
	(void)fprintf(stderr,"%s: Unexpected failure. Password file(s) missing.\n",prognamp);
  	ulckpwdf(lck_fd);
}
