/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pwconv.c: version 25.1 created on 12/2/91 at 16:50:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pwconv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)pwconv:pwconv.c	1.5"

/*  pwconv.c  */
/*  Conversion aid to copy appropriate fields from the	*/
/*  password file to the shadow file.			*/
/*  group file to the shadow file.			*/

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <fcntl.h>
#include <stdio.h>
#include <time.h>
#include <shadow.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/sakioctl.h>
#include <auth.h>
#include <grp.h>
#include <signal.h>

#define PRIVILEGED	0 			/* priviledged id */	

/* exit  code */
#define SUCCESS	0	/* succeeded */
#define NOPERM	1	/* No permission */
#define BADSYN	2	/* Incorrect syntax */
#define FMERR	3	/* File manipulation error */
#define FATAL	4	/* Old file can not be recover */
#define FBUSY	5	/* Lock file busy */

#define	DELPTMP()	(void) unlink(PASSTEMP)

#ifdef SECON
#define DELGTMP()	(void) unlink(GRPTMP)
#define DELSGTMP()	(void) unlink(SGRPTMP)
#endif

#ifdef SECON
char pwdflr[]	= "*";				/* password filler */
char grpflr[]	= "*";				/* group filler */
#else
char pwdflr[]	= "x";				/* password filler */
#endif

char *prognamp;

#ifdef SECON
#define UAPRESENT	0x01
#define ADDUA		0x02
#define PERMISSIVE	0x04
#define SHADPRES	0x08
char   umode;
usrauth_t	tmp_ua;
usrstat_t	tmp_us;
priv_t privs;
#endif

main(argc,argv)
int argc;
char **argv;
{
	extern	char	*strcpy();
	extern	int	errno;
	extern struct	passwd *getpwent();
	extern long	a64l();
  	extern long    time();
	void f_err(), f_miss(), no_recover(), no_convert();
	struct  passwd  *pwdp;
	struct	spwd *sp;
	struct stat buf;
	FILE	*tp_fp;
	register time_t	when, minweeks, maxweeks;
	int file_exist = 1;
	int mode;
	ushort i, pwd_gid, sp_gid;
	ushort pwd_uid, sp_uid;
	int lck_pass;

#ifdef SECON
	usrauth_t *ua;
	usrstat_t *us;
	FILE *ua_fp;
	int	c;
	int usr_exist = 0;
	int	errflg = 0;
	int indx = 0;
	int lck_usr;
#endif

	prognamp = argv[0];
        /* only PRIVILEGED can execute this command */
	if ( ! priv ( P_SEC, getuid())) { 
		fprintf(stderr, "%s: Permission denied.\n", prognamp);
		exit(NOPERM);
	}
	
	/* No argument can be passed to the command*/
	if (argc > 1) {
		fprintf(stderr, "%s: Invalid command syntax.\n", prognamp);
		fprintf(stderr, "Usage: pwconv\n");
		exit(BADSYN);
	}

#ifdef SECON
/* wtk
	if (!getpriv(&privs)) 
*/
		umode |= ADDUA;
#endif
	
	/* lock file so that only one process can read or write at a time */
	if ((lck_pass = lcksec(PASSWD)) == -1) { 
		(void)fprintf(stderr, "%s: Password file(s) busy.  Try again later.\n", 
			prognamp);
		exit(FBUSY);
	}
 
      	/* All signals will be ignored during the execution of pwconv */
	for (i=1; i < NSIG; i++) 
		sigset(i, SIG_IGN);
 
	/* reset errno to avoid side effects of a failed */
	/* sigset (e.g., SIGKILL) */
	errno = 0;

	/* check the file status of the password file */
	/* get the gid of the password file */
	if (stat(PASSWD, &buf) < 0) {
		(void) f_err(lck_pass);
		exit(FMERR);
	} 
	pwd_gid = buf.st_gid;
	pwd_uid = buf.st_uid;
 
	/* mode for the password file should be 644 or less */
	umask(~(buf.st_mode & 0644));

	/* open temporary password file */
	if ((tp_fp = fopen(PASSTEMP,"w")) == NULL) {
		(void) f_err(lck_pass);
		exit(FMERR);
	}

    if (chown(PASSTEMP, pwd_uid, pwd_gid) < 0) {
		DELPTMP();
		(void) f_err(lck_pass);
		exit(FMERR);
	}

#ifdef SECON
	if ( umode & ADDUA ) {

	/* Check to see if the shadow passwd exists */
		if ( access(SHADOW, 0) == 0 )
			umode |= SHADPRES;

	/* Check to see if the user auth exits */
		if (access(USRAUTH, 0)== 0 )
			umode |= UAPRESENT;
	}
#endif 
			
	/* Reads the password file.  				*/
	/* If the shadow password file not exists, or		*/
	/* if an entry doesn't have a corresponding entry in    */
	/* the shadow file, entries/entry will be created.      */
 
	while ((pwdp = getpwent()) != NULL) {
#ifdef SECON
		if ( umode&ADDUA ) {
			if (!( (umode&UAPRESENT) && (ua = getuanam( pwdp->pw_name )))) {
				ua = &tmp_ua;
				us = &tmp_us;
				if (umode&SHADPRES) {
					if ((sp = getspnam(pwdp->pw_name)) != NULL) {
						strncpy(pwdp->pw_passwd,sp->sp_pwdp,PASS_MAX);
					}
					else {
						fprintf(stderr, "%s: Cannot get shadow passwd for %s will use default.\n", prognamp, pwdp->pw_name);
					}
				}
				defaults( ua, pwdp, us );
				if( updateuaent( ua, us ,DO_BOTH) < 0 ) {
					fprintf(stderr,"Cannot update %s\n",USRAUTH );
					exit(1);
				}
			}
		}
#endif
		else {
		/* If an entry in the password file has a string,    	 */
		/* other than 'pwdflr', in the password field, that password	 */
		/* entry will be entered in the corresponding entry	 */
		/* in the shadow file.  The password field will be replaced   */
		/* with an 'pwdflr'.                                     */
		/* If aging is not specified, last_changed day will be   */
		/* updated and max and min will be cleared.              */
			if (strcmp(pwdp->pw_passwd, pwdflr)) {
				sp->sp_pwdp=pwdp->pw_passwd;
				pwdp->pw_passwd = pwdflr;
		   		if (*pwdp->pw_age == NULL) {
					sp->sp_lstchg = DAY_NOW;
					sp->sp_min =  -1;
					sp->sp_max =  -1;
				}
			}
		/* If aging info is added, split aging info into age,    */
		/* max and min.  Convert aging info from weeks to days.  */
		   	if (*pwdp->pw_age != NULL) {
				when = (long) a64l (pwdp->pw_age);
				maxweeks = when & 077;
				minweeks = (when >> 6) & 077;
				when >>= 12;
				sp->sp_lstchg = when * 7;
				sp->sp_min = minweeks * 7;
				sp->sp_max = maxweeks * 7;
 			 	pwdp->pw_age = "";
		   	}
		}
		/* write an entry to temporary password file */

		if ((putpwent(pwdp,tp_fp)) != 0 ) {
			(void) no_convert(lck_pass);

			exit(FMERR);
		}
	}
 	
	(void)fclose(tp_fp);

#ifdef SECON
	enduaent();
	fclose(ua_fp);
#endif

	/* delete old password file if it exists*/
	if (unlink (OPASSWD) && (access (OPASSWD, 0) == 0)) {
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	/* link password file to old password file */
	if (link(PASSWD, OPASSWD) < 0) {
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	/* delete password file */
	if (unlink(PASSWD) < 0) {
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	/* link temporary password file to password file */
	if (link(PASSTEMP, PASSWD) < 0) {
		/* link old password file to password file */
		if (link(OPASSWD, PASSWD) < 0) {
			(void) no_recover(lck_pass);
			exit(FATAL);
 		}
		(void) no_convert(lck_pass);
		exit(FMERR);
	}

	if ( (umode&SHADPRES) && !(unlink(SHADOW)) ){
		fprintf(stderr, "%s: Cannot unlink Shadow passwd file.\n", prognamp); 
	}

	/* Change old password file to read only by owner   */
	/* If chmod fails, delete the old password file so that */
	/* the password fields can not be read by others */
	if (chmod(OPASSWD, 0400) < 0) 
		(void) unlink(OPASSWD);
 
	DELPTMP();
	ulcksec(lck_pass);

#ifdef SECON
	if (indx > 0)
		(void) fprintf(stderr, "%s: %d New addition\(s\) to usrauth passwd file\n",prognamp,indx);
#endif

	exit(0);
}
 
void
no_recover(lck_fd)
int lck_fd;
{
	DELPTMP();
	(void) f_miss(lck_fd);
}

void
no_convert(lck_fd) 
int lck_fd;
{
	DELPTMP();

#ifdef SECON
	DELGTMP();
	DELSGTMP();
#endif

	(void) f_err(lck_fd);
}
 
void
f_err(lck_fd)
int lck_fd;
{
	fprintf(stderr,"%s: Unexpected failure. Conversion not done.\n",prognamp);
  	ulcksec(lck_fd);

}

void
f_miss(lck_fd)
int lck_fd;
{
	fprintf(stderr,"%s: Unexpected failure. Password file(s) missing.\n",prognamp);
  	ulcksec(lck_fd);
}

#ifdef SECON 
settime( ua, mode )
struct usrauth *ua;
int mode;
{
int i;

	if ( mode ) 
		for ( i=0; i<7; i++ ) 
			ua->ua_times[i].st_hr = ua->ua_times[i].et_hr = -1;
	else
		for ( i=0; i<7; i++ ) 
			ua->ua_times[i].st_hr = ua->ua_times[i].et_hr = 0;
}
#endif

defaults( ua, pw, us )
usrauth_t *ua;
struct passwd *pw;
usrstat_t *us;
{
	register time_t	when, minweeks, maxweeks;
	int i;


	strncpy(ua->ua_name,pw->pw_name,NAME_MAX);
	strncpy(ua->ua_passwd,pw->pw_passwd,NAME_MAX);
	strncpy(ua->ua_gecos,pw->pw_gecos,MAXCOMMENT);
	strncpy(ua->ua_defdir,pw->pw_dir,MAXPATH);
	strncpy(ua->ua_defshell,pw->pw_shell,MAXPATH);
	ua->ua_uid = pw->pw_uid;
	ua->ua_gid = pw->pw_gid;
	ua->ua_maxtries = 7;	/* default unsuccessful logins */

	us->us_badtries = 0;

	us->us_uid = pw->pw_uid;
	us->us_lastlogin = 0;
	us->us_ttyn[0] = 0;
	us->us_last_try = 0;
	us->us_ttyn_try[0] = 0;
	us->us_pwdchg = DAY_NOW;

	pw->pw_passwd = pwdflr;

	/* If login has aging info, split the aging info */
	/* into age, max and min.                        */
	/* Convert aging info from weeks to days */

   	if (*pw->pw_age != NULL) {
		when = (long) a64l (pw->pw_age);
		maxweeks = when & 077;
		minweeks = (when >> 6) & 077;
		when >>= 12;
		ua->ua_min_pwdlife = minweeks * 7; /*default user start time */
		ua->ua_max_pwdlife = maxweeks * 7; /*default user end time */
		pw->pw_age = "";
	}
	else {
 
	/* if no aging, last_changed will be the day the 
	conversion is done, min and max fields will be null */
	/* use timezone to get local time */

		us->us_pwdchg = DAY_NOW;
		ua->ua_min_pwdlife =  0;
		ua->ua_max_pwdlife =  0;
   	}

	if ( pw->pw_uid == 0 ) {
		ua->ua_role = ROOT_ROLE;
		settime( ua, PERMISSIVE );
	}
	else {
		/* setup default entries */
		ua->ua_role = USR_ROLE;
		settime( ua, umode & PERMISSIVE );
	}
}
