/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pwck.c: version 25.1 created on 12/2/91 at 16:50:16	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pwck.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)pwck:pwck.c	1.7"

/*SECURE -Include files and defines for security */
#include	<shadow.h>
#include	<auth.h>
#define MESG0	"**** Checking the USER authorization file ****"
#define MESG1	"**** Checking the shadow passwd file ****"
#define MESG2	"**** Checking the TTY authorization file ****"
#define MESG3	"**** Checking the passwd file ****"
#define MESG4	"Lognames in shadow passwd that are not in /etc/passwd:"

#include	<sys/types.h>
#include	<sys/param.h>
#include	<sys/signal.h>
#include	<sys/sysmacros.h>
#include	<sys/stat.h>
#include	<sys/priv.h>
#include	<sys/mls.h>
#include	<stdio.h>
#include	<ctype.h>
#include 	<values.h>
#include 	<grp.h>

#define	ERROR1	"Too many/few fields"
#define ERROR2	"Bad character(s) in logname"
#define ERROR2a "First char in logname not alpha"
#define ERROR2b "Logname field NULL"
#define ERROR3	"Logname missing or too long (greater than 8)"
#define ERROR4	"Invalid UID"
#define ERROR5	"Invalid GID"
#define ERROR6	"Login directory not found"
#define ERROR6a	"Login directory null"
#define	ERROR7	"Optional shell file not found"
#define ERROR7a	"Optional shell file not executable"

/*SECURE -error defines for security*/
/* Errors used for security checking */
#define ERROR8  "No terminal defined for use (or locked) in tty_auth file"
#define ERROR9  "No shadow password entry"
#define ERROR10 "No more memory"
#define ERROR11 "Invalid group(s) in the group field"
#define ERROR12 "Invalid user(s) in the user field"
#define ERROR13	"Invalid or missing MIN field for passwd change"
#define ERROR14	"Invalid or missing MAX field for forced passwd change"
#define ERROR15 "The MIN field exceeds the MAX field"
#define ERROR16 "Invalid or missing format field (max value is 7)"
#define ERROR17 "TTY is not a character device"
#define ERROR18	"TTY is invalid or does not exist"
#define ERROR19 "TTY path is not absolute (does not begin with a /)"
#define ERROR20	"Invalid or missing MAXTRY field"
#define ERROR21	"Warning: MAXTRY is larger than 10"
#define ERROR22	"Invalid or missing LOCK field (0 or 1)"
#define ERROR23 "Warning: This tty is locked!"
#define ERROR24	"Invalid keyword or more than 3 characters in the SAK field"
#define ERROR25 "Invalid privilege level"
#define ERROR26 "Invalid label"
#define ERROR27 "Invalid access time(s)"

#define PASSWD_FILE		"/etc/passwd"
/* Field names */
#define LOGNAME		0
#define PASS		1
#define USRID		2
#define GRPID		3
#define COMMENT		4
#define HOMEDIR		5
#define DEFSHELL	6


/* Fields for shadow passwd (the first two are the same as the passwd file) */
#define SP_LAST		2
#define SP_MIN		3
#define SP_MAX		4
#define SP_FORMAT	5
#define SP_LOCK		6

#define MAX_SPFORMAT	7	/* max number that can be in format field */

/*SECURE -more defines for security purposes */
/* Fields for user_auth file */
#define UA_UNAME	0
#define UA_PRIV		9
#define UA_LABEL	10
#define UA_TIMES	11

#define UA_MAX_DAY	6
#define UA_MAX_HOUR	24

/* Fields for tty_auth file */
#define TA_TTYNAME	0
#define TA_MAXTRY	2
#define TA_LOCKED	1
#define TA_SAK		6
#define TA_GROUP	7
#define TA_USER		8

#define DELETE		01

struct spcache {
	char sp_name[50];
	struct spcache *sp_next;
};

struct tacache {
	char ta_name[50];
	struct tacache *ta_next;
};

struct spcache *sp_head;
struct tacache *ta_head;

/* List of valid keywords permitted in the sak field in the tty_auth file */
char *sak_keywords[] = {
	"CARRIER",
	"BREAK",
	NULL
};

int global_user = 0;

int eflag, code=0;
int badc;
char buf[BUFSIZ];
char *delim[BUFSIZ];
char tmpbuf[BUFSIZ];
char *delim2[BUFSIZ];
char tmpbuf2[BUFSIZ];

main(argc,argv)

int argc;
char **argv;

{
/*SECURE -If the secure files exist check them. */
	struct spcache *p;

	/* check the contents of the user authorization file */
	if (access(USRAUTH,0) ==0){
		mesg(MESG0);
		check_usrauth(USRAUTH);

		/* check the contents of the tty authorization file */
		mesg(MESG2);
		check_ttauth(TTYAUTH);
	}
	else if(access(SHADOW,0) ==0){
		/* check the contents of the shadow passwd file */
		mesg(MESG1);
		check_spasswd(SHADOW);
	}

	mesg(MESG3);

	if (argc == 1) 
		check_passwd(PASSWD_FILE);
	else 
		check_passwd(argv[1]);

	if (access(SHADOW,0) ==0){
		/* List out people who are in the shadow passwd but not in passwd */
		if (sp_head != NULL) {
			mesg(MESG4);
			eflag = 1;
			for (p = sp_head; p != NULL; p = p->sp_next) {
				if ( (getpwnam(p->sp_name)) == NULL )
					error(p->sp_name);
			}
		}
	}
	exit(code);
}

/*SECURE -routine to check the user auth file*/
check_usrauth(file)
char *file;
{
	char *p;
	char *strrchr();
	FILE *fptr, *fopen();
	int n, i;
	uint start, end;

	if ( access(file,0) ) {
		fprintf(stderr,"%s not found\n", file);
		return;
	}

	if ((fptr = fopen(file, "r")) == NULL) {
		fprintf(stderr,"cannot open %s\n", file);
		exit(1);
	}

	while (fgets(buf, BUFSIZ, fptr) != NULL) {

		eflag = 0;
		if (split_line(buf, tmpbuf, delim, ':', 11) != 11) {
			error(ERROR1);
			continue;
		}

		/* check the user name */
		valid_login(delim[UA_UNAME]);

		addlist(delim[UA_UNAME], &sp_head);
		
		/* check the privilege */
		if (!valid_priv(delim[UA_PRIV]))
			error(ERROR25);

		/* check the label */
		if (!valid_label(delim[UA_LABEL]))
			error(ERROR26);

		/* check the access times */
		if ((n = split_line(delim[UA_TIMES], tmpbuf2, delim2, ',',0))
			 != UA_MAX_DAY)
			error(ERROR27);

		/* Strip off the new line */
		if ((p = strrchr(delim2[UA_MAX_DAY], '\n')) != NULL)
			*p = '\0';

		/* check the access times */
		for (i = 0; i <= n; i++) {
			if (strcmp(delim2[i], "*") == 0)
				continue;
			else {
				/* check start and end times */
				sscanf(delim2[i], "%d %d", &start, &end);
				end = abs(end);
				if ((start > 0) && (end < UA_MAX_HOUR) &&
					(start < end))
					continue;
				else
					error(ERROR27);
			}
		}		
	}
}

valid_priv(priv_string)
char *priv_string;
{
	int i;

	for (i = 0; *priv_pmap[i].p_name; i++)
		if (strcmp(priv_string, priv_pmap[i].p_name) == 0)
			return(1);
	return(0);
}

valid_label(label_string)
char *label_string;
{
	int i;

	for (i = 0; *slabel_map[i].name; i++)
		if (strcmp(label_string, slabel_map[i].name) == 0)
			return(1);
	return(0);
}

check_spasswd(file)
char *file;
{
	int error();
	unsigned long min = 0L, max = 0L;
	char *p;
	FILE *fptr, *fopen();

	if ( access(file,0) ) {
		fprintf(stderr,"%s not found\n", file);
		return;
	}

	if ((fptr = fopen(file, "r")) == NULL) {
		fprintf(stderr,"cannot open %s\n", file);
		exit(1);
	}

	while (fgets(buf, BUFSIZ, fptr) != NULL) {

		eflag = 0;
		if (split_line(buf, tmpbuf, delim, ':', 0) != 6) {
			error(ERROR1);
			continue;
		}

		valid_login(delim[LOGNAME]);

		addlist(delim[LOGNAME], &sp_head);

		/* check the min field */
		if (*(delim[SP_MIN]) != '\0')
			if (valid_num(delim[SP_MIN], MAXSHORT, &min) == 0)
				error(ERROR13);

		/* check the max field */
		if (*(delim[SP_MAX]) != '\0')
			if (valid_num(delim[SP_MAX], MAXSHORT, &max) == 0)
				error(ERROR14);

		/* Check that is min < max */
		if (min > max)
			error(ERROR15);

		/* check the format field */
		if (valid_num(delim[SP_FORMAT], MAX_SPFORMAT, &max) == 0)
			error(ERROR16);
	}
	return;
}

check_ttauth(file)
char *file;
{
	int  i, n, errors = 0, locked = 0;
	unsigned long max = 0L;
	char *p, **q;
	char *strrchr();
	struct stat s_buf;
	struct group *grp, *getgrnam();
	FILE *fptr, *fopen();

	if ( access(file,0) ) {
		fprintf(stderr,"%s not found\n", file);
		return;
	}

	if ((fptr = fopen(file, "r")) == NULL) {
		fprintf(stderr,"cannot open %s\n", file);
		exit(1);
	}

	while (fgets(buf, BUFSIZ, fptr) != NULL) {
		
		eflag = 0;
		if (split_line(buf, tmpbuf, delim, ':', 0) != 8) {
			error(ERROR1);
			continue;
		}

		/* Check ttyname field */
		if (stat(delim[TA_TTYNAME], &s_buf) == 0) {
			/* Validate that it is a character device. */
			if (!S_ISCHR(s_buf.st_mode)) 
				error(ERROR17);
		}
		else 
			error(ERROR18);
			
		/* That it has an absolute path name */
		if (*delim[TA_TTYNAME] != '/')
			error(ERROR19);

		/* Check the max try field */
		if (valid_num(delim[TA_MAXTRY], MAXSHORT, &max) == 0)
			error(ERROR20);

		/* warning if > 10 */
		if (max > 10)
			error(ERROR21);

		/* Check the locked field (0 or 1) */
		if (valid_num(delim[TA_LOCKED], 1, &max) == 0)
			error(ERROR22);

		/* Give a warning that the tty is locked and discount the
		 * logins associated with this line.
		 */
		 if (max == 1) {
			locked = 1;
			error(ERROR23);
		}

		/* Check the sak field */
		if (valid_sak(delim[TA_SAK]) == 0)
			error(ERROR24);

		/* Check the group fields */
		n = split_line(delim[TA_GROUP], tmpbuf2, delim2, ',',0);
		for (i = 0; i <= n; i++) {
			/* If * then everyone is great */
			if (strcmp(delim2[i], "*") == 0) {
				if (!locked)
					global_user++;
				continue;
			}
			/* Get the group list */
			if ((grp = getgrnam(delim2[i])) == NULL)
				errors++;
			else {
				if (!locked && !global_user) {
					/* Add everyone to the login list */
					for(q = grp->gr_mem; *q == NULL; q++)
						addlist(*q, &ta_head);
				}
			}
		}

		if (errors > 0)
			error(ERROR11);
		errors = 0;

		/* Check the user fields */

		/* Strip off the new line */
		if ((p = strrchr(delim[TA_USER], '\n')) != NULL)
			*p = '\0';
		
		/* Split the field up by comma's */
		n = split_line(delim[TA_USER], tmpbuf2, delim2, ',',0);
		for (i = 0; i <= n; i++) {
			/* if its a * let everyone in */
			if (strcmp(delim2[i], "*") == 0) {
				if (!locked)
					global_user++;
				continue;
			}
			/* Else validate they are a real person */
			if (getpwnam(delim2[i]) == NULL) {
				errors++;
			}
			else  {
				if (!global_user && !locked)
					/* And add them to the list */
					addlist(delim2[i], &ta_head);
			}
		}

		if (errors > 0)
			error(ERROR12);
		errors = locked = 0;
	}
}



check_passwd(file)
char *file;
{

	int error();
	unsigned long uid, gid;
	char *p;
	char *fgets(), *strrchr();
	FILE *fopen(), *fptr;
	struct	stat obuf;

	if ((fptr = fopen(file, "r")) == NULL) {
		fprintf(stderr,"cannot open %s\n", file);
		exit(1);
	}

	while (fgets(buf,BUFSIZ,fptr) != NULL) {

		badc=0;
		eflag=0;

		/*  Check number of fields and copy into tmpbuf */
		if (split_line(buf, tmpbuf, delim, ':', 0) != 6) {
			error(ERROR1);
			continue;
		}

		/*  Check that first character is alpha and rest alphanum  */
		valid_login(delim[LOGNAME]);

		/*  Check that UID is numeric and <= MAXUID  */

		if (!valid_num(delim[USRID], MAXUID, &uid))
			error(ERROR4);

		/*  Check that GID is numeric and <= MAXUID  */

		if (!valid_num(delim[GRPID], MAXUID, &gid))
			error(ERROR5);

		/*  Stat initial working directory  */

		if ((stat(delim[HOMEDIR],&obuf)) < 0)
			error(ERROR6);

		if (*(delim[HOMEDIR]) == '\0')	/* Currently OS translates */
			error(ERROR6a);		/*  "/" for NULL field */

		/*  Stat of program to use as shell  */

		if (*(delim[DEFSHELL]) != '\n') {
			/* Strip off the new line */
			if ((p = strrchr(delim[DEFSHELL], '\n')) != NULL)
				*p = '\0';

			/* check for subsystem login */
			if (strcmp(delim[DEFSHELL],"*") == 0)
				continue;

			if (stat(delim[DEFSHELL], &obuf) == -1) {
				error(ERROR7);
			}
			else {
				if ((obuf.st_mode & (S_IXUSR|S_IXGRP|S_IXOTH)) == 0)
					error(ERROR7a);
			}
		}
	}
	fclose(fptr);
}

/*  Error printing routine  */
error(msg)
char *msg;
{
	if (!(eflag)) {
		fprintf(stderr,"\n%s",buf);
		code = 1;
		++eflag;
	}
	if (!(badc)) {
		fprintf(stderr,"\t%s\n",msg);
		return;
	}
	else {
		fprintf(stderr,"\t%d %s\n",badc,msg);
		badc=0;
		return;
	}
}

/* Stringently check for a positive number */
valid_num(string, maxval, value)
char *string;
unsigned long maxval;
unsigned long *value;
{
	int len;
	char *p;

	/* check that its not too long */
	len = strlen(string);
	if ( (len > 7) || (len < 1) ) 
		return(0);

	/* check that it is all digits */
	for (p = string; *p != '\0'; p++)
		if (!isdigit(*p))
			return(0);

	/* check that its not bigger than it should be */
	*value = atoi(string);
	if (*value > maxval || *value < 0L)
		return(0);

	return(1);
}

valid_login(logname)
char *logname;
{
	int len;
	char *p;


	if (*logname == '\0') {
		error(ERROR2b);
		return;
	}

	/* Is the first char alpha */
	if ( !isalpha(*logname) )
		error(ERROR2a);

	/* Is the rest alpha numeric */
	for (p = logname; *p != '\0'; p++)
		if (!isalnum(*p))
			++badc;

	if (badc > 0)
		error(ERROR2);

	/*  Check for valid number of characters in logname  */
	len = strlen(logname);
	if (len <= 0  ||  len > 8)
		error(ERROR3);
}

split_line(line, tmpbuf, delim, splitchar, count)
char *line;
char *tmpbuf;
char *delim[];
char splitchar;
int count;
{
	int num = 0;
	char *p, *q;

	delim[num] = tmpbuf;
	for (p = line, q = tmpbuf; *p != '\0'; p++, q++) {
		*q = *p;
		if ((count) && (num == count))
			continue;
		if (*q == splitchar) {
			++num;
			delim[num] = q + 1;
			*q = '\0';
		}
	}
	*q = '\0';
	return(num);
}


/* Determine if string is a valid sak field in the tty_auth file */
valid_sak(string)
char *string;
{
	int count = 0;
	char **p, *q;

	for (p = sak_keywords; *p != NULL; p++)
		if (strcmp(string, *p) == 0)
			return(1);

	for (q = string; *q != '\0'; q++)
		if (*q != '^')
			count++;

	if (count > 3)
		return(0);
	return(1);
}

/* add an entry to the link list pointed to by head */

addlist(string, head)
char *string;
struct spcache **head;
{
	struct spcache *p;

	if ((p = (struct spcache *)malloc(sizeof(struct spcache))) == NULL) {
		error(ERROR10);
		exit(1);
	}

	strcpy(p->sp_name, string);
	p->sp_next = NULL;

	if (*head != NULL)
		p->sp_next = *head;
	*head = p;
}

/* find an entry on the link list pointed to by head, possibly deleting it */
find(string, head, flag)
char *string;
struct spcache **head;
int flag;
{
	struct spcache *p, *q;

	for (p = *head, q = p; p != NULL; q = p, p = p->sp_next)
		if (strcmp(p->sp_name, string) == 0)
			break;
	if (p == NULL)
		return(-1);

	if (flag == DELETE) {
		if (p == *head)
			*head = p->sp_next;
		else
			q->sp_next = p->sp_next;
	}

	return(1);
}


mesg(string)
char *string;
{
	fprintf(stderr, "\n%s\n", string);
}

