/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ps.c: version 25.1 created on 12/2/91 at 16:49:51	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ps.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"ps:ps.c	1.62"			*/

#ident	"@(#)ps:ps.c	25.1"

/*	ps - process status					*/
/*	examine and print certain things about processes	*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <ftw.h>
#include <sys/types.h>
#include <ctype.h>
#include <nlist.h>
#include <pwd.h>
#include <sys/param.h>
#include "sys/kmem.h"
#include "sys/ioctl.h"

#include <sys/immu.h>	    /* sys/immu.h must precede sys/region.h for 3b2 */
#include <sys/region.h>

#include "sys/sysmacros.h"
#include "sys/proc.h"
#include "sys/tty.h"
/* #include "sys/fs/s5dir.h" 	pulled in by user.h	*/
#include "sys/signal.h"
#include "sys/stat.h"
#include "sys/user.h"
#include "sys/var.h"

#define NTTYS	20	/* max # ttys that can be specified with -t option  */
#define SIZ 	30	/* max # processes that can be specified with -p and -g */
#define ARGSIZ	30	/* size of buffer which holds args for -t, -p & -u options   */

#ifndef MAXLOGIN
#define MAXLOGIN	8   /*max # of char in userid that will be printed  */
#endif
		/* NUMSLPS, number of sleep semaphores and hash chains.      */
		/* This does not limit the number of processes which can be  */
		/* sleeping.  They just sleep on the same semaphore.         */
		/* The following #define (NUMSLPS) must match the one in the */
		/* slp.c file in the kernel.  In future releases, the kernel */
		/* should put this value in a variable (var.h ?) so that ps  */
		/* can read it.  For now though, the kernel is frozen. 	     */

/* Structure for storing user info */
struct udata {
	unsigned short uid;	/* numeric user id */
	char name[MAXLOGIN];	/* char user id, may not be null terminated */
};

/* udata and devl granularity for structure allocation */
#define UDQ	50

/* Pointer to user data */
struct udata *ud;
int	nud = 0;	/* number of valid ud structures */
int	maxud = 0;	/* number of ud's allocated */

struct udata uid_tbl[SIZ];	/* table to store selected uid's */
int	nut = 0;		/* counter for uid_tbl */

/*
 * NOTE that we are dependent upon the order of these
 * nlist declarations, see sys/ioctl.h
 */
				/* see nlist(3c)			 */
				/*    semaphores on 3b20, 3b5 and vax	 */
				/* no semaphores on 3b2 or pdp11	 */
				/* swaplo(w): from /syst, 1st block # on */
struct nlist nl[] = {		/* device to be used for swap		 */
	"proc", (long)0, (short)0, (unsigned short)0, (char)0, (char)0,
	"swplo", (long)0, (short)0, (unsigned short)0, (char)0, (char)0,
	"v", (long)0, (short)0, (unsigned short)0, (char)0, (char)0,
	0, (long)0, (short)0, (unsigned short)0, (char)0, (char)0
};

struct proc prc;
#define	mproc	prc
#define	zproc	prc

struct	var  v;

struct	user u;

int	retcode=1;
int	c;
int	lflg;
int	eflg;
int	uflg;
int	aflg;
int	dflg;
int	pflg;
int	fflg;
int	gflg;
int	tflg;
int	errflg;
int	isatty();
char	*gettty();
char	*ttyname();
int	memfd;
int	swmem;
daddr_t	swplo;		   /* disk block number, physical, type long, see sys/types.h */
int	cpuflag;		/*kd0*/
char	argbuf[ARGSIZ];
char	*parg;
char	*p1;				     /* points to successive option arguments */
char	*coref;
char	*memf;
char	*sysname;
long lseek();
static char stdbuf[BUFSIZ];

int	ndev;		/* number of devices */
int	maxdev;		/* number of devl structures allocated */
			/* DIRSIZ: max char per directory, 14, see sys/dir.h  */
struct devl {		/* device list	 */		    /* and sys/param.h*/
	char	dname[DIRSIZ];	/* device name	 */
	dev_t	dev;		/* device number */
} *devl;

char	*tty[NTTYS];	/* for t option */
int	ntty = 0;
int	pid[SIZ];	/* for p option */
int	npid = 0;
int	grpid[SIZ];	/* for g option */
int	ngrpid = 0;

int	usersuid;	/* uid for user executing the command */
int	usersgid;	/* real gid for user executing the command */

static char states[] =	"-SRZTIOX";
    
extern int	chown();
extern unsigned short getegid();
extern int	errno;
extern char	*sys_errlist[];
extern void	exit();
extern char	*malloc();
extern char	*realloc();

main(argc, argv)
char **argv;
{
	register char **ttyp = tty;
	char *getstr;
	char *name;
	char *p;
	int puid, ppid, ppgrp;	/* puid: 	process user id	   */
	int i, found;		/* ppid: parent process id, see sys/proc.h */
	extern char *optarg;	/* ppgrp:	process group id	   */
	extern int optind;
	int pgerrflg = 0;	/* err flg: non-numeric arg w/p & g options */
	void getdev();

	char *usage="ps [ -edalf ] [ -t tlist ] [ -p plist ]";
	char *usage2="	[ -u ulist ] [ -g glist ]";
	char *malloc();
	unsigned size;

	getstr = "lfeadt:p:g:u:";			/* no s or c or n options */
	sysname = "/arix";
	coref = "/dev/mem";
	memf = "/dev/mem";

	/* Load the real user and group id's for later comparison. */
	usersuid=getuid();
	usersgid=getgid();

	setbuf(stdout, stdbuf);
	while ((c = getopt(argc,argv,getstr)) != EOF)
		switch(c) {
		case 'l':		/* long listing */
			lflg++;
			break;

		case 'f':		/* full listing */
			fflg++;
			break;

		case 'e':		/* list for every process */
			eflg++;
			tflg = uflg = pflg = gflg = 0;
			break;

		case 'a':	   /* same as e except no proc grp leaders */
			aflg++;    /* and no non-terminal processes     */
			break;

		case 'd':	   /* same as e except no proc grp leaders */
			dflg++;
			break;

		case 't':		/* terminals */
			tflg++;
			p1 = optarg;
			do {
				parg = argbuf;
				if (ntty >= NTTYS)
					break;
				getarg();
		        	if ((p = malloc(14)) == NULL) {
					fprintf(stderr,"ps: no memory\n");
					done(1);
				}
		        	size = 14;
		        	if(isdigit(*parg)) {
		        	        strcpy(p, "tty");
		        	        size -= 3;
		        	}
		        	strncat(p, parg, size);
				*ttyp++ = p;
				ntty++;
			}
			while (*p1);
			break;

		case 'p':		/* proc ids */
			pflg++;
			p1 = optarg;
			parg = argbuf;
			do {
				if (npid >= SIZ)
					break;
				getarg();
				if (strcmp(parg,"0") && !atoi(parg)) { /* ken#1 */
					pgerrflg++;
					fprintf(stderr,
						"ps: %s in an invalid non-numeric argument for -p option\n", parg);
				}
				pid[npid++] = atoi(parg);
			}
			while (*p1);
			break;

		case 'g':		/* proc group */
			gflg++;
			p1 = optarg;
			parg = argbuf;
			do {
				if (ngrpid >= SIZ)
					break;
				getarg();
				if (strcmp(parg,"0") && !atoi(parg)) { /* ken#1 */
					pgerrflg++;
					fprintf(stderr,
						"ps: %s is an invalid non-numeric argument for -g option\n", parg);
				}
				grpid[ngrpid++] = atoi(parg);
			}
			while (*p1);
			break;

		case 'u':		/* user name or number */
			uflg++;
			p1 = optarg;
			parg = argbuf;
			do {
				getarg();
				if(nut < SIZ)
					strncpy(uid_tbl[nut++].name,parg,MAXLOGIN);
			}
			while (*p1);
			break;

		default:			/* error on ? and s, if not pdp11 */
			errflg++;
			break;
		}

	if (errflg || (optind < argc) || pgerrflg) {
		fprintf(stderr,"usage: %s\n%s\n",usage,usage2);
		done(1);
	}
	if (tflg)
		*ttyp = 0;
					/* if specifying options not used, */
					/*    current terminal is default  */
	if ( !(aflg || eflg || dflg || uflg || tflg || pflg || gflg )) {
		name = 0;
		for (i = 2; i > -1; i--)
			if (isatty(i)) {
				name = ttyname(i);
				break;
			}
		if (name == 0) {
			fprintf(stderr, "ps: can't find controlling terminal\n");
			done(1);
		}
		*ttyp++ = name+5;
		*ttyp = 0;
		ntty++;
		tflg++;
	}
	if (eflg)
		tflg = uflg = pflg = gflg = aflg = dflg = 0;
	if (aflg || dflg)
		tflg = 0;
						/* get data from psfile */
	if(!readata()) {
		getdev();
		getpassfile();
		getnl();
		wrdata();
	}
	uconv();
	if(nl[0].n_value==0||nl[1].n_value==0||nl[2].n_value==0) {
		fprintf(stderr, "ps: no namelist\n");
		done(1);
	}

	if ((memfd = open(coref, 0)) < 0) {
		fprintf(stderr, "ps: no mem\n");
		done(1);
	}
	if ((swmem = open(memf,0)) < 0) {
		fprintf(stderr, "ps: no mem\n");
		done(1);
	}

	/* Find base of swap */
	l_lseek(memfd, (uint)nl[1].n_value - MAINSTORE, 0);
	r_read(memfd, (char *)&swplo, (int)sizeof(swplo));
	/* Find proc table size */
	l_lseek(memfd, (uint)nl[2].n_value - MAINSTORE, 0);
	r_read(memfd, (char *)&v, (int)sizeof(v));

	l_lseek(memfd, (uint)nl[0].n_value - MAINSTORE, 0);
							/* Locate proc table */

/*
   Unless the real user is superuser, the output should be restricted.
*/

	if (fflg && lflg )
		printf(" F S     UID   PID  PPID  C PRI NI     ADDR     SZ    WCHAN    STIME TTY      TIME COMD\n");
	else if (fflg)
		printf("     UID   PID  PPID  C    STIME TTY      TIME COMMAND\n");
	else if (lflg)
		printf(" F S   UID   PID  PPID  C PRI NI     ADDR     SZ    WCHAN TTY      TIME COMD\n");
	else
		printf("   PID TTY      TIME COMMAND\n");
	/* determine which processes to print info about */
	for (i=0; i<v.v_proc; i++) {
		found = 0;
		mproc.p_size = -1;
		r_read(memfd, (char *)&mproc, (int)sizeof(mproc));
		if (mproc.p_stat == 0)	
			continue;
		puid = mproc.p_uid;
		ppid = mproc.p_pid;
		ppgrp = mproc.p_pgrp;
		if ((ppid == ppgrp) && (dflg || aflg))	/* omit process group leaders */
			continue;		/* for a and d options	      */
		if (eflg || dflg)
			found++;
		else if (pflg && search(pid, npid, ppid)) /*ppid in p option arg list?*/
			found++;
		else if (uflg && ufind(puid))		  /*puid in u option arg list?*/
			found++;
		else if (gflg && search(grpid, ngrpid, ppgrp)) /* grpid in g option arg list?*/
			found++;
		if ( !found && !tflg && !aflg )
			continue;


		if (prcom(puid,found)) {
			printf("\n");
			retcode =0;
		}
	}
	done(retcode);	/*NOTREACHED*/
}

/* readata reads in the open devices (terminals) and stores */
/* info in the devl structure. */

static char psfile[] = "/etc/ps_data";

int readata()
{
	struct stat sbuf1, sbuf2;
	int fd;

	if (stat(psfile, &sbuf1) < 0
	    || (stat("/dev", &sbuf2) < 0 || sbuf1.st_mtime <= sbuf2.st_mtime || sbuf1.st_mtime <= sbuf2.st_ctime)
	    || (stat(sysname, &sbuf2) < 0 || sbuf1.st_mtime <= sbuf2.st_mtime || sbuf1.st_mtime <= sbuf2.st_ctime)
	    || (stat("/etc/passwd", &sbuf2) < 0 || sbuf1.st_mtime <= sbuf2.st_mtime || sbuf1.st_mtime <= sbuf2.st_ctime)) {
		return(0);
	}
	if(( fd = open(psfile, O_RDONLY)) < 0)
		return(0);

	/* read /dev data from psfile */
    	psread(fd, &ndev, sizeof(ndev));
	if((devl = (struct devl *)malloc(ndev * sizeof(*devl))) == NULL) {
		fprintf(stderr, "ps: malloc() for device table failed, %s\n",
			sys_errlist[errno]);
		exit(1);
	}
	psread(fd, devl, ndev * sizeof(*devl));

	/* read /etc/passwd data from psfile */
	psread(fd, &nud, sizeof(nud));
	if((ud = (struct udata *)malloc(nud * sizeof(*ud))) == NULL) {
		fprintf(stderr, "ps: not enough memory for udata table\n");
		exit(1);
	}
	psread(fd, ud, nud * sizeof(*ud));

	/* read /syst data from psfile */
	psread(fd, nl, sizeof(nl));

	close(fd);
	return(1);
}

void
getdev()				/* getdev() uses ftw() to pass	  */
{					/* pathnames under /dev to gdev() */
	int gdev();			/* along with a status buffer	  */
	int rcode;

	rcode = ftw ("/dev", gdev, 17);

	switch(rcode) {

	case 0:	 return;		/* successful return, devl populated */

	case 1:  fprintf(stderr, "ps: ftw() encountered problem\n");
		 done(1);

	case -1: fprintf(stderr, "ps: ftw() failed, %s\n", sys_errlist[errno]);
		 done(1);

	default: fprintf(stderr, "ps: ftw() unexpected return, rcode=%d\n", rcode);
		 done(1);
	}
}

int
gdev(objptr, statp, numb)	/* gdev() puts device names and ID into	*/ 
char *objptr;			/* the devl structure for character	*/
struct stat *statp;		/* special files in /dev.  The "/dev/"	*/
int numb;			/* string is stripped from the name and	*/
{				/* if the resulting pathname exceeds	*/
	register int i;		/* DIRSIZ in length then the highest	*/
	int leng, start;	/* level directory names are stripped	*/
				/* until the pathname is DIRSIZ or less	*/
	static struct devl ldevl[2];
	static int lndev, consflg;

	switch (numb) {

	case FTW_F:	if ((statp->st_mode&S_IFMT) == S_IFCHR) {
				/* get more and be ready for syscon & systty */
				while ((ndev + lndev) >= maxdev) {
					maxdev += UDQ;
					devl = (struct devl *) ((devl == NULL) ?
						malloc(sizeof(struct devl) * maxdev) :
						realloc(devl, sizeof(struct devl) * maxdev));
					if (devl == NULL) {
						fprintf(stderr,
							"ps: not enough memory for %d devices\n", maxdev);
						exit(1);
					}
				}
					/* save systty & syscon entries if    */
					/* the console entry hasn't been seen */
				if (!consflg &&
				   (strcmp("/dev/systty", objptr) == 0 ||
				    strcmp("/dev/syscon", objptr) == 0   )) {
					strncpy(ldevl[lndev].dname, &objptr[5], DIRSIZ);
					ldevl[lndev].dev = statp->st_rdev;
					lndev++;
					return(0);
				}

				leng = strlen(objptr);
							/* strip off /dev/ */
				if (leng < (DIRSIZ + 4)) 	/* strip off /dev/ */
					strcpy(devl[ndev].dname, &objptr[5]);
				else {
					start = leng - DIRSIZ - 1;
			
					for (i = start; (i < leng) && (objptr[i] != '/'); i++) ;
					if (i == leng )
						strncpy(devl[ndev].dname, &objptr[start], DIRSIZ);
					else
						strncpy(devl[ndev].dname, &objptr[i+1], DIRSIZ);
				}
				devl[ndev].dev = statp->st_rdev;
				ndev++;
					/* put systty & syscon entries	 */
					/* in devl when console is found */
				if (strcmp("/dev/console", objptr) == 0) {
					consflg++;
					for (i=0; i < lndev; i++) {
						strncpy(devl[ndev].dname, ldevl[i].dname, DIRSIZ);
						devl[ndev].dev = ldevl[i].dev;
						ndev++;
					}
					lndev = 0;
				}
			}
			return(0);

	case FTW_D:
	case FTW_DNR:
	case FTW_NS:	return(0);

	default:	fprintf(stderr, "ps: gdev() error, %d, encountered\n", numb);
			return(1);
	}
		/* FTW_D:   Directory,			  FTW_F:  File	    */
		/* FTW_DNR: Directory-no read permission, FTW_NS: no status */
}

/* Get the passwd file data into the ud structure */
getpassfile()
{
	struct passwd *pw, *getpwent();

	ud = NULL;
	nud = 0;
	maxud = 0;

	while((pw=getpwent()) != NULL) {
		while(nud >= maxud) {
			maxud += UDQ;
			ud = (struct udata *) ((ud == NULL) ?
				malloc(sizeof(struct udata) * maxud) :
				realloc(ud, sizeof(struct udata) * maxud));
			if(ud == NULL) {
				fprintf(stderr,"ps: not enough memory for %d users\n", maxud);
				exit(1);
			}
		}
		/* copy fields from pw file structure to udata */
		ud[nud].uid = pw->pw_uid;
		strncpy(ud[nud].name, pw->pw_name, MAXLOGIN);
		nud++;
	}
	endpwent();
}

/* Get name list data into nl structure */
getnl()
{
	int	kfd, i;

	if ( (kfd = open("/dev/kmem", 0)) == -1 ) {
		fprintf(stderr, "ps: couldn't open /dev/kmem (%s)\n",
		  sys_errlist[errno]);
		exit(99);
	}

	/* Note: we are dependent upon the ordering here */
	if ( (ioctl(kfd, KV_ADDR_PROC, &nl[KV_ADDR_PROC].n_value) == -1) ||
	     (ioctl(kfd, KV_ADDR_SWPLO, &nl[KV_ADDR_SWPLO].n_value) == -1) ||
	     (ioctl(kfd, KV_ADDR_V, &nl[KV_ADDR_V].n_value) == -1) )
	{
		fprintf(stderr, "ps: ioctl on /dev/kmem failed (%s)\n",
		  sys_errlist[errno]);
		exit(100);
	}
}

wrdata()		/* put data in /etc/ps_data file */
{
	int fd;

	umask(02);
	unlink(psfile);
	if((fd = open(psfile, O_WRONLY | O_CREAT | O_EXCL, 0664)) > -1) {
		/* make owner root, group sys */
		chown(psfile, (int)0, (int)getegid());

		/* write /dev data */
		pswrite(fd, &ndev, sizeof(ndev));
		pswrite(fd, devl, ndev * sizeof(*devl));

		/* write /etc/passwd data */
		pswrite(fd, &nud, sizeof(nud));
		pswrite(fd, ud, nud * sizeof(*ud));

		/* write /syst data */
		pswrite(fd, nl, sizeof(nl));

		close(fd);
	}
}


/* getarg finds next argument in list and copies arg into argbuf  */
/* p1 first pts to arg passed back from getopt routine.  p1 is then */
/* bumped to next character that is not a comma or blank - p1 null */
/* indicates end of list    */

getarg()
{
	char *parga;
	parga = argbuf;
	while(*p1 && *p1 != ',' && *p1 != ' ')
		*parga++ = *p1++;
	*parga = '\0';

	while( *p1 && ( *p1 == ',' || *p1 == ' ') )
		p1++;
}

/* gettty returns the user's tty number or ? if none  */
char *gettty()
{
	register i;
	register char *p;

	if (u.u_ttyp==0)
		return("?");
	for (i=0; i<ndev; i++) {
		if (devl[i].dev == u.u_ttyd) {
			p = devl[i].dname;
			return(p);
		}
	}
	return("?");
}

prcom(puid,found)			/* print info about the process */
int puid,found;
{
	int abuf[BSIZE*2/sizeof(int)];		/* BSIZE unchanged, no FSS */
	long addr;
	int	nbytes;

	register char *cp;

	register char *tp;
	char *ctime();
	time_t time();
	time_t *clock, *tloc;
	time_t tim;
	char timbuf[26];
	char *curtim = timbuf;
	char *sttim, *s1;
	long tm;
	int	match, i;
	int	uzero = 0;
	register char **ttyp, *str;


	/* if process is zombie, call print routine and return */
	if (mproc.p_stat==SZOMB) {
		if ( tflg && !found)
			return(0);
		else {
			przom(puid);
			return(1);
		}
	}
	/* SIDL: intermediate state in process creation  */
	/* if SIDL then user block address may be bad or */
	/*	contents of user block may be residue	 */
	if (mproc.p_stat==SIDL) {
		return(1);
		}

/* If paging system,    process is in memory, read in user block	 */
/* If non-paged system, determine if process is in memory or swap space, */
/*						then read in user block  */

/* Pages in the user page table are contiguous on 3b5 but not 3b2/3b20.  */
/* Pages in the segment page table are not contiguous for each segment   */
/*								on 3b5   */
	l_lseek(swmem, (uint)mproc.p_userp - MAINSTORE, 0);
	/* get u page */
	if (read(swmem,(char *)&u,sizeof(u)) != sizeof(u)) {
		printf("ps can not read %s\n",memf);
		return(0);
	}
		/* uptbl, user page table	  */
		/* NBPP, number of bytes per page */
		/*       see sys/page.h           */

	/* get current terminal - if none (?) and aflg is set */
	/* then don't print info - if tflg is set, check if term */
	/* is in list of desired terminals and print if so   */
	tp = gettty();
	if ( aflg && (*tp == '?' ))
		return(0);
	if(tflg && !found) {	/* the t option */
		for (ttyp=tty, match=0; (str = *ttyp) !=0 && !match; ttyp++)
			if (strcmp(tp,str) == 0)
				match++;
		if(!match)
			return(0);
	}

	if (lflg)
		printf("%2x %c", mproc.p_flag&0377, states[mproc.p_stat]);    /* F S */
	if (fflg) {
		i = getunam(puid);
		if (i >= 0)
			printf("%8.8s", ud[i].name);
		else
			printf("%8.8u", puid);
	}
	else if (lflg)
		printf("%6u", puid);
	printf("%6u",mproc.p_pid);				/* PID */
	if (lflg || fflg)
		printf("%6u%3d", mproc.p_ppid, mproc.p_cpu&0377); /* PPID CPU */
	if (lflg) {
		printf("%4d%3d",mproc.p_pri, mproc.p_nice);	/* PRI  NICE */

				/* S_STBL, see sys/sbr.h,    */
				/* word addr of segment table*/

				/* slpsemas undefined should never   */
				/* happen, running ps on machine     */
				/* other than the one compiled for   */

		/* ADDR SZ */
/* FIX THIS, DS.
 *do we want the kernel virtual, or some sort of physical address here?
 */
		printf("%9x%7d", mproc.p_userp, mproc.p_size);
		if (mproc.p_wchan)
			printf("%9x",mproc.p_wchan);		/* WCHAN */
		else 
			printf("         ");

	}
	if (uzero) 		/* u-block zeroed out so return */
		return(1);
	if (fflg) {		  /* STIME*/
		clock = &u.u_start;
		tim = time((time_t *) 0);
		tloc = &tim;
		s1 = ctime(tloc);
		strcpy(curtim,s1);
		sttim = ctime(clock);
		prtim(curtim, sttim);
	}
	printf(" %-7.14s", tp);					/* TTY */
	tm = (u.u_utime + u.u_stime + HZ/2)/HZ;			/* TIME */
	printf(" %2ld:%.2ld", tm/60, tm%60);

	/* if fflg not set or system process, print command from u_block */
				/* SSYS, system process, today 0 or 2    */
	if (!fflg || mproc.p_flag & SSYS) {			/* CMD */
		if (u.u_comm[0])
			printf(" %.8s", u.u_comm);
		else
			printf(" swapper");
		return(1);
	}

	/* set up address maps for user pcs */
				/* PSARGSZ, length of cmd arg string	  */
				/* today 40, see sys/user.h		  */
				/* tommorrow 80?, hope so for consistency */
	for (cp=u.u_psargs; cp<&u.u_psargs[PSARGSZ]; cp++) {
		if (*cp == 0) break;
		if (*cp < ' ' || *cp > '~') {
			printf(" [ %.8s ]", u.u_comm);
			return(1);
		}
	}
	if (lflg)
		printf(" %.35s", u.u_psargs);
	else
		printf(" %.*s", PSARGSZ, u.u_psargs);

				/* no u_psargs on 3b5, look in user stack */

				/* Active Process: (SLOAD) Process has a  */
				/*      page present in memory.  Get      */
				/*      command line arguments from stack.*/

				/* Inactive Process: (!SLOAD) Process has */
				/*      no page present in memory.  Print */
				/*      command name from u.u_comm in	  */
				/*      user block.			  */

				/* SEXEC, execing process:  can't get args*/
	return(1);
}


/* file handling and access routines */

done(exitno)
{
	exit(exitno);
}

/* search returns 1 if arg is found in array arr */
/* which has length num, and returns 0 if not found */

search(arr, number, arg)
int arr[];
int number;
int arg;
{
	int i;
	for (i = 0; i < number; i++)
		if (arg == arr[i])
			return(1);
	return(0);
}

/* after the u option */

uconv()
{
	int found;
	int pwuid;
	int i, j;

	/* search thru name array for oarg */
	for (i=0; i<nut; i++) {
		found = -1;
		for(j=0; j<nud; j++) {
			if (strncmp(uid_tbl[i].name, ud[j].name, MAXLOGIN)==0) {
				found = j;
				break;
			}
		}
		/* if not found and oarg is numeric */
		/* then search through number array */
		if (found < 0 && (uid_tbl[i].name[0] >= '0' && uid_tbl[i].name[0] <= '9')) {
			pwuid = atoi(uid_tbl[i].name);
			for (j=0; j<nud; j++) {
				if (pwuid == ud[j].uid) {
					found = j;
					break;
				}
			}
		}

		/* if found then enter found index into tbl array */
		if ( found != -1 ) {
			uid_tbl[i].uid = ud[found].uid;
			strncpy(uid_tbl[i].name,ud[found].name,MAXLOGIN);
		}else {
			fprintf(stderr,"ps: unknown user %s\n",uid_tbl[i].name);
			for(j=i+1; j<nut; j++) {
				strncpy(uid_tbl[j-1].name,uid_tbl[j].name,MAXLOGIN);
			}
			nut--;
			if (nut <= 0) exit(1);
			i--;
		}
	}
	return;
}

/* for full command (-f flag) print user name instead of number */
/* search thru existing table of userid numbers and if puid is found, */
/* return corresponding name.  Else search thru /etc/passwd */

getunam(puid)
int puid;
{
	int i;

	for(i=0; i<nud; i++)
		if(ud[i].uid == puid)
			return(i);
	return(-1);
}

/* ufind will return 1 if puid is in table ; if not return 0 */
ufind(puid)
int puid;
{
	int i;

	for(i=0; i<nut; i++)
		if(uid_tbl[i].uid == puid)
			return(1);
	return(0);
}

/* lseek with error checking */
l_lseek(fd, offset, whence)
int fd, whence;
long	offset;
{
	if (lseek(fd, offset, whence) == -1) {
		fprintf(stderr, "ps: l_lseek() error on lseek, %s\n", sys_errlist[errno]);
		done(1);
	}
}

/* read with error checking */
r_read (fd, buf, nbytes)
int	fd, nbytes;
char	*buf;
{
	int rbytes;
	rbytes = read(fd, buf, (unsigned)nbytes);
	if (rbytes != nbytes) {
		fprintf(stderr, "ps: r_read() error on read, rbytes=%d, nbytes=%d\n",
			rbytes, nbytes);
		perror("");
		done(1);
	}
}

/* special read unlinks psfile on read error */
psread(fd, bp, bs)
int fd;
char *bp;
unsigned bs;
{
	int rbs;

	rbs = read(fd, bp, bs);
	if(rbs != bs) {
		fprintf(stderr, "ps: psread() error on read, rbs=%d, bs=%d\n", rbs, bs);
		unlink(psfile);
	}
}

/* special write unlinks psfile on read error */
pswrite(fd, bp, bs)
int fd;
char *bp;
unsigned bs;
{
	int wbs;

	wbs = write(fd, bp, bs);
	if(wbs != bs) {
		fprintf(stderr, "ps: pswrite() error on write, wbs=%d, bs=%d\n",
			wbs, bs);
		unlink(psfile);
	}
}

/* print starting time of process unless process started more */
/* than 24 hours ago in which case date is printed   */
/* sttim is start time and it is compared to curtim (current time ) */

prtim(curtim, sttim)
char *curtim, *sttim;
{
	char *ptr1, *ptr2;
	char dayst[3], daycur[3];
	if ( strncmp(curtim, sttim, 11) == 0) {
		ptr1 = sttim + 11;
		ptr2 = ptr1 + 8;
	}
	else {
		ptr1 = sttim + 4;
		ptr2 = ptr1 + 7;
		/* if time is < 24 hours different, then print time */
		if (strncmp(curtim+4, sttim+4, 3) == 0) {
			strncpy(dayst,sttim+8, 2);
			strcat(dayst,"");
			strncpy(daycur,curtim+8,2);
			strcat(daycur,"");
			if ((atoi(dayst) +1 == atoi(daycur)) &&
				 (strncmp(curtim+11,sttim+11,8)<=0)) {
				ptr1 = sttim + 11;
				ptr2 = ptr1 + 8;
			}
		}
	}
	*ptr2 = '\0';
	printf("%9.9s",ptr1);
}

#define xp_flag p_flag
#define xp_stat	p_stat
#define xp_pid	p_pid
#define xp_ppid	p_ppid
#define xp_cpu	p_cpu
#define xp_pri	p_pri
#define xp_nice	p_nice
#define xp_utime p_utime
#define xp_stime p_stime

przom(puid)
/* print zombie process - zproc overlays mproc */
int puid;
{
	int i;
	long tm;

	if (lflg)
		printf("%2x %c", zproc.xp_flag&0377, states[zproc.xp_stat]);  /* F S */
	if (fflg) {
		i = getunam(puid);
		if (i >= 0)
			printf("%8.8s", ud[i].name);
		else
			printf("%8.8u", puid);
	}
	else if (lflg)
		printf("%6u", puid);
	printf("%6u",zproc.xp_pid);				/* PID */
	if (lflg || fflg)
		printf("%6u%3d", zproc.xp_ppid, zproc.xp_cpu&0377); 	/* PPID CPU */
	if (lflg)
		printf("%4d%3d",zproc.xp_pri, zproc.xp_nice);	/* PRI NICE */
        if (fflg)
                printf("         ");				/* STIME */
        if (lflg)
                printf("                         ");	/* ADDR SZ WCHAN */
	tm = (zproc.xp_utime + zproc.xp_stime + HZ/2)/HZ;
	printf("         %2ld:%.2ld", tm/60, tm%60);		/* TTY TIME */
	printf(" <defunct>");
	return;
}
