/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) prtvtoc.c: version 25.1 created on 12/2/91 at 16:49:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)prtvtoc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)cmd/prtvtoc:prtvtoc.c	25.1"

/*	prtvtoc: print device dimensions, and partition information *
 *	   including type, mount flag, mount directory (if any),    *
 *	   start block and size.                                    *
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/errno.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include <sys/ioctl.h>
#include <sys/stat.h>

#ifdef S3000	/* hh1 */
#include <sys/vmem.h>	
#include <sys/pm_iomap.h>
#include <sys/sbus.h>
#include <sys/kmem.h>
#include <sys/iopm/dsdb/sdk_disk.h>
#endif

#include <mnttab.h>

/* GC_ADDR_LOW converts a dual-port ram address to one without the sign bit */
#ifdef S3000
#define GC_ADDR_LOW(addr) addr-KMEM_START
#else
/* GC_ADDR_LOW does nothing for the A1000 */
#define GC_ADDR_LOW(addr) addr
#endif
#define	MNTTAB	"/etc/mnttab"
#define	MAXFIELD	4
#define	MINFIELD	2
char *log_type[]={"NULL","FSYS","SWAP","PWRF","HOLE","SPARE","SKIP","SPLIT"};
char *log_type1[]={"EMPTY","UNIX","SWAP","DIAG","DEFCT","BOOT","ERRLOG"};
static char fsbuf[BUFSIZ];
static char *fieldv[MAXFIELD];
char *p;
#define ERROR 	1
#define WARNING 2

static struct mnttab *mtab;
static struct mnttab *last_entry;

static int mtab_size;
struct mnttab *mp;
int rtn;






main(argc,argv)
int argc;
char *argv[];
{
	register i, j, f;
	char c;
	FILE *fp;
	int fd;
	int vflg=0, controller, pd, ld, num_fields, found=0;
	char *filename = "/dev/kmem";
	char *buffer, *device, *mountdir, *mountflg;
	char bdevice[16];
	register struct bd_desc *bdptr;
	register struct dev_desc *devptr;
	register struct pd *pdptr;
	struct ld *ldptr;
	int bsize=0xfff0;
	struct sdk_block_0 slice;
	int	whichslice;
	int r, ii; char *p;

	setbuf(stdout,0);

	if(strcmp(argv[1],"-v"))
		if(argc != 2)
		{
			fprintf(stderr, "Usage: /etc/prtvtoc [-v] device\n");
			exit(2);
		}
		else device=argv[1];
	else
	{
		++vflg;
		device=argv[2];
	}
		
	/* check validity of beginning of device name */

	if ( (strncmp(device,"/dev/rdsk/",10) != 0) &&
	     (strncmp(device,"/dev/dsk/",9) != 0) )
	{
		fprintf(stderr,"%s is an invalid device.\n",device);
		exit(2); 
	}
	
	controller = 0;
	pd = 0;
	whichslice = 0;

	/* Check to see if we have a raw disk or not */

	if ( (strncmp(device,"/dev/rdsk/",10) == 0) )
                ii=11;
        else
                ii=10;

	/* determine controller number - device in form of /dev/rdsk/c0d0s0
	 *				 or /dev/dsk/c0d0s0 */

	while ((device[ii] != NULL) && (device[ii] != 'd'))
	  {
		controller= (controller * 10) + ((int)device[ii] - '0');
		ii++;
	  }

	if (device[ii] == NULL) {
                fprintf(stderr,"%s, is an invalid device.\n",device);
                exit(2);
        }

	ii++;

	/* determine physical device - device in form of /dev/rdsk/c0d0s0
	 *				or /dev/dsk/c0d0s0 */

	while ((device[ii] != 's') && (device[ii] != NULL))
	  {
		pd= (pd * 10) + ((int)device[ii] - '0');
		ii++;
	  }
	
	if (device[ii] == NULL) {
                fprintf(stderr,"%s, is an invalid device.\n",device);
                exit(2);
        }

	ii++;

	while (ii < strlen(device)) 
	  {
	  whichslice = whichslice * 10 + (int)device[ii] - '0';
	  ii++;
	  }
	
/* See if it's an IOPM world ... */

	/* If the device is given as /dev/dsk/cxdysz then we need to
	 * convert it to /dev/rdsk/cxdysz format to ioctl it */

	if ((strncmp(device,"/dev/dsk/",9)) == 0)
                sprintf(device,"/dev/rdsk/c%dd%ds%d",controller,pd,whichslice);

	if ((fd = open(device,O_RDONLY)) < 0)  {
		fprintf(stderr,"Cannot open device %s\n",device);
		exit(2); 
	}

	if (ioctl(fd, SDK_READ_VTOC, &slice) < 0) {
		fprintf(stderr,"ioctl READ_VTOC failed on %s\n", device); 
		close(fd);
		}
	else
	{
	p= slice.misc.disk_info.vol_id; 
	if (r=(strncmp(p, "IOPMSCSI",8)) != 0)
		{
		fprintf(stderr,"%s is an invalid device.\n",device);
		exit(2); 
		};
	if (slice.misc.disk_info.date != 0x19890828)
		{
		fprintf(stderr,"%s is an invalid device.\n",device);
		exit(2); 
		};

	printf("*  %s partition map\n",device);
	printf("*\n");
	printf("*  Dimension:\n");
	printf("*     %d bytes/sector\n",slice.misc.disk_info.bps);
	printf("*     %d sector/track (approximate)\n", slice.slice_table[whichslice].ldrv.ld_spt);
	printf("*     %d tracks/cylinder\n",slice.misc.disk_info.heads);
	printf("*     %d accessible cylinders (approximate)\n",slice.misc.disk_info.cylns);
	printf("*\n");
	printf("*  Flags:\n");
	printf("*   00: read and write\n");
	printf("*   01: unmountable\n");
	printf("*   10: read only\n");
	printf("*\n");
	printf("*  Partition   Type    Flag    First Sector    Sector Count    Mount Directory\n");

	/* Open mount information */

	if ((rtn = read_mnttab(ERROR)) != 0)
		exit(2);

	/* Get information for all logical disk */

	for(ld=0; ld < MAX_IOPM_SLICES; ld++)
	{
		sprintf(bdevice,"/dev/dsk/c%dd%ds%d",controller,pd,ld);
		for (mp = mtab; mp < last_entry; mp++) {
		  if( strcmp(bdevice, mp->mt_dev) == 0) {
			found=1;
			mountdir = mp->mt_filsys;
			if (mp->mt_ro_flg ==0) mountflg="00";
			else if (mp->mt_ro_flg ==1) mountflg="10";
			else mountflg="01";
		  }
		}
		if(!found)
		{
			mountdir="  ";
			mountflg="  ";
		}

		if (slice.slice_table[ld].ldrv.ld_size > 0)
		{
		if(vflg)
		  if ((slice.slice_table[ld].ldrv.ld_type !=4) &&
		      (slice.slice_table[ld].ldrv.ld_type !=5)) 
			printf("      %2d       %5s    %s         %7d         %7d            %s\n",ld,
			log_type1[slice.slice_table[ld].ldrv.ld_type],
			mountflg,
			slice.slice_table[ld].ldrv.ld_strt,
			slice.slice_table[ld].ldrv.ld_size,
			mountdir);
		  else
			printf("      %2d       %5s    %s         %7d         %7d            %s\n",ld,
			" ",	
			mountflg,
			slice.slice_table[ld].ldrv.ld_strt,
			slice.slice_table[ld].ldrv.ld_size,
			mountdir);

		else
		  if ((slice.slice_table[ld].ldrv.ld_type !=4) &&
		      (slice.slice_table[ld].ldrv.ld_type !=5)) 
			printf("      %2d         %d      %s         %7d         %7d            %s\n",ld,
			slice.slice_table[ld].ldrv.ld_type,mountflg,
			slice.slice_table[ld].ldrv.ld_strt,
			slice.slice_table[ld].ldrv.ld_size,
			mountdir);
		  else
			printf("      %2d                 %s        %7d         %7d            %s\n",ld,
			mountflg,
			slice.slice_table[ld].ldrv.ld_strt,
			slice.slice_table[ld].ldrv.ld_size,
			mountdir);

		}
/*		else printf("      %d\n",ld); */

		found=0;
	}
	fclose(fp);
	exit(0);

	}
}

get_fields(s)
char	*s;
{
	int fieldc = 0;

	if ((fieldv[fieldc] = strtok(s, " \t\n")) == NULL)
		return(fieldc);

	fieldc ++;
	while (fieldc < MAXFIELD
	   && (fieldv[fieldc] = strtok(NULL, " \t\n")) != NULL)
		fieldc ++;

	return(fieldc);
}

/*----------------------------------------------------------------------*/

/*
 *	read_mnttab() attempts to read in MNTTAB.  Upon
 *	successful completion, the following will be set:
 *
 *	mtab :	a pointer to a buffer in memory which contains
 *		MNTTAB plus space to hold one more mount table entry.
 *
 *	mtab_size :	the size in bytes of the buffer pointed
 *			to by mtab.
 *
 *	last_entry :	a pointer to the end of MNTTAB in the
 *			buffer pointed to by mtab.
 */

static
read_mnttab(flag)
int	flag;
{
	char	*mess;
	int	rec;
	struct	stat	 sbuf;

	if (flag == WARNING)
		mess = " warning:";
	else
		mess = "";

	if ((rec = open(MNTTAB,O_RDONLY)) < 0) {
		fprintf(stderr, "mount:%s cannot open %s\n", mess, MNTTAB);
		return(2);
	}

	if (fstat(rec, &sbuf) < 0) {
		fprintf(stderr, "mount:%s cannot stat %s\n", mess, MNTTAB);
		return(2);
	}

	mtab_size = sbuf.st_size + sizeof(struct mnttab );

	if ((mtab = (struct mnttab *)malloc(mtab_size)) == 0) {
		fprintf(stderr, "mount:%s cannot allocate space for %s\n",
			mess, MNTTAB);
		return(2);
	}

	if (read(rec, mtab, sbuf.st_size) != sbuf.st_size) {
		fprintf(stderr, "mount:%s read error on %s\n", mess, MNTTAB);
		return(2);
	}

	last_entry = (struct mnttab *)((char *)mtab + sbuf.st_size);


	close(rec);
	return(0);
}
