/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) prfsnap.c: version 25.1 created on 12/2/91 at 16:49:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)prfsnap.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT: #ident	"profil-3b15:prfsnap.c	1.4.1.1"	*/

#ident	"@(#)profiler/mach:prfsnap.c	25.1"

/*
 *	prfsnap - dump profile data to a log file
 */
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/profiler.h>

struct prfargs pp;

main(argc, argv)
	int	argc;
	char	**argv;
{
	register  int  prf, log;
	int	tvec;

	if(argc != 2)
		error("usage: prfsnap  logfile");
	if((prf = open("/dev/prf", 0)) < 0)
		error("cannot open /dev/prf");
	if((log = open(argv[1], 1)) < 0)
		if((log = creat(argv[1], 0666)) < 0)
			error("cannot creat log file");

	lseek(log, 0, 2);
	if(ioctl(prf, PRF_SET, &pp.p))
		error("cannot activate profiling");
	time(&tvec);
	if(read(prf, &pp, sizeof(struct prfargs)) != sizeof(struct prfargs)){
		switch(errno) {
		case ENXIO:
			error("no valid text addresses\n");
		default:
			perror("prfsnap");
		}
	}
	if(lseek(log, 0, 1) == 0) {
		write(log, &pp.p, sizeof(struct prfid));
		write(log, pp.p_sym, pp.p.max * sizeof(unsigned));
	}
	write(log, &tvec, sizeof tvec);
	write(log, pp.p_sys, (pp.p.max + 1) * sizeof (unsigned));
}

error(s)
	char	*s;
{
	write(2, "prfsnap: ", 9);
	write(2, s, strlen(s));
	write(2, "\n", 1);
	exit(1);
}
