/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) prfpr.c: version 25.1 created on 12/2/91 at 16:48:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)prfpr.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT: #ident	"profil-3b15:prfpr.c	1.9"		*/

#ident	"@(#)profiler/mach:prfpr.c	25.1"

/*
 *	prfpr - print profiler log files
 */
/* kd0 p_ctr was defined incorrectly */

#include <stdio.h>
#include <time.h>
#include <a.out.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/profiler.h>

#ifdef S3000
#define SYSTEM "/arix"
#else
#define SYSTEM "/syst"
#endif                   /* JAS#1, 9/13/88 */

int N_TEXT;

struct prfid pid;
unsigned p_sym[PRFMAX];

struct	profile	{
	long	p_date;		/* time stamp of record */
	unsigned p_ctr[PRFMAX+2];	/* profiler counter values */ /*kd0*/
} p[2];


struct syment *stbl;		/* start of symbol table */
char *strtab;			/* start of string table */
int symcnt;			/* number of symbols */
double cutoff = 1e-2;
double pc;

char *namelist = SYSTEM;
char *logfile;

long sum, osum;


main(argc, argv)
char **argv;
{
	register int ff, log, i;
	unsigned logsiz;
	struct syment *sp, *search();

	switch(argc) {
		case 4:
			namelist = argv[3];
		case 3:
			cutoff = atoi(argv[2]);
		case 2:
			logfile = argv[1];
			break;
		default:
			error("usage: prfpr file [ cutoff [ namelist ] ]");
	}
	if((log = open(logfile, 0)) < 0)
		error("cannot open data file");
	if(cutoff > 100 || cutoff < 0)
		error("invalid cutoff percentage");

	osum=sum=ff=0;

	if(read(log, &pid, sizeof(struct prfid)) != sizeof(struct prfid)) {
		switch(errno) {
		case ENXIO:
			error("no text addresses");
		default:
			perror("prfpr");
			exit(1);
		}
	}
	logsiz= pid.max * sizeof(unsigned);
	if(read(log, p_sym, logsiz) != logsiz)
		error("bad data file");

	logsiz+= sizeof(long) + sizeof(unsigned);
	read(log, &p[!ff], logsiz);
	for(i = 0; i <= pid.max; i++)
		osum += p[!ff].p_ctr[i];

	rdsymtab();
	rdstrtab();
	for(;;) {
		sum = 0;
		if(read(log, &(p[ff]), logsiz) != logsiz)
			exit(0);
		shtime(&p[!ff].p_date);
		shtime(&p[ff].p_date);
		printf("\n");
		for(i = 0; i <= pid.max; i++)
			sum += p[ff].p_ctr[i];
		if(sum == osum)
			printf("no samples\n\n");
		else for(i = 0; i <= pid.max; i++) {
			pc = (double)(p[ff].p_ctr[i] - p[!ff].p_ctr[i]) /
				(double)(sum - osum);
			if(pc > cutoff)
				if(i == pid.max)
					printf("user     %5,2f\n",
					 pc*1e2);
				else {
					sp = search(p_sym[i], N_TEXT, N_TEXT);
					if(sp == 0)
						printf("unknown  %5.2f\n",
						 pc*1e2);
					else {
						printname(sp);
						printf(" %5.2f\n", pc*1e2);
					}
				}
		}
		ff = !ff;
		osum = sum;
		printf("\n");
	}
}

error(s)
char *s;
{
	printf("error: %s\n", s);
	exit(1);
}

shtime(l)
register long *l;
{
	register  struct  tm  *t;
	struct  tm  *localtime();

	if(*l == (long) 0) {
		printf("initialization\n");
		return;
	}
	t = localtime(l);
	printf("%02.2d/%02.2d/%02.2d %02.2d:%02.2d\n", t->tm_mon + 1,
		t->tm_mday, t->tm_year, t->tm_hour, t->tm_min);
}

rdsymtab()
{
	struct filehdr filehdr;
	struct scnhdr scnptr;
	FILE *fp;
	struct syment *sp;
	int i;
	char *sbrk();

	if((fp = fopen(namelist, "r")) == NULL)
		error("cannot open namelist file");
	if(fread(&filehdr, FILHSZ, 1, fp) != 1)
		error("read error in namelist file");
	if(filehdr.f_magic != VAXROMAGIC)
		error("namelist not in a.out format");

	/*
	 * Read the section headers to find the section number
	 * for .text. First seek past the file header 
	 * and optional header, then loop through the section headers
	 * searching for the names .text.
	 */
	N_TEXT=0;
	if(fseek(fp, FILHSZ + filehdr.f_opthdr, 0) != 0)
		error("error in seeking to section headers");

	for(i=1; i<=filehdr.f_nscns; i++) {
		if(fread(&scnptr, SCNHSZ, 1, fp) != 1)
			error("read error in section headers");

		switch(scnmatch(scnptr.s_name,1,_TEXT)) {
			case 1:		/* .text */
					N_TEXT = i; break;
			default:
					break;
		}
	}
	if(N_TEXT == 0) 
		error(".text was not found in section headers");

	if((stbl=(struct syment *)sbrk(filehdr.f_nsyms*SYMESZ)) == (struct syment *)-1)
		error("cannot allocate space for namelist");
	fseek(fp, filehdr.f_symptr, 0);
	symcnt = 0;
	for(i=0, sp=stbl; i < filehdr.f_nsyms; i++, sp++) {
		symcnt++;
		if(fread(sp, SYMESZ, 1, fp) != 1)
			error("read error in namelist file");
		if(sp->n_numaux) {
			fseek(fp, AUXESZ*sp->n_numaux, 1);
			i += sp->n_numaux;
		}
	}
	brk(sp);
	fclose(fp);
}


struct syment *
search(addr, sect1, sect2)
{
	register struct syment *sp;
	register struct syment *save;
	unsigned value;

	value = 0;
	save = 0;
	for(sp = stbl; sp < &stbl[symcnt]; sp++) {
		if(sp->n_sclass == C_EXT && (sp->n_scnum == sect1
		  || sp->n_scnum == sect2) && sp->n_value <= addr
		  && sp->n_value > value) {
			value = sp->n_value;
			save = sp;
		}
	}
	return(save);
}

/* 
 * scnmatch() is only called by rdsymtab() to match a section
 * name in the section headers to find .text.
 * A number is returned indicating which name matched, or a zero
 * is returned if none matched.  This routine was copied out of
 * exec.c in the kernel code.
 */
scnmatch(target, count, sources)
char *target;
int count;
char *sources;
{
	register char *p, *q, **list;
	list = &sources;
	while (count-- > 0) {
		p = target;
		q = *list++;
		while(*p == *q++) {
			if (*p++ == '\0')
			      return(list - &sources);
		}
	}
	return(0);
}

rdstrtab()
{
	static long length;
	struct filehdr filehdr;
	FILE *fp;

	if((fp = fopen(namelist, "r")) == NULL)
		error("cannot open namelist file");
	if(fread(&filehdr, FILHSZ, 1, fp) != 1)
		error("read error in namelist file");

	fseek(fp, filehdr.f_symptr + filehdr.f_nsyms * SYMESZ, 0);
	if (fread((char *)&length, sizeof(long), 1, fp) != 1
	   || (strtab = (char *)malloc((unsigned)length)) == NULL
	   || fread(strtab + sizeof(long), sizeof(char),
	      length - sizeof(long), fp) != length-sizeof(long)
	   || strtab[length - 1] != '\0' ) {
		fprintf(stderr, "error in obtaining string table");
	}
}

printname(ent)
struct syment *ent;
{
	if (ent->n_zeroes == 0L)
		printf("%s", strtab + ent->n_offset);
	else
		printf("%-8.8s", ent->n_name);
}
