/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) prfdc.c: version 25.1 created on 12/2/91 at 16:48:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)prfdc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"profil-3b15:prfdc.c	1.4.1.1"	*/

#ident	"@(#)profiler/mach:prfdc.c	25.1"

/*
 *	prfdc - profiler data collector
 */
/* kd0 - kelly - prfdc was not correctly reading the profiling data */

# include "time.h"
# include "signal.h"
# include "errno.h"
# include "stdio.h"
# include "sys/types.h"
# include "sys/stat.h"
# include "fcntl.h"
#include <sys/profiler.h>


struct prfargs pp = {0};
extern int errno;

sigalrm()
{
	signal(SIGALRM, sigalrm);
}

main(argc, argv)
	char	**argv;
{
	register  int  prf, log;
	register  int  rate = 10, first = 1, toff = 17;
	int	tvec, psize;
	struct	tm	*localtime();


	switch(argc) {
		default:
			error("usage: prfdc  logfile  [ rate  [ off_hour ] ]");
		case 4:
			toff = atoi(argv[3]);
		case 3:
			rate = atoi(argv[2]);
		case 2:
			;
	}
	if(rate <= 0)
		error("invalid sampling rate");
	if((prf = open("/dev/prf", 0)) < 0)
		error("cannot open /dev/prf");
	if(open(argv[1], 0) >= 0)
		error("existing file would be truncated");
	if((log = creat(argv[1], 0666)) < 0)
		error("cannot create log file");
	if(ioctl(prf, PRF_SET, &pp.p))
		error("cannot activate profiling");
	if(fork())
		exit(0);
	setpgrp();
	sigalrm();
	time(&tvec);
	if(read(prf, &pp, sizeof(struct prfargs)) != sizeof(struct prfargs)) {
		switch(errno) {
		case ENXIO:
			error("no valid text addressed\n");
		default:
			perror("prfdc");
			exit(1);
		}
	}

	psize = sizeof(unsigned) * (pp.p.max+1);
	write(log, &pp.p, sizeof(struct prfid));
	for(;;) {	
		alarm(60 * rate);
		time(&tvec);
		if(read(prf, &pp, sizeof(struct prfargs))  /*kd0*/
				!= sizeof(struct prfargs)) {
			switch(errno) {
			case ENXIO:
				error("no valid text addressed\n");
			default:
				perror("prfdc");
				exit(1);
			}
		}
		if(first) {
			write(log, pp.p_sym, pp.p.max * sizeof(unsigned));
			first = 0;
		}
		write(log, &tvec, sizeof tvec);
		write(log, pp.p_sys, psize);
		if(localtime(&tvec)->tm_hour == toff)
			exit(0);
		pause();
	}
}

error(s)
	char	*s;
{
	write(2, "prfdc: ", 6);
	write(2, s, strlen(s));
	write(2, "\n", 1);
	exit(1);
}
